/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.gtis.common.http.Utf8PostMethod;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.SysOpinionService;
import com.gtis.plat.service.SysSubProcessService;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.WorkFlowTransInfo;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.PerformerModel;
import com.gtis.plat.wf.model.PerformerTaskModel;
import com.gtis.portal.entity.PfUser;
import com.gtis.portal.service.PfUserRoleService;
import com.gtis.portal.service.PfUserService;
import com.gtis.portal.util.RequestUtils;
import com.gtis.portal.util.WorkFlowUtil;
import com.gtis.portal.util.WorkFlowXml;
import com.gtis.portal.util.WorkFlowXmlUtil;
import com.gtis.web.SessionUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.tree.DefaultText;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/turnWorkFlow"})
public class TurnWorkFlowController {
    private static final Log log = LogFactory.getLog(TurnWorkFlowController.class);
    @Autowired
    SysWorkFlowDefineService workFlowDefineService;
    @Autowired
    NodeService nodeService;
    @Autowired
    SysWorkFlowInstanceService workFlowIntanceService;
    @Autowired
    SysTaskService taskService;
    @Autowired
    WorkFlowCoreService workFlowService;
    @Autowired
    SysOpinionService opinionService;
    @Autowired
    private SysSubProcessService sysSubProcessService;
    @Autowired
    PfUserRoleService userRoleService;
    @Autowired
    PfUserService userService;

    @RequestMapping(value={""})
    public String turnWorkFlow(Model model, @RequestParam(value="taskid", required=false) String taskid, HttpServletRequest request) throws Exception {
        String userId = SessionUtil.getCurrentUserId();
        WorkFlowInfo info = null;
        String proid = "";
        if (this.sysSubProcessService.isSubProcessFinishing(taskid).booleanValue()) {
            model.addAttribute("subProcessFinish", (Object)true);
            info = this.workFlowService.getWorkFlowTurnInfo("-1", this.taskService.getActivity(this.taskService.getTask(taskid).getActivityId()).getWorkflowInstanceId());
        } else {
            model.addAttribute("subProcessFinish", (Object)false);
            info = this.workFlowService.getWorkFlowTurnInfo(userId, taskid);
        }
        if (info != null && info.getWorkFlowIntanceVo() != null && StringUtils.isNotBlank((String)info.getWorkFlowIntanceVo().getProId())) {
            proid = info.getWorkFlowIntanceVo().getProId();
        }
        String turnXml = this.turnInfo(info, request);
        WorkFlowXml workFlowXml = WorkFlowXmlUtil.getInstanceModel((PfWorkFlowInstanceVo)info.getWorkFlowIntanceVo());
        ActivityModel activityModel = workFlowXml.getActivity(info.getSourceActivity().getActivityDefinitionId());
        String confirmTurnInfo = "false";
        if ("true".equals(activityModel.getExtendedAttribute("ConfirmTurnInfo"))) {
            confirmTurnInfo = "true";
        }
        String version = AppConfig.getProperty((String)"portal.version");
        String opinions = JSONArray.toJSONString((Object)this.opinionService.getOpinionList(userId, info.getWorkFlowDefineVo().getWorkflowName(), info.getSourceActivity().getActivityName()));
        model.addAttribute("taskid", (Object)taskid);
        model.addAttribute("userId", (Object)userId);
        model.addAttribute("proid", (Object)proid);
        model.addAttribute("bdcdjUrl", (Object)RequestUtils.initOptProperties((String)AppConfig.getProperty((String)"bdcdj.url")));
        model.addAttribute("version", (Object)version);
        model.addAttribute("turnXml", (Object)turnXml);
        model.addAttribute("opinions", (Object)opinions);
        model.addAttribute("confirmTurnInfo", (Object)confirmTurnInfo);
        return "/task/handle/turn-workFlow";
    }

    private String turnInfo(WorkFlowInfo info, HttpServletRequest request) throws Exception {
        List lstTrans;
        WorkFlowXml xmlDao = WorkFlowXmlUtil.getInstanceModel((PfWorkFlowInstanceVo)info.getWorkFlowIntanceVo());
        ActivityModel activityModel = xmlDao.getActivity(info.getSourceActivity().getActivityDefinitionId());
        String filterType = null;
        ArrayList<String> filterStr = null;
        if (StringUtils.isNotBlank((String)activityModel.getFilterInfo())) {
            List organList;
            Document fileDoc = DocumentHelper.parseText((String)activityModel.getFilterInfo());
            String user = fileDoc.getRootElement().valueOf("@type");
            Node corNode = fileDoc.selectSingleNode("//Filter/" + user + "[@Id='" + SessionUtil.getUserId((HttpServletRequest)request) + "']/Correspondence");
            if (corNode != null && (organList = corNode.selectNodes((filterType = corNode.valueOf("@type")) + "/text()")) != null && !organList.isEmpty()) {
                filterStr = new ArrayList<String>();
                for (DefaultText text : organList) {
                    filterStr.add(text.getText());
                }
            }
        }
        WorkFlowTransInfo transInfo = info.getTransInfo();
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("Activitys");
        if (transInfo.getTransType().equalsIgnoreCase("and")) {
            root.addAttribute("RelType", "and");
        } else {
            root.addAttribute("RelType", "or");
        }
        if (activityModel.getIsRequiredOpinion().equalsIgnoreCase("true")) {
            root.addAttribute("ReqOpinion", "true");
        } else {
            root.addAttribute("ReqOpinion", "false");
        }
        if (activityModel.getIsSendSMS().equalsIgnoreCase("true")) {
            root.addAttribute("SendSMS", "true");
        } else {
            root.addAttribute("SendSMS", "false");
        }
        if (StringUtils.isNotBlank((String)activityModel.getCooperRootId())) {
            root.addAttribute("cooperRootId", activityModel.getCooperRootId());
        }
        if ((lstTrans = transInfo.getTranActivitys()).size() < 2) {
            root.addAttribute("RelType", "or");
        }
        for (ActivityModel aModel : lstTrans) {
            Element ActivityEle = root.addElement("Activity");
            ActivityEle.addAttribute("Name", aModel.getActivityDefineName());
            ActivityEle.addAttribute("Id", aModel.getDefineId());
            if (aModel.isMutiSelect()) {
                ActivityEle.addAttribute("MutiSelect", "true");
            }
            if (!aModel.isSelectAll()) {
                ActivityEle.addAttribute("SelectAll", "false");
            } else {
                ActivityEle.addAttribute("SelectAll", "true");
            }
            if (aModel.getActivityDefineName().equalsIgnoreCase(activityModel.getDefaultSelectName())) {
                ActivityEle.addAttribute("DefaultSelected", "true");
            } else {
                ActivityEle.addAttribute("DefaultSelected", "false");
            }
            String userName = null;
            if (StringUtils.isNotBlank((String)aModel.getExtendedAttribute("DefaultSelectedUser"))) {
                userName = aModel.getExtendedAttribute("DefaultSelectedUser");
            }
            String allowTurnEmptyRole = "," + aModel.getExtendedAttribute("allowTurnEmptyRole") + ",";
            String allowTurnAllRole = "," + aModel.getExtendedAttribute("allowTurnAllRole") + ",";
            for (PerformerTaskModel userModel : aModel.getPerformerModelList()) {
                if (filterStr != null && userModel.getType().equals(filterType) && !filterStr.contains(userModel.getId())) continue;
                Element User = ActivityEle.addElement("User");
                User.addAttribute("Name", userModel.getName());
                User.addAttribute("Id", userModel.getId());
                if (StringUtils.contains((String)allowTurnEmptyRole, (String)("," + userModel.getName() + ","))) {
                    User.addAttribute("allowEmpty", "true");
                }
                if (StringUtils.contains((String)allowTurnAllRole, (String)("," + userModel.getName() + ","))) {
                    User.addAttribute("allowAll", "true");
                }
                for (PfUserVo vo : userModel.getUserList()) {
                    Element UserInfo2 = User.addElement("UserInfo");
                    UserInfo2.addAttribute("Name", vo.getUserName());
                    UserInfo2.addAttribute("Id", vo.getUserId());
                    if (!StringUtils.isNotBlank((String)userName) || !vo.getUserName().equalsIgnoreCase(userName)) continue;
                    User.addAttribute("DefaultSelected", "true");
                    UserInfo2.addAttribute("DefaultSelected", "true");
                }
            }
        }
        if (transInfo.isCanFinish()) {
            Element ActivityEle = root.addElement("Activity");
            ActivityEle.addAttribute("Name", "\u4efb\u52a1\u529e\u7ed3");
            ActivityEle.addAttribute("Id", "-1");
        }
        doc = this.httpFilterXml(doc, activityModel, info);
        return doc.getRootElement().asXML();
    }

    private Document httpFilterXml(Document doc, ActivityModel actModel, WorkFlowInfo info) {
        if (StringUtils.isNotBlank((String)actModel.getTurnInfoUrl())) {
            String url = actModel.getTurnInfoUrl();
            if (!url.startsWith("http")) {
                url = AppConfig.getPlaceholderValue((String)url);
            }
            HttpClient httpClient = new HttpClient();
            Utf8PostMethod postMethod = new Utf8PostMethod(url);
            NameValuePair[] data = new NameValuePair[]{new NameValuePair("turnInfo", doc.asXML()), new NameValuePair("userId", info.getUserId()), new NameValuePair("proId", info.getWorkFlowIntanceVo() == null ? "" : info.getWorkFlowIntanceVo().getProId())};
            postMethod.setRequestBody(data);
            int status = 0;
            try {
                status = httpClient.executeMethod((HttpMethod)postMethod);
            }
            catch (IOException e) {
                log.error((Object)"TurnInfo filter url request failer{}", (Throwable)e);
            }
            if (status == 200) {
                try {
                    String xml = postMethod.getResponseBodyAsString();
                    if (StringUtils.isNotBlank((String)xml)) {
                        doc = DocumentHelper.parseText((String)xml);
                    }
                }
                catch (Exception e) {
                    log.error((Object)"TurnInfo filter url request success,prase failure{}", (Throwable)e);
                }
            } else {
                log.error((Object)"TurnInfo filter url request failer");
            }
        }
        return doc;
    }

    @ResponseBody
    @RequestMapping(value={"/getTurnWorkFlowInfo"}, method={RequestMethod.GET})
    public String getTurnWorkFlowInfo(Model model, @RequestParam(value="taskid", required=false) String taskid, HttpServletRequest request) throws Exception {
        HashMap map = new HashMap();
        String userId = SessionUtil.getCurrentUserId();
        WorkFlowInfo info = null;
        info = this.workFlowService.getWorkFlowTurnInfo(userId, taskid);
        String proid = "";
        if (info != null && info.getWorkFlowIntanceVo() != null && StringUtils.isNotBlank((String)info.getWorkFlowIntanceVo().getProId())) {
            proid = info.getWorkFlowIntanceVo().getProId();
        }
        return proid;
    }

    @ResponseBody
    @RequestMapping(value={"/filterJoinTransUser"})
    public Object filterJoinTransUser(String proid, String taskid, String targetAdIds) {
        HashMap filterUserMapList = new HashMap();
        String firstTurnFilter = AppConfig.getProperty((String)"portal.mutil2one.filter.firstturn");
        if (!StringUtils.equalsIgnoreCase((String)"true", (String)firstTurnFilter)) {
            return filterUserMapList;
        }
        if (StringUtils.isNotBlank((String)proid) && StringUtils.isNotBlank((String)targetAdIds)) {
            String[] targetAdIdAry = StringUtils.split((String)targetAdIds, (String)";");
            try {
                block2: for (int i = 0; i < targetAdIdAry.length; ++i) {
                    PfTaskVo tmpTaskVo;
                    String targetAdId = targetAdIdAry[i];
                    PfWorkFlowInstanceVo workFlowInstanceVo = this.workFlowIntanceService.getWorkflowInstance(proid);
                    PfActivityVo activityVo = this.taskService.getActivityBywIdandadId(proid, targetAdId);
                    if (activityVo == null) continue;
                    String activityId = activityVo.getActivityId();
                    String tmpAcId = WorkFlowUtil.buildTEMPActivityId((String)activityId);
                    List tmpTaskList = this.taskService.getTaskListByActivity(tmpAcId);
                    if (tmpTaskList == null || tmpTaskList.size() == 0) {
                        tmpTaskList = this.taskService.getHistoryTasks(activityId);
                    }
                    if (tmpTaskList == null || tmpTaskList.size() <= 0 || (tmpTaskVo = (PfTaskVo)tmpTaskList.get(0)) == null) continue;
                    String targetUserid = tmpTaskVo.getUserVo().getUserId();
                    PfUser user = (PfUser)this.userService.findById((Object)targetUserid);
                    LinkedHashMap roleMap = this.userRoleService.getRoleMapByUserid(targetUserid);
                    WorkFlowXml workXml = WorkFlowXmlUtil.getInstanceModel((PfWorkFlowInstanceVo)workFlowInstanceVo);
                    ActivityModel activityModel = workXml.getActivity(targetAdId);
                    if (!activityModel.getJoinType().equalsIgnoreCase("and")) continue;
                    List performerList = activityModel.getPerformerList();
                    for (PerformerModel pModel : performerList) {
                        if (!roleMap.containsKey(pModel.getRoleId())) continue;
                        HashMap<String, String> filterUserMap = new HashMap<String, String>();
                        filterUserMap.put("activityDefinitionId", targetAdId);
                        filterUserMap.put("userId", targetUserid);
                        filterUserMap.put("userName", user.getUserName());
                        filterUserMap.put("roleId", pModel.getRoleId());
                        filterUserMapList.put(targetAdId, filterUserMap);
                        continue block2;
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        System.out.println(JSON.toJSONString(filterUserMapList));
        return filterUserMapList;
    }
}

