/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web;

import com.gtis.common.http.Utf8PostMethod;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.SysOpinionService;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.WorkFlowTransInfo;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.PerformerTaskModel;
import com.gtis.portal.util.WorkFlowXml;
import com.gtis.portal.util.WorkFlowXmlUtil;
import com.gtis.web.SessionUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.tree.DefaultText;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/turnBackWorkFlow"})
public class TurnBackWorkFlowController {
    private static final Log log = LogFactory.getLog(TurnBackWorkFlowController.class);
    @Autowired
    SysWorkFlowDefineService workFlowDefineService;
    @Autowired
    NodeService nodeService;
    @Autowired
    SysWorkFlowInstanceService workFlowIntanceService;
    @Autowired
    SysTaskService taskService;
    @Autowired
    WorkFlowCoreService workFlowService;
    @Autowired
    SysOpinionService opinionService;

    @RequestMapping(value={""})
    public String turnBackWorkFlow(Model model, @RequestParam(value="taskid", required=false) String taskid, HttpServletRequest request) throws Exception {
        String userId = SessionUtil.getUserId((HttpServletRequest)request);
        WorkFlowInfo info = this.workFlowService.getWorkFlowTurnBackInfo(userId, taskid);
        ArrayList backActivitys = info.getTargetActivitys();
        if (backActivitys == null) {
            backActivitys = new ArrayList();
        }
        model.addAttribute("taskid", (Object)taskid);
        model.addAttribute("backActivitys", backActivitys);
        return "/task/handle/turn-back-workflow";
    }

    private String turnInfo(WorkFlowInfo info, HttpServletRequest request) throws Exception {
        List lstTrans;
        WorkFlowXml xmlDao = WorkFlowXmlUtil.getInstanceModel((PfWorkFlowInstanceVo)info.getWorkFlowIntanceVo());
        ActivityModel activityModel = xmlDao.getActivity(info.getSourceActivity().getActivityDefinitionId());
        String filterType = null;
        ArrayList<String> filterStr = null;
        if (StringUtils.isNotBlank((String)activityModel.getFilterInfo())) {
            List organList;
            Document fileDoc = DocumentHelper.parseText((String)activityModel.getFilterInfo());
            String user = fileDoc.getRootElement().valueOf("@type");
            Node corNode = fileDoc.selectSingleNode("//Filter/" + user + "[@Id='" + SessionUtil.getUserId((HttpServletRequest)request) + "']/Correspondence");
            if (corNode != null && (organList = corNode.selectNodes((filterType = corNode.valueOf("@type")) + "/text()")) != null && !organList.isEmpty()) {
                filterStr = new ArrayList<String>();
                for (DefaultText text : organList) {
                    filterStr.add(text.getText());
                }
            }
        }
        WorkFlowTransInfo transInfo = info.getTransInfo();
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("Activitys");
        if (transInfo.getTransType().equalsIgnoreCase("and")) {
            root.addAttribute("RelType", "and");
        } else {
            root.addAttribute("RelType", "or");
        }
        if (activityModel.getIsRequiredOpinion().equalsIgnoreCase("true")) {
            root.addAttribute("ReqOpinion", "true");
        } else {
            root.addAttribute("ReqOpinion", "false");
        }
        if (activityModel.getIsSendSMS().equalsIgnoreCase("true")) {
            root.addAttribute("SendSMS", "true");
        } else {
            root.addAttribute("SendSMS", "false");
        }
        if (StringUtils.isNotBlank((String)activityModel.getCooperRootId())) {
            root.addAttribute("cooperRootId", activityModel.getCooperRootId());
        }
        if ((lstTrans = transInfo.getTranActivitys()).size() < 2) {
            root.addAttribute("RelType", "or");
        }
        for (ActivityModel aModel : lstTrans) {
            Element ActivityEle = root.addElement("Activity");
            ActivityEle.addAttribute("Name", aModel.getActivityDefineName());
            ActivityEle.addAttribute("Id", aModel.getDefineId());
            if (aModel.isMutiSelect()) {
                ActivityEle.addAttribute("MutiSelect", "true");
            }
            if (!aModel.isSelectAll()) {
                ActivityEle.addAttribute("SelectAll", "false");
            } else {
                ActivityEle.addAttribute("SelectAll", "true");
            }
            if (aModel.getActivityDefineName().equalsIgnoreCase(activityModel.getDefaultSelectName())) {
                ActivityEle.addAttribute("DefaultSelected", "true");
            } else {
                ActivityEle.addAttribute("DefaultSelected", "false");
            }
            String userName = null;
            if (StringUtils.isNotBlank((String)aModel.getExtendedAttribute("DefaultSelectedUser"))) {
                userName = aModel.getExtendedAttribute("DefaultSelectedUser");
            }
            for (PerformerTaskModel userModel : aModel.getPerformerModelList()) {
                if (filterStr != null && userModel.getType().equals(filterType) && !filterStr.contains(userModel.getId())) continue;
                Element User = ActivityEle.addElement("User");
                User.addAttribute("Name", userModel.getName());
                User.addAttribute("Id", userModel.getId());
                for (PfUserVo vo : userModel.getUserList()) {
                    Element UserInfo2 = User.addElement("UserInfo");
                    UserInfo2.addAttribute("Name", vo.getUserName());
                    UserInfo2.addAttribute("Id", vo.getUserId());
                    if (StringUtils.isNotBlank((String)userName) && vo.getUserName().equalsIgnoreCase(userName)) {
                        User.addAttribute("DefaultSelected", "true");
                        UserInfo2.addAttribute("DefaultSelected", "true");
                    }
                    if (!vo.getUserId().equals(SessionUtil.getCurrentUserId())) continue;
                    User.addAttribute("DefaultSelected", "true");
                    UserInfo2.addAttribute("DefaultSelected", "true");
                }
            }
        }
        if (transInfo.isCanFinish()) {
            Element ActivityEle = root.addElement("Activity");
            ActivityEle.addAttribute("Name", "\u4efb\u52a1\u529e\u7ed3");
            ActivityEle.addAttribute("Id", "-1");
        }
        doc = this.httpFilterXml(doc, activityModel, info);
        return doc.getRootElement().asXML();
    }

    private Document httpFilterXml(Document doc, ActivityModel actModel, WorkFlowInfo info) {
        if (StringUtils.isNotBlank((String)actModel.getTurnInfoUrl())) {
            String url = actModel.getTurnInfoUrl();
            if (!url.startsWith("http")) {
                url = AppConfig.getPlaceholderValue((String)url);
            }
            HttpClient httpClient = new HttpClient();
            Utf8PostMethod postMethod = new Utf8PostMethod(url);
            NameValuePair[] data = new NameValuePair[]{new NameValuePair("turnInfo", doc.asXML()), new NameValuePair("userId", info.getUserId()), new NameValuePair("proId", info.getWorkFlowIntanceVo() == null ? "" : info.getWorkFlowIntanceVo().getProId())};
            postMethod.setRequestBody(data);
            int status = 0;
            try {
                status = httpClient.executeMethod((HttpMethod)postMethod);
            }
            catch (IOException e) {
                log.error((Object)"TurnInfo filter url request failer{}", (Throwable)e);
            }
            if (status == 200) {
                try {
                    String xml = postMethod.getResponseBodyAsString();
                    if (StringUtils.isNotBlank((String)xml)) {
                        doc = DocumentHelper.parseText((String)xml);
                    }
                }
                catch (Exception e) {
                    log.error((Object)"TurnInfo filter url request success,prase failure{}", (Throwable)e);
                }
            } else {
                log.error((Object)"TurnInfo filter url request failer");
            }
        }
        return doc;
    }
}

