/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web;

import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysAuthorService;
import com.gtis.plat.service.SysOpinionService;
import com.gtis.plat.service.SysSignService;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfOpinionVo;
import com.gtis.plat.vo.PfSignVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.portal.util.SignUitl;
import com.gtis.web.SessionUtil;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/sign"})
public class SignController {
    @Autowired
    private SysSignService signService;
    @Autowired
    private SysAuthorService authorService;
    @Autowired
    private SysOpinionService opinionService;
    @Autowired
    private SysWorkFlowDefineService workFlowDefineService;
    @Autowired
    private SysWorkFlowInstanceService workFlowInstanceService;
    @Autowired
    private SysTaskService sysTaskService;

    @RequestMapping(value={"tag"})
    public String signtag(Model model, String taskid, HttpServletRequest request) throws Exception {
        String optinionSize = "18";
        Object imagesUrl = null;
        String imageWidth = "52";
        String imageHeight = "24";
        Map parameterMap = request.getParameterMap();
        boolean createNew = true;
        boolean disabled = MapUtils.getBooleanValue((Map)parameterMap, (Object)"disabled");
        Object opinionType = null;
        boolean isOpinion = true;
        if (StringUtils.equalsIgnoreCase((String)"false", (String)request.getParameter("opinion"))) {
            isOpinion = false;
        }
        boolean orderByUserNo = MapUtils.getBooleanValue((Map)parameterMap, (Object)"orderByUserNo");
        boolean showSignDate = true;
        if (StringUtils.equalsIgnoreCase((String)"false", (String)MapUtils.getString((Map)parameterMap, (Object)"showSignDate"))) {
            showSignDate = false;
        }
        boolean signUserCheck = MapUtils.getBooleanValue((Map)parameterMap, (Object)"signUserCheck");
        PfSignVo signVo = this.initSignByRequest(request);
        List<Object> lstSign = new ArrayList<PfSignVo>();
        if (StringUtils.isNotBlank((String)signVo.getSignId())) {
            lstSign.add(this.signService.getSign(signVo.getSignId()));
        } else {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("signKey", signVo.getSignKey());
            map.put("proId", signVo.getProId());
            if (orderByUserNo) {
                map.put("_orderfield_", "t2.USER_NO");
            }
            lstSign = this.signService.getSignListOrderfield(map);
        }
        UserInfo userInfo = SessionUtil.getCurrentUser();
        signVo.setUserId(userInfo.getId());
        signVo.setSignName(userInfo.getUsername());
        if (disabled) {
            createNew = false;
        } else {
            for (PfSignVo sign : lstSign) {
                if (!signVo.getUserId().equals(sign.getUserId())) continue;
                createNew = false;
                signVo = sign;
                break;
            }
        }
        signUserCheck = AppConfig.getBooleanProperty((String)"signUserCheck.enable", (boolean)false);
        disabled = this.btnDisable(request, disabled);
        model.addAttribute("optinionSize", (Object)optinionSize);
        model.addAttribute("imagesUrl", imagesUrl);
        model.addAttribute("imageWidth", (Object)imageWidth);
        model.addAttribute("imageHeight", (Object)imageHeight);
        model.addAttribute("opinionType", opinionType);
        model.addAttribute("showSignDate", (Object)showSignDate);
        model.addAttribute("orderByUserNo", (Object)orderByUserNo);
        model.addAttribute("isOpinion", (Object)isOpinion);
        model.addAttribute("lstSign", lstSign);
        model.addAttribute("createNew", (Object)createNew);
        model.addAttribute("signUserCheck", (Object)signUserCheck);
        model.addAttribute("disabled", (Object)disabled);
        model.addAttribute("signVo", (Object)signVo);
        if (isOpinion) {
            return "/template/sign/sign";
        }
        return "/template/sign/sign-nooptinion";
    }

    @ResponseBody
    @RequestMapping(value={"/image"}, method={RequestMethod.GET})
    public void image(Model model, HttpServletResponse response, HttpServletRequest request) throws Exception {
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", -1L);
        PfSignVo signVo = new PfSignVo();
        if (response != null) {
            signVo.setSignId(request.getParameter("signVo.signId"));
        }
        if (StringUtils.isNotBlank((String)signVo.getSignId())) {
            PfSignVo signBean = this.signService.getSign(signVo.getSignId());
            PfSignVo sign = this.signService.getSignImage(signVo.getSignId());
            if (sign == null) {
                IOUtils.write((String)"", (OutputStream)response.getOutputStream());
            } else if (sign.getSignImage() != null && sign.getSignImage().length > 1000) {
                IOUtils.write((byte[])sign.getSignImage(), (OutputStream)response.getOutputStream());
            } else if (signBean != null) {
                SignUitl.BuildSignImage((String)signBean.getSignName(), (OutputStream)response.getOutputStream());
            }
        }
    }

    @RequestMapping(value={"/sign"}, method={RequestMethod.GET})
    public String opensign(Model model, HttpServletRequest request, String opinionType, String signNoOptinion) throws Exception {
        PfWorkFlowInstanceVo workflowInstance;
        PfSignVo signVo = this.initSignByRequest(request);
        if (signVo != null) {
            String signDate;
            UserInfo userInfo = SessionUtil.getCurrentUser();
            String taskid = request.getParameter("taskid");
            if (StringUtils.isNotBlank((String)signVo.getSignId())) {
                signVo = this.signService.getSign(signVo.getSignId());
            }
            if (signVo == null) {
                signVo = new PfSignVo();
            }
            if (StringUtils.isNotBlank((String)signVo.getSignId())) {
                signVo.setSignId(signVo.getSignId());
            }
            if (StringUtils.isNotBlank((String)signVo.getProId())) {
                signVo.setProId(request.getParameter("signVo.proId"));
            }
            if (StringUtils.isNotBlank((String)signVo.getSignOpinion())) {
                signVo.setSignOpinion(request.getParameter("signVo.signOpinion"));
            }
            if (StringUtils.isNotBlank((String)signVo.getSignKey())) {
                signVo.setSignKey(request.getParameter("signVo.signKey"));
            }
            if (signVo.getSignDate() == null && StringUtils.isNotBlank((String)(signDate = request.getParameter("signVo.signDate")))) {
                signVo.setSignDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(signDate));
            }
            model.addAttribute("signVo", (Object)signVo);
            model.addAttribute("userId", (Object)userInfo.getId());
            model.addAttribute("taskid", (Object)taskid);
        }
        if (StringUtils.isBlank((String)opinionType) && StringUtils.isNotBlank((String)signVo.getProId()) && (workflowInstance = this.workFlowInstanceService.getWorkflowInstanceByProId(signVo.getProId())) != null) {
            PfWorkFlowDefineVo workFlowDefineVo = this.workFlowDefineService.getWorkFlowDefine(workflowInstance.getWorkflowDefinitionId());
            opinionType = workFlowDefineVo.getWorkflowName();
        }
        model.addAttribute("opinionType", (Object)opinionType);
        model.addAttribute("signNoOptinion", (Object)signNoOptinion);
        if (StringUtils.equalsIgnoreCase((String)"true", (String)signNoOptinion)) {
            return "/sign/signNo";
        }
        return "/sign/sign";
    }

    @ResponseBody
    @RequestMapping(value={"/menu"}, method={RequestMethod.GET})
    public List<PfOpinionVo> menu(Model model, HttpServletResponse response, HttpServletRequest request) throws Exception {
        List lstOpinions = null;
        if (request != null) {
            String taskid = request.getParameter("taskid");
            String opinionType = request.getParameter("opinionType");
            UserInfo userInfo = SessionUtil.getCurrentUser();
            String UserId = userInfo.getId();
            String activityName = "";
            if (StringUtils.isNotBlank((String)taskid)) {
                activityName = this.sysTaskService.getActivity(this.sysTaskService.getTask(taskid).getActivityId()).getActivityName();
                String wiid = this.sysTaskService.getActivity(this.sysTaskService.getTask(taskid).getActivityId()).getWorkflowInstanceId();
                opinionType = this.workFlowDefineService.getWorkFlowDefine(this.workFlowInstanceService.getWorkflowInstance(wiid).getWorkflowDefinitionId()).getWorkflowName();
            }
            lstOpinions = StringUtils.isNotBlank((String)activityName) ? this.opinionService.getOpinionList(UserId, opinionType, activityName) : this.opinionService.getOpinionList(UserId, opinionType);
        }
        return lstOpinions;
    }

    @ResponseBody
    @RequestMapping(value={"/autosign"}, method={RequestMethod.GET})
    public Object autosign(Model model, HttpServletResponse response, HttpServletRequest request) throws Exception {
        PfSignVo signVo = this.initSignByRequest(request);
        if (signVo != null) {
            PfSignVo sign = this.signService.getSign(signVo.getSignId());
            if (sign != null) {
                sign.setSignOpinion(signVo.getSignOpinion());
                sign.setSignDate(signVo.getSignDate());
                this.signService.updateAutoSign(sign);
                signVo = sign;
            } else {
                this.signService.insertAutoSign(signVo);
            }
        }
        return signVo;
    }

    @ResponseBody
    @RequestMapping(value={"/savesign"}, method={RequestMethod.GET})
    public Object savesign(Model model, HttpServletResponse response, HttpServletRequest request, String signPoints) throws Exception {
        PfSignVo signVo = this.initSignByRequest(request);
        if (signVo != null) {
            PfSignVo sign = this.signService.getSign(signVo.getSignId());
            if (sign != null) {
                sign.setSignOpinion(signVo.getSignOpinion());
                if (signVo.getSignDate() == null) {
                    signVo.setSignDate(new Date(System.currentTimeMillis()));
                }
                sign.setSignDate(signVo.getSignDate());
                sign.setSignType("0");
                this.signService.updateSign(sign);
                this.signService.UpdateCustomSignPic(signVo.getSignId(), signPoints);
                signVo = sign;
            } else {
                String signId = this.signService.AddCustomSign(SessionUtil.getCurrentUserId(), signVo.getProId(), signVo.getSignKey(), signPoints);
                signVo.setSignId(signId);
                signVo.setSignType("0");
                this.signService.updateSign(signVo);
            }
        }
        return signVo;
    }

    @ResponseBody
    @RequestMapping(value={"/saveSignOpinion"}, method={RequestMethod.GET})
    public Object saveSignOpinion(Model model, HttpServletResponse response, HttpServletRequest request) throws Exception {
        PfSignVo signVo = this.initSignByRequest(request);
        if (signVo != null) {
            PfSignVo sign = this.signService.getSign(signVo.getSignId());
            if (sign == null) {
                this.signService.insertAutoSign(signVo);
            }
            sign.setSignOpinion(signVo.getSignOpinion());
            if (signVo.getSignDate() == null) {
                signVo.setSignDate(Calendar.getInstance().getTime());
            }
            sign.setSignDate(signVo.getSignDate());
            this.signService.updateSign(signVo);
        }
        return signVo;
    }

    @ResponseBody
    @RequestMapping(value={"/saveSignDate"}, method={RequestMethod.GET})
    public Object saveSignDate(Model model, HttpServletResponse response, HttpServletRequest request) throws Exception {
        PfSignVo signVo = this.initSignByRequest(request);
        if (signVo != null) {
            PfSignVo sign = this.signService.getSign(signVo.getSignId());
            if (sign == null) {
                this.signService.insertAutoSign(signVo);
            }
            if (signVo.getSignDate() == null) {
                signVo.setSignDate(Calendar.getInstance().getTime());
            }
            sign.setSignDate(signVo.getSignDate());
            this.signService.updateSign(sign);
        }
        return signVo;
    }

    @ResponseBody
    @RequestMapping(value={"/deleteSign"}, method={RequestMethod.GET})
    public void deleteSign(Model model, HttpServletResponse response, HttpServletRequest request) throws Exception {
        PfSignVo signVo = this.initSignByRequest(request);
        if (signVo != null && StringUtils.isNotBlank((String)signVo.getSignId())) {
            this.signService.deleteSign(signVo.getSignId());
        }
    }

    private boolean btnDisable(HttpServletRequest request, boolean disabled) {
        PfSignVo signVo = this.initSignByRequest(request);
        String disable = request.getParameter("disable");
        if (!"true".equals(disable)) {
            if (!disabled) {
                PfWorkFlowInstanceVo workFlowInstanceVo;
                String from = request.getParameter("from");
                String rid = request.getParameter("rid");
                String wiid = request.getParameter("wiid");
                if (StringUtils.isBlank((String)wiid) && (workFlowInstanceVo = this.workFlowInstanceService.getWorkflowInstanceByProId(signVo.getProId())) != null) {
                    wiid = workFlowInstanceVo.getWorkflowIntanceId();
                }
                if (!(StringUtils.isBlank((String)from) || StringUtils.isBlank((String)rid) || StringUtils.isBlank((String)wiid))) {
                    if ("task".equalsIgnoreCase(from)) {
                        String taskid = request.getParameter("taskid");
                        disabled = this.authorService.queryTaskElement(wiid, taskid, rid, signVo.getSignKey());
                    } else if ("pro".equalsIgnoreCase(from)) {
                        String roles = SessionUtil.getUserInfo((HttpServletRequest)request).getRoleIds();
                        disabled = true;
                    }
                }
            }
        } else {
            disabled = true;
        }
        return disabled;
    }

    private PfSignVo initSignByRequest(HttpServletRequest request) {
        PfSignVo signVo = null;
        try {
            if (request != null) {
                signVo = new PfSignVo();
                signVo.setSignId(request.getParameter("signVo.signId"));
                signVo.setProId(request.getParameter("signVo.proId"));
                signVo.setSignOpinion(request.getParameter("signVo.signOpinion"));
                signVo.setSignKey(request.getParameter("signVo.signKey"));
                String signDate = request.getParameter("signVo.signDate");
                if (StringUtils.isNotBlank((String)signDate)) {
                    signVo.setSignDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(signDate));
                }
                if (signVo.getSignDate() == null) {
                    signVo.setSignDate(Calendar.getInstance().getTime());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return signVo;
    }

    @RequestMapping(value={"signCheck"})
    public String openSignCheck(Model model, HttpServletResponse response, HttpServletRequest request) {
        return "/sign/sign-check";
    }
}

