/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.model.impl.File;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.SysDistrictService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.SysWorkFlowInstanceRelService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.portal.model.Ztree;
import com.gtis.portal.service.IndexService;
import com.gtis.portal.service.PfSubsystemService;
import com.gtis.portal.service.PfUserService;
import com.gtis.portal.util.RequestUtils;
import com.gtis.portal.web.BaseController;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/fileCenter"})
public class FileCenterController
extends BaseController {
    @Autowired
    SysUserService sysUserService;
    @Autowired
    SysDistrictService sysDistrictService;
    @Autowired
    IndexService indexService;
    @Autowired
    PfSubsystemService subsystemService;
    @Autowired
    PfUserService pfUserService;
    @Autowired
    NodeService nodeService;
    @Autowired
    SysWorkFlowInstanceService workFlowIntanceService;
    @Autowired
    SysWorkFlowInstanceRelService workFlowInstanceRelService;

    @RequestMapping(value={"select"})
    public String treeSelect(Model model, String fromProid, String toProid) {
        model.addAttribute("fromProid", (Object)fromProid);
        model.addAttribute("toProid", (Object)toProid);
        return "/fileCenter/file-tree-select";
    }

    @RequestMapping(value={"leftjson"})
    @ResponseBody
    public Object leftjson(Model model, String fromProid) throws Exception {
        Space space;
        Node node;
        if (StringUtils.isNotBlank((String)fromProid) && (node = this.nodeService.getNode((space = this.nodeService.getWorkSpace("WORK_FLOW_STUFF", true)).getId(), fromProid, true)) != null) {
            String name = node.getName();
            PfWorkFlowInstanceVo workFlowInstanceVo = this.workFlowIntanceService.getWorkflowInstance(fromProid);
            name = workFlowInstanceVo != null ? workFlowInstanceVo.getWorkflowIntanceName() : "\u6839\u76ee\u5f55";
            Ztree root = new Ztree();
            root.setId(String.valueOf(node.getId()));
            root.setName(name);
            root.setChkDisabled(true);
            root.setParent(true);
            root.setIcon(RequestUtils.initOptProperties((String)(AppConfig.getProperty((String)"portal.url") + "/static/images/folder.gif")));
            List nodeList = this.nodeService.getAllChildNodes(node.getId());
            if (nodeList != null && nodeList.size() > 0) {
                LinkedHashMap<String, Ztree> nodeTreeMap = new LinkedHashMap<String, Ztree>();
                for (Node childNode : nodeList) {
                    nodeTreeMap.put(String.valueOf(childNode.getId()), this.nodeToZtree(childNode, true));
                }
                for (Ztree tree : nodeTreeMap.values()) {
                    if (tree.getPid() == null) continue;
                    Ztree ztree = (Ztree)nodeTreeMap.get(tree.getPid());
                    if (ztree != null) {
                        ztree.addChild(tree);
                        continue;
                    }
                    root.addChild(tree);
                }
            }
            return root;
        }
        return null;
    }

    @RequestMapping(value={"rightjson"})
    @ResponseBody
    public Object rightjson(Model model, String toProid) throws Exception {
        Space space;
        Node node;
        if (StringUtils.isNotBlank((String)toProid) && (node = this.nodeService.getNode((space = this.nodeService.getWorkSpace("WORK_FLOW_STUFF", true)).getId(), toProid, true)) != null) {
            String name = node.getName();
            PfWorkFlowInstanceVo workFlowInstanceVo = this.workFlowIntanceService.getWorkflowInstance(toProid);
            name = workFlowInstanceVo != null ? workFlowInstanceVo.getWorkflowIntanceName() : "\u6839\u76ee\u5f55";
            Ztree root = new Ztree();
            root.setId(String.valueOf(node.getId()));
            root.setName(name);
            root.setChkDisabled(true);
            root.setParent(true);
            root.setIcon(RequestUtils.initOptProperties((String)(AppConfig.getProperty((String)"portal.url") + "/static/images/folder.gif")));
            List nodeList = this.nodeService.getAllChildNodes(node.getId());
            if (nodeList != null && nodeList.size() > 0) {
                LinkedHashMap<String, Ztree> nodeTreeMap = new LinkedHashMap<String, Ztree>();
                for (Node childNode : nodeList) {
                    nodeTreeMap.put(String.valueOf(childNode.getId()), this.nodeToZtree(childNode, false));
                }
                for (Ztree tree : nodeTreeMap.values()) {
                    if (tree.getPid() == null) continue;
                    Ztree ztree = (Ztree)nodeTreeMap.get(tree.getPid());
                    if (ztree != null) {
                        ztree.addChild(tree);
                        continue;
                    }
                    root.addChild(tree);
                }
            }
            return root;
        }
        return null;
    }

    @RequestMapping(value={"save"})
    @ResponseBody
    public Object saveJson(Model model, String fromProid, String toProid, String nodes) throws Exception {
        if (StringUtils.isNotBlank((String)fromProid) && StringUtils.isNotBlank((String)toProid) && StringUtils.isNotBlank((String)nodes)) {
            try {
                List nodeList = (List)JSON.parseObject((String)nodes, List.class);
                LinkedHashMap treeMap = this.fileNodeToTreeMap(nodeList);
                System.out.println(JSON.toJSONString((Object)treeMap));
                Space space = this.nodeService.getWorkSpace("WORK_FLOW_STUFF", true);
                Node leftNode = this.nodeService.getNode(space.getId(), fromProid, true);
                if (leftNode != null) {
                    HashMap leftMap = this.fileNodeToMap(leftNode.getId());
                    HashMap<String, Node> newMap = new HashMap<String, Node>();
                    Node rightNode = this.nodeService.getNode(space.getId(), toProid, true);
                    if (rightNode != null) {
                        HashMap rightMap = this.fileNodeToMap(rightNode.getId());
                        rightMap.put(rightNode.getId(), rightNode);
                        for (Map.Entry entry : treeMap.entrySet()) {
                            Ztree pTree;
                            Node newNode;
                            Ztree tree = (Ztree)entry.getValue();
                            String tid = tree.getKz1();
                            String pTid = tree.getKz2();
                            Node leftChild = (Node)leftMap.get(Integer.parseInt(tree.getId()));
                            if (leftChild == null || !StringUtils.isNotBlank((String)leftChild.getName())) continue;
                            Integer pid = Integer.parseInt(tree.getPid());
                            if (rightMap.containsKey(pid)) {
                                Node rightChild = (Node)rightMap.get(pid);
                                if (rightChild == null) continue;
                                if (leftChild instanceof File) {
                                    Integer[] ids = new Integer[]{leftChild.getId()};
                                    this.nodeService.copy(ids, rightChild.getId(), true);
                                    continue;
                                }
                                newNode = this.nodeService.getNode(rightChild.getId(), leftChild.getName(), true);
                                newMap.put(tid, newNode);
                                continue;
                            }
                            if (!leftMap.containsKey(pid) || (pTree = (Ztree)treeMap.get(pTid)) == null || (newNode = (Node)newMap.get(pTree.getKz1())) == null) continue;
                            if (leftChild instanceof File) {
                                Integer[] ids = new Integer[]{leftChild.getId()};
                                this.nodeService.copy(ids, newNode.getId(), true);
                                continue;
                            }
                            Node newNodeChild = this.nodeService.getNode(newNode.getId(), leftChild.getName(), true);
                            newMap.put(tid, newNodeChild);
                        }
                        this.workFlowInstanceRelService.deleteWorkFlowRel(fromProid, toProid);
                        this.workFlowInstanceRelService.deleteWorkFlowRel(toProid, fromProid);
                        this.workFlowInstanceRelService.insertWorkFlowRel(fromProid, toProid);
                    }
                }
                return this.handlerSuccessJson();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.handlerErrorJson("\u64cd\u4f5c\u5931\u8d25\uff01");
    }

    private Ztree nodeToZtree(Node node, boolean isdrag) {
        Ztree tree = new Ztree();
        tree.setId(String.valueOf(node.getId()));
        tree.setName(node.getName());
        tree.setPid(String.valueOf(node.getParentId()));
        if (!(node instanceof File)) {
            tree.setParent(true);
            tree.setIcon(RequestUtils.initOptProperties((String)(AppConfig.getProperty((String)"portal.url") + "/static/images/folder.gif")));
        }
        tree.setDrag(isdrag);
        return tree;
    }

    private HashMap fileNodeToMap(Integer nodeId) {
        HashMap nodeMap = new HashMap();
        List leftNodeList = this.nodeService.getAllChildNodes(nodeId);
        if (leftNodeList != null && leftNodeList.size() > 0) {
            for (int i = 0; i < leftNodeList.size(); ++i) {
                nodeMap.put(((Node)leftNodeList.get(i)).getId(), leftNodeList.get(i));
            }
        }
        return nodeMap;
    }

    private LinkedHashMap<String, Ztree> fileNodeToTreeMap(List<JSONObject> nodeList) {
        LinkedHashMap<String, Ztree> treeMap = new LinkedHashMap<String, Ztree>();
        for (int i = 0; i < nodeList.size(); ++i) {
            Ztree tree = this.ztreeNodeToZtree(nodeList.get(i));
            String tId = MapUtils.getString((Map)((Map)nodeList.get(i)), (Object)"tId");
            String parentTId = MapUtils.getString((Map)((Map)nodeList.get(i)), (Object)"parentTId");
            tree.setKz1(tId);
            tree.setKz2(parentTId);
            treeMap.put(tId, tree);
        }
        return treeMap;
    }

    private Ztree ztreeNodeToZtree(JSONObject jsonObject) {
        Ztree tree = new Ztree();
        tree.setId(MapUtils.getString((Map)jsonObject, (Object)"id"));
        tree.setName(MapUtils.getString((Map)jsonObject, (Object)"name"));
        tree.setPid(MapUtils.getString((Map)jsonObject, (Object)"pid"));
        tree.setDrag(MapUtils.getBooleanValue((Map)jsonObject, (Object)"drag"));
        return tree;
    }
}

