/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.util;

import com.gtis.config.AppConfig;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.util.PropertyPlaceholderHelper;
import org.springframework.web.util.UrlPathHelper;

/*
 * Exception performing whole class analysis ignored.
 */
public class RequestUtils {
    public static UrlPathHelper URL_PATH_HELPER = new /* Unavailable Anonymous Inner Class!! */;
    public static PathMatcher PATH_MATCHER = new AntPathMatcher();

    public static String getClientIP(HttpServletRequest request) {
        String xForwardedFor = StringUtils.trimToNull((String)request.getHeader("$wsra"));
        if (xForwardedFor != null) {
            return xForwardedFor;
        }
        xForwardedFor = StringUtils.trimToNull((String)request.getHeader("X-Real-IP"));
        if (xForwardedFor != null) {
            return xForwardedFor;
        }
        xForwardedFor = StringUtils.trimToNull((String)request.getHeader("X-Forwarded-For"));
        if (xForwardedFor != null) {
            int spaceIndex = xForwardedFor.indexOf(44);
            if (spaceIndex > 0) {
                return xForwardedFor.substring(0, spaceIndex);
            }
            return xForwardedFor;
        }
        return request.getRemoteAddr();
    }

    public static String getDomain(HttpServletRequest request) {
        StringBuffer url = request.getRequestURL();
        int end = url.indexOf(".");
        if (end == -1) {
            return "";
        }
        int start = url.indexOf("//");
        return url.substring(start + 2, end);
    }

    public static boolean isPost(HttpServletRequest request) {
        return "POST".equals(request.getMethod());
    }

    public static boolean matchAny(HttpServletRequest request, UrlPathHelper urlPathHelper, PathMatcher pathMatcher, String[] patterns) {
        if (ArrayUtils.isNotEmpty((Object[])patterns)) {
            String lookupPath = urlPathHelper.getLookupPathForRequest(request);
            for (String pattern : patterns) {
                if (!pathMatcher.match(pattern, lookupPath)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean matchAll(HttpServletRequest request, UrlPathHelper urlPathHelper, PathMatcher pathMatcher, String[] patterns) {
        if (ArrayUtils.isNotEmpty((Object[])patterns)) {
            String lookupPath = urlPathHelper.getLookupPathForRequest(request);
            for (String pattern : patterns) {
                if (pathMatcher.match(pattern, lookupPath)) continue;
                return false;
            }
        }
        return true;
    }

    public static Boolean getBool(HttpServletRequest request, String name) {
        String value = request.getParameter(name);
        return StringUtils.isEmpty((String)value) ? null : BooleanUtils.toBooleanObject((String)value);
    }

    public static boolean getBool(HttpServletRequest request, String name, boolean def) {
        Boolean value = RequestUtils.getBool((HttpServletRequest)request, (String)name);
        return value == null ? def : value;
    }

    public static Integer getInt(HttpServletRequest request, String name) {
        String value = request.getParameter(name);
        return StringUtils.isEmpty((String)value) ? null : NumberUtils.createInteger((String)value);
    }

    public static int getInt(HttpServletRequest request, String name, int def) {
        Integer value = RequestUtils.getInt((HttpServletRequest)request, (String)name);
        return value == null ? def : value;
    }

    public static Double getDouble(HttpServletRequest request, String name) {
        String value = request.getParameter(name);
        return StringUtils.isEmpty((String)value) ? null : NumberUtils.createDouble((String)value);
    }

    public static double getDouble(HttpServletRequest request, String name, double def) {
        Double value = RequestUtils.getDouble((HttpServletRequest)request, (String)name);
        return value == null ? def : value;
    }

    public static String initOptProperties(String url) {
        if (url != null) {
            PropertyPlaceholderHelper propertyPlaceholderHelper = new PropertyPlaceholderHelper("${", "}");
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)AppConfig.getProperties());
            url = propertyPlaceholderHelper.replacePlaceholders(url, properties);
        }
        return url;
    }

    public static boolean checkIsAdmin() {
        UserInfo userInfo = SessionUtil.getCurrentUser();
        return userInfo != null && StringUtils.equalsIgnoreCase((String)"0", (String)userInfo.getId());
    }
}

