/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.support.spring;

import com.gtis.portal.util.RequestUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.PathMatcher;
import org.springframework.util.StopWatch;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.UrlPathHelper;

public class PerformanceMonitorInterceptor
implements HandlerInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(PerformanceMonitorInterceptor.class);
    private final String KEY = "pmi_" + this.hashCode() + "_";
    private String[] excludes;

    public void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (LOG.isDebugEnabled()) {
            if (this.excludes != null && RequestUtils.matchAny((HttpServletRequest)request, (UrlPathHelper)RequestUtils.URL_PATH_HELPER, (PathMatcher)RequestUtils.PATH_MATCHER, (String[])this.excludes)) {
                return true;
            }
            StopWatch stopWatch = new StopWatch("Uri:" + request.getRequestURI());
            request.setAttribute(this.getKey(request), (Object)stopWatch);
            stopWatch.start();
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        StopWatch stopWatch;
        if (LOG.isDebugEnabled() && (stopWatch = (StopWatch)request.getAttribute(this.getKey(request))) != null) {
            stopWatch.stop();
            LOG.debug(stopWatch.shortSummary());
        }
    }

    private String getKey(HttpServletRequest request) {
        return this.KEY + request.getRequestURI();
    }
}

