/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.support.hibernate;

import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PreDeleteEvent;
import org.hibernate.event.spi.PreDeleteEventListener;
import org.hibernate.event.spi.PreInsertEvent;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.Type;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public final class OneToManyCacheCleaner
implements PreInsertEventListener,
PreDeleteEventListener,
InitializingBean {
    private static final long serialVersionUID = 8106108888493751911L;
    private SessionFactory sessionFactory;

    @Autowired
    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public boolean onPreInsert(PreInsertEvent event) {
        this.clean(event.getSession(), event.getEntity(), event.getPersister());
        return false;
    }

    public boolean onPreDelete(PreDeleteEvent event) {
        this.clean(event.getSession(), event.getEntity(), event.getPersister());
        return false;
    }

    private void clean(EventSource session, Object entity, EntityPersister persister) {
        Type[] propertyTypes = persister.getPropertyTypes();
        int len = propertyTypes.length;
        block0: for (int i = 0; i < len; ++i) {
            Object parent;
            Type type = propertyTypes[i];
            if (!(type instanceof ManyToOneType) || (parent = persister.getPropertyValue(entity, i)) == null) continue;
            EntityPersister parentPersister = session.getEntityPersister(((ManyToOneType)type).getAssociatedEntityName(), parent);
            for (Type type1 : parentPersister.getPropertyTypes()) {
                if (!(type1 instanceof CollectionType)) continue;
                CollectionType collectionType = (CollectionType)type1;
                CollectionPersister collectionPersister = session.getFactory().getCollectionPersister(collectionType.getRole());
                if (!persister.getEntityName().equals(collectionPersister.getElementType().getName()) || !collectionPersister.hasCache()) continue;
                session.getFactory().getCache().evictCollection(collectionType.getRole(), parentPersister.getIdentifier(parent, (SessionImplementor)session));
                continue block0;
            }
        }
    }

    public void afterPropertiesSet() {
        EventListenerRegistry registry = (EventListenerRegistry)((SessionFactoryImplementor)this.sessionFactory).getServiceRegistry().getService(EventListenerRegistry.class);
        registry.getEventListenerGroup(EventType.PRE_INSERT).appendListener((Object)this);
        registry.getEventListenerGroup(EventType.PRE_DELETE).appendListener((Object)this);
    }
}

