/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.service.SysActivityService;
import com.gtis.plat.service.SysSignService;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfRoleVo;
import com.gtis.plat.vo.PfSignVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.WorkFlowTransInfo;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.PerformerModel;
import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.service.WorkflowAutoTurnService;
import com.gtis.portal.util.CommonUtils;
import com.gtis.portal.util.WorkFlowXml;
import com.gtis.portal.util.WorkFlowXmlUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class WorkflowAutoTurnServiceImpl
implements WorkflowAutoTurnService {
    private static final Log log = LogFactory.getLog(WorkflowAutoTurnServiceImpl.class);
    @Value(value="${egov.conf}/portal/workflow_auto_turn.json")
    private String location;
    @Autowired
    BaseDao baseDao;
    @Autowired
    WorkFlowCoreService workFlowCoreService;
    @Autowired
    SysWorkFlowInstanceService workFlowInstanceService;
    @Autowired
    SysTaskService taskService;
    @Autowired
    SysActivityService activityService;
    @Autowired
    SysSignService signService;
    @Autowired
    SysUserService userService;

    public Map getWorkflowAutoTurnMap() {
        try {
            if (StringUtils.isNotBlank((String)this.location)) {
                return (Map)CommonUtils.readJsonFile((String)this.location);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public Map autoTurnWorkflowByAdId(String proid, String taskId, String userId) {
        try {
            String acId;
            PfActivityVo activityVo;
            PfTaskVo taskVo;
            if (StringUtils.isNotBlank((String)proid) && StringUtils.isNotBlank((String)taskId) && (taskVo = this.taskService.getTask(taskId)) != null && StringUtils.isNotBlank((String)taskVo.getActivityId()) && (activityVo = this.activityService.getActivityById(acId = taskVo.getActivityId())) != null && StringUtils.isNotBlank((String)activityVo.getActivityDefinitionId())) {
                String adId = activityVo.getActivityDefinitionId();
                Map turnMap = this.getWorkflowAutoTurnMap();
                Object obj = turnMap.get(adId);
                if (obj != null) {
                    boolean isok;
                    Map adConfigMap = (Map)obj;
                    String wdid = MapUtils.getString((Map)adConfigMap, (Object)"WORKFLOW_DEFINITION_ID");
                    List targetAdList = new ArrayList();
                    Object targetAds = MapUtils.getObject((Map)adConfigMap, (Object)"TARGET_ACTIVITY");
                    if (targetAds != null) {
                        targetAdList = (List)targetAds;
                    }
                    if (isok = this.turnWordkflow(userId, targetAdList, userId, taskId)) {
                        List signMapList = new ArrayList();
                        Object signs = MapUtils.getObject((Map)adConfigMap, (Object)"SIGN");
                        if (signs != null) {
                            signMapList = (List)signs;
                        }
                        if (!signMapList.isEmpty()) {
                            for (int i = 0; i < signMapList.size(); ++i) {
                                JSONObject signMap = (JSONObject)signMapList.get(i);
                                String signKey = MapUtils.getString((Map)signMap, (Object)"SIGN_KEY");
                                String signOpinion = MapUtils.getString((Map)signMap, (Object)"SIGN_OPINION");
                                List signList = this.signService.getSignListByUserId(signKey, proid, userId);
                                if (signList != null && signList.size() >= 1) continue;
                                PfSignVo signVo = new PfSignVo();
                                signVo.setProId(proid);
                                signVo.setSignKey(signKey);
                                signVo.setSignOpinion(signOpinion);
                                signVo.setSignId(UUIDGenerator.generate());
                                signVo.setUserId(userId);
                                this.signService.insertAutoSign(signVo);
                            }
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public boolean turnWordkflow(String proid, List targetAdList, String userId, String taskId) {
        try {
            boolean hasConfigNextAc = false;
            if (targetAdList != null && !targetAdList.isEmpty()) {
                hasConfigNextAc = true;
            }
            boolean hasNextAc = true;
            WorkFlowInfo info = this.workFlowCoreService.getWorkFlowTurnInfo(userId, taskId);
            WorkFlowXml workXml = WorkFlowXmlUtil.getInstanceModel((PfWorkFlowInstanceVo)info.getWorkFlowIntanceVo());
            WorkFlowTransInfo transInfo = info.getTransInfo();
            List lstTrans = transInfo.getTranActivitys();
            if (lstTrans == null || lstTrans.isEmpty()) {
                hasNextAc = false;
            }
            if (!hasNextAc) {
                this.finishWorkflow(proid);
            } else if (hasConfigNextAc) {
                if (lstTrans.size() == 1) {
                    String nextAdId;
                    String nextUserId = MapUtils.getString((Map)((JSONObject)targetAdList.get(0)), (Object)"USER_ID");
                    String turnXml = this.initTurnTaskXml(info, workXml, transInfo, nextUserId, nextAdId = ((ActivityModel)lstTrans.get(0)).getDefineId());
                    if (StringUtils.isNotBlank((String)turnXml)) {
                        Document doc = DocumentHelper.parseText((String)turnXml);
                        this.workFlowCoreService.turnTask(doc, taskId);
                    }
                } else if (lstTrans.size() > 1) {
                    for (int i = 0; i < targetAdList.size(); ++i) {
                        JSONObject adMap = (JSONObject)targetAdList.get(i);
                        String nextAdId = MapUtils.getString((Map)adMap, (Object)"ACTIVITY_DEFINITION_ID");
                        String nextUserId = MapUtils.getString((Map)adMap, (Object)"USER_ID");
                        for (int j = 0; j < lstTrans.size(); ++j) {
                            String turnXml;
                            if (!StringUtils.equals((String)nextAdId, (String)((ActivityModel)lstTrans.get(j)).getDefineId()) || !StringUtils.isNotBlank((String)(turnXml = this.initTurnTaskXml(info, workXml, transInfo, nextUserId, nextAdId)))) continue;
                            Document doc = DocumentHelper.parseText((String)turnXml);
                            this.workFlowCoreService.turnTask(doc, taskId);
                        }
                    }
                }
            }
            return true;
        }
        catch (Exception ex) {
            log.error((Object)("\u7528\u6237\uff1a" + userId + "\u8f6c\u53d1\u4efb\u52a1ID\uff1a" + taskId + "\u8f6c\u5411\u76ee\u6807\u8282\u70b9\uff1a\u8f6c\u53d1\u5931\u8d25\uff01"));
            return false;
        }
    }

    private String initTurnTaskXml(String userId, String nextUserId, String taskid, String nextAdId) throws Exception {
        WorkFlowInfo info = this.workFlowCoreService.getWorkFlowTurnInfo(userId, taskid);
        WorkFlowTransInfo transInfo = info.getTransInfo();
        List lstTrans = transInfo.getTranActivitys();
        if (lstTrans != null && lstTrans.size() > 0) {
            for (int i = 0; i < lstTrans.size(); ++i) {
                WorkFlowXml workXml;
                ActivityModel nextModel;
                List performerList;
                if (!StringUtils.equals((String)nextAdId, (String)((ActivityModel)lstTrans.get(i)).getDefineId()) || (performerList = (nextModel = (workXml = WorkFlowXmlUtil.getInstanceModel((PfWorkFlowInstanceVo)info.getWorkFlowIntanceVo())).getActivity(nextAdId)).getPerformerList()) == null || performerList.size() <= 0) continue;
                String roleId = "";
                List roleList = this.userService.getRoleListByUser(nextUserId);
                for (PerformerModel performerModel : performerList) {
                    if (!StringUtils.isNotBlank((String)performerModel.getRoleId())) continue;
                    boolean isok = false;
                    for (PfRoleVo roleVo : roleList) {
                        if (!StringUtils.equals((String)performerModel.getRoleId(), (String)roleVo.getRoleId())) continue;
                        roleId = performerModel.getRoleId();
                        isok = true;
                        break;
                    }
                    if (!isok) continue;
                    break;
                }
                if (!StringUtils.isNotBlank((String)roleId)) continue;
                String activityRelType = "";
                activityRelType = transInfo.getTransType().equalsIgnoreCase("and") ? "and" : "or";
                String activitysElement = "<Activitys RelType=\"" + activityRelType + "\"";
                activitysElement = activitysElement + " SendSMS= \"false\"";
                activitysElement = activitysElement + ">";
                String activityElement = "<Activity ";
                activityElement = activityElement + " Id=\"" + nextAdId + "\">";
                String userInfoElement = "<UserInfo ";
                userInfoElement = userInfoElement + " RoleId=\"" + roleId + "\"";
                userInfoElement = userInfoElement + " Id=\"" + nextUserId + "\">";
                userInfoElement = userInfoElement + "</UserInfo>";
                activityElement = activityElement + userInfoElement;
                activityElement = activityElement + "</Activity>";
                activitysElement = activitysElement + activityElement;
                String remarkElement = "<ReMark>";
                String remarkTextElement = "<text>";
                remarkTextElement = remarkTextElement + "</text>";
                remarkElement = remarkElement + remarkTextElement + "</ReMark>";
                activitysElement = activitysElement + remarkElement + "</Activitys>";
                return activitysElement;
            }
        } else {
            return "finish";
        }
        return null;
    }

    private String initTurnTaskXml(WorkFlowInfo info, WorkFlowXml workXml, WorkFlowTransInfo transInfo, String nextUserId, String nextAdId) throws Exception {
        ActivityModel nextModel = workXml.getActivity(nextAdId);
        List performerList = nextModel.getPerformerList();
        if (performerList != null && performerList.size() > 0) {
            String roleId = "";
            List roleList = this.userService.getRoleListByUser(nextUserId);
            for (PerformerModel performerModel : performerList) {
                if (!StringUtils.isNotBlank((String)performerModel.getRoleId())) continue;
                boolean isok = false;
                for (PfRoleVo roleVo : roleList) {
                    if (!StringUtils.equals((String)performerModel.getRoleId(), (String)roleVo.getRoleId())) continue;
                    roleId = performerModel.getRoleId();
                    isok = true;
                    break;
                }
                if (!isok) continue;
                break;
            }
            if (StringUtils.isNotBlank((String)roleId)) {
                String activityRelType = "";
                activityRelType = transInfo.getTransType().equalsIgnoreCase("and") ? "and" : "or";
                String activitysElement = "<Activitys RelType=\"" + activityRelType + "\"";
                activitysElement = activitysElement + " SendSMS= \"false\"";
                activitysElement = activitysElement + ">";
                String activityElement = "<Activity ";
                activityElement = activityElement + " Id=\"" + nextAdId + "\">";
                String userInfoElement = "<UserInfo ";
                userInfoElement = userInfoElement + " RoleId=\"" + roleId + "\"";
                userInfoElement = userInfoElement + " Id=\"" + nextUserId + "\">";
                userInfoElement = userInfoElement + "</UserInfo>";
                activityElement = activityElement + userInfoElement;
                activityElement = activityElement + "</Activity>";
                activitysElement = activitysElement + activityElement;
                String remarkElement = "<ReMark>";
                String remarkTextElement = "<text>";
                remarkTextElement = remarkTextElement + "</text>";
                remarkElement = remarkElement + remarkTextElement + "</ReMark>";
                activitysElement = activitysElement + remarkElement + "</Activitys>";
                return activitysElement;
            }
        }
        return null;
    }

    public void finishWorkflow(String proid) throws Exception {
        try {
            this.workFlowCoreService.finishWorkFlow(proid);
            List taskList = this.taskService.getTaskListByInstance(proid);
            if (taskList != null && taskList.size() > 0) {
                int i;
                ArrayList<String> acidList = new ArrayList<String>();
                for (i = 0; i < taskList.size(); ++i) {
                    if (acidList.indexOf(((PfTaskVo)taskList.get(i)).getActivityId()) < 0) {
                        acidList.add(((PfTaskVo)taskList.get(i)).getActivityId());
                    }
                    this.taskService.insertTaskHistory(((PfTaskVo)taskList.get(i)).getTaskId());
                    this.taskService.deleteTask(((PfTaskVo)taskList.get(i)).getTaskId());
                }
                for (i = 0; i < acidList.size(); ++i) {
                    this.taskService.updateActivityStadus((String)acidList.get(i), 2);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

