/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.entity.PfBusiness;
import com.gtis.portal.entity.PfWorkflowDefinition;
import com.gtis.portal.model.Ztree;
import com.gtis.portal.service.PfBusinessService;
import com.gtis.portal.service.PfResourceService;
import com.gtis.portal.service.PfWorkflowDefinitionService;
import com.gtis.portal.util.RequestUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class PfWorkflowDefinitionServiceImpl
implements PfWorkflowDefinitionService {
    @Autowired
    public BaseDao baseDao;
    @PersistenceContext
    public EntityManager em;
    @Autowired
    PfBusinessService businessService;
    @Autowired
    PfResourceService resourceService;
    @Autowired
    SysWorkFlowDefineService sysWorkFlowDefineService;

    public PfWorkflowDefinition findById(String wfdId) {
        if (StringUtils.isNotBlank((String)wfdId)) {
            PfWorkflowDefinition wfd = (PfWorkflowDefinition)this.baseDao.getById(PfWorkflowDefinition.class, (Object)wfdId);
            if (wfd != null) {
                PfBusiness business = this.businessService.findById(wfd.getBusinessId());
                wfd.setBusiness(business);
            }
            return wfd;
        }
        return null;
    }

    @Transactional
    public void update(PfWorkflowDefinition pfWorkflowDefinition) {
        PfWorkflowDefinition tmpWfd;
        if (pfWorkflowDefinition != null && StringUtils.isNotBlank((String)pfWorkflowDefinition.getWorkflowDefinitionId()) && (tmpWfd = this.findById(pfWorkflowDefinition.getWorkflowDefinitionId())) != null) {
            String jqpl = "update PfWorkflowDefinition t set  t.regionCode='" + pfWorkflowDefinition.getRegionCode() + "', " + " t.workflowCode='" + pfWorkflowDefinition.getWorkflowCode() + "', " + " t.workflowName='" + pfWorkflowDefinition.getWorkflowName() + "', " + " t.workflowDefinitionNo='" + pfWorkflowDefinition.getWorkflowDefinitionNo() + "', " + " t.workflowVersion='" + pfWorkflowDefinition.getWorkflowVersion() + "', " + " t.priority=" + pfWorkflowDefinition.getPriority() + ", " + " t.remark='" + pfWorkflowDefinition.getRemark() + "', " + " t.createUrl='" + pfWorkflowDefinition.getCreateUrl() + "', " + " t.createHeight=" + pfWorkflowDefinition.getCreateHeight() + ", " + " t.createWidth=" + pfWorkflowDefinition.getCreateWidth() + ", " + " t.isValid=" + pfWorkflowDefinition.getIsValid() + ", " + " t.isMonitor=" + pfWorkflowDefinition.getIsMonitor() + ", " + " t.timeLimit='" + pfWorkflowDefinition.getTimeLimit() + "' " + " where t.workflowDefinitionId='" + pfWorkflowDefinition.getWorkflowDefinitionId() + "'";
            this.baseDao.executeJpql(jqpl, new Object[0]);
        }
    }

    public List<PfWorkflowDefinition> getAll() {
        ArrayList<PfWorkflowDefinition> wdList = null;
        String sql = "select WORKFLOW_DEFINITION_ID,BUSINESS_ID,WORKFLOW_NAME from PF_WORKFLOW_DEFINITION order by BUSINESS_ID,WORKFLOW_DEFINITION_NO";
        List mapList = this.baseDao.getMapBySql(sql, new Object[0]);
        if (mapList != null && mapList.size() > 0) {
            wdList = new ArrayList<PfWorkflowDefinition>();
            for (int i = 0; i < mapList.size(); ++i) {
                PfWorkflowDefinition wd = new PfWorkflowDefinition();
                wd.setWorkflowDefinitionId(MapUtils.getString((Map)((Map)mapList.get(i)), (Object)"WORKFLOW_DEFINITION_ID"));
                wd.setBusinessId(MapUtils.getString((Map)((Map)mapList.get(i)), (Object)"BUSINESS_ID"));
                wd.setWorkflowName(MapUtils.getString((Map)((Map)mapList.get(i)), (Object)"WORKFLOW_NAME"));
                wdList.add(wd);
            }
        }
        return wdList;
    }

    public Ztree getAllWfdTree() {
        LinkedHashMap<String, Ztree> treeMap = new LinkedHashMap<String, Ztree>();
        List businessList = this.businessService.getAll();
        if (businessList != null && businessList.size() > 0) {
            for (PfBusiness business : businessList) {
                Ztree tree = PfWorkflowDefinitionServiceImpl.toZtreeByBusiness((PfBusiness)business);
                treeMap.put(tree.getId(), tree);
            }
            List wfdList = this.getAll();
            if (wfdList != null && wfdList.size() > 0) {
                for (PfWorkflowDefinition wfd : wfdList) {
                    Ztree tree = PfWorkflowDefinitionServiceImpl.toZtreeByWorkflowDefinition((PfWorkflowDefinition)wfd);
                    treeMap.put(tree.getId(), tree);
                }
            }
        }
        Ztree root = new Ztree();
        Ztree firstNode = new Ztree();
        firstNode.setId("treeroot");
        firstNode.setName("\u5de5\u4f5c\u6d41\u5b9a\u4e49");
        firstNode.setNocheck(true);
        firstNode.setIcon(RequestUtils.initOptProperties((String)(AppConfig.getProperty((String)"portal.url") + "/static/images/folder_blank.png")));
        treeMap.put(firstNode.getId(), firstNode);
        for (Ztree tree : ((HashMap)treeMap).values()) {
            if (tree.getPid() != null) {
                Ztree ztree = (Ztree)((HashMap)treeMap).get(tree.getPid());
                if (ztree == null) continue;
                ztree.addChild(tree);
                continue;
            }
            tree.setOpen(true);
            root = tree;
        }
        return root;
    }

    public List<Ztree> getAllWfdSimpleTree() {
        ArrayList<Ztree> treeList = new ArrayList<Ztree>();
        LinkedHashMap<String, Ztree> treeMap = new LinkedHashMap<String, Ztree>();
        List businessList = this.businessService.getAll();
        if (businessList != null && businessList.size() > 0) {
            for (PfBusiness business : businessList) {
                Ztree tree = PfWorkflowDefinitionServiceImpl.toZtreeByBusiness((PfBusiness)business);
                treeMap.put(tree.getId(), tree);
                treeList.add(tree);
            }
            List wfdList = this.getAll();
            if (wfdList != null && wfdList.size() > 0) {
                for (PfWorkflowDefinition wfd : wfdList) {
                    Ztree tree = PfWorkflowDefinitionServiceImpl.toZtreeByWorkflowDefinition((PfWorkflowDefinition)wfd);
                    treeMap.put(tree.getId(), tree);
                    treeList.add(tree);
                }
            }
        }
        return treeList;
    }

    private static Ztree toZtreeByBusiness(PfBusiness business) {
        Ztree tree = new Ztree();
        tree.setId(business.getBusinessId());
        tree.setName(business.getBusinessName());
        tree.setPid("treeroot");
        tree.setIcon(RequestUtils.initOptProperties((String)(AppConfig.getProperty((String)"portal.url") + "/static/images/folder_blank.png")));
        return tree;
    }

    private static Ztree toZtreeByWorkflowDefinition(PfWorkflowDefinition workflowDefinition) {
        Ztree tree = new Ztree();
        tree.setId(workflowDefinition.getWorkflowDefinitionId());
        tree.setName(workflowDefinition.getWorkflowName());
        tree.setPid(workflowDefinition.getBusinessId());
        tree.setIcon(RequestUtils.initOptProperties((String)(AppConfig.getProperty((String)"portal.url") + "/static/images/flow.gif")));
        return tree;
    }

    public Map<String, List<PfWorkFlowDefineVo>> getWorkFlowDefineMap(UserInfo userInfo, String rid) {
        LinkedHashMap mapWorkFlowDefine = Maps.newLinkedHashMap();
        List lstWorkFlowDefine = Lists.newArrayList();
        lstWorkFlowDefine = userInfo.isAdmin() ? this.sysWorkFlowDefineService.getWorkFlowDefineList() : this.sysWorkFlowDefineService.getWorkFlowDefineListByRole(userInfo.getRoleIds(), rid, null);
        for (PfWorkFlowDefineVo wfd : lstWorkFlowDefine) {
            String businessName = wfd.getBusinessVo().getBusinessName();
            String groupId = wfd.getGroupId();
            String categoryName = businessName;
            String createUrl = wfd.getCreateUrl() == null ? "" : wfd.getCreateUrl();
            wfd.setCreateUrl(AppConfig.getPlaceholderValue((String)createUrl));
            if (StringUtils.isNotBlank((String)groupId)) {
                categoryName = wfd.getResourceGroupVo().getGroupName();
            }
            if (mapWorkFlowDefine.get(categoryName) != null) {
                ((List)mapWorkFlowDefine.get(categoryName)).add(wfd);
                continue;
            }
            ArrayList wfdList = Lists.newArrayList();
            wfdList.add(wfd);
            mapWorkFlowDefine.put(categoryName, wfdList);
        }
        return mapWorkFlowDefine;
    }
}

