/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.service.impl;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.portal.entity.PfOrgan;
import com.gtis.portal.entity.PfUserOrganRel;
import com.gtis.portal.entity.QPfUserOrganRel;
import com.gtis.portal.model.Ztree;
import com.gtis.portal.model.ZtreeChanged;
import com.gtis.portal.service.PfUserOrganService;
import com.gtis.portal.service.impl.BaseServiceImpl;
import com.gtis.portal.util.RequestUtils;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPADeleteClause;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Predicate;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PfUserOrganServiceImpl
extends BaseServiceImpl<PfUserOrganRel, String>
implements PfUserOrganService {
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void deleteByOrganId(String organId) {
        QPfUserOrganRel userOrganRel = QPfUserOrganRel.pfUserOrganRel;
        new JPADeleteClause(this.em, (EntityPath)userOrganRel).where(new Predicate[]{userOrganRel.organId.eq((Object)organId)}).execute();
    }

    public List<Ztree> findOrganbyUserId(String userId) {
        ArrayList<Ztree> treeList = new ArrayList<Ztree>();
        List organList = this.getOrganListByUserId(userId);
        if (organList != null && organList.size() > 0 && organList != null && organList.size() > 0) {
            for (int i = 0; i < organList.size(); ++i) {
                Ztree tree = this.toZtreeByOrgan((PfOrgan)organList.get(i));
                treeList.add(tree);
            }
        }
        return treeList;
    }

    private Ztree toZtreeByOrgan(PfOrgan organ) {
        Ztree tree = new Ztree();
        tree.setId(organ.getOrganId());
        tree.setName(organ.getOrganName());
        tree.setPid("treeroot");
        tree.setIcon(RequestUtils.initOptProperties((String)(AppConfig.getProperty((String)"portal.url") + "/static/images/folder.gif")));
        return tree;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void deleteUserOrganRelByUserIdAndOrganId(String user_id, String organ_id) {
        QPfUserOrganRel userOrganRel = QPfUserOrganRel.pfUserOrganRel;
        new JPADeleteClause(this.em, (EntityPath)userOrganRel).where(new Predicate[]{userOrganRel.organId.eq((Object)organ_id)}).where(new Predicate[]{userOrganRel.userId.eq((Object)user_id)}).execute();
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public boolean findUserOrgan(PfUserOrganRel userOrganRel) {
        JPAQuery query = new JPAQuery(this.em);
        QPfUserOrganRel qfpuserOrganRel = QPfUserOrganRel.pfUserOrganRel;
        List pfUserOrganList = ((JPQLQuery)((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qfpuserOrganRel})).where(new Predicate[]{qfpuserOrganRel.userId.eq((Object)userOrganRel.getUserId())})).where(new Predicate[]{qfpuserOrganRel.organId.eq((Object)userOrganRel.getOrganId())})).list((Expression)qfpuserOrganRel);
        return pfUserOrganList != null && pfUserOrganList.size() >= 1;
    }

    public List<PfOrgan> getOrganListByUserId(String userId) {
        if (StringUtils.isNotBlank((String)userId)) {
            String jpql = "select distinct t1 from PfOrgan t1,PfUserOrganRel t  where t.organId=t1.organId and t.userId=?0 ";
            jpql = jpql + " order by t1.organNo ";
            return this.baseDao.getByJpql(jpql, new Object[]{userId});
        }
        return null;
    }

    public boolean checkHasOrgan(String userId, String organId) {
        String jpql;
        PfUserOrganRel obj;
        return StringUtils.isNotBlank((String)userId) && StringUtils.isNotBlank((String)organId) && (obj = (PfUserOrganRel)this.baseDao.getUniqueResultByJpql(jpql = "select t from PfUserOrganRel t where t.userId=?0 and  t.organId=?1 and rownum=1", new Object[]{userId, organId})) != null && StringUtils.isNotBlank((String)obj.getUdrId());
    }

    @Transactional
    public void addOrganRelByUserId(String userId, List<ZtreeChanged> changeList) {
        if (changeList != null && changeList.size() > 0 && StringUtils.isNotBlank((String)userId)) {
            for (int i = 0; i < changeList.size(); ++i) {
                boolean hasObj;
                ZtreeChanged change = changeList.get(i);
                if (!change.isLeaf() || (hasObj = this.checkHasOrgan(userId, change.getId()))) continue;
                PfUserOrganRel rel = new PfUserOrganRel();
                rel.setUdrId(UUIDGenerator.generate18());
                rel.setOrganId(change.getId());
                rel.setUserId(userId);
                this.insert((Object)rel);
            }
        }
    }

    @Transactional
    public void addUserRelByOrganId(String organId, List<ZtreeChanged> changeList) {
        if (changeList != null && changeList.size() > 0 && StringUtils.isNotBlank((String)organId)) {
            for (int i = 0; i < changeList.size(); ++i) {
                boolean hasObj;
                ZtreeChanged change = changeList.get(i);
                if (!change.isLeaf() || (hasObj = this.checkHasOrgan(change.getId(), organId))) continue;
                PfUserOrganRel rel = new PfUserOrganRel();
                rel.setUdrId(UUIDGenerator.generate18());
                rel.setOrganId(organId);
                rel.setUserId(change.getId());
                this.insert((Object)rel);
            }
        }
    }
}

