/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.service.impl;

import com.gtis.portal.entity.PfStuffConfig;
import com.gtis.portal.entity.QPfStuffConfig;
import com.gtis.portal.model.Ztree;
import com.gtis.portal.service.PfStuffConfigService;
import com.gtis.portal.service.impl.BaseServiceImpl;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PfStuffConfigServiceImpl
extends BaseServiceImpl<PfStuffConfig, String>
implements PfStuffConfigService {
    public List<PfStuffConfig> getListByWfdId(String wfdId) {
        if (StringUtils.isNotBlank((String)wfdId)) {
            QPfStuffConfig qPfStuffConfig = QPfStuffConfig.pfStuffConfig;
            JPAQuery query = new JPAQuery(this.em);
            return ((JPQLQuery)((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfStuffConfig})).where(new Predicate[]{qPfStuffConfig.workflowDefinitionId.eq((Object)wfdId)})).orderBy(new OrderSpecifier[]{qPfStuffConfig.stuffXh.asc()})).list((Expression)qPfStuffConfig);
        }
        return null;
    }

    public Ztree getZtreeByWfdId(String wfdId) {
        ArrayList stuffList = this.getListByWfdId(wfdId);
        if (stuffList == null && stuffList.size() < 1) {
            stuffList = new ArrayList();
        }
        return this.initZtreeByStuffList((List)stuffList);
    }

    public Ztree initZtreeByStuffList(List<PfStuffConfig> stuffList) {
        Ztree ztree = null;
        if (stuffList != null && stuffList.size() > 0) {
            LinkedHashMap<String, Ztree> menuMap = new LinkedHashMap<String, Ztree>();
            for (PfStuffConfig stuffConfig : stuffList) {
                Ztree tree = this.toZtree(stuffConfig);
                menuMap.put(tree.getId(), tree);
            }
            Ztree root = new Ztree();
            root.setId("stuffroot");
            root.setName("\u6839\u76ee\u5f55");
            menuMap.put(root.getId(), root);
            for (Ztree tree : ((HashMap)menuMap).values()) {
                if (tree.getPid() != null) {
                    Ztree ztreeParent = (Ztree)((HashMap)menuMap).get(tree.getPid());
                    if (ztreeParent == null) continue;
                    ztreeParent.addChild(tree);
                    continue;
                }
                tree.setOpen(true);
                ztree = tree;
            }
        }
        return ztree;
    }

    private Ztree toZtree(PfStuffConfig stuffConfig) {
        Ztree tree = new Ztree();
        tree.setId(stuffConfig.getStuffId());
        tree.setName(stuffConfig.getStuffName());
        if (StringUtils.isBlank((String)StringUtils.trimToNull((String)stuffConfig.getProId()))) {
            stuffConfig.setProId("stuffroot");
        }
        tree.setPid(StringUtils.trimToNull((String)stuffConfig.getProId()));
        return tree;
    }

    public List<PfStuffConfig> getAllChildStuffListById(String stuffId) {
        ArrayList<PfStuffConfig> stuffList = new ArrayList<PfStuffConfig>();
        String sql = "select m.* from pf_stuff_config m start with m.stuff_id='" + stuffId + "'connect by m.pro_id = prior m.stuff_id " + " order by m.stuff_xh";
        List mapList = this.baseDao.getMapBySql(sql, new Object[0]);
        for (HashMap tmp : mapList) {
            stuffList.add(this.toStuffByMap(tmp));
        }
        return stuffList;
    }

    @Transactional
    public void deleteStuffAndChildById(String stuffId) {
        List stuffList;
        if (StringUtils.isNotBlank((String)stuffId) && (stuffList = this.getAllChildStuffListById(stuffId)) != null && stuffList.size() > 0) {
            ArrayList<String> idList = new ArrayList<String>();
            for (int i = 0; i < stuffList.size(); ++i) {
                idList.add(((PfStuffConfig)stuffList.get(i)).getStuffId());
            }
            if (idList.size() > 0) {
                String jpql = "delete from PfStuffConfig t where t.stuffId in ?0";
                this.baseDao.executeJpql(jpql, new Object[]{idList});
            }
        }
    }

    private PfStuffConfig toStuffByMap(HashMap map) {
        PfStuffConfig stuff = new PfStuffConfig();
        stuff.setStuffId(MapUtils.getString((Map)map, (Object)"STUFF_ID"));
        stuff.setProId(MapUtils.getString((Map)map, (Object)"PRO_ID"));
        stuff.setStuffXh(MapUtils.getInteger((Map)map, (Object)"STUFF_XH"));
        stuff.setStuffName(MapUtils.getString((Map)map, (Object)"STUFF_NAME"));
        stuff.setMeterial(MapUtils.getString((Map)map, (Object)"METERIAL"));
        stuff.setStuffCount(MapUtils.getInteger((Map)map, (Object)"STUFF_COUNT"));
        stuff.setRemark(MapUtils.getString((Map)map, (Object)"REMARK"));
        stuff.setWorkflowDefinitionId(MapUtils.getString((Map)map, (Object)"WORKFLOW_DEFINITION_ID"));
        stuff.setYsnum(MapUtils.getInteger((Map)map, (Object)"YSNUM"));
        stuff.setDbnum(MapUtils.getInteger((Map)map, (Object)"DBNUM"));
        return stuff;
    }
}

