/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.service.impl;

import com.gtis.portal.entity.PfBusiness;
import com.gtis.portal.entity.PfMenu;
import com.gtis.portal.entity.PfResource;
import com.gtis.portal.entity.QPfAuthorize;
import com.gtis.portal.entity.QPfMenu;
import com.gtis.portal.model.Menu;
import com.gtis.portal.model.Ztree;
import com.gtis.portal.service.PfAuthorizeService;
import com.gtis.portal.service.PfBusinessService;
import com.gtis.portal.service.PfMenuService;
import com.gtis.portal.service.PfResourceService;
import com.gtis.portal.service.impl.BaseServiceImpl;
import com.gtis.portal.util.Constants;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPADeleteClause;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PfMenuServiceImpl
extends BaseServiceImpl<PfMenu, String>
implements PfMenuService {
    @Autowired
    PfResourceService resourceService;
    @Autowired
    PfBusinessService businessService;
    @Autowired
    PfAuthorizeService authorizeService;

    public PfMenu getMenuHasResNoSub(String menuId) {
        PfMenu menu = (PfMenu)this.findById((Object)menuId);
        if (menu != null) {
            if (StringUtils.isNotBlank((String)menu.getResourceId())) {
                PfResource resource = (PfResource)this.resourceService.findById((Object)menu.getResourceId());
                menu.setResource(resource);
            }
            if (menu.getResource() == null) {
                menu.setResource(new PfResource());
            }
            if (StringUtils.isNotBlank((String)menu.getResource().getBusinessId())) {
                PfBusiness business = this.businessService.findById(menu.getResource().getBusinessId());
                menu.getResource().setBusiness(business);
            }
            if (menu.getResource().getBusiness() == null) {
                menu.getResource().setBusiness(new PfBusiness());
            }
        }
        return menu;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void delMenu(PfMenu menu) {
        JPAQuery query = new JPAQuery(this.em);
        QPfMenu qPfMenu = QPfMenu.pfMenu;
        List menuList = ((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfMenu})).where(new Predicate[]{qPfMenu.menuParentId.eq((Object)menu.getMenuId())})).list((Expression)qPfMenu);
        if (menuList == null || menuList.size() == 0) {
            this.authorizeService.deleteAuthorizeListByMenu(menu.getMenuId());
            new JPADeleteClause(this.em, (EntityPath)qPfMenu).where(new Predicate[]{qPfMenu.menuId.eq((Object)menu.getMenuId())}).execute();
        } else {
            for (PfMenu menuVo : menuList) {
                this.delMenu(menuVo);
            }
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void resetResouceRel(String resourceId) {
        if (StringUtils.isNotBlank((String)resourceId)) {
            String jpql = "update PfMenu t set t.resourceId=?0 where t.resourceId=?1";
            this.baseDao.executeJpql(jpql, new Object[]{null, resourceId});
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void refreshMenuResouceRel(String menuId, String resourceId) {
        if (StringUtils.isNotBlank((String)menuId) && StringUtils.isNotBlank((String)resourceId)) {
            String jpql = "update PfMenu t set t.resourceId=?0 where t.menuId=?1 ";
            this.baseDao.executeJpql(jpql, new Object[]{resourceId, menuId});
        }
    }

    public Menu getMenusByRole(String roles) {
        List menuList = this.getMenuListByRole(roles);
        return this.initMenuByMenuList(menuList);
    }

    public List<PfMenu> getMenuListByRole(String roles) {
        List menuList = null;
        QPfMenu qPfMenu = QPfMenu.pfMenu;
        JPAQuery query = new JPAQuery(this.em);
        if (StringUtils.isBlank((String)roles)) {
            menuList = ((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfMenu})).orderBy(new OrderSpecifier[]{qPfMenu.menuOrder.asc()})).list((Expression)qPfMenu);
        } else {
            QPfAuthorize qPfAuthorize = QPfAuthorize.pfAuthorize;
            roles = roles.replace("'", "");
            Object[] roleList = roles.split(",");
            menuList = ((JPQLQuery)((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfMenu})).where(new Predicate[]{qPfMenu.menuId.in((Collection)((JPQLQuery)((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfAuthorize})).where(new Predicate[]{qPfAuthorize.authorizeObjType.eq((Object)Constants.AuthorizeObjType.MENU.getBm()), qPfAuthorize.menuVisible.gt((Number)0), qPfAuthorize.undertakerId.in(roleList)})).distinct()).list((Expression)qPfAuthorize.authorizeObjId))})).orderBy(new OrderSpecifier[]{qPfMenu.menuOrder.asc()})).list((Expression)qPfMenu);
        }
        return menuList;
    }

    public Menu getMenusByRoleJqpl(String roles, String subsystem) {
        ArrayList menuList = new ArrayList();
        return this.initMenuByMenuList(menuList);
    }

    public Menu getMenusByRole(String roles, String subsystem) {
        List menuList = this.getMenuListByRole(roles, subsystem);
        return this.initMenuByMenuList(menuList);
    }

    public List<PfMenu> getMenuListByRole(String roles, String subsystem) {
        String sql;
        ArrayList<PfMenu> menuList = new ArrayList<PfMenu>();
        List menuMapList = null;
        if (StringUtils.isBlank((String)roles)) {
            sql = "select distinct t.* from pf_menu t,pf_subsystem_menu_rel tr  where t.menu_id=tr.menu_id  and tr.subsystem_id='" + subsystem + "'" + " order by t.menu_order";
            menuMapList = this.baseDao.getMapBySql(sql, new Object[0]);
        } else {
            sql = " select distinct t.* from pf_menu t,pf_subsystem_menu_rel tr,PF_AUTHORIZE ta  where t.menu_id=tr.menu_id and t.menu_id=ta.AUTHORIZE_OBJ_ID  and ta.AUTHORIZE_OBJ_TYPE=1 and ta.MENU_VISIBLE>0  and ta.UNDERTAKER_ID in (" + roles + ") " + " and tr.subsystem_id='" + subsystem + "'" + " order by t.menu_order";
            menuMapList = this.baseDao.getMapBySql(sql, new Object[0]);
        }
        if (menuMapList != null) {
            for (int i = 0; i < menuMapList.size(); ++i) {
                menuList.add(this.toMenuByMap((HashMap)menuMapList.get(i)));
            }
        }
        return menuList;
    }

    public Menu getAllMenus() {
        List menuList = null;
        QPfMenu qPfMenu = QPfMenu.pfMenu;
        JPAQuery query = new JPAQuery(this.em);
        menuList = ((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfMenu})).orderBy(new OrderSpecifier[]{qPfMenu.menuOrder.asc()})).list((Expression)qPfMenu);
        return this.initMenuByMenuList(menuList);
    }

    private Menu initMenuByMenuList(List<PfMenu> menuList) {
        Menu root = null;
        if (menuList != null && menuList.size() > 0) {
            LinkedHashMap<String, Menu> menuMap = new LinkedHashMap<String, Menu>();
            for (PfMenu menuVo : menuList) {
                Menu menu = this.toMenu(menuVo);
                menuMap.put(menu.getId(), menu);
            }
            for (Menu menu : ((HashMap)menuMap).values()) {
                if (menu.getPid() != null) {
                    Menu pMenu = (Menu)((HashMap)menuMap).get(menu.getPid());
                    if (pMenu == null) continue;
                    pMenu.addChild(menu);
                    continue;
                }
                root = menu;
            }
        }
        return root;
    }

    public Ztree getAllMenuTree() {
        List menuList = null;
        QPfMenu qPfMenu = QPfMenu.pfMenu;
        JPAQuery query = new JPAQuery(this.em);
        menuList = ((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfMenu})).orderBy(new OrderSpecifier[]{qPfMenu.menuOrder.asc()})).list((Expression)qPfMenu);
        return this.initZtreeByMenuList(menuList);
    }

    public Ztree getSubMenuTree(String subId) {
        List menuList = this.getSubMenuListBySubId(subId);
        return this.initZtreeByMenuList(menuList);
    }

    public Ztree getMenuTreeByRole(String roleId) {
        List menuList = this.authorizeService.getAuthorizeMenuListByRoleId(roleId);
        return this.initZtreeByMenuList(menuList);
    }

    private List<HashMap> getSubMenuMapListBySubId(String subId) {
        ArrayList menuList = new ArrayList();
        List menuMapList = null;
        String sql = "select distinct t.* from pf_menu t,pf_subsystem_menu_rel tr where t.menu_id=tr.menu_id   and tr.subsystem_id='" + subId + "'" + " order by t.menu_order";
        menuMapList = this.baseDao.getMapBySql(sql, new Object[0]);
        return menuMapList;
    }

    private List<PfMenu> getSubMenuListBySubId(String subId) {
        ArrayList<PfMenu> menuList = new ArrayList<PfMenu>();
        List menuMapList = this.getSubMenuMapListBySubId(subId);
        if (menuMapList != null) {
            for (int i = 0; i < menuMapList.size(); ++i) {
                menuList.add(this.toMenuByMap((HashMap)menuMapList.get(i)));
            }
        }
        return menuList;
    }

    public Ztree getSubMenuCheckTree(String subId) {
        Ztree ztree = this.getAllMenuTree();
        List menuMapList = this.getSubMenuMapListBySubId(subId);
        HashMap<String, Boolean> menuMap = new HashMap<String, Boolean>();
        if (menuMapList != null && menuMapList.size() > 0) {
            for (int i = 0; i < menuMapList.size(); ++i) {
                menuMap.put(MapUtils.getString((Map)((Map)menuMapList.get(i)), (Object)"MENU_ID"), true);
            }
        }
        return this.initCheckZtree(menuMap, ztree);
    }

    private Ztree initCheckZtree(HashMap menuMap, Ztree ztree) {
        if (menuMap.containsKey(ztree.getId())) {
            ztree.setChecked(true);
        }
        this.checkZtree(menuMap, ztree.getChildren());
        return ztree;
    }

    private void checkZtree(HashMap menuMap, List<Ztree> list) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                if (!menuMap.containsKey(list.get(i).getId())) continue;
                menuMap.remove(list.get(i).getId());
                list.get(i).setChecked(true);
                this.checkZtree(menuMap, list.get(i).getChildren());
            }
        }
    }

    public Ztree initZtreeByMenuList(List<PfMenu> menuList) {
        Ztree root = null;
        if (menuList != null && menuList.size() > 0) {
            LinkedHashMap<String, Ztree> menuMap = new LinkedHashMap<String, Ztree>();
            for (PfMenu menuVo : menuList) {
                Ztree tree = this.toZtree(menuVo);
                menuMap.put(tree.getId(), tree);
            }
            for (Ztree tree : ((HashMap)menuMap).values()) {
                if (tree.getPid() != null) {
                    Ztree ztree = (Ztree)((HashMap)menuMap).get(tree.getPid());
                    if (ztree == null) continue;
                    ztree.addChild(tree);
                    continue;
                }
                tree.setOpen(true);
                root = tree;
            }
        }
        return root;
    }

    public Menu getFirstLevelMenus() {
        QPfMenu qPfMenu = QPfMenu.pfMenu;
        JPAQuery query = new JPAQuery(this.em);
        List menuList = ((JPQLQuery)((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfMenu})).where(new Predicate[]{qPfMenu.menuParentId.eq((Object)"1")})).orderBy(new OrderSpecifier[]{qPfMenu.menuOrder.asc()})).list((Expression)qPfMenu);
        LinkedHashMap menuMap = new LinkedHashMap();
        PfMenu pfMenu = (PfMenu)((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfMenu})).where(new Predicate[]{qPfMenu.menuId.eq((Object)"1")})).singleResult((Expression)qPfMenu);
        Menu root = this.toMenu(pfMenu);
        for (PfMenu menuVo : menuList) {
            Menu menu = this.toMenu(menuVo);
            root.addChild(menu);
        }
        return root;
    }

    private Ztree toZtree(PfMenu menuVo) {
        Ztree tree = new Ztree();
        tree.setId(menuVo.getMenuId());
        tree.setName(menuVo.getMenuName());
        tree.setPid(StringUtils.trimToNull((String)menuVo.getMenuParentId()));
        return tree;
    }

    private Menu toMenu(PfMenu menuVo) {
        Menu menu = new Menu();
        menu.setId(menuVo.getMenuId());
        menu.setIcon(menuVo.getMenuCode());
        menu.setText(menuVo.getMenuName());
        menu.setPid(StringUtils.trimToNull((String)menuVo.getMenuParentId()));
        menu.setCls(menuVo.getMenuCss());
        menu.setExpanded(menuVo.isMenuExpanded());
        String rid = menuVo.getResourceId();
        if (rid != null) {
            menu.setLink("r:" + rid);
        }
        menu.setModel(menuVo.getMenuModel());
        return menu;
    }

    public List<PfMenu> getMenuListByResourceId(String resourceId) {
        List menuList = null;
        if (StringUtils.isBlank((String)resourceId)) {
            QPfMenu qPfMenu = QPfMenu.pfMenu;
            JPAQuery query = new JPAQuery(this.em);
            menuList = ((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfMenu})).where(new Predicate[]{qPfMenu.resourceId.eq((Object)resourceId)})).list((Expression)qPfMenu);
        }
        return menuList;
    }

    private PfMenu toMenuByMap(HashMap map) {
        PfMenu menu = new PfMenu();
        menu.setMenuId(MapUtils.getString((Map)map, (Object)"MENU_ID"));
        menu.setMenuCode(MapUtils.getString((Map)map, (Object)"MENU_CODE"));
        menu.setMenuName(MapUtils.getString((Map)map, (Object)"MENU_NAME"));
        menu.setMenuParentId(MapUtils.getString((Map)map, (Object)"MENU_PARENT_ID"));
        menu.setResourceId(MapUtils.getString((Map)map, (Object)"RESOURCE_ID"));
        menu.setMenuOrder(MapUtils.getIntValue((Map)map, (Object)"MENU_ORDER"));
        menu.setMenuCss(MapUtils.getString((Map)map, (Object)"MENU_CSS"));
        menu.setMenuExpanded(MapUtils.getBooleanValue((Map)map, (Object)"MENU_EXPANDED"));
        menu.setMenuModel(MapUtils.getIntValue((Map)map, (Object)"MENU_MODEL"));
        return menu;
    }

    public List<PfMenu> getAllChildMenuListByMenuId(String menuId) {
        ArrayList<PfMenu> menuList = new ArrayList<PfMenu>();
        String sql = "select m.* from pf_menu m start with m.menu_id='" + menuId + "'connect by m.menu_parent_id= prior m.menu_id " + " order by m.menu_order";
        List mapList = this.baseDao.getMapBySql(sql, new Object[0]);
        for (HashMap tmp : mapList) {
            menuList.add(this.toMenuByMap(tmp));
        }
        return menuList;
    }

    public List<PfMenu> getAllParentMenuListByMenuId(String menuId) {
        ArrayList<PfMenu> menuList = new ArrayList<PfMenu>();
        String sql = "select m.* from pf_menu m start with m.menu_id='" + menuId + "'connect by prior m.menu_parent_id= m.menu_id " + " order by m.menu_order";
        List mapList = this.baseDao.getMapBySql(sql, new Object[0]);
        for (HashMap tmp : mapList) {
            menuList.add(this.toMenuByMap(tmp));
        }
        return menuList;
    }
}

