/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.service.impl;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.portal.entity.PfInstanceAuthorize;
import com.gtis.portal.entity.PfResource;
import com.gtis.portal.entity.PfResourcePartition;
import com.gtis.portal.entity.PfRole;
import com.gtis.portal.model.Ztree;
import com.gtis.portal.model.ZtreeChanged;
import com.gtis.portal.service.PfInstanceAuthorizeService;
import com.gtis.portal.service.PfResourcePartitionService;
import com.gtis.portal.service.impl.BaseServiceImpl;
import com.gtis.portal.util.RequestUtils;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PfInstanceAuthorizeServiceImpl
extends BaseServiceImpl<PfInstanceAuthorize, String>
implements PfInstanceAuthorizeService {
    @Autowired
    PfResourcePartitionService resourcePartitionService;

    public List<PfInstanceAuthorize> getAuthorizeListByWdId(String wdid) {
        String jpql = "select t from PfInstanceAuthorize t where t.workflowDefinitionId=?0";
        return this.baseDao.getByJpql(jpql, new Object[]{wdid});
    }

    public PfInstanceAuthorize getAuthorizeListByParam(String wdid, String roleId, String resourceId) {
        if (StringUtils.isNotBlank((String)wdid) && StringUtils.isNotBlank((String)roleId) && StringUtils.isNotBlank((String)resourceId)) {
            String jpql = "select t from PfInstanceAuthorize t where t.workflowDefinitionId=?0 and  t.roleId=?1 and  t.resourceId=?2";
            return (PfInstanceAuthorize)this.baseDao.getUniqueResultByJpql(jpql, new Object[]{wdid, roleId, resourceId});
        }
        return null;
    }

    public boolean checkHasRole(String wdid, String roleId) {
        String jpql;
        PfInstanceAuthorize obj;
        return StringUtils.isNotBlank((String)wdid) && StringUtils.isNotBlank((String)roleId) && (obj = (PfInstanceAuthorize)this.baseDao.getUniqueResultByJpql(jpql = "select t from PfInstanceAuthorize t where t.workflowDefinitionId=?0 and  t.roleId=?1 and rownum=1", new Object[]{wdid, roleId})) != null && StringUtils.isNotBlank((String)obj.getWauthorizeId());
    }

    public boolean checkHasResource(String wdid, String resourceId) {
        String jpql;
        PfInstanceAuthorize obj;
        return StringUtils.isNotBlank((String)wdid) && StringUtils.isNotBlank((String)resourceId) && (obj = (PfInstanceAuthorize)this.baseDao.getUniqueResultByJpql(jpql = "select t from PfInstanceAuthorize t where t.workflowDefinitionId=?0 and  t.resourceId=?1 and rownum=1", new Object[]{wdid, resourceId})) != null && StringUtils.isNotBlank((String)obj.getWauthorizeId());
    }

    public List<PfRole> getAuthorizeRoleListByWdId(String wdid) {
        String jpql = "select distinct t1 from PfRole t1,PfInstanceAuthorize t  where t.roleId=t1.roleId and t.workflowDefinitionId=?0 order by t1.roleNo";
        return this.baseDao.getByJpql(jpql, new Object[]{wdid});
    }

    public List<PfResource> getAuthorizeResourceListByWdId(String wdid, String roleId, boolean ischeck) {
        if (StringUtils.isNotBlank((String)wdid)) {
            String jpql = "select distinct t1 from PfResource t1,PfInstanceAuthorize t  where t.resourceId=t1.resourceId and t.workflowDefinitionId=?0 ";
            if (StringUtils.isNotBlank((String)roleId)) {
                jpql = jpql + " and t.roleId=?1 ";
            }
            if (ischeck) {
                jpql = jpql + " and t.visible=1 ";
            }
            jpql = jpql + " order by t1.resourceNo ";
            return this.baseDao.getByJpql(jpql, new Object[]{wdid, roleId});
        }
        return null;
    }

    public List<Ztree> getAuthorizeRoleTreeListByWdId(String wdid) {
        List roleList = this.getAuthorizeRoleListByWdId(wdid);
        ArrayList<Ztree> treeList = new ArrayList<Ztree>();
        if (roleList != null && roleList.size() > 0) {
            for (int i = 0; i < roleList.size(); ++i) {
                Ztree tree = this.toZtreeByRole((PfRole)roleList.get(i));
                treeList.add(tree);
            }
        }
        return treeList;
    }

    public List<Ztree> getAuthorizeResourceTreeListByWdId(String wdid, String roleId, boolean ischeck) {
        List objList = this.getAuthorizeResourceListByWdId(wdid, roleId, ischeck);
        ArrayList<Ztree> treeList = new ArrayList<Ztree>();
        if (objList != null && objList.size() > 0) {
            for (int i = 0; i < objList.size(); ++i) {
                Ztree tree = this.toZtreeByResource((PfResource)objList.get(i));
                treeList.add(tree);
            }
        }
        return treeList;
    }

    public HashMap<String, PfResourcePartition> getInstancePartMap(String wdid, String roleId, String resourceId) {
        HashMap<String, PfResourcePartition> partMap = new HashMap<String, PfResourcePartition>();
        try {
            String infoXml;
            Document document;
            List eleList;
            PfInstanceAuthorize instanceAuthorize = this.getAuthorizeListByParam(wdid, roleId, resourceId);
            if (instanceAuthorize != null && StringUtils.isNotBlank((String)instanceAuthorize.getAuthorizeInfo()) && (eleList = (document = DocumentHelper.parseText((String)(infoXml = instanceAuthorize.getAuthorizeInfo()))).selectNodes("/Partitions/Partition")) != null && eleList.size() > 0) {
                for (int i = 0; i < eleList.size(); ++i) {
                    String operType;
                    Element element = (Element)eleList.get(i);
                    PfResourcePartition part = new PfResourcePartition();
                    part.setPartitionId(element.valueOf("@Id"));
                    String partType = element.valueOf("@PartitionType");
                    if (StringUtils.isNotBlank((String)partType)) {
                        part.setPartitionType(Integer.valueOf(partType));
                    }
                    if (StringUtils.isNotBlank((String)(operType = element.valueOf("@OperType")))) {
                        part.setOperType(Integer.valueOf(operType));
                    }
                    partMap.put(part.getPartitionId(), part);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return partMap;
    }

    @Transactional
    public void updateVisible(String wauthorizeId, Integer visible) {
        if (StringUtils.isNotBlank((String)wauthorizeId) && visible != null) {
            String jpql = "update from PfInstanceAuthorize t set t.visible=?0 where t.wauthorizeId=?1";
            this.baseDao.executeJpql(jpql, new Object[]{visible, wauthorizeId});
        }
    }

    @Transactional
    public void updatePartAuthorizeInfo(String wdid, String roleId, String resourceId, String authorizeInfo) {
        if (StringUtils.isNotBlank((String)wdid) && StringUtils.isNotBlank((String)roleId) && StringUtils.isNotBlank((String)resourceId)) {
            String jpql = "update from PfInstanceAuthorize t set t.authorizeInfo=?0 where t.workflowDefinitionId=?1 and  t.roleId=?2 and  t.resourceId=?3";
            this.baseDao.executeJpql(jpql, new Object[]{authorizeInfo, wdid, roleId, resourceId});
        }
    }

    @Transactional
    public void addRoleRel(String wdid, List<ZtreeChanged> changeList) {
        if (changeList != null && changeList.size() > 0 && StringUtils.isNotBlank((String)wdid)) {
            ArrayList<PfResource> resouceList = this.getAuthorizeResourceListByWdId(wdid, null, false);
            if (resouceList == null || resouceList.size() == 0) {
                resouceList = new ArrayList<PfResource>();
                PfResource resouce = new PfResource();
                resouce.setResourceId("FIRST_ROLE_AUTH_RESOUCE");
                resouceList.add(resouce);
            }
            if (resouceList != null && resouceList.size() > 0) {
                for (int i = 0; i < changeList.size(); ++i) {
                    boolean hasRole;
                    ZtreeChanged change = changeList.get(i);
                    if (!change.isLeaf() || (hasRole = this.checkHasRole(wdid, change.getId()))) continue;
                    for (int j = 0; j < resouceList.size(); ++j) {
                        PfInstanceAuthorize authorize = new PfInstanceAuthorize();
                        authorize.setWauthorizeId(UUIDGenerator.generate18());
                        authorize.setWorkflowDefinitionId(wdid);
                        authorize.setRoleId(change.getId());
                        authorize.setResourceId(((PfResource)resouceList.get(j)).getResourceId());
                        this.insert((Object)authorize);
                    }
                }
            }
        }
    }

    @Transactional
    public void addResourceRel(String wdid, List<ZtreeChanged> changeList) {
        List roleList;
        if (changeList != null && changeList.size() > 0 && StringUtils.isNotBlank((String)wdid) && (roleList = this.getAuthorizeRoleListByWdId(wdid)) != null && roleList.size() > 0) {
            for (int i = 0; i < changeList.size(); ++i) {
                boolean hasRole;
                ZtreeChanged change = changeList.get(i);
                if (!change.isLeaf() || (hasRole = this.checkHasResource(wdid, change.getId()))) continue;
                for (int j = 0; j < roleList.size(); ++j) {
                    PfInstanceAuthorize authorize = new PfInstanceAuthorize();
                    authorize.setWauthorizeId(UUIDGenerator.generate18());
                    authorize.setWorkflowDefinitionId(wdid);
                    authorize.setRoleId(((PfRole)roleList.get(j)).getRoleId());
                    authorize.setResourceId(change.getId());
                    this.insert((Object)authorize);
                }
            }
        }
    }

    @Transactional
    public void updateResourceRel(String wdid, String roleId, List<ZtreeChanged> changeList) {
        if (changeList != null && changeList.size() > 0 && StringUtils.isNotBlank((String)wdid) && StringUtils.isNotBlank((String)roleId)) {
            for (int i = 0; i < changeList.size(); ++i) {
                ZtreeChanged change = changeList.get(i);
                PfInstanceAuthorize authorize = this.getAuthorizeListByParam(wdid, roleId, change.getId());
                Integer visible = change.isChecked() ? 1 : 0;
                if (authorize != null) {
                    String wauthorizeId = authorize.getWauthorizeId();
                    this.updateVisible(wauthorizeId, visible);
                    continue;
                }
                authorize = new PfInstanceAuthorize();
                authorize.setWauthorizeId(UUIDGenerator.generate18());
                authorize.setWorkflowDefinitionId(wdid);
                authorize.setRoleId(roleId);
                authorize.setResourceId(change.getId());
                authorize.setVisible(visible);
                this.insert((Object)authorize);
            }
        }
    }

    @Transactional
    public void updatePartOperType(String wdid, String roleId, String resourceId, List<ZtreeChanged> changeList) {
        if (changeList != null && changeList.size() > 0 && StringUtils.isNotBlank((String)wdid) && StringUtils.isNotBlank((String)roleId) && StringUtils.isNotBlank((String)resourceId)) {
            List partList = this.resourcePartitionService.getListByRid(resourceId);
            HashMap<String, Integer> partMap = new HashMap<String, Integer>();
            if (partList != null && partList.size() > 0) {
                for (int i = 0; i < partList.size(); ++i) {
                    partMap.put(((PfResourcePartition)partList.get(i)).getPartitionId(), ((PfResourcePartition)partList.get(i)).getPartitionType());
                }
            }
            try {
                Document document = DocumentHelper.createDocument();
                Element rootE = document.addElement("Partitions");
                for (int i = 0; i < changeList.size(); ++i) {
                    ZtreeChanged change = changeList.get(i);
                    Element childE = rootE.addElement("Partition");
                    childE.addAttribute("Id", change.getId());
                    childE.addAttribute("OperType", change.getName());
                    childE.addAttribute("PartitionType", MapUtils.getString(partMap, (Object)change.getId()));
                }
                StringWriter stringWriter = new StringWriter();
                OutputFormat xmlFormat = new OutputFormat();
                xmlFormat.setEncoding("UTF-8");
                xmlFormat.setNewlines(true);
                xmlFormat.setIndent(true);
                XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, xmlFormat);
                xmlWriter.write(document);
                xmlWriter.close();
                this.updatePartAuthorizeInfo(wdid, roleId, resourceId, stringWriter.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Transactional
    public void deleteAuthorizeListByWdIdAndRole(String wdid, String roleId) {
        if (StringUtils.isNotBlank((String)wdid) && StringUtils.isNotBlank((String)roleId)) {
            String jpql = "delete from PfInstanceAuthorize t where t.workflowDefinitionId=?0 and t.roleId=?1";
            this.baseDao.executeJpql(jpql, new Object[]{wdid, roleId});
        }
    }

    @Transactional
    public void deleteAuthorizeListByRole(String roleId) {
        if (StringUtils.isNotBlank((String)roleId)) {
            String jpql = "delete from PfInstanceAuthorize t where t.roleId=?0 ";
            this.baseDao.executeJpql(jpql, new Object[]{roleId});
        }
    }

    @Transactional
    public void deleteAuthorizeListByWdIdAndResource(String wdid, String resourceId) {
        if (StringUtils.isNotBlank((String)wdid) && StringUtils.isNotBlank((String)resourceId)) {
            String[] ids = StringUtils.split((String)resourceId, (String)",");
            List<String> idList = Arrays.asList(ids);
            String jpql = "delete from PfInstanceAuthorize t where t.workflowDefinitionId=?0 and t.resourceId in ?1";
            this.baseDao.executeJpql(jpql, new Object[]{wdid, idList});
        }
    }

    @Transactional
    public void deleteAuthorizeListByResource(String resourceId) {
        if (StringUtils.isNotBlank((String)resourceId)) {
            String jpql = "delete from PfInstanceAuthorize t where t.resourceId=?0 ";
            this.baseDao.executeJpql(jpql, new Object[]{resourceId});
        }
    }

    private Ztree toZtreeByRole(PfRole role) {
        Ztree tree = new Ztree();
        tree.setId(role.getRoleId());
        tree.setName(role.getRoleName());
        tree.setPid("treeroot");
        tree.setIcon(RequestUtils.initOptProperties((String)(AppConfig.getProperty((String)"portal.url") + "/static/images/sup.png")));
        return tree;
    }

    private Ztree toZtreeByResource(PfResource obj) {
        Ztree tree = new Ztree();
        tree.setId(obj.getResourceId());
        tree.setName(obj.getResourceName());
        tree.setPid("treeroot");
        return tree;
    }

    private Ztree toZtreeByInstanceAuthorize(PfInstanceAuthorize obj) {
        Ztree tree = new Ztree();
        tree.setId(obj.getWauthorizeId());
        tree.setName(obj.getResourceName());
        tree.setKz1(obj.getResourceId());
        tree.setPid("treeroot");
        return tree;
    }
}

