/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.service.impl;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.portal.entity.PfCalendar;
import com.gtis.portal.entity.QPfCalendar;
import com.gtis.portal.service.PfCalendarService;
import com.gtis.portal.service.impl.BaseServiceImpl;
import com.gtis.portal.util.CalendarUtil;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPADeleteClause;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Predicate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PfCalendarServiceImpl
extends BaseServiceImpl<PfCalendar, String>
implements PfCalendarService {
    public PfCalendar findInitCalendar(String calId) {
        PfCalendar calendar;
        if (StringUtils.isNotBlank((String)calId) && (calendar = (PfCalendar)this.findById((Object)calId)) != null) {
            calendar.setAmBeginStr(CalendarUtil.formateToHMOnlyStr((Date)calendar.getAmBegin()));
            calendar.setAmEndStr(CalendarUtil.formateToHMOnlyStr((Date)calendar.getAmEnd()));
            calendar.setPmBeginStr(CalendarUtil.formateToHMOnlyStr((Date)calendar.getPmBegin()));
            calendar.setPmEndStr(CalendarUtil.formateToHMOnlyStr((Date)calendar.getPmEnd()));
            return calendar;
        }
        return null;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void update(PfCalendar calendar) {
        if (calendar != null && StringUtils.isNotBlank((String)calendar.getCalId())) {
            calendar.setAmBegin(CalendarUtil.formateDateByHMDate((String)(CalendarUtil.formateDatetoStr((Date)calendar.getCalDate()) + " " + calendar.getAmBeginStr())));
            calendar.setAmEnd(CalendarUtil.formateDateByHMDate((String)(CalendarUtil.formateDatetoStr((Date)calendar.getCalDate()) + " " + calendar.getAmEndStr())));
            calendar.setPmBegin(CalendarUtil.formateDateByHMDate((String)(CalendarUtil.formateDatetoStr((Date)calendar.getCalDate()) + " " + calendar.getPmBeginStr())));
            calendar.setPmEnd(CalendarUtil.formateDateByHMDate((String)(CalendarUtil.formateDatetoStr((Date)calendar.getCalDate()) + " " + calendar.getPmEndStr())));
            super.update((Object)calendar);
        }
    }

    public List<PfCalendar> getCalendarListByYM(Integer year, Integer month) {
        List<Object> calendarList = new ArrayList<PfCalendar>();
        QPfCalendar qPfCalendar = QPfCalendar.pfCalendar;
        JPAQuery query = new JPAQuery(this.em);
        if (year != null && month != null) {
            calendarList = ((JPQLQuery)((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfCalendar})).where(new Predicate[]{qPfCalendar.calDate.year().eq((Object)year).and((Predicate)qPfCalendar.calDate.month().eq((Object)month))})).orderBy(new OrderSpecifier[]{qPfCalendar.calDate.asc()})).list((Expression)qPfCalendar);
        }
        return calendarList;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public String createCalByYearMonth(Integer year, Integer month) {
        String msg = "";
        if (this.isok(year, month)) {
            List calendarList = this.getCalendarListByYM(year, month);
            if (calendarList == null || calendarList.size() <= 0) {
                this.createCalendar(year, month);
            } else {
                msg = year + "\u5e74\u5ea6" + month + "\u6708\u4efd\u5df2\u7ecf\u521b\u5efa\u65e5\u5386\u8bb0\u5f55\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01";
            }
        } else {
            msg = "\u4e0d\u5b58\u5728" + year + "\u5e74\u5ea6" + month + "\u6708\u4efd\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\uff01";
        }
        return msg;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public String createCalByYear(Integer year) {
        String msg = "";
        if (year != null && year < 2999 && year > 2000) {
            for (int j = 1; j <= 12; ++j) {
                List calendarList = this.getCalendarListByYM(year, Integer.valueOf(j));
                if (calendarList != null && calendarList.size() > 0) continue;
                this.createCalendar(year, Integer.valueOf(j));
            }
        } else {
            msg = "\u4e0d\u5b58\u5728" + year + "\u5e74\u5ea6\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\uff01";
        }
        return msg;
    }

    private void createCalendar(Integer year, Integer month) {
        int days = CalendarUtil.getDaysOfYearMonth((int)year, (int)month);
        Integer n = month;
        Integer n2 = month = Integer.valueOf(month - 1);
        for (int i = 1; i <= days; ++i) {
            Calendar cal = Calendar.getInstance();
            cal.set(year, month, i);
            String calType = CalendarUtil.getCalTypeByDate((Calendar)cal);
            String calWeek = CalendarUtil.getWeekByDate((Date)cal.getTime());
            PfCalendar obj = new PfCalendar();
            obj.setCalId(UUIDGenerator.generate18());
            obj.setCalDate(CalendarUtil.formatDate((Date)cal.getTime()));
            obj.setCalType(calType);
            obj.setCalWeek(calWeek);
            cal.set(year, month, i, 8, 30, 0);
            obj.setAmBegin(cal.getTime());
            cal.set(year, month, i, 12, 0, 0);
            obj.setAmEnd(cal.getTime());
            cal.set(year, month, i, 13, 30, 0);
            obj.setPmBegin(cal.getTime());
            cal.set(year, month, i, 17, 30, 0);
            obj.setPmEnd(cal.getTime());
            this.insert((Object)obj);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void deleteCalByYearMonth(Integer year, Integer month) {
        if (this.isok(year, month)) {
            QPfCalendar qPfCalendar = QPfCalendar.pfCalendar;
            new JPADeleteClause(this.em, (EntityPath)qPfCalendar).where(new Predicate[]{qPfCalendar.calDate.year().eq((Object)year).and((Predicate)qPfCalendar.calDate.month().eq((Object)month))}).execute();
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void deleteCalByYearMonth(Integer year) {
        if (year != null && year < 2999 && year > 2000) {
            QPfCalendar qPfCalendar = QPfCalendar.pfCalendar;
            new JPADeleteClause(this.em, (EntityPath)qPfCalendar).where(new Predicate[]{qPfCalendar.calDate.year().eq((Object)year)}).execute();
        }
    }

    private boolean isok(Integer year, Integer month) {
        return year != null && month != null && year < 2999 && year > 2000 && month > 0 && month < 13;
    }
}

