package com.gtis.portal.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.model.impl.File;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.SysDistrictService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.SysWorkFlowInstanceRelService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.portal.entity.PfSubsystem;
import com.gtis.portal.entity.PfUser;
import com.gtis.portal.ex.ExceptionCode;
import com.gtis.portal.ex.UserException;
import com.gtis.portal.model.Ztree;
import com.gtis.portal.service.IndexService;
import com.gtis.portal.service.PfSubsystemService;
import com.gtis.portal.service.PfUserService;
import com.gtis.portal.util.Constants;
import com.gtis.portal.util.RequestUtils;
import com.gtis.util.Md5Util;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.util.*;


@Controller
@RequestMapping("/fileCenter")
public class FileCenterController extends BaseController{
    @Autowired
    SysUserService sysUserService;
    @Autowired
    SysDistrictService sysDistrictService;
    @Autowired
    IndexService indexService;
    @Autowired
    PfSubsystemService subsystemService;
    @Autowired
    PfUserService pfUserService;
    @Autowired
    NodeService nodeService;
    @Autowired
    SysWorkFlowInstanceService workFlowIntanceService;
    @Autowired
    SysWorkFlowInstanceRelService workFlowInstanceRelService;

    /**
     * 根据传递的源工作流id，获取带该流程实例下所有的附件材料，用树结构返回
     * 针对树结构，需要对文件夹、文件进行区分，用于前台标识
     * 备注：就是要从fromProid中获取附件列表，复制一份到toProid对应的工作流中
     * @param model
     * @param fromProid 原始工作流
     * @param toProid 目标工作流
     * @return
     * @throws Exception
     */
    @RequestMapping("select")
    public String treeSelect(Model model,String fromProid,String toProid) {
        model.addAttribute("fromProid",fromProid);
        model.addAttribute("toProid",toProid);
        return "/fileCenter/file-tree-select";
    }

    /**
     * 组织文件中心目录树
     * @param model
     * @param fromProid 原始工作流
     * @return
     * @throws Exception
     */
    @RequestMapping("leftjson")
    @ResponseBody
    public Object leftjson(Model model,String fromProid) throws Exception{
        if (StringUtils.isNotBlank(fromProid)){
            Space space = nodeService.getWorkSpace(Constants.WORK_FLOW_STUFF,true);
            Node node = nodeService.getNode(space.getId(), fromProid, true);
            if (node != null){
                String name = node.getName();
                PfWorkFlowInstanceVo workFlowInstanceVo = workFlowIntanceService.getWorkflowInstance(fromProid);
                if (workFlowInstanceVo != null){
                    name = workFlowInstanceVo.getWorkflowIntanceName();
                }else{
                    name = "根目录";
                }
                Ztree root = new Ztree();
                root.setId(String.valueOf(node.getId()));
                root.setName(name);
                root.setChkDisabled(true);
                root.setParent(true);
                root.setIcon(RequestUtils.initOptProperties(AppConfig.getProperty("portal.url") + "/static/images/folder.gif"));

                List<Node> nodeList = nodeService.getAllChildNodes(node.getId());
                if (nodeList != null && nodeList.size() > 0){
                    LinkedHashMap<String,Ztree> nodeTreeMap = new LinkedHashMap<String, Ztree>();
                    for(Node childNode : nodeList){
                        nodeTreeMap.put(String.valueOf(childNode.getId()),nodeToZtree(childNode,true));
                    }
                    for (Ztree tree : nodeTreeMap.values()) {
                        if (tree.getPid() != null) {
                            Ztree ztree = nodeTreeMap.get(tree.getPid());
                            if (ztree != null) {
                                ztree.addChild(tree);
                            }else {
                                root.addChild(tree);
                            }
                        }
                    }
                }
                return root;
            }
        }
        return null;
    }

    /**
     * 组织文件中心目录树
     * @param model
     * @param toProid 目标工作流
     * @return
     * @throws Exception
     */
    @RequestMapping("rightjson")
    @ResponseBody
    public Object rightjson(Model model,String toProid) throws Exception{
        if (StringUtils.isNotBlank(toProid)){
            Space space = nodeService.getWorkSpace(Constants.WORK_FLOW_STUFF,true);
            Node node = nodeService.getNode(space.getId(), toProid, true);
            if (node != null){
                String name = node.getName();
                PfWorkFlowInstanceVo workFlowInstanceVo = workFlowIntanceService.getWorkflowInstance(toProid);
                if (workFlowInstanceVo != null){
                    name = workFlowInstanceVo.getWorkflowIntanceName();
                }else{
                    name = "根目录";
                }
                Ztree root = new Ztree();
                root.setId(String.valueOf(node.getId()));
                root.setName(name);
                root.setChkDisabled(true);
                root.setParent(true);
                root.setIcon(RequestUtils.initOptProperties(AppConfig.getProperty("portal.url") + "/static/images/folder.gif"));

                List<Node> nodeList = nodeService.getAllChildNodes(node.getId());
                if (nodeList != null && nodeList.size() > 0){
                    LinkedHashMap<String,Ztree> nodeTreeMap = new LinkedHashMap<String, Ztree>();
                    for(Node childNode : nodeList){
                        nodeTreeMap.put(String.valueOf(childNode.getId()),nodeToZtree(childNode,false));
                    }
                    for (Ztree tree : nodeTreeMap.values()) {
                        if (tree.getPid() != null) {
                            Ztree ztree = nodeTreeMap.get(tree.getPid());
                            if (ztree != null) {
                                ztree.addChild(tree);
                            }else {
                                root.addChild(tree);
                            }
                        }
                    }
                }
                return root;
            }
        }
        return null;
    }

    /**
     * 组织文件中心目录树
     * @param model
     * @param toProid 目标工作流
     * @return
     * @throws Exception
     */
    @RequestMapping("save")
    @ResponseBody
    public Object saveJson(Model model,String fromProid,String toProid,String nodes) throws Exception{
        if (StringUtils.isNotBlank(fromProid) && StringUtils.isNotBlank(toProid) && StringUtils.isNotBlank(nodes)){
            try {
                List<JSONObject> nodeList = JSON.parseObject(nodes,List.class);
                LinkedHashMap<String,Ztree> treeMap = fileNodeToTreeMap(nodeList);
                System.out.println(JSON.toJSONString(treeMap));

                //处理逻辑：
                /**
                 * 处理说明：
                 * 1、遍历传递过来的nodeList，该nodeList就是需要保存到新的流程下的附件信息
                 * 2、该集合中包含了正确的父子关系，错乱的父子关系，还有只有子，没有父的关系
                 * 3、正确的父子关系就是完整拖动了一个文件夹，错乱的父子关系就是随意的拖动了，改变了原有关系，没有父，则是将左侧子节点，放到了右侧某个节点下
                 *
                 * 操作逻辑
                 * 由于该功能实现的是同一个文件中心下的操作，故id不会重复，也就是左右方的节点id是唯一的，这样就可以完全根据节点id来判断，
                 * 而不用考虑错乱和没有父节点的情况，直接按照一个个节点去遍历即可
                 * 1、获取左侧和右侧附件记录，各自转换为hashmap对象，id为key，便于下面的查找
                 * 2、遍历nodelist集合，
                 * 3、查找每个节点的pid对应的父节点，判断父节点是来源于左侧还是右侧，进行标记
                 * 4、如果来源于右侧，通过左侧树判断该节点是文件夹还是文件，如果是文件夹，直接在右侧该节点下创建对应的节点记录，如果是文件，则进行文件的上传（拷贝）操作
                 * 5、之后返回新创建的右侧节点，生成一个hashmap，用于处理该节点下子节点的关系，因为子节点的父级id，需要更新为新的父节点id，key为老id，value为新节点
                 * 6、如果来源于左侧，则查找左侧在右侧已经创建的记录，也就是第五步的hashmap，获取对应节点，在该节点下创建，步骤参考4
                 * */
                Space space = nodeService.getWorkSpace(Constants.WORK_FLOW_STUFF,true);
                Node leftNode = nodeService.getNode(space.getId(), fromProid, true);
                if (leftNode != null) {
                    HashMap<Integer,Node> leftMap = fileNodeToMap(leftNode.getId());//左侧附件信息

                    HashMap<String,Node> newMap = new HashMap<String, Node>();//左侧插入右侧后新的附件信息
                    Node rightNode = nodeService.getNode(space.getId(), toProid, true);
                    if (rightNode != null) {
                        HashMap<Integer,Node> rightMap = fileNodeToMap(rightNode.getId());//右侧附件信息
                        rightMap.put(rightNode.getId(),rightNode);

                        for (Map.Entry<String,Ztree> entry : treeMap.entrySet()) {
                            Ztree tree = entry.getValue();String tid = tree.getKz1();
                            String pTid = tree.getKz2();

                            Node leftChild = leftMap.get(Integer.parseInt(tree.getId()));
                            if (leftChild != null && StringUtils.isNotBlank(leftChild.getName())){
                                Integer pid = Integer.parseInt(tree.getPid());
                                //String newId = pid+"000000"+leftChild.getId();
                                if (rightMap.containsKey(pid)){
                                    //是左侧拖动到了右侧的某个节点下，此时右侧节点就变成了父节点
                                    Node rightChild = rightMap.get(pid);
                                    if (rightChild != null){
                                        if (leftChild instanceof File){
                                            Integer[] ids = {leftChild.getId()};
                                            nodeService.copy(ids,rightChild.getId(),true);
                                        }else {
                                            Node newNode = nodeService.getNode(rightChild.getId(),leftChild.getName(),true);
                                            newMap.put(tid,newNode);
                                        }
                                    }
                                }else if (leftMap.containsKey(pid)){
                                    Ztree pTree = treeMap.get(pTid);
                                    if (pTree != null){
                                        Node newNode = newMap.get(pTree.getKz1());
                                        if (newNode != null){
                                            if (leftChild instanceof File){
                                                Integer[] ids = {leftChild.getId()};
                                                nodeService.copy(ids,newNode.getId(),true);
                                            }else {
                                                Node newNodeChild = nodeService.getNode(newNode.getId(),leftChild.getName(),true);
                                                newMap.put(tid,newNodeChild);
                                            }
                                        }
                                    }
                                }
                            }
                        }

                        //删除关联数据
                        workFlowInstanceRelService.deleteWorkFlowRel(fromProid,toProid);
                        workFlowInstanceRelService.deleteWorkFlowRel(toProid,fromProid);
                        //生成关联数据
                        workFlowInstanceRelService.insertWorkFlowRel(fromProid,toProid);
                    }
                }
                return handlerSuccessJson();
            }catch (Exception e){
                e.printStackTrace();
            }
        }
        return handlerErrorJson("操作失败！");
    }


    /**
     *
     * @param node
     * @param isdrag，是否允许拖拽，因为对于右侧来说，只有左侧拖拽过去的节点，才允许进一步操作，其余节点是本身的，不提供任何操作
     * @return
     */
    private Ztree nodeToZtree(Node node,boolean isdrag){
        Ztree tree = new Ztree();
        tree.setId(String.valueOf(node.getId()));
        tree.setName(node.getName());
        tree.setPid(String.valueOf(node.getParentId()));
        if (!(node instanceof File)){
            tree.setParent(true);
            tree.setIcon(RequestUtils.initOptProperties(AppConfig.getProperty("portal.url") + "/static/images/folder.gif"));
        }
        tree.setDrag(isdrag);
        return tree;
    }

    /**
     * 获取文件中心下所有子节点，并转换为map
     * @param nodeId
     * @return
     */
    private HashMap fileNodeToMap(Integer nodeId){
        HashMap<Integer,Node> nodeMap = new HashMap<Integer, Node>();
        List<Node> leftNodeList = nodeService.getAllChildNodes(nodeId);
        if (leftNodeList != null && leftNodeList.size() > 0){
            for (int i = 0; i < leftNodeList.size(); i++) {
                nodeMap.put(leftNodeList.get(i).getId(),leftNodeList.get(i));
            }
        }
        return nodeMap;
    }

    /**
     * 前台传递的节点记录转换为树对象map
     * @param nodeList
     * @return
     */
    private LinkedHashMap<String,Ztree> fileNodeToTreeMap(List<JSONObject> nodeList){
        LinkedHashMap<String,Ztree> treeMap = new LinkedHashMap<String, Ztree>();
        for (int i = 0; i < nodeList.size(); i++) {
            Ztree tree = ztreeNodeToZtree(nodeList.get(i));
            String tId = MapUtils.getString(nodeList.get(i),"tId");
            String parentTId = MapUtils.getString(nodeList.get(i),"parentTId");
            tree.setKz1(tId);
            tree.setKz2(parentTId);
            treeMap.put(tId,tree);
        }
        return treeMap;
    }

    /**
     * 单一的节点转为tree对象
     * @param jsonObject
     * @return
     */
    private Ztree ztreeNodeToZtree(JSONObject jsonObject){
        Ztree tree = new Ztree();
        tree.setId(MapUtils.getString(jsonObject,"id"));
        tree.setName(MapUtils.getString(jsonObject,"name"));
        tree.setPid(MapUtils.getString(jsonObject,"pid"));
        tree.setDrag(MapUtils.getBooleanValue(jsonObject,"drag"));
        return tree;
    }
}