package com.gtis.portal.util;

import com.alibaba.fastjson.JSON;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.SysStuffService;
import com.gtis.portal.entity.PfStuffConfig;
import com.gtis.portal.model.Ztree;
import com.gtis.portal.service.PfStuffConfigService;
import org.apache.commons.lang.StringUtils;

import java.io.*;
import java.util.*;

/**
 * @文件说明
 * @作者 deery
 * @创建日期 上午 9:58
 * @版本号 V 1.0
 */
public class CommonUtils {
    public static Map urlMap;
    public static Object readJsonFile(String path) throws Exception {
        if(StringUtils.isNotBlank(path)){
            if(path.indexOf("file:/")>-1)
                path = path.substring(path.indexOf("file:/")+6);
            File file = new File(path);
            if(!file.exists())
                throw new FileNotFoundException();
            BufferedReader bufferedReader=null;
            StringBuffer config = new StringBuffer();
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file), "UTF-8"));
                String tmp=null;
                while ((tmp=bufferedReader.readLine())!=null){
                    config.append(tmp);
                }
            }finally {
                if(bufferedReader!=null)
                    bufferedReader.close();
            }
            if(StringUtils.isNotBlank(config.toString())){
                return JSON.parse(config.toString());
            }
        }
        return null;
    }

    public static String getEgovhomeConfigFilePath(String project)throws Exception{
        //System.out.println(AppConfig.getEgovHome());
        //System.out.println(AppConfig.getProperty("egov.conf"));
        //file:/D:/tomcat/apache-tomcat-onemap/tomcat-7.0.23-x32-std/egov-home/std/
        //file:/D:/tomcat/apache-tomcat-onemap/tomcat-7.0.23-x32-std/egov-home/std/conf/
        String path = AppConfig.getProperty("egov.conf");
        path = java.net.URLDecoder.decode(path, "UTF-8");
        path = path.replace("file:/", "");
        String filePath = path;
        if (StringUtils.equalsIgnoreCase("egov",project)){
            filePath += "egov.properties";
        }else if (StringUtils.equalsIgnoreCase("gis",project)){
            filePath += "gis.properties";
        }else {
            filePath += project+"/application.properties";
        }
        return filePath;
    }

    public static File getEgovhomeConfigFile(String project)throws Exception{
        String filePath = getEgovhomeConfigFilePath(project);
        File file = new File(filePath);
        if (file.exists() && file.isFile()){
            return file;
        }
        return null;
    }

    /**
     * 获取egovhome下所有的系统配置文件夹及根目录下的配置文件，只处理properties配置文件
     * @return
     * @throws Exception
     */
    public static List<String> getEgovhomeConfigFileList()throws Exception{
        List<String> fileList = new ArrayList<String>();
        String path = AppConfig.getProperty("egov.conf");
        path = java.net.URLDecoder.decode(path, "UTF-8");
        path = path.replace("file:/", "");
        File dir = new File(path);
        if (dir.exists()){
            dir.listFiles();
            //如果是目录，则：
            if(dir.isDirectory()){
                //打印当前目录的路径
                //System.out.println(dir);
                //获取该目录下的所有文件和目录组成的File数组
                File[] files = dir.listFiles();
                //递归遍历每一个子文件
                for(File file : files){
                    String fileName = file.getName();
                    if (file.isDirectory()){
                        if(fileName.matches("^[A-Za-z]+$")){
                            fileList.add(fileName);
                        }
                    }else {
                        String prefix=fileName.substring(fileName.lastIndexOf(".")+1);
                        if (StringUtils.equalsIgnoreCase(prefix,"properties")){
                            fileName = StringUtils.split(fileName,".")[0];
                            if(fileName.matches("^[A-Za-z]+$")){
                                fileList.add(0,fileName);
                            }
                        }
                    }
                }
            }
        }
        int egovIndex = fileList.indexOf("egov");
        fileList.remove(egovIndex);
        fileList.add(0,"egov");
        return fileList;
    }

    /**
     * 获得工作流定义中的附件类型(初始化文件中心附件文件夹)
     * @param nodeService
     * @param stuffConfigService
     * @param workflowDefinitionId
     * @param fileCenterNodeId
     */
    public static void initWorkflowFileCenter(NodeService nodeService, PfStuffConfigService stuffConfigService, String workflowDefinitionId, int fileCenterNodeId){
        List<Node> nodeChiles = nodeService.getChildNodes(fileCenterNodeId);
        if (nodeChiles == null || nodeChiles.size() <= 0){
            //获得工作流定义中的附件类型，用于待办任务打开时，初始化待办任务的附件管理页面
            List<PfStuffConfig> configList = stuffConfigService.getListByWfdId(workflowDefinitionId);
            if (configList != null && configList.size() > 0){
                LinkedHashMap<String,Ztree> stuffTreeMap = new LinkedHashMap<String, Ztree>();
                for (int i = 0; i < configList.size(); i++) {
                    PfStuffConfig configTmp =  configList.get(i);

                    PfStuffConfig stuff = new PfStuffConfig();
                    stuff.setStuffId(configTmp.getStuffId());
                    stuff.setProId(configTmp.getProId());
                    stuff.setStuffName(configTmp.getStuffName());

                    Ztree tree = toZtree(stuff);
                    stuffTreeMap.put(tree.getId(),tree);
                }
                Ztree root = new Ztree();
                root.setId("treeroot");
                root.setName("根节点");
                root.setKz3(fileCenterNodeId);
                for (Ztree tree : stuffTreeMap.values()) {
                    if (tree.getPid() != null) {
                        Ztree ztree = stuffTreeMap.get(tree.getPid());
                        if (ztree != null) {
                            ztree.addChild(tree);
                        }else {
                            tree.setPid("treeroot");
                            root.addChild(tree);
                        }
                    }else {
                        tree.setPid("treeroot");
                        root.addChild(tree);
                    }
                }

                if (root.getChildren() != null && root.getChildren().size() > 0){
                    for (int i = 0; i < root.getChildren().size(); i++) {
                        createFileTree(root,nodeService);
                    }
                }
            }
        }
    }

    private static Ztree toZtree(PfStuffConfig stuff) {
        Ztree tree = new Ztree();
        tree.setId(stuff.getStuffId());
        tree.setName(stuff.getStuffName());
        if(stuff.getProId()==null){
            tree.setPid("treeroot");
        }else{
            tree.setPid(StringUtils.trimToNull(stuff.getProId()));
        }
        return tree;
    }

    public static void createFileTree(Ztree parent,NodeService nodeService){
        if (parent.getChildren() != null && parent.getChildren().size() > 0){
            for (int i = 0; i < parent.getChildren().size(); i++) {
                Ztree tree = parent.getChildren().get(i);
                Node stuffNode = nodeService.getNode(parent.getKz3(),tree.getName(),true);
                //用xh字段临时代替文件中心节点id，用于下面获取父节点id的调用
                tree.setKz3(stuffNode.getId());
                createFileTree(tree,nodeService);
                parent.getChildren().set(i,tree);
            }
        }
    }
}
