package com.gtis.portal.service.impl;

import com.gtis.plat.service.SysWorkFlowInstanceRelService;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.entity.PfMessageSend;
import com.gtis.portal.entity.PfWorkflowInstance;
import com.gtis.portal.entity.QPfWorkflowInstance;
import com.gtis.portal.service.BaseService;
import com.gtis.portal.service.PfWorkflowInstanceService;
import com.gtis.portal.util.ClassUtils;
import com.gtis.portal.util.QueryCondition;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.util.*;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import com.mysema.query.types.expr.BooleanExpression;

/**
 * java对象基础操作类
* @文件名 BaseServiceImpl.java
 * @作者 卢向伟
 * @创建日期 2015年12月12日
 * @创建时间 下午2:53:19 
 * @版本号 V 1.0
 */
@Service
public class PfWorkflowInstanceServiceImpl implements PfWorkflowInstanceService {
	@Autowired
	BaseDao baseDao;
	@Autowired
	public SysWorkFlowInstanceRelService workFlowInstanceRelService;

	public Page queryPageList(String proid, @PageableDefault(size = 1)Pageable pageable){
		List<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
		QueryCondition queryCondition;

		QPfWorkflowInstance qPfWorkflowInstance = QPfWorkflowInstance.pfWorkflowInstance;
		BooleanExpression expression=null;
		List<PfWorkFlowInstanceVo> wfList = workFlowInstanceRelService.getWorkFlowRelList(proid);
		if (wfList != null){
			StringBuffer jhlxClause = new StringBuffer();
			jhlxClause.append(" workflowInstanceId in (");
			for (int i = 0; i < wfList.size(); i++) {
				if (wfList.get(i) != null){
					jhlxClause.append("'"+wfList.get(i).getWorkflowIntanceId()+"',");
				}
			}
			jhlxClause.append("'')");
			queryConditions.add(new QueryCondition(jhlxClause.toString()));
		}

		return baseDao.get(PfWorkflowInstance.class,queryConditions,"order by createTime desc",pageable);
	}
}
