package com.gtis.portal.web.config;

import com.gtis.portal.properties.PropertyEntry;
import com.gtis.portal.properties.SafeProperties;
import com.gtis.portal.util.CommonUtils;
import com.gtis.portal.web.BaseController;
import com.gtis.web.SessionUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.*;


@Controller
@RequestMapping("config/pro")
public class PropertiesController extends BaseController {

    @RequestMapping("")
    public String manage(Model model, String paramString,String project) throws Exception{
        List<String> fileList = CommonUtils.getEgovhomeConfigFileList();
        if (StringUtils.isBlank(project)){
            project = fileList.get(0);
        }
        List<PropertyEntry> proList = new ArrayList<PropertyEntry>();
        LinkedHashMap<String,PropertyEntry> entryMap = new LinkedHashMap<String, PropertyEntry>();
        if (SessionUtil.getCurrentUser().isAdmin() && StringUtils.isNotBlank(project)){
            try {
                String filePath = CommonUtils.getEgovhomeConfigFilePath(project);
                File file = new File(filePath);
                if (file.exists() && file.isFile()){
                    FileInputStream inputStream = new FileInputStream(file);
                    SafeProperties prop = new SafeProperties();
                    prop.load(inputStream);
                    prop.initConfigCommentList();
                    proList = prop.getProList();
                    entryMap = prop.getEntryMap();
                }
            }catch (Exception ex){
                ex.printStackTrace();
            }
        }
        model.addAttribute("project",project);
        model.addAttribute("entryMap",entryMap);
        model.addAttribute("fileList",fileList);
        return "/config/properties/manage";
    }

    @RequestMapping("save")
    @ResponseBody
    public Object save(HttpServletRequest req, PropertyEntry propertyEntry,String project,String lastKey){
        if (SessionUtil.getCurrentUser().isAdmin() && propertyEntry != null && StringUtils.isNotBlank(propertyEntry.getKey()) && StringUtils.isNotBlank(project)){
            try {
                String comment = initComment(propertyEntry.getComment());
                propertyEntry.setComment(comment);

                String filePath = CommonUtils.getEgovhomeConfigFilePath(project);
                File file = new File(filePath);
                if (file.exists() && file.isFile()){
                    FileInputStream inputStream = new FileInputStream(file);
                    SafeProperties prop = new SafeProperties();
                    prop.load(inputStream);
                    prop.initConfigCommentList();
                    LinkedHashMap<String,PropertyEntry> entryMap = prop.getEntryMap();

                    //如果是采用插入的方式，则进行判断，当前配置项所在行，之后在行下面插入配置项，并且插入对应的注释
                    if (StringUtils.isNotBlank(lastKey)){
                        if (entryMap.containsKey(propertyEntry.getKey())){
                            return handlerErrorJson("已经存在该配置项："+propertyEntry.getKey()+"，请重新检查");
                        }
                        if (entryMap.containsKey(lastKey)){
                            PropertyEntry lastEntry = entryMap.get(lastKey);
                            PropertyEntry entry = new PropertyEntry(propertyEntry.getKey(),propertyEntry.getValue(),null,propertyEntry.getComment());
                            prop.getContext().getCommentOrEntrys().add(lastEntry.getIndex()+1,entry);
                            if (StringUtils.isNotBlank(propertyEntry.getComment())){
                                prop.getContext().getCommentOrEntrys().add(lastEntry.getIndex()+1,"");
                                prop.getContext().getCommentOrEntrys().add(lastEntry.getIndex()+2,propertyEntry.getComment());
                            }
                            FileOutputStream output = new FileOutputStream(filePath);
                            prop.store(output, null);
                            output.close();
                        }
                    }else {
                        if (entryMap.containsKey(propertyEntry.getKey())){
                            PropertyEntry entry = entryMap.get(propertyEntry.getKey());
                            entry.setValue(propertyEntry.getValue());
                            entry.setComment(propertyEntry.getComment());
                            int length = entry.getLineNum();
                            if (length > 0){
                                prop.getContext().getCommentOrEntrys().add(entry.getLastIndex(),"");
                                prop.getContext().getCommentOrEntrys().add(entry.getIndex()+1,entry.getComment());
                            }else{
                                if (StringUtils.isNotBlank(entry.getComment())){
                                    prop.getContext().getCommentOrEntrys().add(entry.getLastIndex(),"");
                                    prop.getContext().getCommentOrEntrys().add(entry.getIndex()+1,entry.getComment());
                                }
                            }
                            for (int i = 0; i < length; i++) {
                                prop.getContext().getCommentOrEntrys().remove(entry.getLastIndex()+1);
                            }
                            prop.put(entry.getKey(), entry.getValue());
                            FileOutputStream output = new FileOutputStream(filePath);
                            prop.store(output, null);
                            output.close();
                        }
                    }
                }
            }catch (Exception ex){
                ex.printStackTrace();
            }
        }
        return handlerSuccessJson();
    }

    private String initComment(String oldCom){
        String comment = "";
        if (StringUtils.isNotBlank(oldCom)){
            oldCom = StringUtils.removeEnd(oldCom,"\n");
            oldCom = StringUtils.replace(oldCom," ","");
            oldCom = StringUtils.replace(oldCom,"　","");
            String[] coms = StringUtils.split(oldCom,"\n");
            for (int i = 0; i < coms.length; i++) {
                if (StringUtils.isNotBlank(coms[i])){
                    if (!StringUtils.startsWith(coms[i],"#")){
                        comment += "#"+coms[i];
                    }else {
                        comment += coms[i];
                    }
                    comment += "\r\n";
                }
            }
        }
        comment = StringUtils.removeEnd(comment,"\r\n");
        comment = StringUtils.removeStart(comment,"\r\n");
        return comment;
    }
}