package com.gtis.portal.service.impl;

import com.gtis.portal.entity.*;
import com.gtis.portal.service.PfBusinessService;
import com.gtis.portal.service.PfResourceGroupService;
import com.gtis.portal.service.PfResourceService;
import com.gtis.portal.service.PfStuffConfigService;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPAQuery;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Where;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service
public class PfStuffConfigServiceImpl extends BaseServiceImpl<PfStuffConfig, String> implements PfStuffConfigService {

    public List<PfStuffConfig> getListByWfdId(String wfdId){
        if (StringUtils.isNotBlank(wfdId)){
            QPfStuffConfig qPfStuffConfig = QPfStuffConfig.pfStuffConfig;
            JPQLQuery query = new JPAQuery(em);
            return query.from(qPfStuffConfig).where(qPfStuffConfig.workflowDefinitionId.eq(wfdId)).orderBy(qPfStuffConfig.stuffXh.asc()).list(qPfStuffConfig);
        }
        return null;
    }
}
