package com.gtis.portal.service.impl;

import com.gtis.config.AppConfig;
import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.entity.*;
import com.gtis.portal.model.Menu;
import com.gtis.portal.model.Ztree;
import com.gtis.portal.service.*;
import com.gtis.portal.util.RequestUtils;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPAQuery;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

@Service
public class PfResourceServiceImpl extends BaseServiceImpl<PfResource, String> implements PfResourceService {
    @Autowired
    PfBusinessService businessService;
    @Autowired
    PfMenuService menuService;
    @Autowired
    PfResourceGroupService resourceGroupService;
    @Autowired
    PfAuthorizeService authorizeService;
    @Autowired
    PfInstanceAuthorizeService instanceAuthorizeService;

    public PfResource getResourceHasBs(String resouceId){
        PfResource resource = findById(resouceId);
        if (resource != null){
            if (StringUtils.isNotBlank(resource.getBusinessId())){
                PfBusiness business = businessService.findById(resource.getBusinessId());
                resource.setBusiness(business);
            }
            if (resource.getBusiness() == null){
                resource.setBusiness(new PfBusiness());
            }
        }
        return resource;
    }
    public List<PfResource> getAll(){
        QPfResource qPfResource = QPfResource.pfResource;
        JPQLQuery query = new JPAQuery(em);
        return query.from(qPfResource).orderBy(qPfResource.resourceNo.asc()).list(qPfResource);
    }

    public List<PfResource> getResourceListByGroupId(String groupId){
        List<PfResource> resourceList = null;
        if (StringUtils.isNotBlank(groupId)){
//            QPfMenu qPfMenu = QPfMenu.pfMenu;
//            JPQLQuery query = new JPAQuery(em);
//            if (StringUtils.isBlank(roles))
//                menuList = query.from(qPfMenu).where(qPfMenu.subsystems.any().subsystemName.eq(subsystem)).orderBy(qPfMenu.menuOrder.asc()).list(qPfMenu);
//            String jpql = "select t from PfResource t where t.groupId=?0";
//            baseDao.getByJpql(jpql,groupId);
            QPfResource qPfResource = QPfResource.pfResource;
            JPQLQuery query = new JPAQuery(em);
            resourceList = query.from(qPfResource).where(qPfResource.groupId.eq(groupId)).orderBy(qPfResource.resourceNo.asc()).list(qPfResource);
        }
        return resourceList;
    }

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void deleteResource(String resourceId){
        if (StringUtils.isNotBlank(resourceId)){
            //此处需要处理资源是否被菜单关联，如果被关联，则需要更新对应的菜单，将菜单的资源id设置为空
            //将原有菜单关联置空
            menuService.resetResouceRel(resourceId);

            //删除主菜单授权中关于资源的功能分区配置
            authorizeService.deleteAuthorizeListByResource(resourceId);

            //删除实例权限中配置的资源信息
            instanceAuthorizeService.deleteAuthorizeListByResource(resourceId);
            deleteById(resourceId);
        }
    }
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void deleteResourceByGroupId(String groupId){
        if (StringUtils.isNotBlank(groupId)){
            //将资源一并删除，此处需要处理资源是否被菜单关联，如果被关联，则需要更新对应的菜单，将菜单的资源id设置为空
            List<PfResource> resourceList = getResourceListByGroupId(groupId);
            if (resourceList != null && resourceList.size() > 0){
                for (int i=0;i<resourceList.size();i++){
                    deleteResource(resourceList.get(i).getResourceId());
                }
            }
        }
    }
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void clearResourceByGroupId(String groupId){
        if (StringUtils.isNotBlank(groupId)){
            //将资源一并删除，此处需要处理资源是否被菜单关联，如果被关联，则需要更新对应的菜单，将菜单的资源id设置为空
            List<PfResource> resourceList = getResourceListByGroupId(groupId);
            if (resourceList != null && resourceList.size() > 0){
                for (int i=0;i<resourceList.size();i++){
                    resourceList.get(i).setGroupId(null);
                    update(resourceList.get(i));
                }
            }
        }
    }


    @Override
    public Ztree getAllResourceTree(String hascheck) {
        boolean nocheck = true;
        if (StringUtils.isNotBlank(hascheck) && StringUtils.equalsIgnoreCase(hascheck,"true")){
            nocheck = false;
        }
        //获取业务列表、资源分组、资源表记录
        //之后根据业务、资源分组、资源表关系对数据进行整理
        List<Ztree> treeList = new ArrayList<Ztree>();
        HashMap<String, Ztree> treeMap = new LinkedHashMap<String, Ztree>();
        List<PfBusiness> businessList = businessService.getAll();
        if (businessList != null && businessList.size() > 0){
            for (PfBusiness business : businessList) {
                Ztree tree = toZtreeByBusiness(business);
                treeMap.put(tree.getId(), tree);
            }
            List<PfResourceGroup> resourceGroupList = resourceGroupService.getAll();
            if (resourceGroupList != null && resourceGroupList.size() > 0){
                for (PfResourceGroup resourceGroup : resourceGroupList) {
                    Ztree tree = toZtreeByResourceGroup(resourceGroup,nocheck);
                    treeMap.put(tree.getId(), tree);
                }
                List<PfResource> resourceList = getAll();
                if (resourceList != null && resourceList.size() > 0){
                    for (PfResource resource : resourceList) {
                        Ztree tree = toZtreeByResource(resource);
                        treeMap.put(tree.getId(), tree);
                    }
                }
            }
        }
        Ztree root = new Ztree();

        Ztree firstNode = new Ztree();
        firstNode.setId("treeroot");
        firstNode.setName("系统资源");
        firstNode.setNocheck(true);
        firstNode.setIcon(RequestUtils.initOptProperties(AppConfig.getProperty("portal.url") + "/static/images/folder_blank.png"));
        treeMap.put(firstNode.getId(),firstNode);

        for (Ztree tree : treeMap.values()) {
            if (tree.getPid() != null) {
                Ztree ztree = treeMap.get(tree.getPid());
                if (ztree != null) {
                    ztree.addChild(tree);
                }
            }else {
                tree.setOpen(true);
                root = tree;
            }
        }
        return root;
    }
    private Ztree toZtreeByBusiness(PfBusiness business) {
        Ztree tree = new Ztree();
        tree.setId(business.getBusinessId());
        tree.setName(business.getBusinessName());
        tree.setPid("treeroot");
        tree.setNocheck(true);
        tree.setGroup(false);
        tree.setIcon(RequestUtils.initOptProperties(AppConfig.getProperty("portal.url")+"/static/images/folder_blank.png"));
        return tree;
    }
    private Ztree toZtreeByResourceGroup(PfResourceGroup resourceGroup,boolean nocheck) {
        Ztree tree = new Ztree();
        tree.setId(resourceGroup.getGroupId());
        tree.setName(resourceGroup.getGroupName());
        tree.setPid(resourceGroup.getBusinessId());
        tree.setNocheck(nocheck);
        tree.setGroup(true);
        tree.setIcon(RequestUtils.initOptProperties(AppConfig.getProperty("portal.url")+"/static/images/folder.gif"));
        return tree;
    }
    private Ztree toZtreeByResource(PfResource resource) {
        Ztree tree = new Ztree();
        tree.setId(resource.getResourceId());
        tree.setName(resource.getResourceName());
//        tree.setUrl(resource.getResourceUrl());
        if (StringUtils.isBlank(resource.getGroupId())){
            tree.setPid(resource.getBusinessId());
        }else {
            tree.setPid(resource.getGroupId());
        }
        tree.setGroup(false);
        return tree;
    }

}
