/**
 * ztree控件的数据设置
 */
var settingRole = {
	view: {showLine: false},
	check: {enable: false},
	async: {
		enable: true,
		url:cur_proj_url+"/config/role/json",
		type: "get"
	},
	data: {simpleData: {enable: true}},
	callback: {
		onClick: ztreeRoleOnClick,
		onAsyncSuccess: zTreeRoleOnAsyncSuccess
	}
};
var settingOrgan = {
	view: {showLine: false,dblClickExpand: true},
	check: {enable: true},
	async: {
		enable: true,
		url:cur_proj_url+"/config/user/json?",
		type: "get"
	},
	callback: {
		onClick: ztreeOrganOnClick,
		onCheck: ztreeOrganOnCheck,
		onAsyncSuccess: zTreeOrganOnAsyncSuccess
	}
};

var settingUser = {
	view: {showLine: false},
	data: {simpleData: {enable: true}},
	async: {
		enable: true,
		type: "get"
	},
	edit: {
		enable: true,
		editNameSelectAll: false,
		showRenameBtn: false,
		showRemoveBtn: true
	},
	callback: {
		beforeRemove: beforeRemoveUser
	}
};

$(document).ready(function(){
	initdisselect("regionCode");
	$.fn.zTree.init($("#"+treeOrgan), settingOrgan);
	zTreeOrgan = $.fn.zTree.getZTreeObj(treeOrgan);
	$.fn.zTree.init($("#"+treeRole), settingRole);
	zTreeRole = $.fn.zTree.getZTreeObj(treeRole);


	////下面是主题操作事件
	$('#addTreeRole').click(function () {
		$('#roleInfoDiv').addClass("modal fade");
		addTreeRoleItem();
	});
	$('#roleBtn').click(function () {
		saveRoledata();
	});
	$('#deleteTreeRole').click(function () {
		deleteTreeRole();
	});


    //
	////下面是菜单树事件
	$('#expandTreeOrgan').click(function () {
		zTreeOrgan.expandAll(true);
	});
	$('#collapseTreeOrgan').click(function () {
		zTreeOrgan.expandAll(false);
	});

	$('#saveTreeUserRoleRel').click(function () {
		saveRoleUserReldata();
	});


});
//******************* 以下是主题树相关操作*****************************

function zTreeRoleOnAsyncSuccess(event, treeId, treeNode, msg) {
}
/**
 * 左键点击
 * @param event
 * @param treeId
 * @param treeNode
 */
function ztreeRoleOnClick(event, treeId, treeNode) {
	$("#roleForm input[type='hidden']").val("");
	$("#roleForm input[type='text']").val("");
	zTreeRole.selectNode(treeNode);
	$('#roleInfoDiv').show();
	zTreeOrgan.checkAllNodes(false);
	if(treeNode.id){
		//获取节点信息
		var url = cur_proj_url+"/config/role/info";
		var param = {roleId:treeNode.id}
		$.ajax({
			type: "get",
			url: url,
			data: param,
			async: false,
			success: function (result) {
				$('#treeTId').val(treeNode.tId);
				$('#roleId').val(result.role.roleId);
				$('#roleName').val(result.role.roleName);
				$('#roleNo').val(result.role.roleNo);
				if(result.role.regionCode){
				$("#regionCode").find("option[value="+result.role.regionCode+"]").attr("selected","selected");
				}else{
					$("#regionCode").find("option[value='parent']").attr("selected","selected");
				}
				$('#roleInfoDiv').removeClass("modal fade");

				$('#roleInfoDiv').show();
				$('#userList').show();
				$('#closebutton').hide();
				$('#roletitle').hide();

				initRoleUser(result.userList);
			}
		});
	}else{
		//临时增加的节点，需要获取父节点，如果父节点也是临时增加节点，则提示保存父节点
		$('#roleBtn').show();
		$('#treeTId').val(treeNode.tId);
		$('#subsystemTitle').val(result.name);
		cur_sub_id = "";
	}
}
/**
 * 增加节点
 */
function addTreeRoleItem() {
	$("#roleForm input[type='hidden']").val("");
	$("#roleForm input[type='text']").val("");
	$('#closebutton').show();
	$('#roletitle').show();
	$('#userList').hide();


}
/**
 * 保存菜单数据
 */
function saveRoledata(){
	//数据必填，不能为空
	var title = $('#roleName').val();
	if(!title ){
		alert("请填写要添加的角色名称");
		return;
	}

	var url = cur_proj_url+'/config/role/save?';
	$.ajax({
		url:url,
		type:'post',
		dataType:'json',
		data:$("#roleForm").serialize(),
		success:function (data) {
			alert(data.msg);
			$("#roleInfoDiv").modal('hide');
			if(data.success){
				var node = zTreeRole.getNodeByTId($('#treeTId').val());
				if(node){
				node.name=data.role.roleName;
				node.id=data.role.roleId;
				node.kz1=data.role.regionCode;
				zTreeRole.updateNode(node);
				}else{
					var newNode={id:data.role.roleId,name:data.role.roleName};
					zTreeRole.addNodes(null, newNode);
				}
			}

		},
		error:function (data) {
			alert("保存失败");
		}
	});
}
/**
 * 删除节点
 */
function deleteTreeRole() {
	if (confirm("确定要删除该节点吗，不可恢复？")==true){
		var nodes = zTreeRole.getSelectedNodes();
		if (nodes && nodes.length>0) {
			var curNode = nodes[0];
			if(curNode && curNode.id){
				removeCallback(curNode);
			}else{
				zTreeRole.removeNode(curNode);
			}
			$('#roleInfoDiv').hide();
		}
	}
}
/**
 * 删除返回函数
 * @param node
 */
function removeCallback(node){
	var url = cur_proj_url+'/config/role/del?';
	$.ajax({
		url:url,
		type:'post',
		dataType:'json',
		data:{roleId:node.id},
		success:function (data) {
			alert(data.msg);
			if(data.success){
				zTreeRole.removeNode(node);
			}
		},
		error:function (data) {
			alert("请求失败！");
		}
	});
}
//******************************************************************
//******************* 以下是部门树树操作*****************************
function zTreeOrganOnAsyncSuccess(event, treeId, treeNode, msg) {
	//默认选中第一个
	var nodes = zTreeRole.getNodes();
	if(nodes && nodes.length > 0){
		var node = nodes[0];
		zTreeRole.selectNode(node);
		ztreeRoleOnClick(null,null,node);
	}
}
//树控件的复选框、单选框的check事件
function ztreeOrganOnCheck(event, treeId, treeNode) {
	if(!treeNode.children || treeNode.children.length <= 0){
		zTreeOrgan.selectNode(treeNode);
	}
}
/**
 * 左键点击
 * @param event
 * @param treeId
 * @param treeNode
 */
function ztreeOrganOnClick(event, treeId, treeNode) {
	if (treeNode && (!treeNode.children || treeNode.children.length <= 0)) {
		zTreeOrgan.checkNode(treeNode, true, true);
	}
}
/**
 * 保存菜单数据
 */
function saveRoleUserReldata(){
	//测试修改过的节点记录
  var rolenodes=	zTreeRole.getSelectedNodes();
	if(rolenodes.length==0){
		alert("请选中角色之后，在添加相应的用户!");
		return false;
	}
	var nodes = zTreeOrgan.getCheckedNodes();
	if(nodes && nodes.length > 0){
		var zTreeRoleUser = $.fn.zTree.getZTreeObj("treeRoleUser");
		var userid="";
		var mark=1;
		for(var i=0;i<nodes.length;i++){
			if(nodes[i].kz1){
				var name=nodes[i].name;
				var id=nodes[i].id;
				userid+=id+"@";
				mark++;
				}
			}
		if(mark==1){
			alert("请选择用户!");
			return false;
		}
		var userNode= zTreeRoleUser.getNodes();
		var useidList="";
        for (var i=0;i<userNode.length;i++){
            var id= userNode[i].id;
            if(userNode.length-1==0){
                useidList+=id
            }else{
                useidList+=id+"@";
            }
        }
		$("#originaluserid").val(useidList);
        $("#userid").val(userid);
		var url = cur_proj_url+"/config/role/saveUserRole";
		$.ajax({
			type: "get",
			url: url,
			data:$("#roleForm").serialize(),
			async: false,
			success: function (result) {
				alert(result.msg);
				if(result.adduserList){
					var userList=result.adduserList;
					var zTreeRoleUser = $.fn.zTree.getZTreeObj("treeRoleUser");
					for(var i=0;i<userList.length;i++){
						id=	userList[i].userId;
						name=	userList[i].userName;
						var newNode = { name:name,id:id};
						var nodesuser=zTreeRoleUser.getNodes();
						zTreeRoleUser.addNodes(null,newNode);
					}
				}
				if(result.deluserList){
					var zTreeRoleUser = $.fn.zTree.getZTreeObj("treeRoleUser");
					var userList=result.deluserList;
					for(var i=0;i<userList.length;i++){
						id=	userList[i].userId;
						var node=zTreeRoleUser.getNodesByParam("id", id, null);
						zTreeRoleUser.removeNode(node[0]);
					}
				}

			}});
		}
	//zTreeOrgan.reAsyncChildNodes(null, "refresh");
}
//*****************************************************************
//******************* 以下是角色下用户信息操作*****************************
function initRoleUser(userList){
	if(userList && userList.length > 0){
		var jsonUsers=[];
		var pid="userroot";
		for (var i=0;i<userList.length;i++)
		{
			var id=userList[i].id;
			var name=userList[i].name;
			var json={id:id,name:name,pId:pid};
			jsonUsers.push(json);

			var node = zTreeOrgan.getNodeByParam("id", id, null);
			if(node){
				zTreeOrgan.checkNode(node, true, true);
			}
		}
		$.fn.zTree.init($("#"+treeRoleUser), settingUser,jsonUsers);
		zTreeRoleUser = $.fn.zTree.getZTreeObj(treeRoleUser);
	}
}

function beforeRemoveUser(treeId, treeNode) {
	zTreeRoleUser.selectNode(treeNode);
	if(confirm("确认删除“" + treeNode.name + "” 关联关系吗？")){
		var nodes=	zTreeRole.getSelectedNodes();
		var roleId=nodes[0].id;
		removeTreeRoleUser(roleId,treeNode.id);
	}else{
		return false;
	}
}
function removeTreeRoleUser(roleId,userId) {
	if(userId && roleId){
		var url = cur_proj_url+"/config/role/delUserRoleRel?";
		var param = {roleId:roleId,userId:userId};
		$.ajax({
			type: "get",
			url: url,
			data: param,
			async: false,
			success: function (result) {
				alert(result.msg);
				var node=zTreeOrgan.getNodesByParam("id",userId, null);
				zTreeOrgan.checkNode(node, false, true);
			}
		});
	}
}

//*************************************************************************

/*
刷新树
 */
function refreshTreeOrgan(){
	zTreeOrgan.reAsyncChildNodes(null, "refresh");
}

function ztree_check_integer(obj,code) {
	if(obj && obj.value){
		if (/^(\+|-)?\d+$/.test(obj.value)){
			return true;
		}else{
			f_alert(code,"请输入数字");
			return false;
		}
	}
	return false;
}