/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web.config;

import com.alibaba.fastjson.JSON;
import com.gtis.portal.entity.PfSubsystem;
import com.gtis.portal.entity.PublicVo;
import com.gtis.portal.model.Ztree;
import com.gtis.portal.model.ZtreeChanged;
import com.gtis.portal.service.PfMenuService;
import com.gtis.portal.service.PfResourceService;
import com.gtis.portal.service.PfSubsystemService;
import com.gtis.portal.util.RequestUtils;
import com.gtis.portal.web.BaseController;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"config/sub"})
public class SubsystemController
extends BaseController {
    @Autowired
    PfMenuService menuService;
    @Autowired
    PfResourceService resourceService;
    @Autowired
    PfSubsystemService subsystemService;
    @Resource
    @Qualifier(value="boolListNumber")
    List<PublicVo> boolListNumber;
    @Resource
    @Qualifier(value="subTypeList")
    List<PublicVo> subTypeList;
    @Resource
    @Qualifier(value="subMenuTypeList")
    List<PublicVo> subMenuTypeList;

    @RequestMapping(value={""})
    public String manage(Model model) {
        model.addAttribute("boolListNumber", (Object)this.boolListNumber);
        model.addAttribute("subTypeList", (Object)this.subTypeList);
        model.addAttribute("subMenuTypeList", (Object)this.subMenuTypeList);
        List subList = this.subsystemService.getAllSubsystemList(false);
        String curSubId = "";
        if (subList != null && subList.size() > 0) {
            curSubId = ((PfSubsystem)subList.get(0)).getSubsystemId();
        }
        model.addAttribute("curSubId", (Object)curSubId);
        return "/config/menu/submenu";
    }

    @RequestMapping(value={"json"})
    @ResponseBody
    public Object subjson(Model model) {
        List ztreeList = this.subsystemService.getSubsystemTree();
        return ztreeList;
    }

    @RequestMapping(value={"all"})
    @ResponseBody
    public Object allSub(Model model) {
        List subList = this.subsystemService.getAllSubsystemList(true);
        if (subList != null && subList.size() > 0) {
            for (int i = 0; i < subList.size(); ++i) {
                String url = ((PfSubsystem)subList.get(i)).getSubUrl();
                if (!StringUtils.isNotBlank((String)url)) continue;
                ((PfSubsystem)subList.get(i)).setSubUrl(RequestUtils.initOptProperties((String)url));
            }
        }
        return subList;
    }

    @RequestMapping(value={"checkjson"})
    @ResponseBody
    public Object menuCheckjson(Model model, @RequestParam(value="subId", required=false) String subId) {
        Ztree ztree = this.menuService.getSubMenuCheckTree(subId);
        return ztree;
    }

    @RequestMapping(value={"info"})
    @ResponseBody
    public PfSubsystem getSubsystem(@RequestParam(value="subsystemId", required=false) String subsystemId) {
        PfSubsystem subsystem = this.subsystemService.findById(subsystemId);
        if (subsystem == null) {
            subsystem = new PfSubsystem();
            subsystem.setSubsystemId(subsystemId);
        }
        Ztree ztree = this.menuService.getSubMenuTree(subsystem.getSubsystemId());
        subsystem.setSubmenuTree(ztree);
        return subsystem;
    }

    @RequestMapping(value={"save"})
    @ResponseBody
    public Object save(HttpServletRequest req, @ModelAttribute(value="subsystem") PfSubsystem subsystem, Model model) {
        PfSubsystem tmpSub;
        if (StringUtils.isBlank((String)subsystem.getSubsystemId())) {
            subsystem.setSubsystemId(this.subsystemService.getMaxSubsystemId().toString());
        }
        if ((tmpSub = this.subsystemService.findById(subsystem.getSubsystemId())) != null) {
            this.subsystemService.update((Object)subsystem);
        } else {
            this.subsystemService.insert((Object)subsystem);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        result.put("sub", subsystem);
        return result;
    }

    @RequestMapping(value={"del"})
    @ResponseBody
    public Object del(@RequestParam(value="keyId", required=false) String keyId) {
        if (StringUtils.isNotBlank((String)keyId)) {
            this.subsystemService.deleteById((Object)keyId);
            return this.handlerSuccessJson();
        }
        return this.handlerSuccessJson();
    }

    @RequestMapping(value={"menujson"})
    @ResponseBody
    public Object subMenuJson(Model model, @RequestParam(value="subId", required=false) String subId) {
        Ztree ztree = this.menuService.getSubMenuTree(subId);
        return ztree;
    }

    @RequestMapping(value={"saveRel"})
    @ResponseBody
    public Object saveSubMenuRel(HttpServletRequest req, String paramString, @RequestParam(value="subId", required=true) String subId, Model model) {
        if (paramString != null && StringUtils.isNotBlank((String)subId)) {
            List changeList = JSON.parseArray((String)paramString, ZtreeChanged.class);
            this.subsystemService.updateSubMenuRel(changeList, subId);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        return result;
    }

    @RequestMapping(value={"delRel"})
    @ResponseBody
    public Object delSubMenuRel(@RequestParam(value="subId", required=true) String subId, @RequestParam(value="menuId", required=true) String menuId) {
        if (StringUtils.isNotBlank((String)subId) && StringUtils.isNotBlank((String)menuId)) {
            this.subsystemService.deleteSubMenuRel(menuId, subId);
            return this.handlerSuccessJson();
        }
        return this.handlerSuccessJson();
    }
}

