/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web.config;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.vo.UserInfo;
import com.gtis.portal.entity.PfMenu;
import com.gtis.portal.model.Menu;
import com.gtis.portal.model.Ztree;
import com.gtis.portal.service.PfBusinessService;
import com.gtis.portal.service.PfMenuService;
import com.gtis.portal.service.PfResourceService;
import com.gtis.portal.web.BaseController;
import com.gtis.web.SessionUtil;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"config/menu"})
public class MenuController
extends BaseController {
    @Autowired
    PfMenuService menuService;
    @Autowired
    PfResourceService resourceService;
    @Autowired
    PfBusinessService businessService;

    @RequestMapping(value={""})
    public String manage(Model model) {
        return "/config/menu/manage";
    }

    @RequestMapping(value={"json"})
    @ResponseBody
    public Object menujson(Model model) {
        Ztree ztree = this.menuService.getAllMenuTree();
        return ztree;
    }

    @RequestMapping(value={"info"})
    @ResponseBody
    public PfMenu getMemu(@RequestParam(value="menuId", required=false) String menuId) {
        PfMenu menu = this.menuService.getMenuHasResNoSub(menuId);
        return menu == null ? new PfMenu() : menu;
    }

    @RequestMapping(value={"save"})
    @ResponseBody
    public Object save(HttpServletRequest req, @ModelAttribute(value="menu") PfMenu menu, Model model) {
        PfMenu tmpMenu;
        if (StringUtils.isBlank((String)menu.getMenuId())) {
            menu.setMenuId(UUIDGenerator.generate18());
        }
        if ((tmpMenu = this.menuService.getMenuHasResNoSub(menu.getMenuId())) != null) {
            tmpMenu.setMenuName(menu.getMenuName());
            tmpMenu.setMenuOrder(menu.getMenuOrder());
            this.menuService.update((Object)tmpMenu);
        } else {
            tmpMenu = new PfMenu();
            tmpMenu.setMenuId(menu.getMenuId());
            tmpMenu.setMenuName(menu.getMenuName());
            tmpMenu.setMenuOrder(menu.getMenuOrder());
            tmpMenu.setMenuParentId(menu.getMenuParentId());
            tmpMenu.setResourceId(null);
            tmpMenu.setMenuExpanded(false);
            this.menuService.insert((Object)tmpMenu);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        result.put("menu", tmpMenu);
        return result;
    }

    @RequestMapping(value={"del"})
    @ResponseBody
    public Object del(@ModelAttribute(value="menu") PfMenu menu) {
        if (menu != null) {
            this.menuService.delMenu(menu);
            return this.handlerSuccessJson();
        }
        return this.handlerSuccessJson();
    }

    @RequestMapping(value={"saveRel"})
    @ResponseBody
    public Object saveRel(HttpServletRequest req, @ModelAttribute(value="menu") PfMenu menu, Model model) {
        PfMenu tmpMenu;
        if (StringUtils.isNotBlank((String)menu.getMenuId())) {
            this.menuService.refreshMenuResouceRel(menu.getMenuId(), menu.getResourceId());
        }
        if ((tmpMenu = this.menuService.getMenuHasResNoSub(menu.getMenuId())) == null) {
            tmpMenu = new PfMenu();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        result.put("menu", tmpMenu);
        return result;
    }

    @RequestMapping(value={"menunav"})
    @ResponseBody
    public Menu menuNav(String systemId) {
        UserInfo userInfo = SessionUtil.getCurrentUser();
        if (userInfo.isAdmin()) {
            return this.menuService.getMenusByRole("", systemId);
        }
        String roleIds = userInfo.getRoleIds();
        if (StringUtils.isNotBlank((String)roleIds)) {
            return this.menuService.getMenusByRole(roleIds, systemId);
        }
        return null;
    }
}

