/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web.config;

import com.alibaba.fastjson.JSON;
import com.gtis.portal.entity.PfAuthorize;
import com.gtis.portal.entity.PfMenu;
import com.gtis.portal.entity.PfResourcePartition;
import com.gtis.portal.entity.PublicVo;
import com.gtis.portal.model.ZtreeChanged;
import com.gtis.portal.service.PfAuthorizeService;
import com.gtis.portal.service.PfMenuService;
import com.gtis.portal.service.PfResourcePartitionService;
import com.gtis.portal.service.PfResourceService;
import com.gtis.portal.web.BaseController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"config/menuAuth"})
public class MenuAuthorController
extends BaseController {
    @Autowired
    PfMenuService menuService;
    @Autowired
    PfResourceService resourceService;
    @Autowired
    PfAuthorizeService authorizeService;
    @Autowired
    PfResourcePartitionService resourcePartitionService;
    @Resource
    @Qualifier(value="partitionTypeList")
    List<PublicVo> partitionTypeList;
    @Resource
    @Qualifier(value="partitionOperatType")
    List<PublicVo> partitionOperatType;

    @RequestMapping(value={""})
    public String author(Model model) {
        model.addAttribute("partitionTypeJson", (Object)JSON.toJSONString((Object)this.partitionTypeList));
        model.addAttribute("partitionOperatTypeJson", (Object)JSON.toJSONString((Object)this.partitionOperatType));
        return "/config/menu/menu-author";
    }

    @RequestMapping(value={"reljson"})
    @ResponseBody
    public Object roleRelJson(Model model, String menuId) {
        List treeList = this.authorizeService.getAuthorizeRoleTreeListByMenuId(menuId);
        return treeList;
    }

    @RequestMapping(value={"partiInfo"})
    @ResponseBody
    public List<PfResourcePartition> getPartiInfo(@RequestParam(value="menuId", required=true) String menuId) {
        PfMenu menu;
        List rpList = null;
        if (StringUtils.isNotBlank((String)menuId) && (menu = this.menuService.getMenuHasResNoSub(menuId)) != null && StringUtils.isNotBlank((String)menu.getResourceId())) {
            rpList = this.resourcePartitionService.getListByRid(menu.getResourceId());
        }
        return rpList == null ? new ArrayList() : rpList;
    }

    @RequestMapping(value={"partiOperInfo"})
    @ResponseBody
    public List<PfAuthorize> getPartiOperInfo(@RequestParam(value="roleId", required=true) String roleId, @RequestParam(value="menuId", required=true) String menuId) {
        List authPartList = null;
        if (StringUtils.isNotBlank((String)menuId) && StringUtils.isNotBlank((String)roleId)) {
            authPartList = this.authorizeService.getAuthPartListByRoleId(roleId, menuId);
        }
        return authPartList == null ? new ArrayList() : authPartList;
    }

    @RequestMapping(value={"saveRel"})
    @ResponseBody
    public Object saveRoleRel(HttpServletRequest req, @RequestParam(value="menuId", required=true) String menuId, String paramString) {
        if (StringUtils.isNotBlank((String)paramString) && StringUtils.isNotBlank((String)menuId)) {
            System.out.println(paramString);
            List changeList = JSON.parseArray((String)StringUtils.trim((String)paramString), ZtreeChanged.class);
            this.authorizeService.updateMenuRoleRel(menuId, changeList);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        return result;
    }

    @RequestMapping(value={"updatePartOperType"})
    @ResponseBody
    public Object updatePartOperType(HttpServletRequest req, @RequestParam(value="menuId", required=true) String menuId, @RequestParam(value="roleId", required=true) String roleId, String paramString) {
        if (StringUtils.isNotBlank((String)menuId) && StringUtils.isNotBlank((String)roleId) && StringUtils.isNotBlank((String)paramString)) {
            List changeList = JSON.parseArray((String)StringUtils.trim((String)paramString), ZtreeChanged.class);
            this.authorizeService.updatePartOperType(menuId, roleId, changeList);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        return result;
    }
}

