/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web.config;

import com.alibaba.fastjson.JSON;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.portal.entity.PfBusinessGroup;
import com.gtis.portal.model.ZtreeChanged;
import com.gtis.portal.service.PfBusinessGroupService;
import com.gtis.portal.service.PfBusinessService;
import com.gtis.portal.web.BaseController;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"config/busi"})
public class BusinessController
extends BaseController {
    @Autowired
    private PfBusinessGroupService businessGroupService;
    @Autowired
    PfBusinessService businessService;

    @RequestMapping(value={"json"})
    @ResponseBody
    public Object json(Model model) {
        List treeList = this.businessService.getBusinessTree();
        return treeList;
    }

    @RequestMapping(value={"group"})
    public String groupManage(Model model) {
        return "/config/busi/busi-group-manager";
    }

    @RequestMapping(value={"groupjson"})
    @ResponseBody
    public Object groupJson(Model model) {
        List treeList = this.businessGroupService.getBusinessGroupTree();
        return treeList;
    }

    @RequestMapping(value={"groupinfo"})
    @ResponseBody
    public Object getGroupInfo(@RequestParam(value="groupId", required=false) String groupId) {
        PfBusinessGroup group = (PfBusinessGroup)this.businessGroupService.findById((Object)groupId);
        List relList = this.businessGroupService.getBusinessRelList(groupId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("group", group);
        result.put("relList", relList);
        return result;
    }

    @RequestMapping(value={"savegroup"})
    @ResponseBody
    public Object save(HttpServletRequest req, @ModelAttribute(value="group") PfBusinessGroup group, Model model) {
        PfBusinessGroup tmpObj;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (StringUtils.isBlank((String)group.getBusinessGroupId())) {
            group.setBusinessGroupId(UUIDGenerator.generate18());
            List tmpList = this.businessGroupService.getGroupListByName(group.getBusinessGroupName());
            if (tmpList != null && tmpList.size() > 0) {
                return this.handlerErrorJson("\u8981\u6dfb\u52a0\u7684\u5206\u7ec4\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff01");
            }
        }
        if ((tmpObj = (PfBusinessGroup)this.businessGroupService.findById((Object)group.getBusinessGroupId())) != null) {
            this.businessGroupService.updateDetail(group);
        } else {
            this.businessGroupService.insert((Object)group);
        }
        result.put("success", true);
        result.put("msg", "\u64cd\u4f5c\u6210\u529f\uff01");
        result.put("group", group);
        return result;
    }

    @RequestMapping(value={"delgroup"})
    @ResponseBody
    public Object delGroup(@RequestParam(value="groupId") String groupId) {
        if (StringUtils.isNotBlank((String)groupId)) {
            this.businessGroupService.deleteById((Object)groupId);
            return this.handlerSuccessJson();
        }
        return this.handlerErrorJson();
    }

    @RequestMapping(value={"saveBusiGruopRel"})
    @ResponseBody
    public Object saveBusiGruopRel(HttpServletRequest req, @RequestParam(value="groupId", required=true) String groupId, String paramString) {
        if (StringUtils.isNotBlank((String)paramString) && StringUtils.isNotBlank((String)groupId)) {
            List changeList = JSON.parseArray((String)paramString, ZtreeChanged.class);
            this.businessGroupService.updateBusinessIds(groupId, changeList);
        }
        return this.handlerSuccessJson();
    }
}

