/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.gtis.common.util.ByteObjectAccess;
import com.gtis.common.util.CommonUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysAuthorService;
import com.gtis.plat.service.SysMenuService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.plat.vo.PfBusinessVo;
import com.gtis.plat.vo.PfPartitionInfoVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.portal.service.IndexService;
import com.gtis.portal.service.PfBusinessGroupService;
import com.gtis.portal.service.PfWorkflowDefinitionService;
import com.gtis.portal.web.BaseController;
import com.gtis.web.SessionUtil;
import com.gtis.web.SplitParamImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/taskCenter"})
public class TaskCenterController
extends BaseController {
    @Autowired
    SysWorkFlowDefineService sysWorkFlowDefineService;
    @Autowired
    WorkFlowCoreService workFlowCoreService;
    @Autowired
    SysAuthorService sysAuthorService;
    @Autowired
    SysMenuService sysMenuService;
    @Autowired
    IndexService indexService;
    @Autowired
    PfWorkflowDefinitionService workflowDefinitionService;
    @Autowired
    PfBusinessGroupService businessGroupService;

    @RequestMapping(value={"index"})
    public String taskCenter(Model model, @RequestParam String rid) throws Exception {
        model.addAttribute("rid", (Object)rid);
        if (rid.startsWith("r:")) {
            rid = rid.replace("r:", "");
        }
        UserInfo userInfo = SessionUtil.getCurrentUser();
        Map mapWorkFlowDefine = this.workflowDefinitionService.getWorkFlowDefineMap(userInfo, rid);
        model.addAttribute("workFlowDefineMap", (Object)mapWorkFlowDefine);
        String createType = AppConfig.getProperty((String)"portal.taskcenter.createtask.type");
        model.addAttribute("createType", (Object)createType);
        if (StringUtils.isNotBlank((String)createType) && StringUtils.equalsIgnoreCase((String)createType, (String)"group")) {
            ArrayList businessGroupList = this.businessGroupService.getBusinessGroupListByRole(userInfo, rid);
            if (businessGroupList == null) {
                businessGroupList = new ArrayList();
            }
            model.addAttribute("businessGroupList", businessGroupList);
        }
        SplitParamImpl splitParam1 = new SplitParamImpl();
        splitParam1.setQueryString("getTaskList");
        HashMap mapParam = Maps.newHashMap();
        mapParam.put("userIds", SessionUtil.getCurrentUserId().equals("0") ? null : SessionUtil.getCurrentUserIds());
        splitParam1.setQueryParam((Serializable)mapParam);
        model.addAttribute("taskList", (Object)ByteObjectAccess.objectToString((Object)splitParam1));
        splitParam1.setQueryString("getTaskOverList");
        model.addAttribute("taskOverList", (Object)ByteObjectAccess.objectToString((Object)splitParam1));
        splitParam1.setQueryString("getProjectList");
        model.addAttribute("projectList", (Object)ByteObjectAccess.objectToString((Object)splitParam1));
        model.addAttribute("currentDate", (Object)CommonUtil.getCurrStrDate());
        List businessVoList = this.sysWorkFlowDefineService.getBusinessList();
        if (businessVoList != null && businessVoList.size() > 0) {
            for (int i = 0; i < businessVoList.size(); ++i) {
                List tmpList = (List)mapWorkFlowDefine.get(((PfBusinessVo)businessVoList.get(i)).getBusinessName());
                if (tmpList != null && tmpList.size() >= 1) continue;
                businessVoList.remove(i);
                --i;
            }
        }
        model.addAttribute("businessList", (Object)(businessVoList != null ? businessVoList : Lists.newArrayList()));
        boolean hasDel = false;
        boolean hasRestart = false;
        if (SessionUtil.getCurrentUser().isAdmin()) {
            hasDel = true;
            hasRestart = true;
        } else {
            String roles = SessionUtil.getCurrentUser().getRoleIds();
            List lstfPartitions = this.sysAuthorService.getSystemResrouceFunAuthorList(roles, rid);
            if (lstfPartitions != null) {
                for (PfPartitionInfoVo partitionInfoVo : lstfPartitions) {
                    if (!partitionInfoVo.getElementName().endsWith("\u5220\u9664") && !partitionInfoVo.getElementName().equalsIgnoreCase("del")) continue;
                    hasDel = true;
                    break;
                }
                for (PfPartitionInfoVo partitionInfoVo : lstfPartitions) {
                    if (!partitionInfoVo.getElementName().endsWith("\u91cd\u529e") && !partitionInfoVo.getElementName().equalsIgnoreCase("restart")) continue;
                    hasRestart = true;
                    break;
                }
            }
            List listWdids = this.sysMenuService.getProjectWorkFlowDefineIds(roles);
            StringBuffer bufferWdids = new StringBuffer();
            if (listWdids != null) {
                for (int index = 0; index < listWdids.size(); ++index) {
                    if (index > 0) {
                        bufferWdids.append(",");
                    }
                    bufferWdids.append("'" + (String)listWdids.get(index) + "'");
                }
            }
            model.addAttribute("excludeWdids", (Object)bufferWdids.toString());
        }
        model.addAttribute("hasDel", (Object)hasDel);
        model.addAttribute("hasRestart", (Object)hasRestart);
        return this.returnPage("/task/task-center");
    }

    @RequestMapping(value={"workflowDefinition"})
    @ResponseBody
    public Object getWorkflowDefinition(@RequestParam String wdid) {
        HashMap workflowDefinitionMap = Maps.newHashMap();
        PfWorkFlowDefineVo pfWorkFlowDefineVo = null;
        if (StringUtils.isNotBlank((String)wdid)) {
            pfWorkFlowDefineVo = this.sysWorkFlowDefineService.getWorkFlowDefine(wdid);
        }
        workflowDefinitionMap.put("workflowDefine", pfWorkFlowDefineVo);
        workflowDefinitionMap.put("username", SessionUtil.getCurrentUser().getUsername());
        workflowDefinitionMap.put("createTime", CommonUtil.getCurrStrDate());
        return workflowDefinitionMap;
    }

    @RequestMapping(value={"createDefaultTask"})
    @ResponseBody
    public Object createTask(PfWorkFlowInstanceVo pfWorkFlowInstanceVo) throws Exception {
        HashMap result = Maps.newHashMap();
        result.put("success", false);
        String userId = SessionUtil.getCurrentUserId();
        String proId = UUIDGenerator.generate();
        pfWorkFlowInstanceVo.setWorkflowIntanceId(proId);
        pfWorkFlowInstanceVo.setProId(proId);
        String taskId = null;
        try {
            PfTaskVo taskVo;
            WorkFlowInfo infoObj = this.workFlowCoreService.createWorkFlowInstance(pfWorkFlowInstanceVo, userId);
            Iterator i$ = infoObj.getTargetTasks().iterator();
            while (i$.hasNext()) {
                taskVo = (PfTaskVo)i$.next();
                if (!taskVo.getUserVo().getUserId().equals(userId)) continue;
                taskId = taskVo.getTaskId();
                break;
            }
            if (StringUtils.isBlank(taskId) && (i$ = infoObj.getTargetTasks().iterator()).hasNext()) {
                taskVo = (PfTaskVo)i$.next();
                taskId = taskVo.getTaskId();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        result.put("success", true);
        result.put("taskId", taskId);
        return result;
    }

    @RequestMapping(value={"createTask"})
    @ResponseBody
    public Object createTask(String wdid) throws Exception {
        HashMap result = Maps.newHashMap();
        result.put("success", false);
        if (StringUtils.isNotBlank((String)wdid)) {
            PfTaskVo taskVo;
            PfWorkFlowDefineVo pfWorkFlowDefineVo = this.sysWorkFlowDefineService.getWorkFlowDefine(wdid);
            String userId = SessionUtil.getCurrentUserId();
            String proId = UUIDGenerator.generate();
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo = new PfWorkFlowInstanceVo();
            StringBuilder workflowInstanceName = new StringBuilder("\u65b0\u5efa\u9879\u76ee");
            workflowInstanceName.append(Calendar.getInstance().getTimeInMillis());
            pfWorkFlowInstanceVo.setWorkflowIntanceName(workflowInstanceName.toString());
            pfWorkFlowInstanceVo.setWorkflowDefinitionId(wdid);
            pfWorkFlowInstanceVo.setCreateTime(Calendar.getInstance().getTime());
            pfWorkFlowInstanceVo.setTimeLimit(pfWorkFlowDefineVo.getTimeLimit());
            pfWorkFlowInstanceVo.setPriority("1");
            pfWorkFlowInstanceVo.setCreateUser(SessionUtil.getCurrentUserId());
            pfWorkFlowInstanceVo.setWorkflowIntanceId(proId);
            pfWorkFlowInstanceVo.setProId(proId);
            WorkFlowInfo infoObj = this.workFlowCoreService.createWorkFlowInstance(pfWorkFlowInstanceVo, userId);
            String taskId = null;
            Iterator i$ = infoObj.getTargetTasks().iterator();
            while (i$.hasNext()) {
                taskVo = (PfTaskVo)i$.next();
                if (!taskVo.getUserVo().getUserId().equals(userId)) continue;
                taskId = taskVo.getTaskId();
                break;
            }
            if (StringUtils.isBlank(taskId) && (i$ = infoObj.getTargetTasks().iterator()).hasNext()) {
                taskVo = (PfTaskVo)i$.next();
                taskId = taskVo.getTaskId();
            }
            result.put("success", true);
            result.put("taskId", taskId);
        }
        return result;
    }

    @RequestMapping(value={"getWorkflowDefinitions"})
    @ResponseBody
    public Object getWorkflowDefinitions(String businessId) {
        List workFlowDefineVoList = null;
        workFlowDefineVoList = StringUtils.isBlank((String)businessId) ? this.sysWorkFlowDefineService.getWorkFlowDefineList() : this.sysWorkFlowDefineService.getWorkFlowDefineByBusiness(businessId);
        return workFlowDefineVoList;
    }

    @RequestMapping(value={"indextask"})
    @ResponseBody
    public Object getIndexTaskList() {
        HashMap result = Maps.newHashMap();
        result.put("success", true);
        result.put("msg", "\u64cd\u4f5c\u6210\u529f");
        ArrayList mapList = this.indexService.getIndexTaskList();
        if (mapList == null) {
            mapList = new ArrayList();
        }
        ArrayList dataList = new ArrayList();
        for (int i = 0; i < mapList.size(); ++i) {
            HashMap map = (HashMap)mapList.get(i);
            HashMap<String, String> dataMap = new HashMap<String, String>();
            dataMap.put("id", MapUtils.getString((Map)map, (Object)"ASSIGNMENT_ID"));
            dataMap.put("url", AppConfig.getProperty((String)"server.url") + "/platform/taskhandle.action?taskid=" + MapUtils.getString((Map)map, (Object)"ASSIGNMENT_ID"));
            dataMap.put("title", MapUtils.getString((Map)map, (Object)"WORKFLOW_INSTANCE_NAME"));
            dataMap.put("date", MapUtils.getString((Map)map, (Object)"BEGIN_TIME"));
            String sfcq = MapUtils.getString((Map)map, (Object)"SFCQ");
            if (StringUtils.equals((String)"cqrw", (String)sfcq)) {
                dataMap.put("type", "top");
            } else {
                dataMap.put("type", "down");
            }
            dataList.add(dataMap);
        }
        result.put("data", dataList);
        return result;
    }
}

