/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.web;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysDistrictService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.portal.entity.PfSubsystem;
import com.gtis.portal.ex.ExceptionCode;
import com.gtis.portal.ex.UserException;
import com.gtis.portal.service.IndexService;
import com.gtis.portal.service.PfSubsystemService;
import com.gtis.portal.util.RequestUtils;
import com.gtis.portal.web.BaseController;
import com.gtis.util.Md5Util;
import com.gtis.web.SessionUtil;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class IndexController
extends BaseController {
    @Autowired
    SysUserService sysUserService;
    @Autowired
    SysDistrictService sysDistrictService;
    @Autowired
    IndexService indexService;
    @Autowired
    PfSubsystemService subsystemService;

    @RequestMapping(value={"index"})
    public String index(Model model, String systemId) {
        List subList;
        this.initIndex(model);
        PfSubsystem sub = this.subsystemService.findById(systemId);
        if (sub == null) {
            sub = this.subsystemService.getSubsystemByName(systemId);
        }
        if ((sub == null || StringUtils.isBlank((String)systemId)) && (subList = this.subsystemService.getAllSubsystemList(true)) != null && subList.size() > 0) {
            sub = (PfSubsystem)subList.get(0);
            systemId = sub.getSubsystemId();
        }
        if (sub == null) {
            sub = new PfSubsystem();
        }
        model.addAttribute("sub", (Object)sub);
        String returnPage = sub.getSubsystemName();
        if (sub.getSubType() != null) {
            switch (sub.getSubType()) {
                case 1: {
                    if (sub.getSubMenuType() == null) break;
                    returnPage = sub.getSubMenuType();
                    break;
                }
                case 2: {
                    Map urlMap = this.indexService.getConfigIndexZhswUrl();
                    model.addAttribute("urlMap", (Object)urlMap);
                    model.addAttribute("urlMapJson", (Object)JSON.toJSONString((Object)urlMap));
                    break;
                }
                case 3: {
                    returnPage = "iframe";
                }
            }
        }
        return "index/" + returnPage + "/index";
    }

    @RequestMapping(value={"indexFrame"})
    public String indexFrame(Model model, String subUrl) throws Exception {
        if (StringUtils.isNotBlank((String)subUrl)) {
            subUrl = URLDecoder.decode(subUrl, "utf-8");
        }
        this.initIndex(model);
        PfSubsystem sub = new PfSubsystem();
        sub.setSubUrl(RequestUtils.initOptProperties((String)subUrl));
        model.addAttribute("sub", (Object)sub);
        return "index/iframe/index";
    }

    public void initIndex(Model model) {
        UserInfo userInfo = SessionUtil.getCurrentUser();
        model.addAttribute("userName", (Object)SessionUtil.getCurrentUser().getUsername());
        List organList = userInfo.getLstOragn();
        String organ = "";
        if (organList != null && organList.size() > 0) {
            organ = ((PfOrganVo)organList.get(0)).getOrganName();
        }
        model.addAttribute("organName", (Object)organ);
        model.addAttribute("organList", (Object)organList);
        String defaultDistrictCode = AppConfig.getProperty((String)"district.code");
        List districtList = Lists.newArrayList();
        districtList = StringUtils.isNotBlank((String)defaultDistrictCode) ? this.sysDistrictService.querySubDistrictByCode(AppConfig.getProperty((String)"district.code")) : this.sysDistrictService.queryAllDistrict();
        model.addAttribute("districtList", (Object)districtList);
    }

    @RequestMapping(value={"password"})
    @ResponseBody
    public Object password(Model model, String oldPassword, String newPassword, String confirmNewPassword) throws Exception {
        if (!newPassword.equals(confirmNewPassword)) {
            throw new UserException(ExceptionCode.NEW_PASSWORD_CONFIRM_PASSWORD_DIFF);
        }
        String userId = SessionUtil.getCurrentUserId();
        PfUserVo userObj = this.sysUserService.getUserVo(userId);
        if (userObj == null) {
            throw new UserException(ExceptionCode.USER_NOT_FOUND);
        }
        String checkpass = oldPassword;
        String md5 = Md5Util.Build((String)checkpass);
        if (md5.equals(userObj.getLoginPassWord())) {
            if (this.sysUserService.savePassWord(userId, newPassword)) {
                return this.handlerSuccessJson();
            }
            throw new UserException(ExceptionCode.USER_MODIFY_ERROR);
        }
        throw new UserException(ExceptionCode.USER_OLD_PASSWORD_ERROR);
    }

    @RequestMapping(value={"signPassword"})
    @ResponseBody
    public Object signPassword(Model model, String oldSignPassword, String newSignPassword, String confirmNewSignPassword) throws Exception {
        if (!newSignPassword.equals(confirmNewSignPassword)) {
            throw new UserException(ExceptionCode.NEW_PASSWORD_CONFIRM_PASSWORD_DIFF);
        }
        String userId = SessionUtil.getCurrentUserId();
        PfUserVo userObj = this.sysUserService.getUserVo(userId);
        if (userObj == null) {
            throw new UserException(ExceptionCode.USER_NOT_FOUND);
        }
        String checkpass = oldSignPassword;
        String md5 = Md5Util.Build((String)checkpass);
        if (md5.equals(userObj.getSignPassword())) {
            if (this.sysUserService.saveSignPassword(userId, newSignPassword)) {
                return this.handlerSuccessJson();
            }
            throw new UserException(ExceptionCode.USER_MODIFY_ERROR);
        }
        throw new UserException(ExceptionCode.USER_OLD_PASSWORD_ERROR);
    }
}

