/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.support.freemarker;

import com.google.common.collect.Maps;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Map;

public class ConfigurableObjectWrapper
extends DefaultObjectWrapper {
    private Map<Class, Class<TemplateModel>> classMapping = Collections.emptyMap();
    private Map<Class, Constructor> cache = Maps.newHashMap();

    public void setClassMapping(Map<Class, Class<TemplateModel>> classMapping) {
        this.classMapping = classMapping;
    }

    protected TemplateModel handleUnknownType(Object obj) throws TemplateModelException {
        Class<?> clazz = obj.getClass();
        Constructor<?> constructor = null;
        if (this.cache.containsKey(clazz)) {
            constructor = (Constructor<?>)this.cache.get(clazz);
        } else {
            for (Map.Entry entry : this.classMapping.entrySet()) {
                if (!((Class)entry.getKey()).isAssignableFrom(clazz)) continue;
                constructor = ((Class)entry.getValue()).getConstructors()[0];
                break;
            }
            this.cache.put(clazz, constructor);
        }
        if (constructor != null) {
            try {
                return (TemplateModel)constructor.newInstance(obj, this);
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        return super.handleUnknownType(obj);
    }
}

