/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.support.fastjson;

import com.gtis.portal.support.fastjson.Helper;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.view.AbstractView;

public class FastjsonView
extends AbstractView {
    public static final String DEFAULT_CONTENT_TYPE = "application/json; charset=utf-8";
    private String rootKey;
    private String jsonpParameterName = "callback";
    private boolean disableCaching = true;

    public void setRootKey(String rootKey) {
        this.rootKey = rootKey;
    }

    public void setJsonpParameterName(String jsonpParameterName) {
        this.jsonpParameterName = jsonpParameterName;
    }

    public void setDisableCaching(boolean disableCaching) {
        this.disableCaching = disableCaching;
    }

    public FastjsonView() {
        this.setContentType(DEFAULT_CONTENT_TYPE);
        this.setExposePathVariables(false);
    }

    protected void prepareResponse(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType(this.getContentType());
        if (this.disableCaching) {
            response.addHeader("Pragma", "no-cache");
            response.addHeader("Cache-Control", "no-cache, no-store, max-age=0");
            response.addDateHeader("Expires", 1L);
        }
    }

    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Helper.render((Object)(this.rootKey == null ? model : model.get(this.rootKey)), (String)request.getParameter(this.jsonpParameterName), (Writer)response.getWriter());
    }
}

