/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.service.impl;

import com.gtis.config.AppConfig;
import com.gtis.portal.entity.PfMenu;
import com.gtis.portal.entity.PfSubsystem;
import com.gtis.portal.entity.PfSubsystemMenuRel;
import com.gtis.portal.entity.QPfSubsystem;
import com.gtis.portal.entity.QPfSubsystemMenuRel;
import com.gtis.portal.model.Ztree;
import com.gtis.portal.model.ZtreeChanged;
import com.gtis.portal.service.PfBusinessService;
import com.gtis.portal.service.PfMenuService;
import com.gtis.portal.service.PfResourceService;
import com.gtis.portal.service.PfSubsystemService;
import com.gtis.portal.service.impl.BaseServiceImpl;
import com.gtis.portal.util.RequestUtils;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PfSubsystemServiceImpl
extends BaseServiceImpl<PfSubsystem, String>
implements PfSubsystemService {
    @Autowired
    PfBusinessService businessService;
    @Autowired
    PfResourceService resourceService;
    @Autowired
    PfMenuService menuService;

    public PfSubsystem findById(String systemId) {
        PfSubsystem sub = (PfSubsystem)super.findById((Object)systemId);
        if (sub != null && StringUtils.isNotBlank((String)sub.getSubUrl())) {
            sub.setSubUrl(RequestUtils.initOptProperties((String)sub.getSubUrl()));
        }
        return sub;
    }

    public List<Ztree> getSubsystemTree() {
        List subList = this.getAllSubsystemList(false);
        ArrayList<Ztree> treeList = new ArrayList<Ztree>();
        if (subList != null && subList.size() > 0) {
            for (int i = 0; i < subList.size(); ++i) {
                Ztree tree = this.toZtreeBySubsystem((PfSubsystem)subList.get(i));
                treeList.add(tree);
            }
        }
        return treeList;
    }

    public PfSubsystem getSubsystemByName(String name) {
        QPfSubsystem qPfSubsystem;
        JPAQuery query;
        List list;
        if (StringUtils.isNotBlank((String)name) && (list = ((JPQLQuery)((JPQLQuery)((JPQLQuery)(query = new JPAQuery(this.em)).from(new EntityPath[]{qPfSubsystem = QPfSubsystem.pfSubsystem})).where(new Predicate[]{qPfSubsystem.subsystemName.eq((Object)name)})).orderBy(new OrderSpecifier[]{qPfSubsystem.subNo.asc()})).list((Expression)qPfSubsystem)) != null && list.size() > 0) {
            if (StringUtils.isNotBlank((String)((PfSubsystem)list.get(0)).getSubUrl())) {
                ((PfSubsystem)list.get(0)).setSubUrl(RequestUtils.initOptProperties((String)((PfSubsystem)list.get(0)).getSubUrl()));
            }
            return (PfSubsystem)list.get(0);
        }
        return null;
    }

    public List<PfSubsystem> getAllSubsystemList(boolean enable) {
        QPfSubsystem qPfSubsystem = QPfSubsystem.pfSubsystem;
        JPAQuery query = new JPAQuery(this.em);
        if (enable) {
            return ((JPQLQuery)((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfSubsystem})).where(new Predicate[]{qPfSubsystem.enabled.eq(Boolean.valueOf(true))})).orderBy(new OrderSpecifier[]{qPfSubsystem.subNo.asc()})).list((Expression)qPfSubsystem);
        }
        return ((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfSubsystem})).orderBy(new OrderSpecifier[]{qPfSubsystem.subNo.asc()})).list((Expression)qPfSubsystem);
    }

    public Integer getMaxSubsystemId() {
        String jpql = "select max(subsystemId) from PfSubsystem";
        String maxId = (String)this.baseDao.getUniqueResultByJpql(jpql, new Object[0]);
        if (StringUtils.isNotBlank((String)maxId)) {
            Integer max;
            Integer n = max = Integer.valueOf(maxId);
            Integer n2 = max = Integer.valueOf(max + 1);
            return max;
        }
        return 1;
    }

    public PfSubsystemMenuRel getSubMenuRel(String menuId, String subId) {
        List relList = this.getSubMenuRelList(menuId, subId);
        if (relList != null && relList.size() > 0) {
            return (PfSubsystemMenuRel)relList.get(0);
        }
        return null;
    }

    public List<PfSubsystemMenuRel> getSubMenuRelList(String menuId, String subId) {
        QPfSubsystemMenuRel qPfSubsystemMenuRel = QPfSubsystemMenuRel.pfSubsystemMenuRel;
        JPAQuery query = new JPAQuery(this.em);
        List relList = null;
        if (StringUtils.isNotBlank((String)menuId) && StringUtils.isNotBlank((String)subId)) {
            relList = ((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfSubsystemMenuRel})).where(new Predicate[]{qPfSubsystemMenuRel.menuId.eq((Object)menuId).and((Predicate)qPfSubsystemMenuRel.subsystemId.eq((Object)subId))})).list((Expression)qPfSubsystemMenuRel);
        } else if (StringUtils.isNotBlank((String)menuId) && StringUtils.isBlank((String)subId)) {
            relList = ((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfSubsystemMenuRel})).where(new Predicate[]{qPfSubsystemMenuRel.menuId.eq((Object)menuId)})).list((Expression)qPfSubsystemMenuRel);
        } else if (StringUtils.isBlank((String)menuId) && StringUtils.isNotBlank((String)subId)) {
            relList = ((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfSubsystemMenuRel})).where(new Predicate[]{qPfSubsystemMenuRel.subsystemId.eq((Object)subId)})).list((Expression)qPfSubsystemMenuRel);
        }
        return relList;
    }

    @Transactional
    public void deleteSubMenuRel(String menuId, String subId) {
        List menuList;
        if (StringUtils.isNotBlank((String)menuId) && StringUtils.isNotBlank((String)subId) && (menuList = this.menuService.getSubMenuListBySubIdAndMenuId(menuId)) != null && menuList.size() > 0) {
            for (int i = menuList.size() - 1; i >= 0; --i) {
                String jpql = "delete from PfSubsystemMenuRel t where t.menuId=?0 and t.subsystemId=?1";
                this.baseDao.executeJpql(jpql, new Object[]{((PfMenu)menuList.get(i)).getMenuId(), subId});
            }
        }
    }

    @Transactional
    public void insertMenuRel(String menuId, String subId) {
        List relList = this.getSubMenuRelList(menuId, subId);
        if (relList == null || relList.size() < 1) {
            PfSubsystemMenuRel rel = new PfSubsystemMenuRel();
            rel.setMenuId(menuId);
            rel.setSubsystemId(subId);
            this.baseDao.save((Object)rel);
        }
    }

    @Transactional
    public void updateSubMenuRel(List<ZtreeChanged> changeList, String subId) {
        if (changeList != null && StringUtils.isNotBlank((String)subId)) {
            for (int i = 0; i < changeList.size(); ++i) {
                ZtreeChanged changed = changeList.get(i);
                if (changed.isChecked()) {
                    this.insertMenuRel(changed.getId(), subId);
                    continue;
                }
                this.deleteSubMenuRel(changed.getId(), subId);
            }
        }
    }

    @Transactional
    public void refreshMenuRel(String menuIds, String subId) {
        if (StringUtils.isNotBlank((String)menuIds) && StringUtils.isNotBlank((String)subId)) {
            HashMap<String, String> idMap = new HashMap<String, String>();
            String[] idAry = StringUtils.split((String)menuIds, (String)",");
            for (int i = 0; i < idAry.length; ++i) {
                if (!StringUtils.isNotBlank((String)idAry[i])) continue;
                idMap.put(idAry[i], idAry[i]);
            }
            JPAQuery query = new JPAQuery(this.em);
            QPfSubsystemMenuRel qPfSubsystemMenuRel = QPfSubsystemMenuRel.pfSubsystemMenuRel;
            List relList = ((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfSubsystemMenuRel})).where(new Predicate[]{qPfSubsystemMenuRel.subsystemId.eq((Object)subId)})).list((Expression)qPfSubsystemMenuRel);
            if (relList != null && relList.size() > 1) {
                for (int i = 0; i < relList.size(); ++i) {
                    String menuId = ((PfSubsystemMenuRel)relList.get(i)).getMenuId();
                    if (!idMap.containsKey(menuId)) {
                        this.baseDao.delete(relList.get(i));
                        relList.remove(i);
                        --i;
                        break;
                    }
                    idMap.remove(menuId);
                }
                for (Map.Entry entry : idMap.entrySet()) {
                    String key = (String)entry.getKey();
                    PfSubsystemMenuRel rel = new PfSubsystemMenuRel();
                    rel.setMenuId(key);
                    rel.setSubsystemId(subId);
                    this.baseDao.save((Object)rel);
                }
            }
        }
    }

    private Ztree toZtreeBySubsystem(PfSubsystem sub) {
        Ztree tree = new Ztree();
        tree.setId(sub.getSubsystemId());
        tree.setName(sub.getSubsystemTitle());
        tree.setNocheck(true);
        tree.setKz1(sub.getSubsystemName());
        tree.setIcon(RequestUtils.initOptProperties((String)(AppConfig.getProperty((String)"portal.url") + "/static/images/40x40icon05.png")));
        return tree;
    }
}

