/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.service.impl;

import com.gtis.portal.entity.PfRole;
import com.gtis.portal.entity.QPfRole;
import com.gtis.portal.model.Ztree;
import com.gtis.portal.service.PfInstanceAuthorizeService;
import com.gtis.portal.service.PfRoleService;
import com.gtis.portal.service.PfUserService;
import com.gtis.portal.service.impl.BaseServiceImpl;
import com.gtis.portal.service.impl.PfAuthorizeServiceImpl;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Predicate;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PfRoleServiceImpl
extends BaseServiceImpl<PfRole, String>
implements PfRoleService {
    @Autowired
    PfUserService userService;
    @Autowired
    PfAuthorizeServiceImpl authorizeService;
    @Autowired
    PfInstanceAuthorizeService instanceAuthorizeService;

    public List<PfRole> getRoleByName(String roleName) {
        QPfRole qPfRole = QPfRole.pfRole;
        JPAQuery query = new JPAQuery(this.em);
        List pfRoleList = ((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfRole})).where(new Predicate[]{qPfRole.roleName.eq((Object)roleName)})).list((Expression)qPfRole);
        return pfRoleList;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void deleteById(String roleId) {
        if (StringUtils.isNotBlank((String)roleId)) {
            this.authorizeService.deleteAuthorizeListByRole(roleId);
            this.instanceAuthorizeService.deleteAuthorizeListByRole(roleId);
            String jpql = "delete from PfUserRoleRel t where t.roleId=?0";
            this.baseDao.executeJpql(jpql, new Object[]{roleId});
            super.deleteById((Object)roleId);
        }
    }

    public List<PfRole> getListByXzqdm(String xzqdm) {
        QPfRole qPfRole = QPfRole.pfRole;
        JPAQuery query = new JPAQuery(this.em);
        if (StringUtils.isNotBlank((String)xzqdm)) {
            return ((JPQLQuery)((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfRole})).where(new Predicate[]{qPfRole.regionCode.eq((Object)xzqdm)})).orderBy(new OrderSpecifier[]{qPfRole.roleNo.asc()})).list((Expression)qPfRole);
        }
        return ((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfRole})).orderBy(new OrderSpecifier[]{qPfRole.roleNo.asc()})).list((Expression)qPfRole);
    }

    public List<Ztree> getTreeByXzqdm(String xzqdm) {
        ArrayList<Ztree> treeList = new ArrayList<Ztree>();
        List roleList = this.getListByXzqdm(xzqdm);
        if (roleList != null && roleList.size() > 0) {
            for (int i = 0; i < roleList.size(); ++i) {
                treeList.add(this.toZtreeByRole((PfRole)roleList.get(i)));
            }
        }
        return treeList;
    }

    private Ztree toZtreeByRole(PfRole role) {
        Ztree tree = new Ztree();
        tree.setId(role.getRoleId());
        tree.setName(role.getRoleName());
        tree.setKz1(role.getRegionCode());
        tree.setKz2(role.getRoleNo());
        tree.setPid("treeroot");
        return tree;
    }
}

