/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.service.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.portal.entity.PfBusinessGroup;
import com.gtis.portal.entity.PublicVo;
import com.gtis.portal.entity.QPfBusinessGroup;
import com.gtis.portal.model.Ztree;
import com.gtis.portal.model.ZtreeChanged;
import com.gtis.portal.service.PfBusinessGroupService;
import com.gtis.portal.service.PfBusinessService;
import com.gtis.portal.service.PfWorkflowDefinitionService;
import com.gtis.portal.service.impl.BaseServiceImpl;
import com.gtis.portal.util.RequestUtils;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PfBusinessGroupServiceImpl
extends BaseServiceImpl<PfBusinessGroup, String>
implements PfBusinessGroupService {
    @Autowired
    SysWorkFlowDefineService sysWorkFlowDefineService;
    @Autowired
    PfWorkflowDefinitionService workflowDefinitionService;
    @Autowired
    PfBusinessService businessService;

    public List<PfBusinessGroup> getGroupListByName(String name) {
        QPfBusinessGroup qPfBusinessGroup = QPfBusinessGroup.pfBusinessGroup;
        JPAQuery query = new JPAQuery(this.em);
        return ((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfBusinessGroup})).where(new Predicate[]{qPfBusinessGroup.businessGroupName.eq((Object)name)})).list((Expression)qPfBusinessGroup);
    }

    public List<PfBusinessGroup> getBusinessGroupList() {
        QPfBusinessGroup qPfBusinessGroup = QPfBusinessGroup.pfBusinessGroup;
        JPAQuery query = new JPAQuery(this.em);
        return ((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qPfBusinessGroup})).orderBy(new OrderSpecifier[]{qPfBusinessGroup.businessGroupNo.asc()})).list((Expression)qPfBusinessGroup);
    }

    public List<Ztree> getBusinessGroupTree() {
        List groupList = this.getBusinessGroupList();
        ArrayList<Ztree> treeList = new ArrayList<Ztree>();
        if (groupList != null && groupList.size() > 0) {
            for (int i = 0; i < groupList.size(); ++i) {
                Ztree tree = this.toZtreeByGroup((PfBusinessGroup)groupList.get(i));
                treeList.add(tree);
            }
        }
        return treeList;
    }

    public List<PublicVo> getBusinessRelList(String groupId) {
        String busiIds;
        PfBusinessGroup group;
        ArrayList<PublicVo> publicList = new ArrayList<PublicVo>();
        if (StringUtils.isNotBlank((String)groupId) && (group = (PfBusinessGroup)this.findById((Object)groupId)) != null && StringUtils.isNotBlank((String)(busiIds = group.getBusinessIds()))) {
            HashMap relMap = (HashMap)JSON.parseObject((String)busiIds, HashMap.class);
            for (Map.Entry entry : relMap.entrySet()) {
                String key = (String)entry.getKey();
                PublicVo publicVo = new PublicVo();
                publicVo.setValue((String)entry.getKey());
                publicVo.setName((String)entry.getValue());
                publicList.add(publicVo);
            }
        }
        return publicList;
    }

    public List<PfBusinessGroup> getBusinessGroupListByRole(UserInfo userInfo, String rid) {
        ArrayList<PfBusinessGroup> businessGroupList = new ArrayList<PfBusinessGroup>();
        List groupTmpList = this.getBusinessGroupList();
        if (groupTmpList != null && groupTmpList.size() > 0) {
            int i;
            List lstWorkFlowDefine = Lists.newArrayList();
            lstWorkFlowDefine = userInfo.isAdmin() ? this.sysWorkFlowDefineService.getWorkFlowDefineList() : this.sysWorkFlowDefineService.getWorkFlowDefineListByRole(userInfo.getRoleIds(), rid, null);
            LinkedHashMap<String, ArrayList> workflowDefineMap = new LinkedHashMap<String, ArrayList>();
            if (lstWorkFlowDefine != null && lstWorkFlowDefine.size() > 0) {
                for (i = 0; i < lstWorkFlowDefine.size(); ++i) {
                    PfWorkFlowDefineVo wfd = (PfWorkFlowDefineVo)lstWorkFlowDefine.get(i);
                    String categoryKey = wfd.getBusinessId();
                    String createUrl = wfd.getCreateUrl() == null ? "" : wfd.getCreateUrl();
                    wfd.setCreateUrl(AppConfig.getPlaceholderValue((String)createUrl));
                    if (workflowDefineMap.get(categoryKey) != null) {
                        ((List)workflowDefineMap.get(categoryKey)).add(wfd);
                        continue;
                    }
                    ArrayList wfdList = Lists.newArrayList();
                    wfdList.add(wfd);
                    workflowDefineMap.put(categoryKey, wfdList);
                }
            }
            for (i = 0; i < groupTmpList.size(); ++i) {
                String busiIds = ((PfBusinessGroup)groupTmpList.get(i)).getBusinessIds();
                if (!StringUtils.isNotBlank((String)busiIds)) continue;
                LinkedHashMap tmpWdMap = new LinkedHashMap();
                HashMap relMap = (HashMap)JSON.parseObject((String)busiIds, HashMap.class);
                for (Map.Entry entry : relMap.entrySet()) {
                    String key = (String)entry.getKey();
                    if (!workflowDefineMap.containsKey(key)) continue;
                    tmpWdMap.put(((PfWorkFlowDefineVo)((List)workflowDefineMap.get(key)).get(0)).getBusinessVo().getBusinessName(), workflowDefineMap.get(key));
                }
                if (tmpWdMap == null || tmpWdMap.keySet().size() <= 0) continue;
                PfBusinessGroup group = (PfBusinessGroup)groupTmpList.get(i);
                group.setWorkflowDefineMap(tmpWdMap);
                businessGroupList.add(group);
            }
        }
        return businessGroupList;
    }

    @Transactional
    public void updateDetail(PfBusinessGroup businessGroup) {
        PfBusinessGroup tmpBs;
        if (businessGroup != null && StringUtils.isNotBlank((String)businessGroup.getBusinessGroupId()) && (tmpBs = (PfBusinessGroup)this.findById((Object)businessGroup.getBusinessGroupId())) != null) {
            tmpBs.setBusinessGroupName(businessGroup.getBusinessGroupName());
            tmpBs.setBusinessGroupNo(businessGroup.getBusinessGroupNo());
            this.baseDao.update((Object)tmpBs);
        }
    }

    @Transactional
    public void updateBusinessIds(String groupId, List<ZtreeChanged> changeList) {
        PfBusinessGroup group;
        if (changeList != null && changeList.size() > 0 && StringUtils.isNotBlank((String)groupId) && (group = (PfBusinessGroup)this.findById((Object)groupId)) != null) {
            HashMap busiMap = new HashMap();
            String busiIds = group.getBusinessIds();
            if (StringUtils.isNotBlank((String)busiIds)) {
                busiMap = (HashMap)JSON.parseObject((String)busiIds, HashMap.class);
            }
            ArrayList busiMapList = new ArrayList();
            for (int i = 0; i < changeList.size(); ++i) {
                ZtreeChanged change = changeList.get(i);
                if (change.isChecked()) {
                    busiMap.put(change.getId(), change.getName());
                    continue;
                }
                busiMap.remove(change.getId());
            }
            group.setBusinessIds(JSON.toJSONString((Object)busiMap));
            this.baseDao.update((Object)group);
        }
    }

    private Ztree toZtreeByGroup(PfBusinessGroup group) {
        Ztree tree = new Ztree();
        tree.setId(group.getBusinessGroupId());
        tree.setName(group.getBusinessGroupName());
        tree.setIcon(RequestUtils.initOptProperties((String)(AppConfig.getProperty((String)"portal.url") + "/static/images/flow.gif")));
        return tree;
    }
}

