/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.portal.service.impl;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.portal.entity.PfAuthorize;
import com.gtis.portal.entity.PfMenu;
import com.gtis.portal.entity.PfResourcePartition;
import com.gtis.portal.entity.PfRole;
import com.gtis.portal.model.ZtreeChanged;
import com.gtis.portal.service.PfAuthorizeService;
import com.gtis.portal.service.PfMenuService;
import com.gtis.portal.service.PfResourcePartitionService;
import com.gtis.portal.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PfAuthorizeServiceImpl
extends BaseServiceImpl<PfAuthorize, String>
implements PfAuthorizeService {
    @Autowired
    PfResourcePartitionService resourcePartitionService;
    @Autowired
    PfMenuService menuService;

    public List<PfAuthorize> getAuthPartListByRoleId(String roleId, String menuId) {
        PfMenu menu;
        if (StringUtils.isNotBlank((String)roleId) && StringUtils.isNotBlank((String)menuId) && (menu = (PfMenu)this.menuService.findById((Object)menuId)) != null && StringUtils.isNotBlank((String)menu.getResourceId())) {
            String jpql = "select t from PfAuthorize t,PfResourcePartition t1 where t1.partitionId=t.authorizeObjId and t.undertakerId=?0 and t1.resourceId=?1 and t.authorizeObjType=0";
            return this.baseDao.getByJpql(jpql, new Object[]{roleId, menu.getResourceId()});
        }
        return null;
    }

    public PfAuthorize getAuthorizeByRoleMenuId(String roleId, String menuId) {
        if (StringUtils.isNotBlank((String)roleId) && StringUtils.isNotBlank((String)menuId)) {
            String jpql = "select t from PfAuthorize t where t.undertakerId=?0 and t.authorizeObjId=?1 and t.authorizeObjType=1 and rownum=1";
            return (PfAuthorize)this.baseDao.getUniqueResultByJpql(jpql, new Object[]{roleId, menuId});
        }
        return null;
    }

    public boolean checkHasAuthRoleMenu(String roleId, String menuId) {
        PfAuthorize obj;
        return StringUtils.isNotBlank((String)roleId) && StringUtils.isNotBlank((String)menuId) && (obj = this.getAuthorizeByRoleMenuId(roleId, menuId)) != null && StringUtils.isNotBlank((String)obj.getAuthorizeId());
    }

    public List<PfRole> getAuthorizeRoleListByMenuId(String menuId) {
        String jpql = "select distinct t1 from PfRole t1,PfAuthorize t  where t.undertakerId=t1.roleId and t.authorizeObjId=?0 and t.menuVisible>0 order by t1.roleNo";
        return this.baseDao.getByJpql(jpql, new Object[]{menuId});
    }

    public PfAuthorize getAuthorizeListByParam(String wdid, String roleId, String resourceId) {
        if (StringUtils.isNotBlank((String)wdid) && StringUtils.isNotBlank((String)roleId) && StringUtils.isNotBlank((String)resourceId)) {
            String jpql = "select t from PfAuthorize t where t.workflowDefinitionId=?0 and  t.roleId=?1 and  t.resourceId=?2";
            return (PfAuthorize)this.baseDao.getUniqueResultByJpql(jpql, new Object[]{wdid, roleId, resourceId});
        }
        return null;
    }

    public boolean checkHasAuth(String undertakerId, String authorizeObjId, Integer authorizeObjType) {
        String jpql;
        PfAuthorize obj;
        return StringUtils.isNotBlank((String)undertakerId) && StringUtils.isNotBlank((String)authorizeObjId) && authorizeObjId != null && (obj = (PfAuthorize)this.baseDao.getUniqueResultByJpql(jpql = "select t from PfAuthorize t where t.undertakerId=?0 and  t.authorizeObjId=?1 and t.authorizeObjType=?2 and rownum=1", new Object[]{undertakerId, authorizeObjId, authorizeObjType})) != null && StringUtils.isNotBlank((String)obj.getAuthorizeId());
    }

    public List<ZtreeChanged> getAuthorizeRoleTreeListByMenuId(String menuId) {
        List roleList = this.getAuthorizeRoleListByMenuId(menuId);
        ArrayList<ZtreeChanged> treeList = new ArrayList<ZtreeChanged>();
        if (roleList != null && roleList.size() > 0) {
            for (int i = 0; i < roleList.size(); ++i) {
                ZtreeChanged tree = this.toZtreeByRole((PfRole)roleList.get(i));
                treeList.add(tree);
            }
        }
        return treeList;
    }

    @Transactional
    public void updateRoleMenuVisible(String roleId, String menuId, Integer menuVisible) {
        if (StringUtils.isNotBlank((String)roleId) && StringUtils.isNotBlank((String)menuId) && menuVisible != null) {
            String jpql = "update from PfAuthorize t set t.menuVisible=?0 where t.undertakerId=?1 and t.authorizeObjId=?2 and t.authorizeObjType=1 ";
            this.baseDao.executeJpql(jpql, new Object[]{menuVisible, roleId, menuId});
        }
    }

    @Transactional
    public void updateMenuRoleRel(String menuId, List<ZtreeChanged> changeList) {
        if (changeList != null && changeList.size() > 0 && StringUtils.isNotBlank((String)menuId)) {
            for (int i = 0; i < changeList.size(); ++i) {
                ZtreeChanged change = changeList.get(i);
                Integer visible = change.isChecked() ? 1 : 0;
                boolean hasRole = this.checkHasAuthRoleMenu(change.getId(), menuId);
                if (!hasRole) {
                    PfAuthorize authorize = new PfAuthorize();
                    authorize.setAuthorizeId(UUIDGenerator.generate18());
                    authorize.setAuthorizeObjType(Integer.valueOf(1));
                    authorize.setUndertakerId(change.getId());
                    authorize.setAuthorizeObjId(menuId);
                    authorize.setMenuVisible(visible);
                    this.insert((Object)authorize);
                    continue;
                }
                this.updateRoleMenuVisible(change.getId(), menuId, visible);
            }
        }
    }

    @Transactional
    public void updateMenuRoleAuthorizePart(String roleId, String menuId, Integer operateType) {
        if (StringUtils.isNotBlank((String)roleId) && StringUtils.isNotBlank((String)menuId) && operateType != null) {
            String jpql = "update from PfAuthorize t set t.operateType=?0 where t.undertakerId=?1 and t.authorizeObjId=?2 and t.authorizeObjType=0";
            this.baseDao.executeJpql(jpql, new Object[]{operateType, roleId, menuId});
        }
    }

    @Transactional
    public void updatePartOperType(String menuId, String roleId, List<ZtreeChanged> changeList) {
        PfMenu menu;
        if (changeList != null && changeList.size() > 0 && StringUtils.isNotBlank((String)menuId) && StringUtils.isNotBlank((String)roleId) && (menu = (PfMenu)this.menuService.findById((Object)menuId)) != null && StringUtils.isNotBlank((String)menu.getResourceId())) {
            for (int i = 0; i < changeList.size(); ++i) {
                ZtreeChanged change = changeList.get(i);
                if (!StringUtils.isNotBlank((String)change.getName())) continue;
                Integer operateType = Integer.parseInt(StringUtils.trim((String)change.getName()));
                boolean hasRole = this.checkHasAuthRoleMenu(change.getId(), menuId);
                if (!hasRole) {
                    PfAuthorize authorize = new PfAuthorize();
                    authorize.setAuthorizeId(UUIDGenerator.generate18());
                    authorize.setAuthorizeObjType(Integer.valueOf(0));
                    authorize.setUndertakerId(roleId);
                    authorize.setAuthorizeObjId(change.getId());
                    authorize.setOperateType(operateType);
                    this.insert((Object)authorize);
                    continue;
                }
                this.updateMenuRoleAuthorizePart(roleId, menuId, operateType);
            }
        }
    }

    @Transactional
    public void deleteAuthorizeListByRole(String roleId) {
        if (StringUtils.isNotBlank((String)roleId)) {
            String jpql = "delete from PfAuthorize t where t.undertakerId=?0";
            this.baseDao.executeJpql(jpql, new Object[]{roleId});
        }
    }

    @Transactional
    public void deleteAuthorizeListByMenu(String menuId) {
        PfMenu menu;
        if (StringUtils.isNotBlank((String)menuId) && (menu = (PfMenu)this.menuService.findById((Object)menuId)) != null && StringUtils.isNotBlank((String)menu.getResourceId())) {
            this.deleteAuthorizeListByResource(menu.getResourceId());
            String jpql = "delete from PfAuthorize t where t.authorizeObjId=?0 and t.authorizeObjType=1";
            this.baseDao.executeJpql(jpql, new Object[]{menuId});
        }
    }

    @Transactional
    public void deleteAuthorizeListByResource(String resourceId) {
        List partList;
        if (StringUtils.isNotBlank((String)resourceId) && (partList = this.resourcePartitionService.getListByRid(resourceId)) != null && partList.size() > 0) {
            ArrayList<String> idList = new ArrayList<String>();
            for (int i = 0; i < partList.size(); ++i) {
                idList.add(((PfResourcePartition)partList.get(i)).getPartitionId());
            }
            if (idList.size() > 0) {
                String jpql = "delete from PfAuthorize t where t.authorizeObjId in ?0 and t.authorizeObjType=0";
                this.baseDao.executeJpql(jpql, new Object[]{idList});
            }
        }
    }

    @Transactional
    public void deleteAuthorizeListByPartitionId(String partitionId) {
        if (StringUtils.isNotBlank((String)partitionId)) {
            String jpql = "delete from PfAuthorize t where t.authorizeObjId = ?0 and t.authorizeObjType=0";
            this.baseDao.executeJpql(jpql, new Object[]{partitionId});
        }
    }

    private ZtreeChanged toZtreeByRole(PfRole role) {
        ZtreeChanged tree = new ZtreeChanged();
        tree.setId(role.getRoleId());
        tree.setName(role.getRoleName());
        return tree;
    }
}

