package com.gtis.portal.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.gtis.common.util.ByteObjectAccess;
import com.gtis.common.util.CommonUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.*;
import com.gtis.plat.vo.*;
import com.gtis.plat.wf.WorkFlowException;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.portal.entity.*;
import com.gtis.portal.service.*;
import com.gtis.portal.util.*;
import com.gtis.web.SessionUtil;
import com.gtis.web.SplitParamImpl;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 任务中心
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2015/1/8
 */
@Controller
@RequestMapping("/taskCenter")
public class TaskCenterController extends BaseController {
    @Autowired
    SysWorkFlowDefineService sysWorkFlowDefineService;
    @Autowired
    WorkFlowCoreService workFlowCoreService;
    @Autowired
    SysWorkFlowInstanceService sysWorkFlowInstanceService;
    @Autowired
    SysDynamicSignService sysDynamicSignService;
    @Autowired
    SysCalendarService sysCalendarService;
    @Autowired
    SysTaskService sysTaskService;
    @Autowired
    SysAuthorService sysAuthorService;
    @Autowired
    SysMenuService sysMenuService;
    @Autowired
    IndexService indexService;
    @Autowired
    PfWorkflowDefinitionService workflowDefinitionService;
    @Autowired
    PfBusinessGroupService businessGroupService;
    @Autowired
    SysWorkFlowInstanceRelService workFlowInstanceRelService;
    @Autowired
    WorkflowAutoTurnService workflowAutoTurnService;
    @Autowired
    PfResourceService resourceService;
    @Autowired
    SysWorkFlowPostService sysWorkFlowPostService;
    @Autowired
    PfWorkflowInstanceService pfWorkflowInstanceService;
    @Resource
    @Qualifier("nodeService")
    NodeService nodeService;
    @Autowired
    PfSjdService pfSjdService;
    @Autowired
    PfDistrictService districtService;
    @Autowired
    PfUserService pfUserService;

    @RequestMapping("index")
    public String taskCenter(Model model,@RequestParam(value = "rid", required = false) String rid,HttpServletRequest req) throws Exception {
        pfWorkflowInstanceService.initWorkflowInstanceName(false);
        //显示自动转发功能，#任务列表是否增加批量转发功能，针对特定节点、特定人员的转发
        model.addAttribute("autoTurnTask",AppConfig.getProperty("portal.tasklist.autoTurnTask"));
        String taskState = req.getParameter("taskState");
        model.addAttribute("taskState",taskState);
        //如果没有传递资源id，则自动获取任务中心的资源id
        if (StringUtils.isBlank(rid)){
            List<PfResource> resourceList = resourceService.getResourceListByUrl("taskCenter/index");
            if (resourceList != null && resourceList.size() > 0){
                rid = resourceList.get(0).getResourceId();
            }
        }
        model.addAttribute("rid",rid);
        if (StringUtils.isNotBlank(rid) && rid.startsWith("r:")){
            rid = rid.replace("r:","");
        }
        UserInfo userInfo = SessionUtil.getCurrentUser();
        List<PfOrganVo> organList = userInfo.getLstOragn();
        Map<String,List<PfWorkFlowDefineVo>> mapWorkFlowDefine = workflowDefinitionService.getWorkFlowDefineMap(userInfo,rid);
        model.addAttribute("workFlowDefineMap",mapWorkFlowDefine);

        String createType = req.getParameter("createType");
        if(StringUtils.isBlank(createType)){
            createType = AppConfig.getProperty("portal.taskcenter.createtask.type");
        }

        model.addAttribute("createType",createType);
        if (StringUtils.isNotBlank(createType) && StringUtils.equalsIgnoreCase(createType,"group")){
            List<PfBusinessGroup> businessGroupList = businessGroupService.getBusinessGroupListByRole(userInfo,rid);
            if (businessGroupList == null){
                businessGroupList = new ArrayList<PfBusinessGroup>();
            }
            model.addAttribute("businessGroupList",businessGroupList);
        }

        List<PfBusinessVo> businessVoList= sysWorkFlowDefineService.getBusinessList();
        if (businessVoList != null && businessVoList.size() > 0) {
            for (int i = 0; i < businessVoList.size(); i++) {
                List tmpList = mapWorkFlowDefine.get(businessVoList.get(i).getBusinessName());
                if (tmpList == null || tmpList.size() < 1) {
                    businessVoList.remove(i);
                    i--;
                }
            }
        }
        model.addAttribute("businessList",businessVoList!=null?businessVoList:Lists.newArrayList());

        boolean hasDel=false;
        boolean hasRestart = false;
        StringBuffer bufferWdids = new StringBuffer("''");
        if (SessionUtil.getCurrentUser().isAdmin()) {
            hasDel=true;
            hasRestart = true;
            bufferWdids = new StringBuffer("");
        }else{
            String roles = SessionUtil.getCurrentUser().getRoleIds();
            List<PfPartitionInfoVo> lstfPartitions=sysAuthorService.getSystemResrouceFunAuthorList(roles,rid);
            if (lstfPartitions!=null){
                for (PfPartitionInfoVo partitionInfoVo:lstfPartitions){
                    if (partitionInfoVo.getElementName().endsWith("删除")
                            || partitionInfoVo.getElementName().equalsIgnoreCase("del")){
                        hasDel=true;
                        break;
                    }
                }
                for (PfPartitionInfoVo partitionInfoVo:lstfPartitions){
                    if (partitionInfoVo.getElementName().endsWith("重办")
                            || partitionInfoVo.getElementName().equalsIgnoreCase("restart")){
                        hasRestart=true;
                        break;
                    }
                }
            }
            List<String> listWdids=sysMenuService.getProjectWorkFlowDefineIds(roles);
            if (listWdids!=null){
                for(int index = 0; index < listWdids.size(); index ++){
                    bufferWdids.append(",");
                    bufferWdids.append("'" + listWdids.get(index) + "'");
                }
            }
            model.addAttribute("excludeWdids",bufferWdids.toString());
        }

        model.addAttribute("hasDel",hasDel);
        model.addAttribute("hasRestart",hasRestart);

        SplitParamImpl splitParam1=new SplitParamImpl();
        splitParam1.setQueryString("getTaskList");
        HashMap mapParam=Maps.newHashMap();

        /**
         *paramStr参数指的是后台一些定制化的参数处理：比如：
         * 1、默认加载某个业务，这就需要传递一个业务id，这时候，前台页面中的新建任务就会隐藏掉其他的新建任务，并且任务列表默认加载当前业务数据：paramStr={"BUSINESS_ID":"1546CB36EAE549B5AD960FEAF402E11A"}
         * 2、只需要打开待办任务或者已办任务、项目列表的时候，也就是页面只加载某一个列表，这个时候，需要隐藏其他列表，并且隐藏新建任务栏，相当于一个台账页面，这就需要传递对应选项卡的id：paramStr={"taskTabId":"taskOverListTab"}
         */
        String paramStr = req.getParameter("paramStr");
        if (StringUtils.isNotBlank(paramStr)){
            paramStr = java.net.URLDecoder.decode(paramStr,"utf-8");
            mapParam.putAll(JSON.parseObject(paramStr,HashMap.class));
        }

        if (StringUtils.isNotBlank(taskState)){
            mapParam.put("TASK_STATE",taskState);
        }
        String initLastYear = AppConfig.getProperty("portal.taskcenter.data.init.lastyear");
        if (StringUtils.equalsIgnoreCase(initLastYear,"true")){
            mapParam.put("BEGIN_TIME",CalendarUtil.getPreviousYearFirst());
        }
        mapParam.put("userIds",SessionUtil.getCurrentUserId().equals("0") ? null:SessionUtil.getCurrentUserIds());
        //设置定义排序
        if (StringUtils.isNotBlank(AppConfig.getProperty("tasklisk.orderfield")))
            mapParam.put("_orderfield_",AppConfig.getProperty("tasklisk.orderfield"));
        splitParam1.setQueryParam(mapParam);
        model.addAttribute("taskList", ByteObjectAccess.objectToString(splitParam1));

        mapParam.put("_orderfield_","");

        String canQueryTransUsers = AppConfig.getProperty("platform.taskoverlist.query.transusers");
        model.addAttribute("canQueryTransUsers",canQueryTransUsers);
        String querySql = "getTaskOverList";
        if (StringUtils.equalsIgnoreCase("true",canQueryTransUsers)){
            querySql = "getTaskOverList_TransUsers";
        }
        splitParam1.setQueryString(querySql);
        model.addAttribute("taskOverList",ByteObjectAccess.objectToString(splitParam1));

        //如果当前人员不是管理员，则获取当前人员所属部门的行政区代码组合
        if (!SessionUtil.getCurrentUser().isAdmin() && !SessionUtil.getCurrentUser().hasRole("系统管理员")){
            //获取当前人员所属部门的行政区代码
            if (organList != null && organList.size() > 0){
                String regionCodes = "''";
                HashMap<String,String> regionMap = new HashMap<String, String>();
                for (int i = 0; i < organList.size(); i++) {
                    regionMap.put(organList.get(i).getRegionCode(),organList.get(i).getRegionCode());
                }

                boolean viewRegion = false;
                String region = "";
                for(Map.Entry<String,String> entry : regionMap.entrySet()){
                    regionCodes += ",'"+entry.getKey()+"'";
                    if (StringUtils.equals(entry.getKey(),AppConfig.getProperty("portal.regioncode"))){
                        viewRegion = true;
                        region = entry.getKey();
                    }
                }
                if (viewRegion){
                    if (StringUtils.length(region) == 6){
                        region = StringUtils.removeEnd(region,"0000");
                        region = StringUtils.removeEnd(region,"00");
                    }
                    mapParam.put("REGION_CODE",region);
                }else {
                    mapParam.put("REGION_CODES",regionCodes);
                }
            }
        }

        //项目列表（按照工作流实例权限来展示数据）
        mapParam.put("userIds",null);
        mapParam.put("wdids",bufferWdids.toString());
        splitParam1.setQueryString("getProjectList");
        model.addAttribute("projectList",ByteObjectAccess.objectToString(splitParam1));

        //参与的项目列表（按照人员参与过的项目展示）
        mapParam.put("wdids",null);
        mapParam.put("USER_ID",SessionUtil.getCurrentUserId());
        mapParam.put("REGION_CODES",null);
        splitParam1.setQueryParam(mapParam);
        splitParam1.setQueryString("getProjectListByPerformer");
        model.addAttribute("projectPerformerList",ByteObjectAccess.objectToString(splitParam1));

        model.addAttribute("currentDate",CommonUtil.getCurrTime());

        PfOrganVo organ = new PfOrganVo();
        if(organList!=null&&organList.size()>0)
            organ = organList.get(0);

        model.addAttribute("curOrgan",organ);

        //是否显示转发、退回按钮
        String hideTurnBtn = AppConfig.getProperty("portal.taskcenter.hide.turnbtn");
        boolean isShowTurnBtn = true;
        if (StringUtils.equalsIgnoreCase("true",hideTurnBtn) && !SessionUtil.getCurrentUser().isAdmin()){
            isShowTurnBtn = false;
        }
        model.addAttribute("isShowTurnBtn",isShowTurnBtn);

        //是否显示暂停、取消暂停按钮
        String hidePostBtn = AppConfig.getProperty("portal.taskcenter.hide.postbtn");
        boolean isShowPostBtn = true;
        if (StringUtils.equalsIgnoreCase("true",hidePostBtn) && !SessionUtil.getCurrentUser().isAdmin()){
            isShowPostBtn = false;
        }
        model.addAttribute("isShowPostBtn",isShowPostBtn);

        //是否显示工作流退件、终止按钮
        String showOverBtn = AppConfig.getProperty("portal.taskcenter.show.overbtn");
        boolean isShowOverBtn = false;
        if (StringUtils.equalsIgnoreCase("true",showOverBtn) || SessionUtil.getCurrentUser().isAdmin()){
            isShowOverBtn = true;
        }
        model.addAttribute("isShowOverBtn",isShowOverBtn);

        //是否显示删除按钮
        String hideDelBtn = AppConfig.getProperty("portal.taskcenter.hide.delbtn");
        boolean isShowDelBtn = true;
        if (StringUtils.equalsIgnoreCase("true",hideDelBtn) && !SessionUtil.getCurrentUser().isAdmin()){
            isShowDelBtn = false;
        }
        model.addAttribute("isShowDelBtn",isShowDelBtn);

        model.addAttribute("hideTabPerformer",AppConfig.getProperty("portal.taskcenter.tab.hide.performer.project"));

        String hideTabProject = AppConfig.getProperty("portal.taskcenter.tab.hide.project");
        if (SessionUtil.getCurrentUser().isAdmin()){
            hideTabProject = "false";
        }
        model.addAttribute("hideTabProject",hideTabProject);

        model.addAttribute("mapParam",mapParam);

        initIndex(model);

        return returnPage("/task/task-center");
    }

    @RequestMapping("index/{version}")
    public String versionIndex(Model model,@RequestParam(value = "rid", required = false) String rid,HttpServletRequest req,@PathVariable("version") String version) throws Exception {
        String turnPage = taskCenter(model,rid,req);
        if (CommonUtils.checkHasTaskCenterVersion(version)){
            return "/task/"+version+"/task-center";
        }
        return turnPage;
    }
    public void initIndex(Model model) {
        UserInfo userInfo = SessionUtil.getCurrentUser();
        PfUser pfUser = pfUserService.findById(userInfo.getId());
        model.addAttribute("userName",SessionUtil.getCurrentUser().getUsername());
        model.addAttribute("userId",pfUser.getUserId());
        model.addAttribute("loginName",pfUser.getLoginName());
        List<PfOrganVo> organList = userInfo.getLstOragn();
        PfOrganVo organ = new PfOrganVo();
        if(organList!=null&&organList.size()>0) {
            organ = organList.get(0);
        }

        model.addAttribute("organ",organ);
        model.addAttribute("organName",organ.getOrganName());
        model.addAttribute("regionCode",organ.getRegionCode());
        model.addAttribute("organList",organList);

        String defaultDistrictCode = AppConfig.getProperty("district.code");
        List districtList = districtService.getAllDistrictList(defaultDistrictCode);
        model.addAttribute("districtList",districtList);
        model.addAttribute("districtNoZreoList",districtService.getAllDistrictList(defaultDistrictCode,true));
        model.addAttribute("districtMap",JSON.toJSONString(districtService.getDistrictList(defaultDistrictCode)));
    }
    /**
     * 获取所有工作流定义信息
     * @param wdid
     * @return
     */
    @RequestMapping("workflowDefinition")
    @ResponseBody
    public Object getWorkflowDefinition(@RequestParam String wdid){
        Map workflowDefinitionMap = Maps.newHashMap();
        PfWorkFlowDefineVo pfWorkFlowDefineVo = null;
        if(StringUtils.isNotBlank(wdid)){
            pfWorkFlowDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(wdid);
        }
        if (pfWorkFlowDefineVo != null){
            WorkFlowXml xmlDao = WorkFlowXmlUtil.getDefineModel(pfWorkFlowDefineVo);
            //直接创建工作流任务，不用弹出新建页面
            String directCreateTask = xmlDao.getExtendedAttribute("DirectCreateTask")+"";
            workflowDefinitionMap.put("directCreateTask",directCreateTask);
            //该属性表示，新建任务后弹出的待办任务办理界面，关闭时是否提示用户是否保存该流程，选择取消则删掉流程，该配置一般配合上面的直接创建任务的功能一起使用
            //因为如果直接创建，会导致冗余任务，因此通过这个参数提示用户，是否确认保留这个任务
            workflowDefinitionMap.put("createTaskAlertSave",xmlDao.getExtendedAttribute("CreateTaskAlertSave")+"");
        }
        workflowDefinitionMap.put("workflowDefine",pfWorkFlowDefineVo);
        workflowDefinitionMap.put("username",SessionUtil.getCurrentUser().getUsername());
        workflowDefinitionMap.put("createTime", CommonUtil.getCurrStrDate());
        workflowDefinitionMap.put("instanceName", pfWorkflowInstanceService.getWorkflowInstanceDefaultName(wdid));
        return workflowDefinitionMap;
    }
    /**
     * 创建任务
     * 弹出工作流新建页面
     * @param pfWorkFlowInstanceVo
     * @return
     * @throws Exception
     */
    @RequestMapping("createDefaultTask")
    @ResponseBody
    public Object createTask(PfWorkFlowInstanceVo pfWorkFlowInstanceVo) throws Exception{
        Map result = Maps.newHashMap();
        result.put("success",false);
        String userId = SessionUtil.getCurrentUserId();
        String proId = UUIDGenerator.generate();
        pfWorkFlowInstanceVo.setWorkflowIntanceId(proId);
        pfWorkFlowInstanceVo.setProId(proId);
        pfWorkFlowInstanceVo.setRegionCode(pfWorkFlowInstanceVo.getDistrict());
        String taskId=null;
        try {
            WorkFlowInfo infoObj = workFlowCoreService.createWorkFlowInstance(pfWorkFlowInstanceVo, userId);

            for (PfTaskVo taskVo : infoObj.getTargetTasks()) {
                if (taskVo.getUserVo().getUserId().equals(userId)) {
                    taskId = taskVo.getTaskId();
                    break;
                }
            }
            if (StringUtils.isBlank(taskId)) {
                for (PfTaskVo taskVo : infoObj.getTargetTasks()) {
                    taskId = taskVo.getTaskId();
                    break;
                }
            }
            WorkFlowXml xmlDao = WorkFlowXmlUtil.getInstanceModel(pfWorkFlowInstanceVo);
            //该属性表示，新建任务后弹出的待办任务办理界面，关闭时是否提示用户是否保存该流程，选择取消则删掉流程，该配置一般配合上面的直接创建任务的功能一起使用
            //因为如果直接创建，会导致冗余任务，因此通过这个参数提示用户，是否确认保留这个任务
            result.put("createTaskAlertSave",xmlDao.getExtendedAttribute("CreateTaskAlertSave")+"");
        }catch (Exception e){
            e.printStackTrace();
        }

        result.put("success",true);
        result.put("taskId",taskId);
        return result;
    }
    /**
     * 创建任务
     * 无需弹出工作流新建页面，直接新增流程
     * @param wdid
     * @return
     * @throws Exception
     */
    @RequestMapping("createTask")
    @ResponseBody
    public Object createTask(String wdid) throws Exception{
        Map result = Maps.newHashMap();
        result.put("success",false);
        if(StringUtils.isNotBlank(wdid)){
            PfWorkFlowDefineVo pfWorkFlowDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(wdid);
            String userId = SessionUtil.getCurrentUserId();
            String proId = UUIDGenerator.generate();
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo = new PfWorkFlowInstanceVo();
            String defaultName = pfWorkflowInstanceService.getWorkflowInstanceDefaultName(wdid);
            if (StringUtils.isBlank(defaultName)){
                defaultName = "新建项目" + Calendar.getInstance().getTimeInMillis();
            }
            pfWorkFlowInstanceVo.setWorkflowIntanceName(defaultName);
            pfWorkFlowInstanceVo.setWorkflowDefinitionId(wdid);
            pfWorkFlowInstanceVo.setCreateTime(Calendar.getInstance().getTime());
            pfWorkFlowInstanceVo.setTimeLimit(pfWorkFlowDefineVo.getTimeLimit());
            pfWorkFlowInstanceVo.setPriority("1");
            pfWorkFlowInstanceVo.setCreateUser(SessionUtil.getCurrentUserId());
            pfWorkFlowInstanceVo.setWorkflowIntanceId(proId);
            pfWorkFlowInstanceVo.setProId(proId);
            WorkFlowInfo infoObj = workFlowCoreService.createWorkFlowInstance(
                    pfWorkFlowInstanceVo, userId);
            String taskId=null;
            for (PfTaskVo taskVo : infoObj.getTargetTasks()) {
                if (taskVo.getUserVo().getUserId().equals(userId)) {
                    taskId = taskVo.getTaskId();
                    break;
                }
            }
            if (StringUtils.isBlank(taskId)) {
                for (PfTaskVo taskVo : infoObj.getTargetTasks()) {
                    taskId = taskVo.getTaskId();
                    break;
                }
            }
            WorkFlowXml xmlDao = WorkFlowXmlUtil.getInstanceModel(pfWorkFlowInstanceVo);
            //该属性表示，新建任务后弹出的待办任务办理界面，关闭时是否提示用户是否保存该流程，选择取消则删掉流程，该配置一般配合上面的直接创建任务的功能一起使用
            //因为如果直接创建，会导致冗余任务，因此通过这个参数提示用户，是否确认保留这个任务
            result.put("createTaskAlertSave",xmlDao.getExtendedAttribute("CreateTaskAlertSave")+"");
            result.put("success",true);
            result.put("taskId",taskId);
        }

        return result;
    }
    @RequestMapping("getWorkflowDefinitions")
    @ResponseBody
    public Object getWorkflowDefinitions(String businessId){
        List<PfWorkFlowDefineVo> workFlowDefineVoList = null;
        if(StringUtils.isBlank(businessId))
            workFlowDefineVoList = sysWorkFlowDefineService.getWorkFlowDefineList();
        else
            workFlowDefineVoList = sysWorkFlowDefineService.getWorkFlowDefineByBusiness(businessId);
        return workFlowDefineVoList;
    }

    @RequestMapping("indextask")
    @ResponseBody
    public Object getIndexTaskList(){
        Map result = Maps.newHashMap();
        result.put("success",true);
        result.put("msg","操作成功");
        //获取十条记录，用于综合资讯首页显示，十条记录分为超期和未超期的待办任务，按照紧急程度排序
        //显示规则：超期最多显示7条，剩余的条数用于显示正常的待办任务
        List<HashMap> mapList = indexService.getIndexTaskList();
        if (mapList == null){
            mapList = new ArrayList<HashMap>();
        }
        List<HashMap> dataList = new ArrayList<HashMap>();
        for (int i=0;i<mapList.size();i++){
            HashMap map = mapList.get(i);
            HashMap dataMap = new HashMap();
            dataMap.put("id",MapUtils.getString(map,"ASSIGNMENT_ID"));
//            dataMap.put("img", MapUtils.getString(map,""));
            dataMap.put("url", AppConfig.getProperty("server.url")+"/platform/taskhandle.action?taskid="+MapUtils.getString(map,"ASSIGNMENT_ID"));
            dataMap.put("title", MapUtils.getString(map,"WORKFLOW_INSTANCE_NAME"));
            dataMap.put("date", MapUtils.getString(map,"BEGIN_TIME"));
//            dataMap.put("content", MapUtils.getString(map,""));

            String sfcq = MapUtils.getString(map,"SFCQ");
            if (StringUtils.equals("cqrw",sfcq)){
                dataMap.put("type", "top");
            }else {
                dataMap.put("type", "down");
            }
//            dataMap.put("date", MapUtils.getString(map,""));
            dataList.add(dataMap);
        }
        result.put("data", dataList);
        return result;
    }

    /**
     * @return
     */
    @RequestMapping("relcount")
    @ResponseBody
    public Object getRelCount(@RequestParam String proid){
        Integer count = 0;
        List<PfWorkFlowInstanceVo> list = workFlowInstanceRelService.getWorkFlowRelList(proid);
        if (list != null){
            count = list.size();
        }
        return count;
    }

    @RequestMapping("autoTurn")
    @ResponseBody
    public Object autoTurn(String paramString) throws Exception{
        Map result = Maps.newHashMap();
        result.put("success",false);
        result.put("msg","操作异常！");
        try {
            if (StringUtils.isNotBlank(paramString)){
                paramString = java.net.URLDecoder.decode(paramString,"utf-8");
                JSONArray jsonArray = JSON.parseArray(paramString);
                String userid = SessionUtil.getCurrentUserId();
                if (jsonArray != null && jsonArray.size() > 0){
                    for (int i = 0; i < jsonArray.size(); i++) {
                        JSONObject jsonObject = jsonArray.getJSONObject(i);
                        String proid = MapUtils.getString(jsonObject,"proid");
                        String taskid = MapUtils.getString(jsonObject,"taskid");
                        if (StringUtils.isNotBlank(proid) && StringUtils.isNotBlank(taskid)){
                            System.out.println(proid+"-----"+taskid);
                            workflowAutoTurnService.autoTurnWorkflowByAdId(proid,taskid,userid);
                        }
                    }
                }
            }
            result.put("success",true);
            result.put("msg","操作成功！");
        }catch (Exception e){
            e.printStackTrace();
        }
        return result;
    }

    @RequestMapping("getLockReason")
    @ResponseBody
    public String getLockReason(@RequestParam(value = "taskid", required = false) String taskid, @RequestParam(value = "wiid", required = false) String wiid) {
        String reason = "";
        if (StringUtils.isNotBlank(taskid)) {
            List<PfWorkFlowPostVo> pfWorkFlowPostVoList = sysWorkFlowPostService.getPostByTask(taskid);
            if (pfWorkFlowPostVoList != null && pfWorkFlowPostVoList.size() > 0) {
                for (PfWorkFlowPostVo pfWorkFlowPostVo : pfWorkFlowPostVoList) {
                    if (pfWorkFlowPostVo.getUnPostDate() == null) {
                        reason = pfWorkFlowPostVo.getPostReason();
                        break;
                    }
                }
            }
        }
        if (StringUtils.isNotBlank(wiid)) {
            List<PfWorkFlowPostVo> pfWorkFlowPostVoList = sysWorkFlowPostService.getPostByInstance(wiid);
            if (pfWorkFlowPostVoList != null && pfWorkFlowPostVoList.size() > 0) {
                for (PfWorkFlowPostVo pfWorkFlowPostVo : pfWorkFlowPostVoList) {
                    if (pfWorkFlowPostVo.getUnPostDate() == null) {
                        reason = pfWorkFlowPostVo.getPostReason();
                        break;
                    }
                }
            }
        }
        if (StringUtils.isNotBlank(reason)) {
            try {
                reason = URLEncoder.encode(reason, "UTF-8");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return reason;
    }

    @RequestMapping("getLockInfo")
    @ResponseBody
    public String getLockInfo(@RequestParam(value = "taskid", required = true) String taskid, @RequestParam(value = "wiid", required = true) String wiid) throws Exception{
        String reason = "";
        PfWorkFlowPostVo pfWorkFlowPostVo = null;
        if (StringUtils.isNotBlank(taskid)) {
            List<PfWorkFlowPostVo> pfWorkFlowPostVoList = sysWorkFlowPostService.getPostByTask(taskid);
            if (pfWorkFlowPostVoList != null && pfWorkFlowPostVoList.size() > 0) {
                pfWorkFlowPostVo = pfWorkFlowPostVoList.get(0);
            }
        }
        if (pfWorkFlowPostVo == null){
            if (StringUtils.isNotBlank(wiid)) {
                List<PfWorkFlowPostVo> pfWorkFlowPostVoList = sysWorkFlowPostService.getPostByInstance(wiid);
                if (pfWorkFlowPostVoList != null && pfWorkFlowPostVoList.size() > 0) {
                    pfWorkFlowPostVo = pfWorkFlowPostVoList.get(0);
                }
            }
        }
        return URLEncoder.encode(JSON.toJSONString(pfWorkFlowPostVo), "UTF-8");
    }

    /**
     * 项目列表选择页面
     * @param model
     * @param proid
     * @return
     */
    @RequestMapping("projSelect")
    public String projSelect(Model model,@RequestParam(value = "proid", required = true) String proid){
        model.addAttribute("proid",proid);
        return "/task/project-select";
    }

    /**
     * 已关联项目的分页列表
     * @param proid
     * @param page
     * @param model
     * @return
     */
    @RequestMapping("projRelPage")
    public String projRelPage(String proid, Pageable page,Model model) {
        //page = new PageRequest(page.getPageNumber(), page.getPageSize(), Sort.Direction.DESC, "createTime");
        page = new PageRequest(page.getPageNumber(), page.getPageSize());
        //page = new PageRequest(0,0);
        Page<PfWorkflowInstance> instancePage= pfWorkflowInstanceService.queryPageList(proid, page);
        model.addAttribute("instancePage", instancePage);
        return "/task/project-rel-page-list";
    }


    /**
     * 删除
     * 管理员 或 在首节点,同时也是创建人 可删除工作流;
     * 在首节点，不是创建人,是参与者 可删除所属任务;
     * 在首节点，不是创建人和参与者 或 不在首节点  无法删除
     *
     * @return
     * @throws Exception
     */
    @RequestMapping("del")
    @ResponseBody
    public Object del(String taskid, Model model,HttpServletRequest req,HttpServletResponse response) throws Exception {
        if (StringUtils.isNotBlank(taskid)){
            PfTaskVo taskVo = sysTaskService.getTask(taskid);
            if (taskVo != null){
                switch(permitDel(taskVo,req)){
                    case 0:{
                        delProject(taskVo,req,response);
                        break;
                    }
                    case 1:{
                        delProject(taskVo,req,response);
                        break;
                    }
                    default:{
                    }
                }
            }
        }
        return super.handlerSuccessJson();
    }

    /**
     * 删除工作流
     * @param taskVo
     * @return
     * @throws Exception
     */
    private Object delProject(PfTaskVo taskVo,HttpServletRequest req,HttpServletResponse response) throws Exception {
        PfActivityVo activityVo = sysTaskService.getActivity(taskVo.getActivityId());
        String wiid = activityVo.getWorkflowInstanceId();
        delProject(wiid,wiid,req,response);
        return super.handlerSuccessJson();
    }
    /**
     * 删除项目，项目列表用的
     * @return
     * @throws Exception
     */
    @RequestMapping("delProject")
    @ResponseBody
    public Object delProject(String wiid,String proid,HttpServletRequest req,HttpServletResponse response) throws Exception {
        if (StringUtils.isBlank(proid)){
            proid = wiid;
        }
        if (StringUtils.isNotBlank(wiid)){
            PfWorkFlowInstanceVo workFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(wiid);
            if (workFlowInstanceVo != null){
                try {
                    Space space = nodeService.getWorkSpace(Constants.WORK_FLOW_STUFF);
                    Node tempNode = nodeService.getNode(space.getId(), workFlowInstanceVo.getProId());
                    nodeService.remove(tempNode.getId());
                } catch (Exception e) {
                }
                //删除用户签名
                try {
                    sysDynamicSignService.deleteUserSignByProId(workFlowInstanceVo.getProId());
                } catch (Exception e) {
                }
                //删除收件单
                try {
                    pfSjdService.deleteByProId(workFlowInstanceVo.getProId());
                } catch (Exception e) {
                }
                //删除工作流实例
                try{
                    workFlowCoreService.deleteWorkFlowInstance(SessionUtil.getCurrentUserId(), wiid);
                }catch(WorkFlowException ex){
                    return super.handlerErrorJson();
                }
                return super.handlerSuccessJson();
            }
        }
        return super.handlerErrorJson();
    }
    /**
     * 判断删除情况
     * @param taskVo
     * @return 0 超级用户 或 在首节点,同时也是创建人;1 在首节点，不是创建人;是参与者(参与者只有一人时);2 在首节点，不是创建人;是参与者(参与者有多人时) 3在首节点，不是创建人和参与者 和 该项目不在首节点，无法删除 5 无返回
     */
    private int permitDel(PfTaskVo taskVo,HttpServletRequest req) throws Exception{
        if (SessionUtil.getCurrentUser().isAdmin()) {
            return 0;
        }else {
            String userId = SessionUtil.getCurrentUserId();
            PfActivityVo activityVo = sysTaskService.getActivity(taskVo.getActivityId());
            PfWorkFlowInstanceVo workFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(activityVo.getWorkflowInstanceId());
            WorkFlowXml workXml = WorkFlowXmlUtil.getInstanceModel(workFlowInstanceVo);
            if (workXml.getBeginActivityDefine().equals(activityVo.getActivityDefinitionId())) {
                if(workFlowInstanceVo.getCreateUser().equals(userId)){
                    return 0;
                }else {
                    if(userId.equals(taskVo.getUserVo().getUserId())){
                        int count = sysTaskService.getAllTaskCountByActivityId(activityVo.getActivityId());
                        if(count == 1){
                            return 1;
                        }else {
                            return 2;
                        }
                    }else {
                        return 3;
                    }
                }
            }
        }
        return 5;
    }

    /**
     * 获取所有工作流定义信息
     * @param proid
     * @return
     */
    @RequestMapping("workflowInstance")
    @ResponseBody
    public Object getWorkflowInstance(@RequestParam String proid){
        Map workflowDefinitionMap = Maps.newHashMap();
        PfWorkFlowInstanceVo workFlowInstanceVo = new PfWorkFlowInstanceVo();
        if (StringUtils.isNotBlank(proid)){
            workFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(proid);
        }
        if (workFlowInstanceVo == null){
            workFlowInstanceVo = new PfWorkFlowInstanceVo();
        }
        workflowDefinitionMap.put("workFlowInstanceVo",workFlowInstanceVo);
        return workflowDefinitionMap;
    }


    /**
     * 根据前台传递的批量任务id、理论超时时间来计算剩余多少工作日
     * 返回一个map，key为任务id，value为当前任务的剩余时间、上节点的转发人员
     * @return
     */
    @RequestMapping("calMoreLeftTime")
    @ResponseBody
    public Object calMoreLeftTime(String paramString){
        HashMap taskMap = new HashMap();
        if(StringUtils.isNotBlank(paramString)){
            List<HashMap> mapList = JSON.parseArray(paramString,HashMap.class);
            if (mapList != null && mapList.size() > 0){
                for (int i = 0; i < mapList.size(); i++) {
                    HashMap map = mapList.get(i);
                    String tmpTaskId= MapUtils.getString(map,"TASKID");

                    //map.put("FORWARDER",initSendUsers(tmpTaskId));
                    if (StringUtils.equals(MapUtils.getString(map,"WORKFLOW_STATE"),"3") ||
                            StringUtils.equals("-1",MapUtils.getString(map,"TIME_LIMIT")) ||
                            StringUtils.equals("-1",MapUtils.getString(map,"WFD_TIME_LIMIT")) ||
                            StringUtils.equals(MapUtils.getString(map,"TASK_OVER_TIME"),"2999-12-31") ||
                            StringUtils.equals(MapUtils.getString(map,"OVER_TIME"),"2999-12-31")){
                        map.put("TIME_LEFT",9999);
                        map.put("WF_TIME_LEFT",9999);
                    }else{
                        map.put("TIME_LEFT",initTimeLeft(MapUtils.getString(map,"TASK_OVER_TIME")));
                        map.put("WF_TIME_LEFT",initTimeLeft(MapUtils.getString(map,"OVER_TIME")));
                    }
                    taskMap.put(tmpTaskId,map);
                }
            }
        }
        //Struts2Utils.renderJson(JSON.toJSONString(taskMap));
        return taskMap;//Action.NONE;
    }

    /**
     * 根据前台传递的批量任务id，计算上节点的转发人员
     * 返回一个map，key为任务id，value为当前任务上节点的转发人员
     * @return
     */
    @RequestMapping("calMoreSendUsers")
    @ResponseBody
    public Object calMoreSendUsers(String paramString){
        HashMap taskMap = new HashMap();
        if(StringUtils.isNotBlank(paramString)){
            List<HashMap> mapList = JSON.parseArray(paramString,HashMap.class);
            if (mapList != null && mapList.size() > 0){
                for (int i = 0; i < mapList.size(); i++) {
                    HashMap map = mapList.get(i);
                    String tmpTaskId= MapUtils.getString(map,"TASKID");
                    map.put("FORWARDER",initSendUsers(tmpTaskId));
                    taskMap.put(tmpTaskId,map);
                }
            }
        }
        //Struts2Utils.renderJson(JSON.toJSONString(taskMap));
        return taskMap;//Action.NONE;
    }
    /**
     * 根据前台传递的批量项目id，计算项目的当前节点状态和剩余时间
     * 返回一个map，key为任务id，value为当前项目的描述信息
     * @return
     */
    @RequestMapping("getMoreActivityNames")
    @ResponseBody
    public Object getMoreActivityNames(String paramString){
        HashMap taskMap = new HashMap();
        if(StringUtils.isNotBlank(paramString)){
            List<HashMap> mapList = JSON.parseArray(paramString,HashMap.class);
            if (mapList != null && mapList.size() > 0){
                for (int i = 0; i < mapList.size(); i++) {
                    HashMap map = mapList.get(i);
                    String wiid= MapUtils.getString(map,"WORKFLOW_INSTANCE_ID");
                    //map.put("ACTIVITY_NAMES",initProjectActivityNames(wiid));
                    if (StringUtils.equals(MapUtils.getString(map,"WORKFLOW_STATE"),"3") ||
                            StringUtils.equals("-1",MapUtils.getString(map,"TIME_LIMIT")) ||
                            StringUtils.equals("-1",MapUtils.getString(map,"WFD_TIME_LIMIT")) ||
                            StringUtils.equals(MapUtils.getString(map,"TASK_OVER_TIME"),"2999-12-31") ||
                            StringUtils.equals(MapUtils.getString(map,"OVER_TIME"),"2999-12-31")){
                        map.put("WF_TIME_LEFT",9999);
                    }else{
                        map.put("WF_TIME_LEFT",initTimeLeft(MapUtils.getString(map,"OVER_TIME")));
                    }
                    taskMap.put(wiid,map);
                }
            }
        }
        //Struts2Utils.renderJson(JSON.toJSONString(taskMap));
        return taskMap;//Action.NONE;
    }

    private int initTimeLeft(String taskOverTime){
        Date overDate = CommonUtil.formateDateToStr(taskOverTime);
        return sysCalendarService.getTimeLeft(overDate);
    }

    private String initSendUsers(String tmpTaskId){
        StringBuffer userNameBuffer=new StringBuffer();
        PfTaskVo taskVo = sysTaskService.getTask(tmpTaskId);
        if (taskVo==null){
            taskVo = sysTaskService.getHistoryTask(tmpTaskId);
        }
        List<PfTaskVo> beforeTasks=sysTaskService.getHistoryTaskByBefore(taskVo);
        if (beforeTasks!=null && beforeTasks.size()>0) {
            int size=0;
            for (PfTaskVo task:beforeTasks) {
                size++;
                userNameBuffer.append(task.getUserVo().getUserName() + " ");
            }
        }else{
            userNameBuffer.append("");
        }
        return userNameBuffer.toString();
    }

    private String initProjectActivityNames(String wiid){
        StringBuffer userNameBuffer=new StringBuffer();
        if (StringUtils.isNotBlank(wiid)) {
            List<PfActivityVo> activityVoList= sysTaskService.getWorkFlowInstanceActivityList(wiid);
            for (int i = 0; i < activityVoList.size(); i++) {
                if (i>0) {
                    userNameBuffer.append(";");
                }
                try {
                    PfActivityVo activityVo = activityVoList.get(i);
                    userNameBuffer.append("["+activityVo.getActivityName());
                    String projectShowTime= AppConfig.getProperty("projectlist.activityName.otherTime.show");
                    if(StringUtils.equals(projectShowTime,"true")) {
                        List<PfTaskVo> taskList = sysTaskService.getTaskListByActivity(activityVo.getActivityId());
                        if (taskList != null && taskList.size() > 0) {
                            PfTaskVo taskVo = taskList.get(0);
                            if (taskVo.getOverTime().compareTo(CalendarUtil.getCurDate()) < 0) {
                                userNameBuffer.append("已超期");
                            } else {
                                long days = CalendarUtil.getDaysByTwoDate(CalendarUtil.getCurDate(), taskVo.getOverTime());
                                userNameBuffer.append("剩余" + days + "天");
                            }
                        }
                    }
                    userNameBuffer.append("]");
                }catch (Exception ex){}
            }
        }
        return userNameBuffer.toString();
    }
}
