package com.gtis.portal.web;

import com.gtis.config.AppConfig;
import com.gtis.plat.service.*;
import com.gtis.plat.vo.*;
import com.gtis.portal.entity.PfBusiness;
import com.gtis.portal.entity.PfUser;
import com.gtis.portal.entity.PfWorkflowDefinition;
import com.gtis.portal.entity.PfWorkflowInstance;
import com.gtis.portal.service.PfBusinessService;
import com.gtis.portal.service.PfUserService;
import com.gtis.portal.service.PfWorkflowDefinitionService;
import com.gtis.portal.service.PfWorkflowInstanceService;
import com.gtis.portal.util.CommonUtils;
import com.gtis.portal.util.SignUitl;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 任务办理中心
 * @author <a href="mailto:zhangxing@gtmap.cn">shenjian</a>
 * @version 1.0, 2015/1/8
 */
@Controller
@RequestMapping("/sms")
public class SmsController extends BaseController{
    @Autowired
    private PfUserService userService;

    @Autowired
    private SysSmsService sysSmsService;

    @Autowired
    PfWorkflowInstanceService workflowInstanceService;
    @Autowired
    PfWorkflowDefinitionService workflowDefinitionService;
    @Autowired
    PfBusinessService businessService;

    @RequestMapping("user")
    public String user(Model model,String userId,HttpServletRequest request) throws Exception {
        if (StringUtils.isNotBlank(userId)){
            PfUser user = userService.findById(userId);
            if (user != null && StringUtils.isNotBlank(user.getMobilePhone())){
                model.addAttribute("phone",user.getMobilePhone());
            }
        }
        String proid = request.getParameter("proid");
        HashMap map = new HashMap();
        if (StringUtils.isNotBlank(proid)){
            PfWorkflowInstance workFlowInstanceVo = workflowInstanceService.findById(proid);
            if (workFlowInstanceVo != null){
                map.put("workflowInstanceName",workFlowInstanceVo.getWorkflowInstanceName());
                PfWorkflowDefinition workflowDefinition = workflowDefinitionService.findById(workFlowInstanceVo.getWorkflowDefinitionId());
                if (workflowDefinition != null){
                    map.put("workflowDefinitionName",workflowDefinition.getWorkflowName());
                    PfBusiness business = businessService.findById(workflowDefinition.getBusinessId());
                    if (business != null){
                        map.put("businessName",business.getBusinessName());
                    }
                }
            }
        }
        String smsMsg = exceptionService.getConfigMsg("sms.workflow.db");
        smsMsg = CommonUtils.freemarkerProcess(map,smsMsg);
        model.addAttribute("content",smsMsg);
        return "/sms/phone";
    }

    @RequestMapping("phone")
    public String phone(Model model,String phone,HttpServletRequest request) throws Exception {
        model.addAttribute("phone",phone);
        String proid = request.getParameter("proid");
        HashMap map = new HashMap();
        if (StringUtils.isNotBlank(proid)){
            PfWorkflowInstance workFlowInstanceVo = workflowInstanceService.findById(proid);
            if (workFlowInstanceVo != null){
                map.put("workflowInstanceName",workFlowInstanceVo.getWorkflowInstanceName());
                PfWorkflowDefinition workflowDefinition = workflowDefinitionService.findById(workFlowInstanceVo.getWorkflowDefinitionId());
                if (workflowDefinition != null){
                    map.put("workflowDefinitionName",workflowDefinition.getWorkflowName());
                    PfBusiness business = businessService.findById(workflowDefinition.getBusinessId());
                    if (business != null){
                        map.put("businessName",business.getBusinessName());
                    }
                }
            }
        }
        String smsMsg = exceptionService.getConfigMsg("sms.workflow.db");
        smsMsg = CommonUtils.freemarkerProcess(map,smsMsg);
        model.addAttribute("content",smsMsg);
        return "/sms/phone";
    }

    @ResponseBody
    @RequestMapping(value = "/send")
    public Object send(Model model,String phone,String content,HttpServletRequest request) throws Exception {
        if (StringUtils.isNotBlank(phone) && StringUtils.isNotBlank(content)){
            content = java.net.URLDecoder.decode(content,"utf-8");
            sysSmsService.sendMsg(null,null,phone,content);
        }else {
            return handlerErrorJson("请填写完整的手机号码和短信内容！");
        }
        return handlerSuccessJson();
    }
}
