package com.gtis.portal.service.impl;

import com.alibaba.fastjson.JSON;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.SysWorkFlowInstanceRelService;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.entity.*;
import com.gtis.portal.service.BaseService;
import com.gtis.portal.service.PfUserService;
import com.gtis.portal.service.PfWorkflowDefinitionService;
import com.gtis.portal.service.PfWorkflowInstanceService;
import com.gtis.portal.util.*;
import com.gtis.web.SessionUtil;
import freemarker.cache.StringTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.io.IOException;
import java.io.StringWriter;
import java.util.*;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import com.mysema.query.types.expr.BooleanExpression;

/**
 * java对象基础操作类
* @文件名 BaseServiceImpl.java
 * @作者 卢向伟
 * @创建日期 2015年12月12日
 * @创建时间 下午2:53:19 
 * @版本号 V 1.0
 */
@Service
public class PfWorkflowInstanceServiceImpl implements PfWorkflowInstanceService {
	@Value("${egov.conf}/portal/workflow_default_name.json")
	private String location;
	@Autowired
	BaseDao baseDao;
	@Autowired
	public SysWorkFlowInstanceRelService workFlowInstanceRelService;
	@Autowired
	private SysWorkFlowDefineService sysWorkFlowDefineService;
	@Autowired
	private PfUserService userService;

	public PfWorkflowInstance findById(String proid){
		if (StringUtils.isNotBlank(proid)){
			return baseDao.getById(PfWorkflowInstance.class,proid);
		}
		return null;
	}

	public Page queryPageList(String proid, @PageableDefault(size = 1)Pageable pageable){
		List<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
		QueryCondition queryCondition;

		QPfWorkflowInstance qPfWorkflowInstance = QPfWorkflowInstance.pfWorkflowInstance;
		BooleanExpression expression=null;
		List<PfWorkFlowInstanceVo> wfList = workFlowInstanceRelService.getWorkFlowRelList(proid);
		if (wfList != null){
			StringBuffer jhlxClause = new StringBuffer();
			jhlxClause.append(" workflowInstanceId in (");
			for (int i = 0; i < wfList.size(); i++) {
				if (wfList.get(i) != null){
					jhlxClause.append("'"+wfList.get(i).getWorkflowIntanceId()+"',");
				}
			}
			jhlxClause.append("'')");
			queryConditions.add(new QueryCondition(jhlxClause.toString()));
		}

		return baseDao.get(PfWorkflowInstance.class,queryConditions,"order by createTime desc",pageable);
	}

	/**
	 * 加载工作流实例创建的时候，默认的工作流名称配置
	 * @param reload
	 */
	public void initWorkflowInstanceName(boolean reload){
		try {
			if (reload){
				CommonUtils.defaultWINameMap = null;
			}
			if (CommonUtils.defaultWINameMap == null || CommonUtils.defaultWINameMap.keySet().size() <=0 ){
				CommonUtils.defaultWINameMap = (Map) CommonUtils.readJsonFile(location);
			}
		}catch (Exception e){
			e.printStackTrace();
		}
	}

	/**
	 * 初始化当前时间点、人员的工作流实例的默认名称
	 * @param wdId
	 */
	public String getWorkflowInstanceDefaultName(String wdId){
		try {
			if (CommonUtils.defaultWINameMap != null && CommonUtils.defaultWINameMap.keySet().size() > 0 ){
				Object obj = CommonUtils.defaultWINameMap.get(wdId);
				if (obj != null){
					Map<String,String> valueMap = (Map<String,String>)obj;
					String wdname = MapUtils.getString(valueMap,"wdname");
					PfWorkFlowDefineVo workFlowDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(wdId);
					String workflowDefineName = workFlowDefineVo != null?workFlowDefineVo.getWorkflowName():"";
					wdname = StringUtils.isBlank(wdname)?workflowDefineName:wdname;
					String custom = MapUtils.getString(valueMap,"custom");
					String defaultName = MapUtils.getString(valueMap,"defaultName");
					String split = MapUtils.getString(valueMap,"split");
					if (StringUtils.isNotBlank(defaultName)){
						//"user+date+wdname+custom+organ",
//						defaultName = StringUtils.replace(defaultName,"user","（"+SessionUtil.getCurrentUser().getUsername()+"）");
//						defaultName = StringUtils.replace(defaultName,"date", CalendarUtil.getCurChinaYMDStrDate());
//						defaultName = StringUtils.replace(defaultName,"wdname", wdname);
//						defaultName = StringUtils.replace(defaultName,"custom", custom);
//						defaultName = StringUtils.replace(defaultName,"organ",SessionUtil.getCurrentUser().getLstOragn().get(0).getOrganName());
//						defaultName = StringUtils.replace(defaultName,"+", split);
//						defaultName = StringUtils.replace(defaultName,"null","");
//						defaultName = StringUtils.replace(defaultName," ","");
//						return defaultName;
						Map m = new HashMap();
						m.put("user", SessionUtil.getCurrentUser().getUsername());
						m.put("date", CalendarUtil.getCurChinaYMDStrDate());
						m.put("wdname", wdname);
						m.put("organ", SessionUtil.getCurrentUser().getLstOragn().get(0).getOrganName());

						//System.out.println(CommonUtils.freemarkerProcess(m, defaultName));
						return CommonUtils.freemarkerProcess(m, defaultName);
					}
				}
			}
		}catch (Exception e){
			e.printStackTrace();
		}
		return "";
	}

	public List<HashMap> getTaskList(HashMap param,Integer rownum){
		try {
			String sql = "select t.* from ( ";
			String tasksql =
					" select t1.ASSIGNMENT_ID,t1.BEGIN_TIME,t1.USER_ID,t2.ACTIVITY_NAME,t2.ACTIVITY_ID,t3.WORKFLOW_INSTANCE_NAME," +
							" t3.CREATE_TIME,t3.WORKFLOW_INSTANCE_ID,t3.WORKFLOW_DEFINITION_ID,t3.create_user" +
							" from PF_ASSIGNMENT t1,PF_ACTIVITY t2,Pf_Workflow_Instance t3 " +
							" where t1.activity_id=t2.activity_id and t2.workflow_instance_id=t3.workflow_instance_id " +
							" and t2.ACTIVITY_STATE=1 and (t3.WORKFLOW_STATE=1 or t3.WORKFLOW_STATE=3) ";
			if (param != null){
				if (param.containsKey("BEGIN_TIME") && StringUtils.isNotBlank(MapUtils.getString(param,"BEGIN_TIME"))){
					tasksql += " and to_char(t1.BEGIN_TIME,'yyyy-MM-dd') >= '"+ MapUtils.getString(param,"BEGIN_TIME")+"' ";
				}
				if (param.containsKey("userIds") && StringUtils.isNotBlank(MapUtils.getString(param,"userIds"))){
					tasksql += " and t1.USER_ID in ("+MapUtils.getString(param,"userIds")+")";
				}
			}
			tasksql += " order by t1.begin_time desc ";
			sql += tasksql + " ) t ";
			if (rownum != null){
				sql += "  where  rownum<= " + rownum;
			}else {
				sql += "  where  rownum<= 12";
			}
//            System.out.println(sql);
			List<HashMap> queryResults = baseDao.getMapBySql(sql);
			return  queryResults;
		}catch (Exception e){
			e.printStackTrace();
		}
		return null;
	}

	public String getTaskCount(HashMap param){
		try {
			String tasksql =
					" select count(*) as TASKSIZE" +
							" from PF_ASSIGNMENT t1,PF_ACTIVITY t2,Pf_Workflow_Instance t3 " +
							" where t1.activity_id=t2.activity_id and t2.workflow_instance_id=t3.workflow_instance_id " +
							" and t2.ACTIVITY_STATE=1 and (t3.WORKFLOW_STATE=1 or t3.WORKFLOW_STATE=3) ";
			if (param != null){
				if (param.containsKey("BEGIN_TIME") && StringUtils.isNotBlank(MapUtils.getString(param,"BEGIN_TIME"))){
					tasksql += " and to_char(t1.BEGIN_TIME,'yyyy-MM-dd') >= '"+ MapUtils.getString(param,"BEGIN_TIME")+"' ";
				}
				if (param.containsKey("userIds") && StringUtils.isNotBlank(MapUtils.getString(param,"userIds"))){
					tasksql += " and t1.USER_ID in ("+MapUtils.getString(param,"userIds")+")";
				}
			}
			Object queryObject = baseDao.getMapObjBySql(tasksql);
			if (queryObject != null){
				return MapUtils.getString((HashMap)queryObject,"TASKSIZE");
			}
		}catch (Exception e){
			e.printStackTrace();
		}
		return null;
	}

	public List<HashMap> getTaskOverList(HashMap param,Integer rownum){
		try {
			String sql = "select t.* from ( ";
			String tasksql =
					" select t1.ASSIGNMENT_ID,t1.BEGIN_TIME,t1.USER_ID,t2.ACTIVITY_NAME,t2.ACTIVITY_ID,t3.WORKFLOW_INSTANCE_NAME," +
							" t3.CREATE_TIME,t3.WORKFLOW_INSTANCE_ID,t3.WORKFLOW_DEFINITION_ID,t3.create_user" +
							" from PF_ASSIGNMENTHISTORY t1,PF_ACTIVITY t2,Pf_Workflow_Instance t3 " +
							" where t1.activity_id=t2.activity_id and t2.workflow_instance_id=t3.workflow_instance_id " +
							" and t1.IS_REPEAT=0 ";
			if (param != null){
				if (param.containsKey("BEGIN_TIME") && StringUtils.isNotBlank(MapUtils.getString(param,"BEGIN_TIME"))){
					tasksql += " and to_char(t1.BEGIN_TIME,'yyyy-MM-dd') >= '"+ MapUtils.getString(param,"BEGIN_TIME")+"' ";
				}
				if (param.containsKey("userIds") && StringUtils.isNotBlank(MapUtils.getString(param,"userIds"))){
					tasksql += " and t1.USER_ID in ("+MapUtils.getString(param,"userIds")+")";
				}
			}
			tasksql += " order by t1.begin_time desc ";
			sql += tasksql + " ) t ";
			if (rownum != null){
				sql += "  where  rownum<= " + rownum;
			}else {
				sql += "  where  rownum<= 12";
			}
			List<HashMap> queryResults = baseDao.getMapBySql(sql);
			return  queryResults;
		}catch (Exception e){
			e.printStackTrace();
		}
		return null;
	}

	public String getTaskOverCount(HashMap param){
		try {
			String tasksql =
					" select count(*) as TASKSIZE" +
							" from PF_ASSIGNMENT t1,PF_ACTIVITY t2,Pf_Workflow_Instance t3 " +
							" where t1.activity_id=t2.activity_id and t2.workflow_instance_id=t3.workflow_instance_id " +
							" and t1.IS_REPEAT=0 ";
			if (param != null){
				if (param.containsKey("BEGIN_TIME") && StringUtils.isNotBlank(MapUtils.getString(param,"BEGIN_TIME"))){
					tasksql += " and to_char(t1.BEGIN_TIME,'yyyy-MM-dd') >= '"+ MapUtils.getString(param,"BEGIN_TIME")+"' ";
				}
				if (param.containsKey("userIds") && StringUtils.isNotBlank(MapUtils.getString(param,"userIds"))){
					tasksql += " and t1.USER_ID in ("+MapUtils.getString(param,"userIds")+")";
				}
			}
			Object queryObject = baseDao.getMapObjBySql(tasksql);
			if (queryObject != null){
				return MapUtils.getString((HashMap)queryObject,"TASKSIZE");
			}
		}catch (Exception e){
			e.printStackTrace();
		}
		return null;
	}
}
