package com.gtis.portal.service.impl;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.portal.entity.*;
import com.gtis.portal.model.Ztree;
import com.gtis.portal.service.*;
import com.gtis.portal.util.CalendarUtil;
import com.gtis.portal.util.Constants;
import com.gtis.portal.util.RequestUtils;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPAQuery;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

@Service
public class PfResourceStatusServiceImpl extends BaseServiceImpl<PfResourceStatus, String> implements PfResourceStatusService {
    @Autowired
    PfRequireFieldService requireFieldService;
    @Autowired
    SysWorkFlowDefineService workFlowDefineService;
    @Autowired
    SysWorkFlowInstanceService workFlowIntanceService;
    @Autowired
    SysTaskService taskService;
    @Autowired
    PfResourceService resourceService;

    /**
     * 根据任务id、资源id、用户id，查找资源点击记录
     * @param taskId
     * @param userId
     * @return
     */
    @Override
    public List<PfResourceStatus> getPfResourceStatusListByCur(String taskId,String userId,String resourceId){
        if (StringUtils.isNotBlank(taskId)){
            QPfResourceStatus qPfResourceStatus = QPfResourceStatus.pfResourceStatus;
            JPQLQuery query = new JPAQuery(em);
            query.from(qPfResourceStatus);
            if (StringUtils.isNotBlank(taskId)){
                query.where(qPfResourceStatus.taskId.eq(taskId));
            }
            if (StringUtils.isNotBlank(userId)){
                query.where(qPfResourceStatus.userId.eq(userId));
            }
            if (StringUtils.isNotBlank(resourceId)){
                query.where(qPfResourceStatus.resourceId.eq(resourceId));
            }
            return query.orderBy(qPfResourceStatus.statusDate.asc()).list(qPfResourceStatus);
        }
        return null;
    }

    /**
     * 更新当前资源点击状态
     * @param resourceStatus
     */
    @Override
    public void refreshStatus(PfResourceStatus resourceStatus){
        if (resourceStatus != null && StringUtils.isNotBlank(resourceStatus.getTaskId()) && StringUtils.isNotBlank(resourceStatus.getResourceId())){
            if (StringUtils.isBlank(resourceStatus.getResourceStatusId())){
                resourceStatus.setResourceStatusId(UUIDGenerator.generate());
            }
            if (resourceStatus.getStatusDate() == null){
                resourceStatus.setStatusDate(CalendarUtil.getCurHMSDate());
            }
            resourceStatus.setResourceStatus(Constants.ResourceStatusEnum.CLICK.getBm());

            List<PfResourceStatus> tmpList = getPfResourceStatusListByCur(resourceStatus.getTaskId(),resourceStatus.getUserId(),resourceStatus.getResourceId());
            if (tmpList != null && !tmpList.isEmpty()){
                resourceStatus = tmpList.get(0);
                resourceStatus.setResourceStatus(Constants.ResourceStatusEnum.CLICK.getBm());
                resourceStatus.setStatusDate(CalendarUtil.getCurHMSDate());
                update(resourceStatus);
            }else {
                insert(resourceStatus);
            }
        }
    }

    /**
     * 根据任务id、资源id、用户id更新当前资源点击状态
     * @param taskId
     * @param resourceId
     * @param userId
     */
    @Override
    public void refreshStatus(String taskId,String resourceId,String userId){
        PfResourceStatus resourceStatus = new PfResourceStatus();
        resourceStatus.setTaskId(taskId);
        resourceStatus.setResourceId(resourceId);
        resourceStatus.setUserId(userId);
        refreshStatus(resourceStatus);
    }

    /**
     * 检查当前流程、任务、人员下，相关资源是否已经点击过，用于核查操作人员是否按规定查看相关信息
     * 1、根据工作流id和任务id查找业务id、流程定义id、节点id
     * 2、根据任务id和人员id查找资源点击记录，转成map，key为资源id
     * 3、根据以上id查找配置表中资源必点列表配置
     * 4、遍历必点资源列表，记录中的资源是用逗号隔开的，因此要再进行分开遍历，之后和第2步的map进行比对，将不在map中的资源存放到集合中
     * 5、遍历没有点击过的资源集合，查找资源信息，主要是获取资源名称，组织提示信息返回
     * @param proid
     * @param taskId
     * @param userId
     * @return
     */
    @Override
    public String checkClickStatus(String proid,String taskId,String userId){
        StringBuffer msg = new StringBuffer("");
        List<String> resourceIdNoClickList = new ArrayList<String>();
        if (StringUtils.isNotBlank(proid) && StringUtils.isNotBlank(taskId)){
            //获取工作流实例，并获取对应的工作流定义模型
            PfWorkFlowInstanceVo workFlowInstanceVo = workFlowIntanceService.getWorkflowInstance(proid);
            PfTaskVo taskVo = taskService.getTask(taskId);
            if (workFlowInstanceVo != null && taskVo != null){
                PfWorkFlowDefineVo workFlowDefineVo = workFlowDefineService.getWorkFlowDefine(workFlowInstanceVo.getWorkflowDefinitionId());
                PfActivityVo activityVo = taskService.getActivity(taskVo.getActivityId());
                String bsId = workFlowDefineVo.getBusinessId();
                String wdId = workFlowInstanceVo.getWorkflowDefinitionId();
                String adId = activityVo.getActivityDefinitionId();

                //查询当前任务下，该人员的资源点击记录
                HashMap<String,String> idMap = new HashMap<String, String>();
                List<PfResourceStatus> resourceStatusList = getPfResourceStatusListByCur(taskId,userId,null);
                if (resourceStatusList != null && !resourceStatusList.isEmpty()){
                    for (int i = 0; i < resourceStatusList.size(); i++) {
                        if (StringUtils.equals(Constants.ResourceStatusEnum.CLICK.getBm(),resourceStatusList.get(i).getResourceStatus())){
                            idMap.put(resourceStatusList.get(i).getResourceId(),resourceStatusList.get(i).getResourceId());
                        }
                    }
                }

                //查询该节点下，资源点击的配置记录，之后与点击记录进行比对，将对应不上的放到定义好的集合中
                PfRequireField requireField = new PfRequireField();
                requireField.setWdId(wdId);
                requireField.setAdId(adId);
                List<PfRequireField> requireList = requireFieldService.getPfRequireResourceList(requireField);
                if (requireList != null && !requireList.isEmpty()){
                    for (int i = 0; i < requireList.size(); i++) {
                        if (StringUtils.isNotBlank(requireList.get(i).getTableName())){
                            String[] idAry = StringUtils.split(requireList.get(i).getTableName(),',');
                            for (int j = 0; j < idAry.length; j++) {
                                if (!idMap.containsKey(idAry[j])){
                                    resourceIdNoClickList.add(idAry[j]);
                                }
                            }
                        }
                    }
                }
            }
        }
        //奖没有点击过的资源id作为参数，查询资源信息，之后根据资源信息组织前台页面返回提示信息
        List<PfResource> resourceNoClickList = resourceService.getResListByResIds(resourceIdNoClickList);
        if (resourceNoClickList != null && !resourceNoClickList.isEmpty()){
            msg.append("流程在当前环节必须进行");
            for (int i = 0; i < resourceNoClickList.size(); i++) {
                msg.append("【"+resourceNoClickList.get(i).getResourceName()+"】");
            }
            msg.append("资源的审查，请检查是否对这些资源进行浏览或审查！");
        }
        return msg.toString();
    }
}

