package com.gtis.portal.service.impl;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.portal.entity.PfRequireField;
import com.gtis.portal.entity.PfResourceStatus;
import com.gtis.portal.entity.QPfRequireField;
import com.gtis.portal.entity.QPfResourceStatus;
import com.gtis.portal.service.PfRequireFieldService;
import com.gtis.portal.service.PfResourceStatusService;
import com.gtis.portal.util.CalendarUtil;
import com.gtis.portal.util.Constants;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPAQuery;
import com.sun.org.apache.regexp.internal.RE;
import com.sun.org.apache.xpath.internal.operations.Mult;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Service
public class PfRequireFieldServiceImpl extends BaseServiceImpl<PfRequireField, String> implements PfRequireFieldService {

    /**
     * 查找必填字段的配置
     * @param requireField
     * @return
     */
    @Override
    public List<PfRequireField> getPfRequireFieldList(PfRequireField requireField){
        List<PfRequireField> list = null;
        if (requireField != null){
            StringBuffer sql = new StringBuffer("");
            sql.append("select t.* from pf_require_field t,pf_require_tablekey t1 ");
            sql.append(" where t.TABLE_NAME=t1.TABLE_NAME and t.BS_ID=t1.BUSINESS_ID ");
            if (StringUtils.isNotBlank(requireField.getBsId())){
                sql.append(" and t.bs_id='"+requireField.getBsId()+"' ");
            }
            if (StringUtils.isNotBlank(requireField.getWdId())){
                sql.append(" and t.wd_id='"+requireField.getWdId()+"' ");
            }
            if (StringUtils.isNotBlank(requireField.getAdId())){
                sql.append(" and t.ad_id='"+requireField.getAdId()+"' ");
            }
            if (StringUtils.isNotBlank(requireField.getTableName())){
                sql.append(" and t.table_name='"+requireField.getTableName()+"' ");
            }
            List<HashMap> mapList= baseDao.getMapBySql(sql.toString());
            if (mapList != null && !mapList.isEmpty()){
                list = new ArrayList<PfRequireField>();
                for (int i = 0; i < mapList.size(); i++) {
                    list.add(map2RequeireField(mapList.get(i)));
                }
            }
        }
        return list;
    }

    /**
     * 查找转发必须点击的资源配置
     * @param requireField
     * @return
     */
    @Override
    public List<PfRequireField> getPfRequireResourceList(PfRequireField requireField){
        List<PfRequireField> list = null;
        if (requireField != null){
            StringBuffer sql = new StringBuffer("");
            sql.append("select t.* from pf_require_field t ");
            sql.append(" left outer join pf_require_tablekey t1 on t.table_name=t1.table_name ");
            sql.append(" where t1.table_name is null ");
            if (StringUtils.isNotBlank(requireField.getBsId())){
                sql.append(" and t.bs_id='"+requireField.getBsId()+"' ");
            }
            if (StringUtils.isNotBlank(requireField.getWdId())){
                sql.append(" and t.wd_id='"+requireField.getWdId()+"' ");
            }
            if (StringUtils.isNotBlank(requireField.getAdId())){
                sql.append(" and t.ad_id='"+requireField.getAdId()+"' ");
            }
            if (StringUtils.isNotBlank(requireField.getTableName())){
                sql.append(" and t.table_name='"+requireField.getTableName()+"' ");
            }
            List<HashMap> mapList= baseDao.getMapBySql(sql.toString());
            if (mapList != null && !mapList.isEmpty()){
                list = new ArrayList<PfRequireField>();
                for (int i = 0; i < mapList.size(); i++) {
                    list.add(map2RequeireField(mapList.get(i)));
                }
            }
        }
        return list;
    }

    private PfRequireField map2RequeireField(HashMap map){
        PfRequireField requireField = new PfRequireField();
        requireField.setReqid(MapUtils.getString(map,"REQID"));
        requireField.setBsId(MapUtils.getString(map,"BS_ID"));
        requireField.setWdId(MapUtils.getString(map,"WD_ID"));
        requireField.setWdName(MapUtils.getString(map,"WD_NAME"));
        requireField.setAdId(MapUtils.getString(map,"AD_ID"));
        requireField.setAdName(MapUtils.getString(map,"AD_NAME"));
        requireField.setTableName(MapUtils.getString(map,"TABLE_NAME"));
        requireField.setFieldName(MapUtils.getString(map,"FIELD_NAME"));
        requireField.setFieldAlias(MapUtils.getString(map,"FIELD_ALIAS"));
        requireField.setSignKey(MapUtils.getString(map,"SIGN_KEY"));
        requireField.setSignKeyAlias(MapUtils.getString(map,"SIGN_KEY_ALIAS"));
        requireField.setSignOptionKey(MapUtils.getString(map,"SIGN_OPTION_KEY"));
        requireField.setSignOptionAlias(MapUtils.getString(map,"SIGN_OPTION_ALIAS"));
        return requireField;
    }

}

