package com.gtis.portal.service;


import com.gtis.portal.entity.PfResource;
import com.gtis.portal.entity.PfResourceStatus;
import com.gtis.portal.model.Ztree;

import java.util.HashMap;
import java.util.List;

public interface PfResourceStatusService extends BaseService<PfResourceStatus, String> {
    public List<PfResourceStatus> getPfResourceStatusListByCur(String taskId,String userId,String resourceId);
    public void refreshStatus(PfResourceStatus resourceStatus);
    public void refreshStatus(String taskId,String resourceId,String userId);
    /**
     * 检查当前流程、任务、人员下，相关资源是否已经点击过，用于核查操作人员是否按规定查看相关信息
     * 1、根据工作流id和任务id查找业务id、流程定义id、节点id
     * 2、根据任务id和人员id查找资源点击记录，转成map，key为资源id
     * 3、根据以上id查找配置表中资源必点列表配置
     * 4、遍历必点资源列表，记录中的资源是用逗号隔开的，因此要再进行分开遍历，之后和第2步的map进行比对，将不在map中的资源存放到集合中
     * 5、遍历没有点击过的资源集合，查找资源信息，主要是获取资源名称，组织提示信息返回
     * @param proid
     * @param taskId
     * @param userId
     * @return
     */
    public String checkClickStatus(String proid,String taskId,String userId);
}
