package com.gtis.portal.entity;

import com.alibaba.fastjson.annotation.JSONField;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Blob;
import java.util.Date;

/**
 * 工作流实例表
 */
@Entity
@Table(name = "PF_WORKFLOW_INSTANCE")
public class PfWorkflowInstance implements Serializable {
    @Id
    @Column
    private String workflowInstanceId;//WORKFLOW_INSTANCE_ID

    @Column
    private String workflowDefinitionId;//WORKFLOW_DEFINITION_ID

    @Column
    private Date createTime;//创建时间

    @Column
    private String remark;//备注

    @Column
    private Integer workflowState;//工作流状态

    @Column
    private String workflowInstanceName;//实例名称

    @Column
    private Date finishTime;//结束时间

    @Column
    private String regionCode;//行政区代码

    @Column
    private String createUser;//创建人

    @Column
    private String district;

    @Column
    private Date overTime;

    @Column
    private String timeLimit;

    @Lob
    @Basic(fetch=FetchType.LAZY)
    @JSONField(serialize = false)
    @Column(name="FLOWCHART", columnDefinition="BLOB", nullable=true)
    private java.sql.Blob flowchart;//流程图对象

    /*@Lob
    @Basic(fetch=FetchType.LAZY)
    @JSONField(serialize = false)
    @Column(name="WORKFLOW_IMAGE", columnDefinition="BLOB", nullable=true)
    private java.sql.Blob workflowImage;//流程图对象*/

    public String getWorkflowInstanceId() {
        return workflowInstanceId;
    }

    public void setWorkflowInstanceId(String workflowInstanceId) {
        this.workflowInstanceId = workflowInstanceId;
    }

    public String getWorkflowDefinitionId() {
        return workflowDefinitionId;
    }

    public void setWorkflowDefinitionId(String workflowDefinitionId) {
        this.workflowDefinitionId = workflowDefinitionId;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Integer getWorkflowState() {
        return workflowState;
    }

    public void setWorkflowState(Integer workflowState) {
        this.workflowState = workflowState;
    }

    public String getWorkflowInstanceName() {
        return workflowInstanceName;
    }

    public void setWorkflowInstanceName(String workflowInstanceName) {
        this.workflowInstanceName = workflowInstanceName;
    }

    public Date getFinishTime() {
        return finishTime;
    }

    public void setFinishTime(Date finishTime) {
        this.finishTime = finishTime;
    }

    public String getRegionCode() {
        return regionCode;
    }

    public void setRegionCode(String regionCode) {
        this.regionCode = regionCode;
    }

    public String getCreateUser() {
        return createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public String getDistrict() {
        return district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public Date getOverTime() {
        return overTime;
    }

    public void setOverTime(Date overTime) {
        this.overTime = overTime;
    }

    public String getTimeLimit() {
        return timeLimit;
    }

    public void setTimeLimit(String timeLimit) {
        this.timeLimit = timeLimit;
    }

    public Blob getFlowchart() {
        return flowchart;
    }

    public void setFlowchart(Blob flowchart) {
        this.flowchart = flowchart;
    }

    /*public Blob getWorkflowImage() {
        return workflowImage;
    }

    public void setWorkflowImage(Blob workflowImage) {
        this.workflowImage = workflowImage;
    }*/
}