-------------------------------------------
-- Export file for user PF_GTIS_JSYD     --
-- Created by ibm on 2016/7/13, 22:35:53 --
-------------------------------------------

spool sub.log

prompt
prompt Creating table PF_SUBSYSTEM
prompt ===========================
prompt
create table PF_SUBSYSTEM
(
  SUBSYSTEM_ID    VARCHAR2(32) not null,
  SUBSYSTEM_NAME  VARCHAR2(50),
  SUBSYSTEM_TITLE VARCHAR2(100),
  ENABLED         NUMBER(1),
  SUB_TYPE        NUMBER(1),
  SUB_NO          NUMBER(4),
  SUB_URL         VARCHAR2(200),
  SUB_MENU_TYPE   VARCHAR2(20)
);
comment on column PF_SUBSYSTEM.SUB_TYPE
  is '主题类型：0菜单还是1超链接';
comment on column PF_SUBSYSTEM.SUB_NO
  is '编号（排序码）';
comment on column PF_SUBSYSTEM.SUB_URL
  is '超链接地址';
comment on column PF_SUBSYSTEM.SUB_MENU_TYPE
  is '菜单风格，two左两级、three三级';
alter table PF_SUBSYSTEM
  add constraint PK_SUBSYSTEM_ID primary key (SUBSYSTEM_ID)
  using index 
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    next 1M
    minextents 1
    maxextents unlimited
  );
alter table PF_SUBSYSTEM
  add constraint UK_SUBSYSTEM_NAME unique (SUBSYSTEM_NAME)
  using index 
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    next 1M
    minextents 1
    maxextents unlimited
  );

prompt
prompt Creating table PF_SUBSYSTEM_MENU_REL
prompt ====================================
prompt
create table PF_SUBSYSTEM_MENU_REL
(
  MENU_ID      VARCHAR2(32) not null,
  SUBSYSTEM_ID VARCHAR2(32) not null
)
;


-- Create table
create table PF_BUSINESS_GROUP
(
  BUSINESS_GROUP_ID   VARCHAR2(32) not null,
  BUSINESS_GROUP_NAME VARCHAR2(200),
  BUSINESS_GROUP_NO   NUMBER(12),
  BUSINESS_IDS        VARCHAR2(2000)
);
-- Add comments to the table
comment on table PF_BUSINESS_GROUP
  is '工作流定义分组';
-- Add comments to the columns
comment on column PF_BUSINESS_GROUP.BUSINESS_GROUP_ID
  is '业务分组';
comment on column PF_BUSINESS_GROUP.BUSINESS_GROUP_NAME
  is '业务分组名称';
comment on column PF_BUSINESS_GROUP.BUSINESS_GROUP_NO
  is '业务分组编号排序用';
comment on column PF_BUSINESS_GROUP.BUSINESS_IDS
  is '业务定义ID';
-- Create/Recreate primary, unique and foreign key constraints
alter table PF_BUSINESS_GROUP
  add constraint PK_WD_GROUP_ID primary key (BUSINESS_GROUP_ID)
  using index
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    next 1M
    minextents 1
    maxextents unlimited
  );


create table PF_RESOURCE_STATUS
(
  RESOURCE_STATUS_ID VARCHAR2(32) not null,
  RESOURCE_ID        VARCHAR2(32) not null,
  RESOURCE_NAME      VARCHAR2(100),
  RESOURCE_STATUS    VARCHAR2(100),
  TASK_ID            VARCHAR2(32) not null,
  USER_ID            VARCHAR2(32),
  STATUS_DATE        DATE
);
-- Add comments to the table
comment on table PF_RESOURCE_STATUS
  is '资源点击状态';
-- Add comments to the columns
comment on column PF_RESOURCE_STATUS.RESOURCE_ID
  is 'RESOURCE_ID';
comment on column PF_RESOURCE_STATUS.RESOURCE_NAME
  is '资源名称';
comment on column PF_RESOURCE_STATUS.RESOURCE_STATUS
  is '资源点击状态';
comment on column PF_RESOURCE_STATUS.TASK_ID
  is '任务id';
comment on column PF_RESOURCE_STATUS.USER_ID
  is '用户id';
comment on column PF_RESOURCE_STATUS.STATUS_DATE
  is '状态发生时间';

-- Add/modify columns 必填字段配置表字段加长
alter table PF_REQUIRE_FIELD modify TABLE_NAME VARCHAR2(2000);
spool off
