/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.common.utils;

import com.alibaba.druid.proxy.jdbc.ClobProxyImpl;
import com.alibaba.fastjson.JSON;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import oracle.sql.CLOB;
import org.apache.commons.lang.StringUtils;

public class MapUtils {
    private static DateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static HashMap<String, Object> getMapFromStr(String paramString) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)paramString)) {
            paramString = URLDecoder.decode(paramString, "UTF-8");
            map.putAll((Map<String, Object>)JSON.parseObject((String)paramString));
        }
        return map;
    }

    public static Object convertMap(Class type, Map map) throws IntrospectionException, IllegalAccessException, InstantiationException, InvocationTargetException, SQLException, IOException {
        BeanInfo beanInfo = Introspector.getBeanInfo(type);
        Object obj = type.newInstance();
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            PropertyDescriptor descriptor = propertyDescriptors[i];
            String propertyName = descriptor.getName().toUpperCase();
            if (!map.containsKey(propertyName)) continue;
            Object value = map.get(propertyName);
            if (value instanceof ClobProxyImpl) {
                value = MapUtils.ClobToString((CLOB)((ClobProxyImpl)value).getRawClob());
            }
            if (value instanceof Timestamp) {
                value = sdf.format((Timestamp)value);
            }
            Object[] args = new Object[]{value};
            descriptor.getWriteMethod().invoke(obj, args);
        }
        return obj;
    }

    public static String ClobToString(CLOB clob) throws SQLException, IOException {
        String reString = "";
        Reader is = clob.getCharacterStream();
        BufferedReader br = new BufferedReader(is);
        String s = br.readLine();
        StringBuffer sb = new StringBuffer();
        while (s != null) {
            sb.append(s);
            s = br.readLine();
        }
        reString = sb.toString();
        return reString;
    }

    public static Object convertBean2Bean(Object from, Object to) {
        try {
            PropertyDescriptor[] ps;
            BeanInfo beanInfo = Introspector.getBeanInfo(to.getClass());
            for (PropertyDescriptor p : ps = beanInfo.getPropertyDescriptors()) {
                Method getMethod = p.getReadMethod();
                Method setMethod = p.getWriteMethod();
                if (getMethod == null || setMethod == null) continue;
                try {
                    Object result = getMethod.invoke(from, new Object[0]);
                    setMethod.invoke(to, result);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return to;
    }
}

