package cn.gtmap.landtax.web.ydqc;

/**
 * Created by xiongWen on 2014/9/2.
 */

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.Czlx;
import cn.gtmap.landtax.model.dictionary.Hcxmlx;
import cn.gtmap.landtax.model.dictionary.ResponseMessage;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.model.query.ZdQuery;
import cn.gtmap.landtax.print.PrintTjtzExcelUtil;
import cn.gtmap.landtax.printexcel.access.ExcelBean;
import cn.gtmap.landtax.service.*;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.CommonUtil;
import cn.gtmap.landtax.util.ObjectValueManager;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysUserService;
import com.gtis.web.SessionUtil;
import jxl.Workbook;
import jxl.format.Alignment;
import jxl.format.VerticalAlignment;
import jxl.write.*;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.lang.Boolean;
import java.math.BigDecimal;
import java.util.*;

/**
 * .
 * <p/>
 * 税源宗地数据对比疑点清册
 * @author xuchao
 * @version V1.0, 2014/9/2
 */
@Controller
@RequestMapping("/ydqc/zd")
public class ZdYdqcControllerTaiZhou {
    @Autowired
    YdqcServiceTaiZhou ydqcService;
    @Autowired
    ZdService zdService;
    @Autowired
    HcxmService hcxmService;
    @Autowired
    TaxService taxService;
    @Autowired
    SwdjSyTempService swdjSyTempService;
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    DwxxService dwxxService;
    @Autowired
    SysUserService sysUserService;

    /**
     * 国土宗地核查疑点
     * @param model
     * @return
     */
    @RequestMapping("zdydTzTaiZhou")
    public String zdydTz(Model model){
        return "landtax/ydqc/zd/zdydTzTaiZhou";
    }

    @RequestMapping("zdydTzJsonTaiZhou")
    @ResponseBody
    public Object zdydTzJson(Model model){
        String result = ydqcService.getZdydTzListJsonTaiZhou();
        return result;
    }
    /**
     * 存在疑点的宗地列表
     * @param model
     * @return
     */
    @RequestMapping("listTaiZhou")
    public String list(Model model, String dwdm){
        model.addAttribute("dwdm", dwdm);
        return "landtax/ydqc/zd/zdListTaiZhou";
    }

    @RequestMapping("listJsonTaiZhou")
    @ResponseBody
    public Object getZd(Model model,Pageable request,ZdQuery zdQuery) {
        String djh = zdQuery.getDjh();
        if (djh == null) {
            djh = "";
        }
        String swdwdm = dwxxService.getUserQxDm();
//        if (swdwdm != null&&swdwdm !="") {
//            if (djh.length() < 6) {
//                zdQuery.setDjh(swdwdm);
//            }
//            else if (!swdwdm.isEmpty() && !swdwdm.equals(djh.substring(0, 6))){
//                zdQuery.setDjh(swdwdm);
//            }
//        }
        return ydqcService.findZdListTaiZhou(zdQuery, request);
    }
    /**
     * 已下发疑点任务的宗地列表
     * @param model
     * @return
     */
    @RequestMapping("yxfListTaiZhou")
    public String yxfList(Model model, String dwdm) {
        model.addAttribute("dwdm", dwdm);
        return "landtax/ydqc/zd/zdYxfListTaiZhou";
    }

    @RequestMapping("yxfListJsonTaiZhou")
    @ResponseBody
    public Object yxfListJson(Model model,Pageable request,ZdQuery zdQuery) {
        return ydqcService.findZdYxfListTaiZhou(zdQuery, request);
    }
    /**
     *新建国土宗地疑点信息核查项目
     *
     * @param model
     * @param hcxmMc
     * @param
     * @return
     */
    @RequestMapping("xjxmTaiZhou")
    @ResponseBody
    public Object xjxm(Model model,String hcxmMc,String djhs,ZdQuery zdQuery){
        String result = "true";
        List<Zd> zdList=null;
        if(StringUtils.isNotBlank(djhs)){
            String[] djhArray = djhs.split(",");
            zdList = zdService.getZdsByDjhs(djhArray);
        }else{
            zdList = ydqcService.findZdListTz(zdQuery);
        }

        SwHcXm swHcXm = new SwHcXm();
        if(StringUtils.isNotBlank(hcxmMc))
            swHcXm.setMc(hcxmMc);
        else
            swHcXm.setMc("国土宗地疑点核查项目"+ Calendar.getInstance().getTime());
        swHcXm.setXmId(UUIDGenerator.generate());
        swHcXm.setCjrq(Calendar.getInstance().getTime());
        swHcXm.setCjrId(SessionUtil.getCurrentUserId());
        swHcXm.setXmlx(Hcxmlx.SYZDYDQC.toString());
        swHcXm.setXmybj("0");
        hcxmService.createGtzdYdqcHcxm(swHcXm, zdList);
        return result;
    }

    @RequestMapping("sytzTaiZhou")
    public String sytz(Model model,Pageable request,String proid){
        SwHcXmRwRel swHcXmRwRel = hcxmService.getSwHcXmRwRelByRwid(proid);
        String djh = hcxmService.getHcxmBdIdByWiid(proid);
        String jpql = "from SwDjSy o where o.zd.djh =?0 and (o.syzt is null or o.syzt='1') ";
        List<SwDjSy> swdjSyList = baseRepository.getByJpql(jpql,djh);
        List<SwDjSyTemp> swDjSyTempList =  ydqcService.findSytzByProid(proid);
        String[] swDjSyTempIdArr = new String[swDjSyTempList.size()];

        for(int i=0;i<swDjSyTempList.size();i++){
            swDjSyTempIdArr[i] = swDjSyTempList.get(i).getSyId();
        }
        for(int j=0;j<swdjSyList.size();j++){
            if(!CommonUtil.isIn(swdjSyList.get(j).getSyId(),swDjSyTempIdArr)){
                SwDjSy swDjSy = baseRepository.get(SwDjSy.class,swdjSyList.get(j).getSyId());
                hcxmService.saveSwDjHisZdYdqc(swDjSy, proid, swHcXmRwRel.getSwHcXm().getCjrId(), Czlx.UPDATE.toString());
            }
        }
        swDjSyTempList =  ydqcService.findSytzByProid(proid);
        model.addAttribute("swDjSyTempList",swDjSyTempList);
        model.addAttribute("proid",proid);

        Zd zd = zdService.findZdByDjh(djh);
        if(zd==null){
            zd = new Zd();
        }

        model.addAttribute("zd",zd);
        return "landtax/ydqc/zd/SyxxTz";

    }

    @RequestMapping("/syxx/saveTaiZhou")
    @ResponseBody
    public Object saveSyxx(Model model,SwDjSyTemp swDjSyTemp,String rwid) {
        String syId = swDjSyTemp.getSyId();
        if(StringUtils.isBlank(syId)){
            syId = UUIDGenerator.generate();
        }
        SwDjSyTemp tempVo = swdjSyTempService.getswDjSyTempBySyIdAndRwid(syId,rwid);
        if(tempVo!=null){

        }else{

        }
        String proid = tempVo.getProid();
        swDjSyTemp.setRwid(rwid);
        swDjSyTemp.setProid(proid);
        String djh = swDjSyTemp.getDjh();
        Zd zd = zdService.findZdByDjh(djh);
        swDjSyTemp.setTdyt(zd.getTdyt());
        swDjSyTemp.setQlrmc(zd.getQlrmc());
        swDjSyTemp.setScmjZd(zd.getScmjZd());
        swdjSyTempService.updateSwDjSyTemp(swDjSyTemp);
        ResponseMessage vo = new ResponseMessage();
        vo.setMsg("保存成功");
        return vo;

    }

    @RequestMapping("syxxTaiZhou")
    public String sytz(Model model,Pageable request,String rwid,String syId,String djh,String proid) throws  Exception{
        String userId = SessionUtil.getCurrentUserId();
        String remark=sysUserService.getUserVo(userId).getRemark();
        String canXg="";
        if(StringUtils.isNotBlank(remark)&&remark.indexOf("swy")>=0){
            canXg="1";
        }
        model.addAttribute("canXg",canXg);
        if(syId!=null && rwid!=null){
            SwDjSyTemp tempVo = swdjSyTempService.getswDjSyTempBySyIdAndRwid(syId,rwid);
            SwDjSyQuery swDjSyQuery = new SwDjSyQuery();
            BeanUtils.copyProperties(tempVo, swDjSyQuery);
              //设置征管系统应交额与欠缴额
            String nsrsbh = swDjSyQuery.getNsrsbh();
            if(StringUtils.isNotBlank(nsrsbh)){
                swDjSyQuery =  taxService.setZgxtSet(nsrsbh,swDjSyQuery);
            }
            String hydm=swDjSyQuery.getHyDm();
         if(StringUtils.isNotEmpty(hydm)){
            if(hydm.length()==1){
                String hydl=hydm;
                model.addAttribute("hydl",hydl);
            }else if(hydm.length()==3){
                String hyzl=hydm;
                model.addAttribute("hyzl",hyzl);
                List hyd1a=taxService.getHydl(hydm);
                Object hydmdl=hyd1a.get(0);
                model.addAttribute("hydl",hydmdl);
            }else if(hydm.length()>3){
                List<String> hyzl=taxService.getHyzl(hydm);
                Object hydmzl=hyzl.get(0);
                model.addAttribute("hyzl", hydmzl);
                List hyd1a=taxService.getHydl(hydm);
                Object hydmdl1=hyd1a.get(0);
                model.addAttribute("hydl",hydmdl1);

                }
            }

            model.addAttribute("syxx",swDjSyQuery);

            if (StringUtils.isEmpty(djh)) {
                djh = tempVo.getDjh();
            }

        }

        String is_open_nsrxx_xg = AppConfig.getProperty("IS_OPEN_NSRXX_XG");
        model.addAttribute("is_open_nsrxx_xg", is_open_nsrxx_xg);

        Zd zd = zdService.findZdByDjh(djh);
        model.addAttribute("zd",zd);
        model.addAttribute("proid",proid);
        //初始化土地等级下拉框
        List tddjList = taxService.getTddjByDjhLike(djh);
        model.addAttribute("tddjList",tddjList);
        String hydm_level = AppConfig.getProperty("HYDM_LEVELS");
        model.addAttribute("hydm_level",hydm_level);
        //加载税源种类
        Map<String,Boolean> taxTypeConf =CommonUtil.getSyTypes();
        model.addAttribute("taxTypeConf",taxTypeConf);
        model.addAttribute(ObjectValueManager.LOAD_FCS,taxTypeConf.get(ObjectValueManager.LOAD_FCS)?"true":"false");
        return "landtax/ydqc/zd/syxxMenu";

    }

    /**
     * 工作流办结事件
     * @param model
     * @param proid
     * @return
     * @throws Exception
     */
    @RequestMapping("/wf/endTaiZhou")
    @ResponseBody
    public String wfEnd(Model model,String proid) throws  Exception{
       ydqcService.zdYdqcWfEnd(proid);
       return "";
    }

    /**
     * 工作流删除事件
     * @param model
     * @param proid
     * @return
     */
    @RequestMapping("/wf/delTaiZhou")
    @ResponseBody
    public String wfDel(Model model,String proid) {
        ydqcService.zdYdqcWfDel(proid);
        return "";
    }


    @RequestMapping("exportExcelTzTaiZhou")
    public String exportExcelTz(ZdQuery zdQuery,String ids,HttpServletRequest request) throws Exception {
        try {
            HashMap param = new HashMap();

            // 判断是checkbox导出，还是查询导出
            if (StringUtils.isNotBlank(ids)) {
                // 说明是checkbox导出
                param.put("ids",ids);
            } else {
                param.put("zdQuery",zdQuery);
            }

            List<Object> zdydqcTzList = ydqcService.getZdydqcTzListTaiZhou(param);
            List<String[]> retList = new ArrayList<String[]>();
            for(int i=0;i<zdydqcTzList.size();i++){
                String[] tempArr = new String[8];
                for(int j=0;j<tempArr.length;j++){
                    tempArr[j] = "";
                }
                Object[] obj = (Object[]) zdydqcTzList.get(i);
                tempArr[0] = String.valueOf(i+1);
                for(int k=1;k<tempArr.length;k++){
                    tempArr[k] = String.valueOf(obj[k-1]);
                }
                retList.add(tempArr);
            }

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate("zdYdqc.xls"); //
            eb.setExcelXml("zdYdqc.xml"); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    @RequestMapping("zdydCbdTaiZhou")
    public String zdydCbd(Model model,String proid){
        String djh = hcxmService.getHcxmBdIdByWiid(proid);
        Zd zd = zdService.findZdByDjh(djh);
        model.addAttribute("zd",zd);

        BigDecimal beforeSumScmj = new BigDecimal(0);
        BigDecimal afterSumScmj = new BigDecimal(0);


        List<SwDjSyTemp> swDjSyTempList = swdjSyTempService.getSwDjSyTempListByRwid(proid);
        for(SwDjSyTemp swDjSyTemp : swDjSyTempList){
            afterSumScmj = afterSumScmj.add(swDjSyTemp.getScmj()==null?new BigDecimal(0):swDjSyTemp.getScmj());
        }
        beforeSumScmj = taxService.getSumScmjByDjh(djh);
        model.addAttribute("beforeSumScmj",beforeSumScmj);
        model.addAttribute("afterSumScmj",afterSumScmj);

        model.addAttribute("proid",proid);

        return "landtax/ydqc/zd/zdyd_cbd";
    }
    @RequestMapping("exportZdydTzJsonTaiZhou")
    public void exportZdydTzJson(Model model,HttpServletResponse response,HttpServletRequest request){
        String filePath = request.getSession().getServletContext().getRealPath("/")+"\\static\\excel\\template\\common.xls";
        Integer flag = 0;
        Integer hs = 0;//记录行数

        try{
            WritableWorkbook wwb = Workbook.createWorkbook(new File(filePath));
            WritableSheet ws = wwb.createSheet("sheet1", 0);
            ws.setColumnView(0, 50);
            ws.setColumnView(1, 20);
            ws.setColumnView(2, 20);
            ws.setColumnView(3, 20);
            ws.setColumnView(4, 20);
            ws.getSettings().setDefaultRowHeight(400);

            //设置字体大小与单元格样式
            WritableFont titleFont = new WritableFont(WritableFont.createFont("宋体"), 18, WritableFont.BOLD);
            WritableCellFormat titleFormat = new WritableCellFormat(titleFont);
            titleFormat.setVerticalAlignment(VerticalAlignment.CENTRE); // 垂直对齐
            titleFormat.setAlignment(Alignment.CENTRE); // 水平对齐

            //设置字体大小与单元格样式
            WritableFont contentFont = new WritableFont(WritableFont.createFont("宋体"), 15, WritableFont.NO_BOLD);
            WritableCellFormat contentFormat = new WritableCellFormat(contentFont);
            contentFormat.setVerticalAlignment(VerticalAlignment.CENTRE); // 垂直对齐
            contentFormat.setAlignment(Alignment.CENTRE); // 水平对齐

            //设置字体大小与单元格样式
            WritableFont nameFont = new WritableFont(WritableFont.createFont("宋体"), 15, WritableFont.NO_BOLD);
            WritableCellFormat nameFormat = new WritableCellFormat(nameFont);
            nameFormat.setVerticalAlignment(VerticalAlignment.CENTRE); // 垂直对齐
            nameFormat.setAlignment(Alignment.LEFT); // 水平对齐


            ws.mergeCells(0, 0, 4, 0); // 合并标题单元格

            Label excelLabel1 = new Label(0, 0, "国土宗地核查疑点",titleFormat);
            ws.addCell(excelLabel1);

            //设置表头
            Label excelLabel21 = new Label(0,1,"区县",titleFormat);
            Label excelLabel22 = new Label(1,1,"疑点总数",titleFormat);
            Label excelLabel23 = new Label(2,1,"下发疑点数",titleFormat);
            Label excelLabel24 = new Label(3,1,"未下发疑点数",titleFormat);
            Label excelLabel25 = new Label(4,1,"下发率（%）",titleFormat);
            ws.addCell(excelLabel21);
            ws.addCell(excelLabel22);
            ws.addCell(excelLabel23);
            ws.addCell(excelLabel24);
            ws.addCell(excelLabel25);

            //设置内容

            String listJson = ydqcService.getZdydTzListJsonTaiZhou();
            String[] columnArr = new String[]{"name","zs","yxf","wxf","xfl"};
            List list = Arrays.asList(columnArr);
            PrintTjtzExcelUtil.printTjtzExcel(list, listJson, ws, flag, hs, contentFormat, nameFormat, wwb, response, filePath);

            model.addAttribute("FileDownLoadURL",filePath);

        }catch (Exception e){

        }
    }
    @RequestMapping("exportExcelYxfTzTaiZhou")
    public String exportExcelYxfTz(ZdQuery zdQuery,String ids,HttpServletRequest request) throws Exception {
        try {
            HashMap param = new HashMap();

            // 判断是checkbox导出，还是查询导出
            if (StringUtils.isNotBlank(ids)) {
                // 说明是checkbox导出
                param.put("ids",ids);
            } else {
                param.put("zdQuery",zdQuery);
            }
            List<Object> zdydqcTzList = ydqcService.getZdYxfTzListTaiZhou(param);
            List<String[]> retList = new ArrayList<String[]>();
            for(int i=0;i<zdydqcTzList.size();i++){
                String[] tempArr = new String[8];
                for(int j=0;j<tempArr.length;j++){
                    tempArr[j] = "";
                }
                Object[] obj = (Object[]) zdydqcTzList.get(i);
                tempArr[0] = String.valueOf(i+1);
                for(int k=1;k<tempArr.length;k++){
                    tempArr[k] = String.valueOf(obj[k-1]);
                }
                retList.add(tempArr);
            }

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate("zdYdqc.xls"); //
            eb.setExcelXml("zdYdqc.xml"); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }
    /**
     * 土地等级疑点
     * @param model
     * @return
     */
    @RequestMapping("tddjydTzTaiZhou")
    public String tddjydTz(Model model){
        return "landtax/ydqc/zd/tddjydTz";
    }

    @RequestMapping("tddjydTzJsonTaiZhou")
    @ResponseBody
    public Object tddjydTzJson(Model model){
        String result = ydqcService.getTddjydTzListJson();
        return result;
    }
    /**
     * 存在土地等级疑点的税源列表
     * @param model
     * @return
     */
    @RequestMapping("syListTaiZhou")
    public String sylist(Model model, String dwdm)throws Exception{
        //加载税源种类
        Map<String,Boolean> taxTypeConf =CommonUtil.getSyTypes();
        model.addAttribute("taxTypeConf",taxTypeConf);
        model.addAttribute(ObjectValueManager.LOAD_FCS,taxTypeConf.get(ObjectValueManager.LOAD_FCS)?"true":"false");
        model.addAttribute("dwdm", dwdm);
        return "landtax/ydqc/zd/syList";
    }

    @RequestMapping("sylistJsonTaiZhou")
    @ResponseBody
    public Object getSyList(Model model,Pageable request,SwDjSyQuery swDjSyQuery) {
        return ydqcService.findSyList(swDjSyQuery, request);
    }
}
