package cn.gtmap.landtax.web.tj;

import cn.gtmap.landtax.model.dictionary.Sylx;
import cn.gtmap.landtax.model.query.GdzysQuery;
import cn.gtmap.landtax.model.query.SwDjQsQuery;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.service.*;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.CommonUtil;
import cn.gtmap.landtax.util.ObjectValueManager;
import com.gtis.plat.service.SysUserService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.lang.Boolean;
import java.util.*;

/**
 * Created by byj on 2016/10/17
 */
@Controller
@RequestMapping("/tj/sybyz")
public class TjSyByzController {
    @Autowired
    TaxService taxService;
    @Autowired
    SysUserService sysUserService;
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    private DwxxService dwxxService;
    @Autowired
    GdzysService gdzysService;
    @Autowired
    SwDjQsService swDjQsService;

    @RequestMapping("")
    public String syByzTj(Model model)throws Exception{

        //加载税源种类
        Map<String,Boolean> taxTypeConf =CommonUtil.getSyTypes();
        model.addAttribute("taxTypeConf",taxTypeConf);
        model.addAttribute(ObjectValueManager.LOAD_FCS,taxTypeConf.get(ObjectValueManager.LOAD_FCS)?"true":"false");

        return "landtax/tj/byztj/sytz";
    }

    @RequestMapping("syJson")
    @ResponseBody
    public Object getSwdjSy(Model model,Pageable request,String sylx,SwDjSyQuery swDjSyQuery,GdzysQuery gdzysQuery,SwDjQsQuery swDjQsQuery) {
        if(StringUtils.isBlank(sylx)|| Sylx.TDSY.toString().equals(sylx) )
            return taxService.findSwdjTdMap(swDjSyQuery, request);
        else if(StringUtils.isBlank(sylx)|| Sylx.FCSY.toString().equals(sylx) )
            return taxService.findSwdjFcMap(swDjSyQuery,request);
        else if(StringUtils.isBlank(sylx)|| Sylx.GDZYS.toString().equals(sylx)  ){
            String xzqdm = dwxxService.getUserQxDm();
            if (StringUtils.isNotBlank(xzqdm) && StringUtils.isBlank(gdzysQuery.getPcXzqdm())){
                gdzysQuery.setPcXzqdm(xzqdm);
            }
            Object oo = gdzysService.findGdzystz(gdzysQuery, request);
            return oo;
        }

        else if(StringUtils.isBlank(sylx)|| Sylx.QS.toString().equals(sylx) ){
            String xzqdm = dwxxService.getUserQxDm();
            if (StringUtils.isNotBlank(xzqdm) && StringUtils.isBlank(swDjQsQuery.getXmXzqdm())){
                swDjQsQuery.setXmXzqdm(xzqdm);
            }
            Object obj =  swDjQsService.findQstz(swDjQsQuery, request);
            return obj;
        }

        return null;
    }
}
