package cn.gtmap.landtax.web.tj;

import cn.gtmap.landtax.entity.SDmDwxxCz;
import cn.gtmap.landtax.model.dictionary.ResponseMessage;
import cn.gtmap.landtax.model.dictionary.Tdjb;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.printexcel.access.ExcelBean;
import cn.gtmap.landtax.service.DwxxService;
import cn.gtmap.landtax.service.TaxService;
import cn.gtmap.landtax.service.TjService;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * Created by xuchao on 2014/9/27.
 */
@Controller
@RequestMapping("/tj/lzlgh")
public class TjLzlghController {
    @Autowired
    TjService tjService;
    @Autowired
    TaxService taxService;
    @Autowired
    private DwxxService dwxxService;
    @RequestMapping("td")
    public String lzlghTd(Model model,String dw) {
        model.addAttribute("dw",dw);

        //获取所有区县信息
        List<SDmDwxxCz> allQxList = dwxxService.getAllQxList();
        model.addAttribute("allQxList",allQxList);
        //计算合计
        Object[] objArr = tjService.lzlgTdHj(new SwDjSyQuery());
        model.addAttribute("objArr",objArr);
        String gisPlatForm = AppConfig.getProperty("SSGXL_CONFIG");
        model.addAttribute("GISPlatForm", gisPlatForm);
        return "landtax/tj/lzlgh/td";
    }

    @RequestMapping("tdListJson")
    @ResponseBody
    public Object tdListJson(Model model,SwDjSyQuery swDjSyQuery,Pageable request) {
        //计算合计
        Page<SwDjSyQuery> page = tjService.lzlgTdListJson(swDjSyQuery,request);
        return page;
    }

    @RequestMapping("tdHjJson")
    @ResponseBody
    public Object tdHjJson(Model model,SwDjSyQuery swDjSyQuery) {
        //计算合计
        Object[] objArr = tjService.lzlgTdHj(swDjSyQuery);
        return objArr;
    }

    @RequestMapping("parseTddjByDm")
    @ResponseBody
    public Object parseTddjByDm(Model model,String tddj) {
        if(StringUtils.isBlank(tddj)){
            ResponseMessage responseMessage = new ResponseMessage("");
            return responseMessage;
        }else{
            String tddjMc = "";
            HashMap tddjMap = (HashMap) taxService.getTddjByDm(tddj);
            if(tddjMap != null){
                tddjMc = String.valueOf(tddjMap.get("MC"));
            }
            ResponseMessage responseMessage = new ResponseMessage(tddjMc);
            return responseMessage;
        }
    }

    // 导出Excel
    @RequestMapping("exportExcelTd")
    public String exportExcelTd(SwDjSyQuery swDjSyQuery,String ids,HttpServletRequest request) throws Exception {
        try {
            HashMap param = new HashMap();
            List<SwDjSyQuery> swDjSyQueryList = new ArrayList<SwDjSyQuery>();
            // 判断是checkbox导出，还是查询导出
            //计算合计
            String hjZdmj = "";
            String hjYnmj = "";
            String hjYnse = "";
            String hjMsmj = "";
            String hjMsse = "";
            Object[] objArr = null;
            if (StringUtils.isNotBlank(ids)) {
                // 说明是checkbox导出
                param.put("ids",ids);
                objArr = tjService.lzlgTdHjByTdIds(ids);

            } else {
                param.put("swDjSyQuery",swDjSyQuery);
                objArr = tjService.lzlgTdHj(swDjSyQuery);
            }
            hjZdmj = String.valueOf(objArr[0]);
            hjYnmj = String.valueOf(objArr[1]);
            hjYnse = String.valueOf(objArr[2]);
            hjMsmj = String.valueOf(objArr[3]);
            hjMsse = String.valueOf(objArr[4]);

            request.setAttribute("hjZdmj",String.valueOf(hjZdmj));
            request.setAttribute("hjYnmj",String.valueOf(hjYnmj));
            request.setAttribute("hjYnse",String.valueOf(hjYnse));
            request.setAttribute("hjMsmj",String.valueOf(hjMsmj));
            request.setAttribute("hjMsse",String.valueOf(hjMsse));

            swDjSyQueryList = tjService.getLzlgTdList(param);
            List<String[]> retList = this.getStrList(swDjSyQueryList); // 组织参数

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            request.setAttribute("date", "汇总日期："+new SimpleDateFormat("yyyy年MM月dd日").format(new Date()));
            request.setAttribute("year","所属年份："+new SimpleDateFormat("yyyy").format(new Date()));
            request.setAttribute("hzdw","汇总单位：地税局");

            eb.setGroupMap(map);
            eb.setExcelTemplate("lzlghTd.xls"); //
            eb.setExcelXml("lzlghTd.xml"); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    private List<String[]> getStrList(List<SwDjSyQuery> list) {
        List<String[]> retList = new ArrayList<String[]>();
        HashMap<String,String> tdjbMap = tjService.getTdjbList();
        for (int i = 0; i < list.size(); i++) {
            SwDjSyQuery tempVo = list.get(i);
            if (tempVo != null) {
                String[] strs = new String[20];
                for (int j = 0; j < strs.length; j++) {
                    strs[j] = "";
                }
                strs[0] = String.valueOf(i + 1);

                if (StringUtils.isNotBlank(tempVo.getNsrsbh())) {
                    strs[1] = tempVo.getNsrsbh();
                }

                if (StringUtils.isNotBlank(tempVo.getNsrmc())) {
                    strs[2] = tempVo.getNsrmc();
                }
                if (StringUtils.isNotBlank(tempVo.getDjh())) {
                    strs[3] = tempVo.getDjh();
                }
                if (StringUtils.isNotBlank(tempVo.getDbh())) {
                    strs[4] = tempVo.getDbh();
                }
                if (StringUtils.isNotBlank(tempVo.getTdzl())) {
                    strs[5] = tempVo.getTdzl();
                }

                if (tempVo.getYnmj()!=null){
                    strs[7] = String.valueOf(tempVo.getYnmj());
                }
                if (StringUtils.isNotBlank(tempVo.getTddj())) {
                    String tddj = tdjbMap.get(tempVo.getTddj());
                    if(tddj == null){
                        tddj = "";
                    }
                    strs[8] = tddj;//土地等级转换
                }
                if (tempVo.getDwse()!=null) {
                    strs[9] = String.valueOf(tempVo.getDwse());
                }
                if (tempVo.getNynseTd()!=null) {
                    strs[10] = String.valueOf(tempVo.getNynseTd());
                }
                if (tempVo.getMsmj()!=null) {
                    strs[11] = String.valueOf(tempVo.getMsmj());
                }
                if (tempVo.getTddj()!=null) {
                    String tddj = tdjbMap.get(tempVo.getTddj());
                    if(tddj == null){
                        tddj = "";
                    }
                    strs[12] = tddj;//土地等级转换
                }
                if (tempVo.getDwse()!=null) {
                    strs[13] = String.valueOf(tempVo.getDwse());
                }
                //计算strs[6]
                Double ynmj = 0.0;
                Double msmj = 0.0;
                if(StringUtils.isNotBlank(strs[7])){
                    ynmj =  Double.parseDouble(strs[7]);
                }
                if(StringUtils.isNotBlank(strs[11])){
                    msmj = Double.parseDouble(strs[11]);
                }
                strs[6] = String.valueOf(ynmj+msmj);

                //计算strs[14]
                Double dwse = 0.0;
                if(StringUtils.isNotBlank(strs[13])){
                    dwse = Double.parseDouble(strs[13]);
                }
                strs[14] = String.valueOf(msmj*dwse);

                strs[15] = "";
                strs[16] = "";
                strs[17] = "";

                if (StringUtils.isNotBlank(tempVo.getZgkgMc())) {
                    strs[18] = tempVo.getZgkgMc();
                }
                if (StringUtils.isNotBlank(tempVo.getSgyMc())){
                    strs[19]  =tempVo.getSgyMc();
                }
                retList.add(strs);
            }
        }

        return retList;
    }
}
