package cn.gtmap.landtax.web.tj;

import cn.gtmap.landtax.model.dictionary.Sylx;
import cn.gtmap.landtax.model.query.GdzysQuery;
import cn.gtmap.landtax.model.query.SwDjQsQuery;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.service.*;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.CommonUtil;
import cn.gtmap.landtax.util.ObjectValueManager;
import com.gtis.plat.service.SysUserService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by hengyaohua on 2017/3/5.
 */
@Controller
@RequestMapping("/tj/jxtj")
public class TjJxController {
    @Autowired
    TjService tjService;
    @Autowired
    SysUserService sysUserService;
    @Autowired
    BaseRepository baseRepository;

    @RequestMapping("")
    public String syByzTj(Model model)throws Exception{

        //加载税源种类
        Map<String,Boolean> taxTypeConf = CommonUtil.getSyTypes();
        model.addAttribute("taxTypeConf",taxTypeConf);
        model.addAttribute(ObjectValueManager.LOAD_FCS,taxTypeConf.get(ObjectValueManager.LOAD_FCS)?"true":"false");

        return "landtax/tj/jxtj/jxtjtz";
    }
    @RequestMapping("jxJson")
    @ResponseBody
    public Object getJxJson(Model model,Pageable request,SwDjSyQuery swDjSyQuery) {
        return tjService.getJxJson(swDjSyQuery,request);

    }
    @RequestMapping("rwList")
    public String getSyListByGlbm(Model model,String userId,SwDjSyQuery swDjSyQuery)throws Exception{
        if(StringUtils.isNotBlank(userId)){
            List<HashMap<String,Object>> rwlist=tjService.getRwList(userId,swDjSyQuery);
            model.addAttribute("rwList",rwlist);
        }

        return "landtax/tj/jxtj/rwList";


    }
}
