package cn.gtmap.landtax.web.tj;

import cn.gtmap.landtax.entity.SDmDwxxCz;
import cn.gtmap.landtax.entity.TjBaseParamVo;
import cn.gtmap.landtax.model.dictionary.*;
import cn.gtmap.landtax.model.query.*;
import cn.gtmap.landtax.printexcel.access.ExcelBean;
import cn.gtmap.landtax.service.DwxxService;
import cn.gtmap.landtax.service.TaxService;
import cn.gtmap.landtax.service.TjService;
import cn.gtmap.landtax.service.impl.DicServiceImpl;
import cn.gtmap.landtax.util.CommonUtil;
import cn.gtmap.landtax.util.ObjectValueManager;
import com.gtis.config.AppConfig;
import com.gtis.web.SessionUtil;
import jxl.Workbook;
import jxl.format.CellFormat;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import net.sf.json.JSONArray;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * Created by xuchao on 2014/9/27.
 */
@Controller
@RequestMapping("/tj/hz")
public class SyHzController {
    @Autowired
    TjService tjService;
    @Autowired
    TaxService taxService;
    @Autowired
    DicServiceImpl dicServiceImpl;
    @Autowired
    DwxxService dwxxService;
    //城镇土地使用税税源汇总台账（不含可转化税源）
    @RequestMapping("tdExcKzh")
    public String tdExcKzh(Model model) {
        return "landtax/tj/hz/tdExcKzh";
    }
    //城镇土地使用税税源汇总台账（不含未登记户和可转化税源）
    @RequestMapping("tdExcKzhAndLzlg")
    public String tdExcKzhAndLzlg(Model model) {
        return "landtax/tj/hz/tdExcKzhAndLzlg";
    }
    //房产税税源汇总台账（不含可转化税源）
    @RequestMapping("fcExcKzh")
    public String fcExcKzh(Model model) {
        return "landtax/tj/hz/fcExcKzh";
    }
    //房产税税源汇总台账（不含未登记户和可转化税源）
    @RequestMapping("fcExcKzhAndLzlg")
    public String fcExcKzhAndLzlg(Model model) {
        return "landtax/tj/hz/fcExcKzhAndLzlg";
    }
    //征管系统土地税征收台账
    @RequestMapping("tdExcZgNsrZs")
    public String tdExcZgNsrZs(Model model) {
        return "landtax/tj/hz/tdExcZgNsrZs";
    }
    //征管系统房产税征收台账
    @RequestMapping("fcExcZgNsrZs")
    public String fcExcZgZs(Model model) {
        return "landtax/tj/hz/fcExcZgNsrZs";
    }
    //城镇土地使用税和房产税税源核查进度统计表
    @RequestMapping("tdfcHcjdTj")
    public String tdfcHcjdTj(Model model, String beginRq, String endRq) {
        Date dt = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (StringUtils.isBlank(beginRq))
            beginRq = (sdf.format(dt)).substring(0, 4) + "-01-01";
        if (StringUtils.isBlank(endRq))
            endRq = sdf.format(dt);
        List<HashMap> list = (List<HashMap>)tjService.tdfcHcjdTjJson(null, beginRq, endRq);
        model.addAttribute("listData",list);
        model.addAttribute("beginRq", beginRq);
        model.addAttribute("endRq", endRq);
        return "landtax/tj/hz/tdfcHcjdTj";
    }
    /**
     * 税源综合统计表
     * @param model
     * @return
     */
    @RequestMapping("syzhtjb")
    public String syzhtjb(Model model){
        return "landtax/tj/hz/syzhtjb";
    }

    @RequestMapping("syzhtjbJson")
    @ResponseBody
    public List<HashMap<String,Object>> syzhtjbJson(Model model,  String id) {
        return tjService.syzhtjbJson(id);
    }

    @RequestMapping("syzhtjbExcel")
    public String exportExcel(HttpServletRequest request) throws Exception {
        try {
            String id = null;
            List<HashMap<String,Object>> syzhtjbQueryList = tjService.syzhtjbJson(id);//相当于第一次进入，id为null获取结果

            List<String[]> retList = new ArrayList<String[]>();
            retList= this.recursionToGetSon(syzhtjbQueryList,retList);//递归查询子节点

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate("syzhtjbContainFc.xls"); //
            eb.setExcelXml("syzhtjbContainFc.xml"); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }
    private  List<String[]> recursionToGetSon(List<HashMap<String,Object>> syzhtjbQueryList,List<String[]> retList){

        for(int i=0;i<syzhtjbQueryList.size();i++){
            HashMap<String,Object> syzhtjbQuery = syzhtjbQueryList.get(i);

            String[] tempArr = new String[20];//18列
            for(int j=0;j<tempArr.length;j++){
                tempArr[j] = "";//数组初始化
            }

            tempArr[0] = String.valueOf(syzhtjbQuery.get("DWMC"));
            tempArr[1] = String.valueOf(syzhtjbQuery.get("SL"));
            tempArr[2] = String.valueOf(syzhtjbQuery.get("SY_HJ"));
            tempArr[3] = String.valueOf(syzhtjbQuery.get("SY_KGH"));
            tempArr[4] = String.valueOf(syzhtjbQuery.get("SY_LZLGH"));
            tempArr[5] = String.valueOf(syzhtjbQuery.get("SY_KZH"));
            tempArr[6] = String.valueOf(syzhtjbQuery.get("SY_JGDW"));
            tempArr[7] = String.valueOf(syzhtjbQuery.get("SY_GR"));
            tempArr[8] = String.valueOf(syzhtjbQuery.get("TD_HCMJ"));
            tempArr[9] = String.valueOf(syzhtjbQuery.get("TD_MSMJ"));
            tempArr[10] = String.valueOf(syzhtjbQuery.get("TD_YSMJ"));
            tempArr[11] = String.valueOf(syzhtjbQuery.get("TD_MSSE"));
            tempArr[12] = String.valueOf(syzhtjbQuery.get("TD_NYNSE"));
            tempArr[13] = String.valueOf(syzhtjbQuery.get("FC_FCYZ_YS"));
            tempArr[14] = String.valueOf(syzhtjbQuery.get("FC_FCYZ_MS"));
            tempArr[15] = String.valueOf(syzhtjbQuery.get("FC_YNSE_ZY_CZJ"));
            tempArr[16] = String.valueOf(syzhtjbQuery.get("FC_YNSE_ZY"));
            tempArr[17] = String.valueOf(syzhtjbQuery.get("FC_NYNSE"));
            tempArr[18] = String.valueOf(syzhtjbQuery.get("FC_YNSE_ZY_CJJ"));
            tempArr[19] = String.valueOf(syzhtjbQuery.get("FC_YNSE_ZY_CZJ"));
            retList.add(tempArr);//查询结果插入返回值中

            if(String.valueOf(syzhtjbQuery.get("state")).equals("closed")){//如果列的状态为“closed”，有子节点，再次查询
                List<HashMap<String,Object>> sonOfThisQueryList = tjService.syzhtjbJson(String.valueOf(syzhtjbQuery.get("DWDM")));
                recursionToGetSon(sonOfThisQueryList,retList);//对子节点递归
            }
        }
        return retList;
    }



    //基础统计表
    @RequestMapping("baseTj")
    public String baseTj(Model model, String tag, String reportName, String colJson, String headPagePath, String excelTemplate, String excelXml)throws Exception{
        model.addAttribute("tag",tag);
        //加载税源种类
        Map<String,Boolean> taxTypeConf =CommonUtil.getSyTypes();
        String tempTag=taxTypeConf.get(ObjectValueManager.LOAD_FCS)?tag+ObjectValueManager.CONTAIN_FC:tag;
        TjBaseParamVo tjBaseParamVo = tjService.getTjBaseParam(tempTag);
        model.addAttribute("tjBaseParamVo", tjBaseParamVo);
        if (tjBaseParamVo != null) {
            model.addAttribute("colJson", tjBaseParamVo.getColJson());
            model.addAttribute("headPageFile", tjBaseParamVo.getHeadPageFile());
            model.addAttribute("reportName", tjBaseParamVo.getReportName());
            if (StringUtils.isNotBlank(tjBaseParamVo.getExcelTemplate()) && StringUtils.isNotBlank(tjBaseParamVo.getExcelXml()) && StringUtils.isNotBlank(tjBaseParamVo.getExportFieldList())) {
                model.addAttribute("needExport", "true");
            }
        }
        String regionCode = SessionUtil.getCurrentUser().getRegionCode();
        model.addAttribute("regionCode",regionCode);
        return "landtax/tj/hz/baseTj";
    }

    //基础统计表
    @RequestMapping("baseTjCommon")
    public String baseTjCommon(Model model)throws Exception{
        String regionCode = SessionUtil.getCurrentUser().getRegionCode();
        String tag=null;
        if(StringUtils.isNotBlank(regionCode)){
            if(regionCode.length() == 4){
                tag = "syhcjdtjb";
            }else if(regionCode.length() >= 6){
                tag = "syhcjdtjb_qx";
                regionCode = regionCode.substring(0, 6);
            }
        }
        model.addAttribute("regionCode", regionCode);
        model.addAttribute("tag",tag);
        //加载税源种类
        Map<String,Boolean> taxTypeConf =CommonUtil.getSyTypes();
        String tempTag=taxTypeConf.get(ObjectValueManager.LOAD_FCS)?tag+ObjectValueManager.CONTAIN_FC:tag;
        TjBaseParamVo tjBaseParamVo = tjService.getTjBaseParam(tempTag);
        model.addAttribute("tjBaseParamVo", tjBaseParamVo);
        if (tjBaseParamVo != null) {
            model.addAttribute("colJson", tjBaseParamVo.getColJson());
            model.addAttribute("headPageFile", tjBaseParamVo.getHeadPageFile());
            model.addAttribute("reportName", tjBaseParamVo.getReportName());
            if (StringUtils.isNotBlank(tjBaseParamVo.getExcelTemplate()) && StringUtils.isNotBlank(tjBaseParamVo.getExcelXml()) && StringUtils.isNotBlank(tjBaseParamVo.getExportFieldList())) {
                model.addAttribute("needExport", "true");
            }
        }

        return "landtax/tj/hz/baseTj";
    }

    @RequestMapping("tdExcKzhJson")
    @ResponseBody
    public Object tdExcKzhJson(Model model,Pageable request) {
        return tjService.tdExcKzhJson(request);
    }

    @RequestMapping("exptdExcKzhSyhzF")
    public String expExcTdSyhzF(HttpServletRequest request) throws Exception {
        try {
            HashMap param = new HashMap();
            List<HashMap<String,String>> tempList= new ArrayList<HashMap<String, String>>();
            tempList = tjService.getTdSyhzF();

            List<String[]> retList = new ArrayList<String[]>();
            for (int i = 0; i < tempList.size(); i++) {
                HashMap tempMap = tempList.get(i);
                if (tempMap != null) {
                    String[] strs = new String[10];
                    for (int j = 0; j < strs.length; j++) {
                        strs[j] = "";
                    }
                    strs[0] = String.valueOf(i + 1);
                        strs[1] = String.valueOf(tempMap.get("DWMC")==null?"":tempMap.get("DWMC"));
                        strs[2] = String.valueOf(tempMap.get("HS")==null?"":tempMap.get("HS"));
                        strs[3] = String.valueOf(tempMap.get("ZDMJ")==null?"":tempMap.get("ZDMJ"));
                        strs[4] = String.valueOf(tempMap.get("YSMJ")==null?"":tempMap.get("YSMJ"));
                        strs[5] = String.valueOf(tempMap.get("MSMJ")==null?"":tempMap.get("MSMJ"));
                        strs[6] = String.valueOf(tempMap.get("NYNSE")==null?"":tempMap.get("NYNSE"));
                        strs[7] = String.valueOf(tempMap.get("MSSE")==null?"":tempMap.get("MSSE"));
                        strs[8] = String.valueOf(tempMap.get("JZBQYNSE")==null?"":tempMap.get("JZBQYNSE"));
                        strs[9] = String.valueOf(tempMap.get("RKSE")==null?"":tempMap.get("RKSE"));
                    retList.add(strs);
                }
            }// 组织参数

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate("tdsyhzf.xls"); //
            eb.setExcelXml("tdsyhzf.xml"); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }


    @RequestMapping("tdExcKzhAndLzlgJson")
    @ResponseBody
    public Object tdExcKzhAndLzlgJson(Model model,Pageable request) {
        return tjService.tdExcKzhAndLzlgJson(request);
    }

    @RequestMapping("expExctdExcKzhAndLzlg")
    public String expExctdExcKzhAndLzlg(HttpServletRequest request)throws Exception{
        try {
            HashMap param = new HashMap();
            List<HashMap<String,String>> tempList= new ArrayList<HashMap<String, String>>();
            tempList = tjService.getTdSyhzS();

            List<String[]> retList = new ArrayList<String[]>();
            for (int i = 0; i < tempList.size(); i++) {
                HashMap tempMap = tempList.get(i);
                if (tempMap != null) {
                    String[] strs = new String[10];
                    for (int j = 0; j < strs.length; j++) {
                        strs[j] = "";
                    }
                    strs[0] = String.valueOf(i + 1);
                    strs[1] = String.valueOf(tempMap.get("DWMC")==null?"":tempMap.get("DWMC"));
                    strs[2] = String.valueOf(tempMap.get("HS")==null?"":tempMap.get("HS"));
                    strs[3] = String.valueOf(tempMap.get("ZDMJ")==null?"":tempMap.get("ZDMJ"));
                    strs[4] = String.valueOf(tempMap.get("YSMJ")==null?"":tempMap.get("YSMJ"));
                    strs[5] = String.valueOf(tempMap.get("MSMJ")==null?"":tempMap.get("MSMJ"));
                    strs[6] = String.valueOf(tempMap.get("NYNSE")==null?"":tempMap.get("NYNSE"));
                    strs[7] = String.valueOf(tempMap.get("MSSE")==null?"":tempMap.get("MSSE"));
                    strs[8] = String.valueOf(tempMap.get("JZBQYNSE")==null?"":tempMap.get("JZBQYNSE"));
                    strs[9] = String.valueOf(tempMap.get("RKSE")==null?"":tempMap.get("RKSE"));
                    retList.add(strs);
                }
            }// 组织参数

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate("tdsyhzs.xls"); //
            eb.setExcelXml("tdsyhzs.xml"); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    @RequestMapping("fcExcKzhJson")
    @ResponseBody
    public Object fcExcKzhJson(Model model,Pageable request) {
        return tjService.fcExcKzhJson(request);
    }

    @RequestMapping("expExcfcExcKzh")
    public String expExcfcExcKzh(HttpServletRequest request)throws Exception{
        try {
            HashMap param = new HashMap();
            List<HashMap<String,String>> tempList= new ArrayList<HashMap<String, String>>();
            tempList = tjService.getFcSyhzF();

            List<String[]> retList = new ArrayList<String[]>();
            for (int i = 0; i < tempList.size(); i++) {
                HashMap tempMap = tempList.get(i);
                if (tempMap != null) {
                    String[] strs = new String[15];
                    for (int j = 0; j < strs.length; j++) {
                        strs[j] = "";
                    }
                    strs[0] = String.valueOf(i + 1);
                    strs[1] = String.valueOf(tempMap.get("DWMC")==null?"":tempMap.get("DWMC"));
                    strs[2] = String.valueOf(tempMap.get("HS")==null?"":tempMap.get("HS"));
                    strs[3] = String.valueOf(tempMap.get("FCYZ")==null?"":tempMap.get("FCYZ"));
                    strs[4] = String.valueOf(tempMap.get("FCYZ_YS")==null?"":tempMap.get("FCYZ_YS"));
                    strs[5] = String.valueOf(tempMap.get("FCYZ_MS")==null?"":tempMap.get("FCYZ_MS"));
                    strs[6] = String.valueOf(tempMap.get("NZJ")==null?"":tempMap.get("NZJ"));
                    strs[7] = String.valueOf(tempMap.get("NYNSE")==null?"":tempMap.get("NYNSE"));
                    strs[8] = String.valueOf(tempMap.get("YNSE_ZY")==null?"":tempMap.get("YNSE_ZY"));
                    strs[9] = String.valueOf(tempMap.get("YNSE_CZ")==null?"":tempMap.get("YNSE_CZ"));
                    strs[10] = String.valueOf(tempMap.get("MSSE")==null?"":tempMap.get("MSSE"));
                    strs[11] = String.valueOf(tempMap.get("ZY_MSSE")==null?"":tempMap.get("ZY_MSSE"));
                    strs[12] = String.valueOf(tempMap.get("CZ_MSSE")==null?"":tempMap.get("CZ_MSSE"));
                    strs[13] = String.valueOf(tempMap.get("JZBQYNSE")==null?"":tempMap.get("JZBQYNSE"));
                    strs[14] = String.valueOf(tempMap.get("RKSE")==null?"":tempMap.get("RKSE"));
                    retList.add(strs);
                }
            }// 组织参数

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate("fcsyhzf.xls"); //
            eb.setExcelXml("fcsyhzf.xml"); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    @RequestMapping("fcExcKzhAndLzlgJson")
    @ResponseBody
    public Object fcExcKzhAndLzlgJson(Model model,Pageable request) {
        return tjService.fcExcKzhAndLzlgJson(request);
    }

    @RequestMapping("expExcfcExcKzhAndLzlg")
    public String expExcfcExcKzhAndLzlg(HttpServletRequest request)throws Exception{
        try {
            HashMap param = new HashMap();
            List<HashMap<String,String>> tempList= new ArrayList<HashMap<String, String>>();
            tempList = tjService.getFcSyhzS();

            List<String[]> retList = new ArrayList<String[]>();
            for (int i = 0; i < tempList.size(); i++) {
                HashMap tempMap = tempList.get(i);
                if (tempMap != null) {
                    String[] strs = new String[15];
                    for (int j = 0; j < strs.length; j++) {
                        strs[j] = "";
                    }
                    strs[0] = String.valueOf(i + 1);
                    strs[1] = String.valueOf(tempMap.get("DWMC")==null?"":tempMap.get("DWMC"));
                    strs[2] = String.valueOf(tempMap.get("HS")==null?"":tempMap.get("HS"));
                    strs[3] = String.valueOf(tempMap.get("FCYZ")==null?"":tempMap.get("FCYZ"));
                    strs[4] = String.valueOf(tempMap.get("FCYZ_YS")==null?"":tempMap.get("FCYZ_YS"));
                    strs[5] = String.valueOf(tempMap.get("FCYZ_MS")==null?"":tempMap.get("FCYZ_MS"));
                    strs[6] = String.valueOf(tempMap.get("NZJ")==null?"":tempMap.get("NZJ"));
                    strs[7] = String.valueOf(tempMap.get("NYNSE")==null?"":tempMap.get("NYNSE"));
                    strs[8] = String.valueOf(tempMap.get("YNSE_ZY")==null?"":tempMap.get("YNSE_ZY"));
                    strs[9] = String.valueOf(tempMap.get("YNSE_CZ")==null?"":tempMap.get("YNSE_CZ"));
                    strs[10] = String.valueOf(tempMap.get("MSSE")==null?"":tempMap.get("MSSE"));
                    strs[11] = String.valueOf(tempMap.get("ZY_MSSE")==null?"":tempMap.get("ZY_MSSE"));
                    strs[12] = String.valueOf(tempMap.get("CZ_MSSE")==null?"":tempMap.get("CZ_MSSE"));
                    strs[13] = String.valueOf(tempMap.get("JZBQYNSE")==null?"":tempMap.get("JZBQYNSE"));
                    strs[14] = String.valueOf(tempMap.get("RKSE")==null?"":tempMap.get("RKSE"));
                    retList.add(strs);
                }
            }// 组织参数

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate("fcsyhzs.xls"); //
            eb.setExcelXml("fcsyhzs.xml"); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    @RequestMapping("tdExcZgNsrZsJson")
    @ResponseBody
    public Object tdExcZgNsrZsJson(Model model,Pageable request) {
        return tjService.tdExcZgNsrZsJson(request);
    }
    @RequestMapping("fcExcZgNsrZsJson")
    @ResponseBody
    public Object fcExcZgNsrZsJson(Model model,Pageable request) {
        return tjService.fcExcZgNsrZsJson(request);
    }

    @RequestMapping("tdfcHcjdTjData")
    @ResponseBody
    public Object tdfcHcjdTjData(Model model, String beginRq, String endRq) {
        return (List<HashMap>)tjService.tdfcHcjdTjJson(null, beginRq, endRq);
    }

    // 获取统计报表的数据
    @RequestMapping("tjJson")
    @ResponseBody
    public Object tjJson(Model model,Pageable request, String tag, String param) {
        HashMap queryFilter = null;
        try {
            if (param != null) {
                JSONArray jsonArray = JSONArray.fromObject("[" + param + "]");
                HashMap[] hashMaps = (HashMap[]) JSONArray.toArray(jsonArray, HashMap.class);
                if (hashMaps != null && hashMaps.length > 0) {
                    queryFilter = hashMaps[0];
                }
            }
        } catch (Exception e){

        }
        return tjService.getTjJson(request, tag, queryFilter);
    }

    // 导出Excel
    @RequestMapping("exportExcelTd")
    public String exportExcelTd(SwDjSyQuery swDjSyQuery,String ids,HttpServletRequest request) throws Exception {
        try {
            HashMap param = new HashMap();
            List<SwDjSyQuery> swDjSyQueryList = new ArrayList<SwDjSyQuery>();
            // 判断是checkbox导出，还是查询导出
            //计算合计
            String hjZdmj = "";
            String hjYnmj = "";
            String hjYnse = "";
            String hjMsmj = "";
            String hjMsse = "";
            Object[] objArr = null;
            if (StringUtils.isNotBlank(ids)) {
                // 说明是checkbox导出
                param.put("ids",ids);
                objArr = tjService.lzlgTdHjByTdIds(ids);

            } else {
                param.put("swDjSyQuery",swDjSyQuery);
                objArr = tjService.lzlgTdHj(swDjSyQuery);
            }
            hjZdmj = String.valueOf(objArr[0]);
            hjYnmj = String.valueOf(objArr[1]);
            hjYnse = String.valueOf(objArr[2]);
            hjMsmj = String.valueOf(objArr[3]);
            hjMsse = String.valueOf(objArr[4]);

            request.setAttribute("hjZdmj",String.valueOf(hjZdmj));
            request.setAttribute("hjYnmj",String.valueOf(hjYnmj));
            request.setAttribute("hjYnse",String.valueOf(hjYnse));
            request.setAttribute("hjMsmj",String.valueOf(hjMsmj));
            request.setAttribute("hjMsse",String.valueOf(hjMsse));

            swDjSyQueryList = tjService.getLzlgTdList(param);
            List<String[]> retList = this.getStrList(swDjSyQueryList); // 组织参数

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            request.setAttribute("date", "汇总日期："+new SimpleDateFormat("yyyy年MM月dd日").format(new Date()));
            request.setAttribute("year","所属年份："+new SimpleDateFormat("yyyy").format(new Date()));
            request.setAttribute("hzdw","汇总单位：汉中市地税局");

            eb.setGroupMap(map);
            eb.setExcelTemplate("lzlghTd.xls"); //
            eb.setExcelXml("lzlghTd.xml"); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    @RequestMapping("exportExcelTj")
    public String exportExcelTj(HttpServletRequest request, String tag, Object param) throws Exception {
        try {
            HashMap queryFilter = null;
            try {
                queryFilter = (HashMap)param;
            } catch (Exception e){

            }
            TjBaseParamVo tjBaseParamVo = tjService.getTjBaseParam(tag);
            if (tjBaseParamVo == null) {
                return null;
            }
            String[] fieldList = tjBaseParamVo.getExportFieldList().split(",");
            List<HashMap> list = (List<HashMap>)tjService.getTjList(tag, queryFilter);
            List<String[]> retList = new ArrayList<String[]>(); // 组织参数
            for (int i = 0; i < list.size(); i++) {
                HashMap tempVo = list.get(i);
                if (tempVo != null) {
                    String[] strs = new String[fieldList.length];
                    for (int j = 0; j < fieldList.length; j++){
                        if (tempVo.get(fieldList[j].toString()) != null) {
                            strs[j] = tempVo.get(fieldList[j].toString()).toString();
                        } else if (fieldList[j].toString().equals("XH")) {
                            strs[j] = String.valueOf((i + 1));
                        }
                    }
                    retList.add(strs);
                }
            }

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            request.setAttribute("date", ""+new SimpleDateFormat("yyyy年MM月dd日").format(new Date()));
            request.setAttribute("year",""+new SimpleDateFormat("yyyy").format(new Date()));
            request.setAttribute("hzdw","汉中市地税局");

            eb.setGroupMap(map);
            eb.setExcelTemplate(tjBaseParamVo.getExcelTemplate()); //
            eb.setExcelXml(tjBaseParamVo.getExcelXml()); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    private List<String[]> getStrList(List<SwDjSyQuery> list) {
        List<String[]> retList = new ArrayList<String[]>();
        for (int i = 0; i < list.size(); i++) {
            SwDjSyQuery tempVo = list.get(i);
            if (tempVo != null) {
                String[] strs = new String[20];
                for (int j = 0; j < strs.length; j++) {
                    strs[j] = "";
                }
                strs[0] = String.valueOf(i + 1);

                if (StringUtils.isNotBlank(tempVo.getGlbm())) {
                    strs[1] = tempVo.getGlbm();
                }

                if (StringUtils.isNotBlank(tempVo.getNsrmc())) {
                    strs[2] = tempVo.getNsrmc();
                }
                if (StringUtils.isNotBlank(tempVo.getDjh())) {
                    strs[3] = tempVo.getDjh();
                }
                if (StringUtils.isNotBlank(tempVo.getDbh())) {
                    strs[4] = tempVo.getDbh();
                }
                if (StringUtils.isNotBlank(tempVo.getTdzl())) {
                    strs[5] = tempVo.getTdzl();
                }

                if (tempVo.getYnmj()!=null){
                    strs[7] = String.valueOf(tempVo.getYnmj());
                }
                if (StringUtils.isNotBlank(tempVo.getTddj())) {
                    strs[8] = tempVo.getTddj();
                }
                if (tempVo.getDwse()!=null) {
                    strs[9] = String.valueOf(tempVo.getDwse());
                }
                if (tempVo.getNynseTd()!=null) {
                    strs[10] = String.valueOf(tempVo.getNynseTd());
                }
                if (tempVo.getMsmj()!=null) {
                    strs[11] = String.valueOf(tempVo.getMsmj());
                }
                if (tempVo.getTddj()!=null) {
                    strs[12] = String.valueOf(tempVo.getTddj());
                }
                if (tempVo.getDwse()!=null) {
                    strs[13] = String.valueOf(tempVo.getDwse());
                }
                //计算strs[6]
                Double ynmj = 0.0;
                Double msmj = 0.0;
                if(StringUtils.isNotBlank(strs[7])){
                    ynmj =  Double.parseDouble(strs[7]);
                }
                if(StringUtils.isNotBlank(strs[11])){
                    msmj = Double.parseDouble(strs[11]);
                }
                strs[6] = String.valueOf(ynmj+msmj);

                //计算strs[14]
                Double dwse = 0.0;
                if(StringUtils.isNotBlank(strs[13])){
                    dwse = Double.parseDouble(strs[13]);
                }
                strs[14] = String.valueOf(msmj*dwse);

                strs[15] = "";
                strs[16] = "";
                strs[17] = "";

                if (StringUtils.isNotBlank(tempVo.getZgkgMc())) {
                    strs[18] = tempVo.getZgkgMc();
                }
                if (StringUtils.isNotBlank(tempVo.getSgyMc())){
                    strs[19]  =tempVo.getSgyMc();
                }
                retList.add(strs);
            }
        }

        return retList;
    }

    @RequestMapping("exportExceltdfcHcjdTj")
    public String exportExceltdfcHcjdTj(HttpServletRequest request, String beginRq, String endRq) throws Exception {
        try {
            List<HashMap> list = (List<HashMap>)tjService.tdfcHcjdTjJson(null, beginRq, endRq);
            List<String[]> retList = this.getStrListHashMap(list); // 组织参数

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            request.setAttribute("date", "汇总日期："+new SimpleDateFormat("yyyy年MM月dd日").format(new Date()));
            request.setAttribute("year","所属年份："+new SimpleDateFormat("yyyy").format(new Date()));

            eb.setGroupMap(map);
            eb.setExcelTemplate("tdfcHcjdTj.xls"); //
            eb.setExcelXml("tdfcHcjdTj.xml"); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    private List<String[]> getStrListHashMap(List<HashMap> list) {
        List<String[]> retList = new ArrayList<String[]>();
        for (int i = 0; i < list.size(); i++) {
            HashMap tempVo = list.get(i);
            if (tempVo != null) {
                String[] strs = new String[20];
                strs[0] = tempVo.get("DWMC").toString();
                strs[1] = tempVo.get("TDHCZHS").toString();
                strs[2] = tempVo.get("TDSBBSH").toString();
                strs[3] = tempVo.get("TDLZLGH").toString();
                strs[4] = tempVo.get("TDMJ").toString();
                strs[5] = tempVo.get("YSTDMJ").toString();
                strs[6] = tempVo.get("TDYNSE").toString();
                strs[7] = tempVo.get("TDNSE").toString();
                strs[8] = tempVo.get("FCHCZHS").toString();
                strs[9] = tempVo.get("FCSBBSH").toString();
                strs[10] = tempVo.get("FCLZLGH").toString();
                strs[11] = tempVo.get("FCYZ").toString();
                strs[12] = tempVo.get("ZJSR").toString();
                strs[13] = tempVo.get("FCYNSE").toString();
                strs[14] = tempVo.get("FCNSE").toString();
                retList.add(strs);
            }
        }

        return retList;
    }

    @RequestMapping("zhfx")
    public String zhfx(Model model) throws Exception{
        Map hylxMap = dicServiceImpl.buildEnumMap("Hylx");
        model.addAttribute("hylxMap",hylxMap);

        String regionCode = SessionUtil.getCurrentUser().getRegionCode();
        //获取所有区县信息
        List<SDmDwxxCz> allQxList = dwxxService.getAllQxList();
        List allSwjgList = new ArrayList();
        if(regionCode.length()==4){//市
            model.addAttribute("issj",true);
        }else if(regionCode.length()==6){//区县
            model.addAttribute("issj",false);
            allSwjgList = (List) taxService.getSgjgByQx(regionCode);
        }
        model.addAttribute("dwList",allQxList);
        model.addAttribute("swjgList",allSwjgList);
        //加载税源种类
        Map<String,Boolean> taxTypeConf =CommonUtil.getSyTypes();
        model.addAttribute("taxTypeConf",taxTypeConf);
        return "landtax/tj/hz/zhfx";

    }

    //税源分析，根据行业性质进行查询和统计
    @RequestMapping("hyxzFx")
    public String hyxzFx(Model model,String hydm,String sylx,String nf) throws Exception{

        List<Map<String,Object>> queryList = new ArrayList<Map<String,Object>>();
        List<String> queryHydmList = new ArrayList<String>();
        if(StringUtils.isNotBlank(hydm)){
            String[] queryHydmArr = hydm.split(",");
            queryList = (List) taxService.tjNynseByHylx(queryHydmArr, sylx,nf);
        }
        model.addAttribute("queryList",queryList);
        if(Sylx.TDSY.toString().equals(sylx)){
            return "landtax/tj/hz/tdHyxzFx";
        }else if(Sylx.FCSY.toString().equals(sylx)){
            return "landtax/tj/hz/fcHyxzFx";
        }
        return null;
    }

    @RequestMapping("hyxzFx/chart")
    @ResponseBody
    public Object hyxzFxChart(String hydm,String sylx,String nf) throws Exception{
        List<Map<String,Object>> queryList = new ArrayList<Map<String,Object>>();
        if(StringUtils.isNotBlank(hydm)){
            String[] queryHydmArr = hydm.split(",");
            if(Sylx.TDSY.toString().equals(sylx)){
                queryList = (List) taxService.tjNynseByHylx(queryHydmArr, Sylx.TDSY.toString(),nf);
            }else if(Sylx.FCSY.toString().equals(sylx)){
                queryList = (List) taxService.tjNynseByHylx(queryHydmArr, Sylx.FCSY.toString(),nf);
            }
        }
        Map resultMap = new HashMap();
        List<String> categoriesList = new ArrayList<String>();
        List series = new ArrayList();
        List nynseData = new ArrayList();
        List taxfinalData = new ArrayList();
        List qjseData = new ArrayList();
        for(Map tempMap : queryList){
            categoriesList.add(String.valueOf(tempMap.get("HY_MC")));
            nynseData.add(tempMap.get("SUMNYNSE"));
            taxfinalData.add(tempMap.get("SUMTAXFINAL"));
            qjseData.add(tempMap.get("QJSE"));
        }
        Map nynseMap = new HashMap();
        nynseMap.put("name","年应纳税额");
        nynseMap.put("data",nynseData);
        Map taxfinalMap = new HashMap();
        taxfinalMap.put("name","已纳税额");
        taxfinalMap.put("data",taxfinalData);
        Map qjseMap = new HashMap();
        qjseMap.put("name","欠缴税额");
        qjseMap.put("data",qjseData);

        series.add(nynseMap);
        series.add(taxfinalMap);
        series.add(qjseMap);

        resultMap.put("categories",categoriesList);
        resultMap.put("series",series);
        return resultMap;
    }


    //税源分析，根据行业性质进行查询和统计
    @RequestMapping("sgjgFx")
    public String sgjgFx(Model model,String sylx,String qx,String swjg,String nf) throws Exception{
        List<Map<String,Object>> queryList = new ArrayList<Map<String,Object>>();
        if(StringUtils.isNotBlank(qx)){
            String[] queryQx = qx.split(",");
            queryList = taxService.tjNynseByQx(sylx,queryQx,nf);
        }else if (StringUtils.isNotBlank(swjg)){
            String[] querySwjg = swjg.split(",");
            queryList = taxService.tjNynseByQx(sylx,querySwjg,nf);
        }

        model.addAttribute("queryList",queryList);
        return "landtax/tj/hz/tdSgjgFx";
    }

    @RequestMapping("sgjgFx/chart")
    @ResponseBody
    public Object sgjgFxChart(String qx,String swjg,String sylx,String nf) throws Exception{
        List<Map<String,Object>> queryList = new ArrayList<Map<String,Object>>();
        if(StringUtils.isNotBlank(qx)){
            String[] queryQx = qx.split(",");
            queryList = taxService.tjNynseByQx(sylx,queryQx,nf);
        }else if (StringUtils.isNotBlank(swjg)){
            String[] querySwjg = swjg.split(",");
            queryList = taxService.tjNynseByQx(sylx,querySwjg,nf);
        }

        Map resultMap = new HashMap();
        List<String> categoriesList = new ArrayList<String>();
        List series = new ArrayList();
        List nynseData = new ArrayList();
        List taxfinalData = new ArrayList();
        List qjseData = new ArrayList();
        for(Map tempMap : queryList){
            categoriesList.add(String.valueOf(tempMap.get("DWMC")));
            nynseData.add(tempMap.get("SUMNYNSE"));
            taxfinalData.add(tempMap.get("SUMTAXFINAL"));
            qjseData.add(tempMap.get("QJSE"));
        }
        Map nynseMap = new HashMap();
        nynseMap.put("name","年应纳税额");
        nynseMap.put("data",nynseData);
        Map taxfinalMap = new HashMap();
        taxfinalMap.put("name","已纳税额");
        taxfinalMap.put("data",taxfinalData);
        Map qjseMap = new HashMap();
        qjseMap.put("name","欠缴税额");
        qjseMap.put("data",qjseData);
        series.add(nynseMap);
        series.add(taxfinalMap);
        series.add(qjseMap);
        resultMap.put("categories",categoriesList);
        resultMap.put("series",series);
        return resultMap;
    }
    @RequestMapping("hyxzFx/piechart")
    @ResponseBody
    public Object hyxzFxPieChart(String hydm,String sylx,String nf,String setj) throws Exception{
        List<Map<String,Object>> queryList = new ArrayList<Map<String,Object>>();
        if(StringUtils.isNotBlank(hydm)){
            String[] queryHydmArr = hydm.split(",");
            if(Sylx.TDSY.toString().equals(sylx)){
                queryList = (List) taxService.tjNynseByHylx(queryHydmArr, Sylx.TDSY.toString(),nf);
            }else if(Sylx.FCSY.toString().equals(sylx)){
                queryList = (List) taxService.tjNynseByHylx(queryHydmArr, Sylx.FCSY.toString(),nf);
            }
        }


        Map resultMap = new HashMap();
        List series = new ArrayList();
        List hcseData = new ArrayList();

        Map hcseMap = new HashMap();
        for(Map tempMap : queryList){
            Map tjMap=new HashMap();
            tjMap.put("name", String.valueOf(tempMap.get("HY_MC")));

            if(setj.equals("nynse")){
                tjMap.put("y",tempMap.get("SUMNYNSE"));
                hcseMap.put("name","税源核查税额");
            }else if(setj.equals("zgnynse")){
                tjMap.put("y",tempMap.get("SUMTAXFINAL"));
                hcseMap.put("name","税源征管税额");
            }else if(setj.equals("zjmjse")){
                tjMap.put("y",tempMap.get("QJSE"));
                hcseMap.put("name","税源核查增加税额");
            }
            hcseData.add(tjMap);

        }
        hcseMap.put("data",hcseData);
        series.add(hcseMap);
        resultMap.put("series",series);
        return resultMap;
    }
    @RequestMapping("sgjgFx/piechart")
    @ResponseBody
    public Object sgjgFxPieChart(String qx,String swjg,String sylx,String nf,String setj) throws Exception{
        List<Map<String,Object>> queryList = new ArrayList<Map<String,Object>>();
        if(StringUtils.isNotBlank(qx)){
            String[] queryQx = qx.split(",");
            queryList = taxService.tjNynseByQx(sylx,queryQx,nf);
        }else if (StringUtils.isNotBlank(swjg)){
            String[] querySwjg = swjg.split(",");
            queryList = taxService.tjNynseByQx(sylx,querySwjg,nf);
        }

        Map resultMap = new HashMap();
        List series = new ArrayList();
        List hcseData = new ArrayList();

        Map hcseMap = new HashMap();
        for(Map tempMap : queryList){
            Map tjMap=new HashMap();
            tjMap.put("name", String.valueOf(tempMap.get("DWMC")));

            if(setj.equals("nynse")){
                tjMap.put("y",tempMap.get("SUMNYNSE"));
                hcseMap.put("name","税源核查税额");
            }else if(setj.equals("zgnynse")){
                tjMap.put("y",tempMap.get("SUMTAXFINAL"));
                hcseMap.put("name","税源征管税额");
            }else if(setj.equals("zjmjse")){
                tjMap.put("y",tempMap.get("QJSE"));
                hcseMap.put("name","税源核查增加税额");
            }
            hcseData.add(tjMap);

        }
        hcseMap.put("data",hcseData);
        series.add(hcseMap);
        resultMap.put("series",series);
        return resultMap;
    }
    //税源变化分析
    @RequestMapping("sybhFx")
    public String sybhFx(Model model,String sylx,String nf) throws Exception{

        List<Map<String,Object>> queryList = new ArrayList<Map<String,Object>>();
        if(StringUtils.isBlank(sylx)){
            sylx = Sylx.TDSY.toString();
        }
        if(StringUtils.isBlank(nf)){
            nf = String.valueOf(Calendar.getInstance().get(Calendar.YEAR));
        }

        queryList = taxService.tjSybhfx(sylx,nf);
        model.addAttribute("queryList",queryList);
        model.addAttribute("sylx",sylx);
        model.addAttribute("nf",nf);
        //加载税源种类
        Map<String,Boolean> taxTypeConf = CommonUtil.getSyTypes();
        model.addAttribute("taxTypeConf",taxTypeConf);
        return "landtax/tj/hz/tdSybhFx";

    }
    //税源变化分析
    @RequestMapping("sybhFxXq")
    public String sybhFxXq(Model model,String sylx,String nf) throws Exception{

        List<Map<String,Object>> queryList = new ArrayList<Map<String,Object>>();
        if(StringUtils.isBlank(sylx)){
            sylx = Sylx.TDSY.toString();
        }
        if(StringUtils.isBlank(nf)){
            nf = String.valueOf(Calendar.getInstance().get(Calendar.YEAR));
        }

        queryList = taxService.tjSybhfx(sylx,nf);
        model.addAttribute("queryList",queryList);
        model.addAttribute("sylx",sylx);
        model.addAttribute("nf",nf);

        return "landtax/tj/hz/sybhfxxq";

    }

    @RequestMapping("sybhFx/chart")
    @ResponseBody
    public Object sybhFxChart(Model model,String sylx,String nf) throws Exception{
        List<Map<String,Object>> queryList = new ArrayList<Map<String,Object>>();
        if(StringUtils.isBlank(sylx)){
            sylx = Sylx.TDSY.toString();
        }
        if(StringUtils.isBlank(nf)){
            nf = String.valueOf(Calendar.getInstance().get(Calendar.YEAR));
        }
        queryList = taxService.tjSybhfx(sylx,nf);

        Map resultMap = new HashMap();
        List<String> categoriesList = new ArrayList<String>();
        List series = new ArrayList();
        List nynseData = new ArrayList();
        List taxfinalData = new ArrayList();
        List qjseData = new ArrayList();
        for(Map tempMap : queryList){
            categoriesList.add(String.valueOf(tempMap.get("YF")));
            nynseData.add(tempMap.get("SUMYNSE"));
            taxfinalData.add(tempMap.get("SUMTAXFINAL"));
            qjseData.add(tempMap.get("QJSE"));
        }

        Map nynseMap = new HashMap();
        nynseMap.put("name","月应纳税额");
        nynseMap.put("data",nynseData);
        Map taxfinalMap = new HashMap();
        taxfinalMap.put("name","月已纳税额");
        taxfinalMap.put("data",taxfinalData);
        Map qjseMap = new HashMap();
        qjseMap.put("name","欠缴税额");
        qjseMap.put("data",qjseData);
        series.add(nynseMap);
        series.add(taxfinalMap);
        series.add(qjseMap);
        resultMap.put("categories",categoriesList);
        resultMap.put("series",series);
        return resultMap;
    }

    /**
     * 税收贡献率
     * @param model
     * @return
     */
    @RequestMapping("ssgxl")
    public String ssgxl(Model model){
        return "landtax/tj/ssgxl/ssgxl";
    }

    @RequestMapping("ssgxlJson")
    @ResponseBody
    public Page ssgxlJson(Model model, Pageable request, String nsrsbh, String year) {
        return tjService.getSsgxlJson(request, nsrsbh, year);
    }

    @RequestMapping("ssgxlExport")
    public String ssgxlExport(Model model, HttpServletRequest request, String nsrsbh, String year) {
        try {
            HashMap param = new HashMap();
            List<HashMap<String, Object>> tempList= tjService.getAllSsgxl(nsrsbh, year);
            List<String[]> retList = new ArrayList<String[]>();
            for (int i = 0; i < tempList.size(); i++) {
                HashMap tempMap = tempList.get(i);
                String[] strs = new String[5];
                for (int j = 0; j < strs.length; j++) {
                    strs[j] = "";
                }
                strs[0] = String.valueOf(i + 1);
                strs[1] = String.valueOf(tempMap.get("NSRSBH"));
                strs[2] = String.valueOf(tempMap.get("NSRMC"));
                strs[3] = String.valueOf(tempMap.get("SSNF"));
                strs[4] = String.valueOf((BigDecimal)tempMap.get("GXL"));
                retList.add(strs);
            }

            //取出workProceedTbtj.xls文件，然后拼接标题
            String title = year + "年" + (StringUtils.isNotBlank(nsrsbh)?("社会信用代码"+nsrsbh):"") + "税收贡献率";

            //打开文件
            Workbook workbook = Workbook.getWorkbook(new File(request.getRealPath("/" + "static\\excel\\template") + "\\" + "ssgxl.xls"));
            //打开一个文本的副本，并指定数据写回到源文件
            WritableWorkbook writableWorkbook = Workbook.createWorkbook(new File(request.getRealPath("/" + "static\\excel\\template") + "\\" + "ssgxl.xls"), workbook);
            //获取第一张Sheet表
            WritableSheet writableSheet = writableWorkbook.getSheet(0);

            //获取标题的格式
            WritableCell cell = writableSheet.getWritableCell(1, 1);
            CellFormat cf = cell.getCellFormat();
            //修改标题的内容
            Label label = new Label(1, 1, title);
            label.setCellFormat(cf);
            writableSheet.addCell(label);

            writableWorkbook.write();
            writableWorkbook.close();

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate("ssgxl.xls");
            eb.setExcelXml("ssgxl.xml"); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    /**
     * 税收贡献率统计图表
     * @param model
     * @return
     */
    @RequestMapping("ssgxlTj")
    @ResponseBody
    public Object ssgxlTj(Model model, String hyDm, String year) {
        List<HashMap<String,Object>> queryList = tjService.getSsgxlTjJson(hyDm, year);
        Map resultMap = new HashMap();
        List<String> categoriesList = new ArrayList<String>();
        List series = new ArrayList();
        List nynseData = new ArrayList();
        List taxfinalData = new ArrayList();
        List qjseData = new ArrayList();
        for(Map tempMap : queryList){
            categoriesList.add(String.valueOf(tempMap.get("HY_MC")));
            nynseData.add(tempMap.get("NSE"));
            taxfinalData.add(tempMap.get("YNMJ"));
            qjseData.add(tempMap.get("GXL"));
        }
//        Map nynseMap = new HashMap();
//        nynseMap.put("name","已纳税额");
//        nynseMap.put("data",nynseData);
//        Map taxfinalMap = new HashMap();
//        taxfinalMap.put("name","应纳面积");
//        taxfinalMap.put("data",taxfinalData);
        Map qjseMap = new HashMap();
        qjseMap.put("name","税收贡献率");
        qjseMap.put("data",qjseData);

//        series.add(nynseMap);
//        series.add(taxfinalMap);
        series.add(qjseMap);

        resultMap.put("categories",categoriesList);
        resultMap.put("series",series);
        return resultMap;
    }

    /**
     * 税收贡献率统计报表
     * @param model
     * @return
     */
    @RequestMapping("ssgxlTjJson")
    public Object ssgxlTjJson(Model model, String hyDm, String year) {
        List<HashMap<String,Object>> queryList = tjService.getSsgxlTjJson(hyDm, year);
        model.addAttribute("queryList", queryList);
        return "landtax/tj/hz/sslgxbb";
    }

    /**
     * 税收贡献率初始界面
     * @param model
     * @return
     */
    @RequestMapping("hysygxl")
    public String hysygxl(Model model) {
        Map hylxMap = null;
        try {
            hylxMap = dicServiceImpl.buildEnumMap("Hylx");
        } catch (Exception e) {
            e.printStackTrace();
        }
        model.addAttribute("hylxMap",hylxMap);

        String regionCode = SessionUtil.getCurrentUser().getRegionCode();
        //获取所有区县信息
        List<SDmDwxxCz> allQxList = dwxxService.getAllQxList();
        List allSwjgList = new ArrayList();
        if(regionCode.length()==4){//市
            model.addAttribute("issj",true);
        }else if(regionCode.length()==6){//区县
            model.addAttribute("issj",false);
            allSwjgList = (List) taxService.getSgjgByQx(regionCode);
        }
        model.addAttribute("dwList",allQxList);
        model.addAttribute("swjgList",allSwjgList);
        //加载税源种类
        Map<String,Boolean> taxTypeConf = null;
        try {
            taxTypeConf = CommonUtil.getSyTypes();
        } catch (Exception e) {
            e.printStackTrace();
        }
        model.addAttribute("taxTypeConf",taxTypeConf);
        return "landtax/tj/hz/syltj";
    }
    @RequestMapping("syList")
    public String taxSourceList(Model model,String dwdm,String tag)throws Exception {
        //宗地定位
        model.addAttribute("dw","true");

        model.addAttribute("sycx","true");

        //获取所有区县信息
        List<SDmDwxxCz> allQxList = dwxxService.getAllQxList();
        model.addAttribute("allQxList",allQxList);

        //加载税源种类
        Map<String,Boolean> taxTypeConf =CommonUtil.getSyTypes();
        model.addAttribute("taxTypeConf",taxTypeConf);
        model.addAttribute(ObjectValueManager.LOAD_FCS,taxTypeConf.get(ObjectValueManager.LOAD_FCS)?"true":"false");
        model.addAttribute("dwdm",dwdm);
        model.addAttribute("tag",tag);
        return "landtax/tj/hz/sytz";

    }
    @RequestMapping("syJson")
    @ResponseBody
    public Object getSwdjSy(Model model,Pageable request,String sylx,SwDjSyQuery swDjSyQuery,String isGkq) {
        if (StringUtils.isBlank(sylx)) {
            sylx = Sylx.TDSY.toString();
        }
        if (Sylx.TDSY.toString().equals(sylx)) {
            //工矿区
            if ("1".equals(isGkq)) {
                swDjSyQuery.setIsGkq("1");
            }
            return taxService.findSwdjTdWbdMap(swDjSyQuery, request);
        } else if (Sylx.FCSY.toString().equals(sylx)) {
            return taxService.findSwdjFcMap(swDjSyQuery, request);
        }
        return null;
    }
    @RequestMapping("zdList")
    public String zdList(Model model,String dwdm,String tag)throws Exception {
        model.addAttribute("dwdm",dwdm);
        model.addAttribute("tag",tag);
        return "landtax/tj/hz/zdList";

    }
    @RequestMapping("zdJson")
    @ResponseBody
    public Object getZd(Model model,Pageable request,ZdQuery zdQuery) {
        return taxService.findZdList(zdQuery, request);
    }
    @RequestMapping("exportExcelSyTz")
    public String exportExcelSyTz(String sylx,SwDjSyQuery swDjSyQuery,String ids,HttpServletRequest request,String isGkq) throws Exception {
        if("1".equals(isGkq)){
            swDjSyQuery.setIsGkq("1");
        }
        try {
            HashMap param = new HashMap();
            param.put("sylx",sylx);
            // 判断是checkbox导出，还是查询导出
            if (StringUtils.isNotBlank(ids)) {
                // 说明是checkbox导出
                param.put("ids",ids);
                param.put("swDjSyQuery",swDjSyQuery);
            } else {
                param.put("swDjSyQuery",swDjSyQuery);
            }
            String excelBegin = swDjSyQuery.getExcelBegin();
            if(StringUtils.isBlank(excelBegin)){
                excelBegin = "0";
            }else{
                excelBegin = String.valueOf(Integer.parseInt(excelBegin)-1);
            }
            List<SwDjSyQuery> swdjTzList = taxService.getTdSyTzList(param);
            List<String[]> retList = new ArrayList<String[]>();
            for(int i=(0+Integer.parseInt(excelBegin));i<(swdjTzList.size()+Integer.parseInt(excelBegin));i++){
                String[] tempArr = new String[20];
                for(int j=0;j<tempArr.length;j++){
                    tempArr[j] = "";
                }
                SwDjSyQuery temp = swdjTzList.get(i-Integer.parseInt(excelBegin));
                if(sylx.equals(Sylx.TDSY.toString())) {
                    tempArr[0] = String.valueOf(i + 1 - Integer.parseInt(excelBegin));
                    tempArr[1] = temp.getDjh();
                    tempArr[2] = temp.getNsrsbh();
                    tempArr[3] = temp.getNsrmc();
                    tempArr[4] = temp.getTdzl();
                    tempArr[5] = String.valueOf(temp.getScmjZd());

                    tempArr[6] = String.valueOf(temp.getScmj());
                    tempArr[7] = String.valueOf(temp.getMsmj());
                    tempArr[8] = String.valueOf(temp.getYnmj());
                    tempArr[9] = String.valueOf(temp.getDwse());
                    tempArr[10] = String.valueOf(temp.getMsse());
                    tempArr[11] = String.valueOf(temp.getNynseTd());

                    tempArr[12] = temp.getZgkgMc();
                    tempArr[13] = temp.getSgyMc();
                    String sgztDm = temp.getSgztDm();
                    tempArr[14] = Sgzt.getMcByDm(sgztDm);
                    String tdyt = temp.getTdsyytDm();
                    tempArr[15] = Tdyt.getMcByDm(tdyt);
                } else if(sylx.equals(Sylx.FCSY.toString())) {
                    tempArr[0] = String.valueOf(i + 1);
                    tempArr[1] = temp.getDjh();
                    tempArr[2] = temp.getNsrsbh();
                    tempArr[3] = temp.getNsrmc();
                    tempArr[4] = temp.getFczl();

                    tempArr[5] = String.valueOf(temp.getFcyz());
                    tempArr[6] = String.valueOf(temp.getFcyzYs());
                    tempArr[7] = String.valueOf(temp.getFcyzMs());
                    tempArr[8] = String.valueOf(temp.getYnseZy());
                    tempArr[9] = String.valueOf(temp.getNzj());
                    tempArr[10] = String.valueOf(temp.getSl());
                    tempArr[11] = String.valueOf(temp.getYnseCz());
                    tempArr[12] = String.valueOf(temp.getNynseFc());

                    tempArr[13] = temp.getZgkgMc();
                    tempArr[14] = temp.getSgyMc();
                    String sgztDm = temp.getSgztDm();
                    tempArr[15] = Sgzt.getMcByDm(sgztDm);
                    String fcyt = temp.getFwxzDm();
                    tempArr[16] = Fwxz.getMcByDm(fcyt);
                } else if(sylx.equals(Sylx.GDZYS.toString())) {
                    tempArr[0] = String.valueOf(i + 1);
                    tempArr[1] = temp.getNsrsbh();
                    tempArr[2] = temp.getNsrmc();
                    tempArr[3] = temp.getZgkgMc();
                    tempArr[4] = temp.getPcmc();
                    tempArr[5] = temp.getPwh();
                    tempArr[6] = temp.getPzmj()==null?"":String.valueOf(temp.getPzmj().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[7] = temp.getNydmj()==null?"":String.valueOf(temp.getNydmj().setScale(2, BigDecimal.ROUND_HALF_UP));
                    tempArr[8] = temp.getPzsj()==null?"":new SimpleDateFormat("yyyy-MM-dd").format(temp.getPzsj());
                    tempArr[9] = temp.getPcYddw();
                    tempArr[10] = temp.getGdzysYnse()==null?"":String.valueOf(temp.getGdzysYnse().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[11] = temp.getGdzysDwse()==null?"":String.valueOf(temp.getGdzysDwse().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[12] = temp.getGdzysJspz();
                    tempArr[13] = temp.getGdzysYjne()==null?"":String.valueOf(temp.getGdzysYjne().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[14] = temp.getGdzysXbjse()==null?"":String.valueOf(temp.getGdzysXbjse().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[15] = temp.getGdzysBz();

                } else if(sylx.equals(Sylx.QS.toString())) {
                    tempArr[0] = String.valueOf(i + 1);
                    tempArr[1] = temp.getNsrsbh();
                    tempArr[2] = temp.getNsrmc();
                    tempArr[3] = temp.getZgkgMc();
                    tempArr[4] = temp.getXmmc();
                    tempArr[5] = temp.getXmYddw();
                    tempArr[6] = temp.getGdmj()==null?"":String.valueOf(temp.getGdmj().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[7] = Tdqdfs.getMcByDm(temp.getQdfs());
                    tempArr[8] = temp.getQdjg()==null?"":String.valueOf(temp.getQdjg().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[9] = temp.getGdsj()==null?"":new SimpleDateFormat("yyyy-MM-dd").format(temp.getGdsj());
                    tempArr[10] = temp.getQsYnse()==null?"":String.valueOf(temp.getQsYnse().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[11] = temp.getQsYjne()==null?"":String.valueOf(temp.getQsYjne().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[12] = temp.getQsJspz();
                    tempArr[13] = temp.getQsXbjse()==null?"":String.valueOf(temp.getQsXbjse().setScale(2,BigDecimal.ROUND_HALF_UP));
                    tempArr[14] = temp.getQsBz();
                }
                retList.add(tempArr);
            }

            String excelTemplate = "";
            String excelXml = "";
            if(sylx.equals(Sylx.TDSY.toString())) {
                excelTemplate = "sybjTz_td.xls";
                excelXml = "sybjTz_td.xml";
            } else if(sylx.equals(Sylx.FCSY.toString())) {
                excelTemplate = "sybjTz_fc.xls";
                excelXml = "sybjTz_fc.xml";
            } else if(sylx.equals(Sylx.GDZYS.toString())) {
                excelTemplate = "sybjTz_gdzys.xls";
                excelXml = "sybjTz_gdzysQs.xml";
            } else if(sylx.equals(Sylx.QS.toString())) {
                excelTemplate = "sybjTz_qs.xls";
                excelXml = "sybjTz_Qs.xml";
            }

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate(excelTemplate); //
            eb.setExcelXml(excelXml); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }
    @RequestMapping("exportExcelZdTz")
    public String exportExcelZdTz(ZdQuery zdQuery,String ids,HttpServletRequest request) throws Exception {
        try {
            HashMap param = new HashMap();

            // 判断是checkbox导出，还是查询导出
            if (StringUtils.isNotBlank(ids)) {
                // 说明是checkbox导出
                param.put("ids",ids);
                param.put("zdQuery",zdQuery);
            } else {
                param.put("zdQuery",zdQuery);
            }
            List<Object> zdList = taxService.getZdList(param);
            List<String[]> retList = new ArrayList<String[]>();
            for(int i=0;i<zdList.size();i++){
                String[] tempArr = new String[6];
                for(int j=0;j<tempArr.length;j++){
                    tempArr[j] = "";
                }
                Object[] obj = (Object[]) zdList.get(i);
                tempArr[0] = String.valueOf(i+1);
                for(int k=1;k<tempArr.length;k++){
                    tempArr[k] = String.valueOf(obj[k-1]);
                }
                retList.add(tempArr);
            }

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);
            eb.setExcelTemplate("zdList.xls"); //
            eb.setExcelXml("zdList.xml"); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }
}
