package cn.gtmap.landtax.web.tj;

import cn.gtmap.landtax.entity.SDmDwxxCz;
import cn.gtmap.landtax.model.dictionary.Hcxmlx;
import cn.gtmap.landtax.model.query.GtSwTzQuery;
import cn.gtmap.landtax.printexcel.access.ExcelBean;
import cn.gtmap.landtax.util.WorkFlowXmlUtil;
import com.gtis.config.AppConfig;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import cn.gtmap.landtax.service.*;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by wgy on 2017/10/23.
 */
@Controller
@RequestMapping("/tj/hcjd/taiZhou")
public class HcjdControllerTaiZhou {
    @Autowired
    HcjdServiceTaiZhou hcjdServiceTaiZhou;
    @Autowired
    DwxxService dwxxService;
    @Autowired
    ZdhcService zdhcService;

    @RequestMapping("")
    public String hcjdTaiZhou(Model model,String hcxmlx,String minMj,String maxMj){
        model.addAttribute("hcxmlx",hcxmlx);

        if(Hcxmlx.ZDHC.toString().equals(hcxmlx)){
            if(StringUtils.isNotEmpty(minMj)){
                model.addAttribute("minMj",minMj);
            }
            if(StringUtils.isNotEmpty(maxMj)){
                model.addAttribute("maxMj",maxMj);
            }
            return "landtax/tj/hcjd/hcjdSwdjhcTaiZhou";
        }else {
            return "landtax/tj/hcjd/hcjdSwdjhcTaiZhouSwdj";
        }
    }

    @RequestMapping("getTreeJson")
    @ResponseBody
    public Object getTreeJson(Model model,String id,String hcxmlx,String minMj,String maxMj){
        Object obj = hcjdServiceTaiZhou.hcjdTreeJson(id,hcxmlx,minMj,maxMj);
        return obj;
    }

    @RequestMapping("hcjdDetail")
    public String hcjdDetail(Model model,String organId,String jdlx,String hcxmlx,String minMj,String maxMj) throws  Exception{
        model.addAttribute("organId",organId);
        model.addAttribute("jdlx",jdlx);
        model.addAttribute("hcxmlx",hcxmlx);
        //获取所有区县信息
        List<SDmDwxxCz> allQxList = dwxxService.getUserQxList();
        model.addAttribute("allQxList",allQxList);

        if(Hcxmlx.ZDHC.toString().equals(hcxmlx)){//国土宗地核查
            if(StringUtils.isNotEmpty(minMj)){
                model.addAttribute("minMj",minMj);
            }
            if(StringUtils.isNotEmpty(maxMj)){
                model.addAttribute("maxMj",maxMj);
            }
            return "landtax/tj/hcjd/zdhcHcjdDetailTaiZhou";
        }else {//税务登记核查
            return "landtax/tj/hcjd/swdjhcHcjdDetailTaiZhou";
        }

    }

    @RequestMapping("hcjdDetailJson")
    @ResponseBody
    public Object hcjdDetailJson(Model model,String organId,String jdlx,String hcxmlx,Pageable pageable,GtSwTzQuery gtSwTzQuery,String minMj,String maxMj){
        return hcjdServiceTaiZhou.getHcjdDetail(organId, jdlx,hcxmlx, pageable,gtSwTzQuery,minMj,maxMj);

    }

    /*
    * 宗地核查导出Excel
    * */
    @RequestMapping("zdhc/exportExcelTz")
    public String exportExcelTzZdhc(String organId,String jdlx,GtSwTzQuery sSjGtbd,HttpServletRequest request,String minMj,String maxMj) throws Exception {
        try {
            //key: 节点定义ID， value：节点名称   获取流程Map
            Map<String, String> activityMap = this.getActivityMap();

            HashMap param = new HashMap();
            // 判断是checkbox导出，还是查询导出
            List<HashMap> whczdList = hcjdServiceTaiZhou.getHcjdDetailZdhcList(organId,jdlx,sSjGtbd,minMj,maxMj);
            List<String[]> retList = new ArrayList<String[]>();
            String excelBegin = sSjGtbd.getExcelBegin();
            if(StringUtils.isBlank(excelBegin)){
                excelBegin = "0";
            }else{
                excelBegin = String.valueOf(Integer.parseInt(excelBegin)-1);
            }
            for(int i=(0+Integer.parseInt(excelBegin));i<(whczdList.size()+Integer.parseInt(excelBegin));i++){
                String[] tempArr = new String[13];
                for(int j=0;j<tempArr.length;j++){
                    tempArr[j] = "";
                }
                HashMap tempMap = whczdList.get(i-Integer.parseInt(excelBegin));
                tempArr[0] = String.valueOf(i + 1);
                tempArr[1] = String.valueOf(tempMap.get("DJH")==null?"":tempMap.get("DJH"));
                tempArr[2] = new BigDecimal(String.valueOf(tempMap.get("SCMJ") == null ? "0" : tempMap.get("SCMJ"))).setScale(2, BigDecimal.ROUND_DOWN).toString();
                tempArr[3] = String.valueOf(tempMap.get("TDYTMC")==null?"":tempMap.get("TDYTMC"));
                tempArr[4] = String.valueOf(tempMap.get("TDZL") == null ? "" : tempMap.get("TDZL"));
                tempArr[5] = String.valueOf(tempMap.get("QLRMC") == null ? "" : tempMap.get("QLRMC"));
                //根据gtbdId获取任务节点
                String statue = String.valueOf(((HashMap)zdhcService.getZtByGtbdId(String.valueOf(tempMap.get("GTBD_ID")))).get("statue"));
                if(activityMap.containsKey(statue)){
                    tempArr[6] = activityMap.get(statue);
                }

                String userName = String.valueOf(((HashMap) zdhcService.getZtByGtbdId(String.valueOf(tempMap.get("GTBD_ID")))).get("userName"));
                tempArr[7] = userName;
                //暂时未对已退回节点写特殊的查询逻辑
                /*if(jdlx.equals("4")) {
                    String rwId = String.valueOf(tempMap.get("RW_ID"));
                    List<HashMap<String, Object>> thyjList = hcxmService.findThyj(rwId, xzqdm);
                    List<HashMap<String,Object>> thuser=hcxmService.findUsers(rwId);
                    Object obj1 = thuser.get(0);
                    HashMap map1 = (HashMap)obj1;
                    String thsws=String.valueOf(map1.get("THSWS"));
                    if(thsws.equals("null")){
                        thsws="";
                    }
                    String thqx=String.valueOf(map1.get("THQX"));
                    if(thqx.equals("null")){
                        thqx="";
                    }
                    String remark = "";
                    for (int j = 0; j < thyjList.size(); j++) {
                        Object obj = thyjList.get(j);
                        HashMap map = (HashMap) obj;
                        if (!String.valueOf(map.get("REMARK")).equals("null")) {
                            remark += String.valueOf(map.get("USER_NAME")) + "：" + String.valueOf(map.get("REMARK")) + "； ";
                            break;
                        }
                    }
                    tempArr[8]=thsws;
                    tempArr[9]=thqx;
                    tempArr[10]=remark;

                }*/
                retList.add(tempArr);
            }

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            ExcelBean eb = new ExcelBean();
            map.put("group1", retList);// 把retList放入group1中
            eb.setGroupMap(map);

            eb.setExcelTemplate("wppzdTz.xls"); //
            eb.setExcelXml("wppzdTz.xml"); // 上述两步骤是把xml文件和xls文件有机组合

            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    private Map<String, String> getActivityMap() throws Exception{
        String workflowDefinId = AppConfig.getProperty("sszd");
        List activityList = WorkFlowXmlUtil.getActivityListByWorkDefinId(workflowDefinId);
        //key: 节点定义ID， value：节点名称
        Map<String, String> activityMap = new HashMap<String, String>();
        activityMap.put("wxf", "未下发");
        activityMap.put("ybj", "已办结");
        //流程节点
        for(Object activityObj : activityList){
            HashMap map = (HashMap)activityObj;
            String activityDefinitionId = (String)map.get("activityDefinitionId");
            String activityName = (String)map.get("activityName");
            activityMap.put(activityDefinitionId, activityName);
        }
        return activityMap;
    }

}
