package cn.gtmap.landtax.web.tj;
/*
 * @author <a href="mailto:wangzhengqing@gtmap.cn">wangzhengqing</a>
 * @version 1.0, 2016/4/23 0023
 * @description 
 */

import cn.gtmap.landtax.service.CzfxxService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang.StringUtils;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.persistence.Query;
import java.util.HashMap;
import java.util.List;

@Controller
@RequestMapping("/tj/cz/")
public class CzfxxcxController {
    @Autowired
    CzfxxService czfxxService;
    @Autowired
    BaseRepository baseRepository;

    String fcszdSql = "select djh,count(djh) a,sum(t1.nzj) nzj,sum(t1.ynse_cz) ynse_cz,t1.sl\n" +
            "        from sw_dj_sy t2 \n" +
            "       left join sw_dj_fc t1 on t1.sy_id=t2.sy_id  \n" +
            "       where t1.nzj is not null and t1.nzj != 0 and  t1.ynse_cz is not null and t1.ynse_cz != 0 \n" +
            "        group by t2.djh,t1.sl\n" +
            "        order by nzj desc";

    @RequestMapping("xxll")
    public String xxll(Model model) {
        //czfxxService.czf();
        model.addAttribute("zdlx", 2);
        return "landtax/tj/czfxx/czfxxDetail";
    }

    @RequestMapping("czfxxJson")
    @ResponseBody
    public Object czfJson(Model model, Pageable pageable) {
        //String sql = getHcjdDetailZdhcSql(xzqdm, configArr, flag, isSgy, jdlx, sSjGtbd, true);
        String sql = "select t1.nzj,t1.ynse_cz,t2.nsrsbh,t2.nsrmc,t2.jbb_id,t3.sgzt_dm,t4.djh" +
                " from sw_dj_fc t1\n" +
                "left join sw_dj_jbb t2 on t1.jbb_id = t2.jbb_id " +
                "left join sw_dj_td t3 on t3.sy_id=t1.sy_id\n " +
                "left join sw_dj_sy t4 on t1.sy_id=t4.sy_id\n" +
                " order by t1.nzj desc";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        StringBuffer countSql = new StringBuffer("select count(*) from (").append(sql).append(")");
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql.toString());
        Page page = baseRepository.find(query, countQuery, pageable);
        return page;
    }

    @RequestMapping("zlsf")
    public String zlsf(Model model, String pjyzjsr, String jbbid, String czjzfcs) {
        model.addAttribute("jbbid", jbbid);
        model.addAttribute("pjyzjsr", pjyzjsr);
        model.addAttribute("czjzfcs", czjzfcs);

        return "landtax/tj/czfxx/zlsfDetail";
    }

    @RequestMapping("zlsfJson")
    @ResponseBody
    public String zlsfJson(Model model, String pjyzjsr, String jbbid, String czjzfcs, String sgzt_dm, String nsrmc, String djh) {
        double pjyzj = Double.parseDouble(pjyzjsr);//月租金
        double yys = 0;//营业税
        double yys_sl = 0;//营业税税率
        if (StringUtils.isEmpty(sgzt_dm)) {
            if (StringUtils.equals(sgzt_dm, "05") ||
                    (StringUtils.equals(sgzt_dm, "02") && (nsrmc.contains("公司") || nsrmc.contains("厂") || nsrmc.contains("股份制"))) ||
                    (StringUtils.equals(sgzt_dm, "01") && (nsrmc.contains("公司") || nsrmc.contains("厂") || nsrmc.contains("股份制")))
                    )

            {
                yys_sl = 0.05;
                yys = pjyzj * yys_sl;//营业税（企业或者机关）
            } else {
                yys_sl = 0.03;
                yys = (pjyzj * yys_sl) / 2;//营业税（个人）
            }
        }
        double cjs = 0;//城建税
        double cjs_sl = 0;//城建税税率
        if (StringUtils.isNotEmpty("djh")) {
            if (StringUtils.startsWith(djh, "61070200")) {
                cjs_sl = 0.07;
                cjs = yys * cjs_sl;//市区
            } else {
                cjs_sl = 0.05;
                cjs = yys * cjs_sl;
            }
        }
        double jyffj = yys * 0.03;//教育费附加
        double fcs = Double.parseDouble(czjzfcs) / 12;//读过来的是年房产税，转换成月的
        double yhs = pjyzj * 0.001;//印花税
        double grsdsJs = pjyzj - (yys + cjs + jyffj + fcs + yhs) - 800;
        double grsds = grsdsJs * 0.1;//个人所得税
        double hj = yys + cjs + jyffj + fcs + yhs + grsds;//合计

        HashMap map = new HashMap();
        map.put("pjyzj", pjyzj);//月租金
        map.put("yys", yys);
        map.put("cjs", cjs);
        map.put("cjs_sl", cjs_sl);//城建税税率
        map.put("jyffj", jyffj);
        map.put("yys", yys);
        map.put("yys_sl", yys_sl);
        map.put("fcs", fcs);
        map.put("yhs", yhs);
        map.put("grsds", grsds);
        map.put("grsdsJs", grsdsJs);
        map.put("hj", hj);

        return JSON.toJSONString(map);
    }

    @RequestMapping("fcszd")
    public String zlsf(Model model) {
        return "landtax/tj/czfxx/fcszdDetail";
    }

    @RequestMapping("fcszdJson")
    @ResponseBody
    public Object fcszdJson(Model model, Pageable pageable) {
        //String sql = getHcjdDetailZdhcSql(xzqdm, configArr, flag, isSgy, jdlx, sSjGtbd, true);

        Query query = baseRepository.getEntityManager().createNativeQuery(fcszdSql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        StringBuffer countSql = new StringBuffer("select count(*) from (").append(fcszdSql).append(")");
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql.toString());
        Page page = baseRepository.find(query, countQuery, pageable);
        return page;
    }

    @RequestMapping("fcszdSum")
    @ResponseBody
    public String fcszdSum(Model model) {
        String sql1 = "select sum(nzj) as nzjSum,sum(ynse_cz) as ynse_czSum from (" + fcszdSql + " )";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql1);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        Object resultmap = query.getSingleResult();
        return JSON.toJSONString(resultmap);
    }

    @RequestMapping("czfTree")
    public String czfTree(Model model) {

        return "landtax/tj/czfxx/synCzf";
    }

    @RequestMapping("czfTreeRootJson")
    @ResponseBody
    public Object czfTreeRootJson(Model model, String hcxmlx, String id) {
        Object obj = czfxxService.syncHcjdRootJson(hcxmlx, id);
        return obj;
    }


}
