package cn.gtmap.landtax.web.syhc;

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.*;
import cn.gtmap.landtax.model.query.GtSwTzQuery;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.model.query.ZdQuery;
import cn.gtmap.landtax.print.XMLBuildHelper;
import cn.gtmap.landtax.printexcel.access.ExcelBean;
import cn.gtmap.landtax.service.*;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import cn.gtmap.landtax.util.CommonUtil;
import cn.gtmap.landtax.util.ObjectValueManager;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.util.BeanUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 税源登记匹配台账
 * <p/>
 *
 * @author yang
 * @version V1.0, 14-7-5
 */
@Controller
@RequestMapping("/swdjtz")
public class SwdjtzController {
    @Autowired
    SwdjtzService swdjtzService;
    @Autowired
    ZdService zdService;
    @Autowired
    TaxService taxService;
    @Autowired
    HcxmService hcxmService;
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    SysUserService sysUserService;
    @Autowired
    DwxxService dwxxService;
    @Autowired
    ZdhcService zdhcService;
    //未匹配走流程列表
    @RequestMapping("")
    public String   swdjwpplist(Model model,String xzq)throws Exception{
        //加载税源种类
        Map<String,Boolean> taxTypeConf = CommonUtil.getSyTypes();
        if(taxTypeConf.get(ObjectValueManager.LOAD_FCS)){
            model.addAttribute("loadJSON","swdjwpplist_wppConFc");
        }else{
            model.addAttribute("loadJSON","swdjwpplist_wpp");
        }
        UserInfo userInfo = SessionUtil.getCurrentUser();
        if(userInfo!=null){
            String regionCode = userInfo.getRegionCode();
            model.addAttribute("regionCode",regionCode);
        }
        String regionCode = SessionUtil.getCurrentUser().getRegionCode();
        if(regionCode.length()>6){
            regionCode=regionCode.substring(0,6);
        }
        List<Zgswjg> zgkgList=dwxxService.getZgkgByRegionCode(regionCode);
        model.addAttribute("zgkgList",zgkgList);
        List<SDmSwjdxz> jdxzList=dwxxService.getJdByRegion(regionCode);
        model.addAttribute("jdxzList",jdxzList);
        zdhcService.isShowBtnByRoleName("gdhcDelBtnRoleName","gdhcAutoCreRoleName","swdjhcCreateRoleName",model);
        return "landtax/syhc/sypptz/swdjwpplist";
    }

    @RequestMapping("swdjYxfList")
    public String   swdjYxfList(Model model){
        return "landtax/syhc/sypptz/swdjYxfList";
    }

    //税源已匹配列表
    @RequestMapping("swdjsjypp")
    public String   swdjypp(Model model,String xzq,String lx){
        model.addAttribute("xzq",xzq);
        model.addAttribute("lx",lx);
        return "landtax/syhc/sypptz/swdjsjypp";
    }
    //税源未匹配列表
    @RequestMapping("swdjsjwpp")
    public String   swdjwpp(Model model,String xzq,String lx){
        model.addAttribute("xzq",xzq);
        model.addAttribute("lx",lx);
        return "landtax/syhc/sypptz/swdjsjwpp";
    }

    @RequestMapping("sydj")
    public String getSydj(){
        return  "landtax/syhc/swdjsjNew";
    }
     //匹配登记台账
    @RequestMapping("tz")
    public String   tz(Model model,String lx){
        if (lx.equals("1")){
            return "landtax/syhc/sypptz/swdjtz";
        }else if(lx.equals("2")){
            return "landtax/syhc/sypptz/swdjtzFc";
        }
        return "" ;
    }


    //匹配登记台账
    @RequestMapping("projecttz")
    public String   projecttz(Model model){
        return "landtax/syhc/sypptz/swdjprojecttz";
    }

    @RequestMapping("projecttzJson")
    @ResponseBody
    public Object projectTzJson(Model model,String xzq){
        return swdjtzService.getProjectSwtzJson(xzq, new StringBuffer());
    }

    @RequestMapping("tzJson")
    @ResponseBody
    public Object getTz(Model model,String xzq,String lx){
        //土地税务登记台帐统计
          return swdjtzService.getSwtzJson(xzq,new StringBuffer(),lx);
    }


    @RequestMapping("ppxxJson")
    @ResponseBody
    public Page<SSjSwbd> getSwdjSy(Model model,String xzqbh,String lx,String lxs,Pageable request,SwDjSyQuery swDjSyQuery) {
        Sylx sylx=null;
        if(StringUtils.isBlank(lxs)|| Sylx.TDSY.toString().equals(lxs))  //默认是土地税源
            sylx=Sylx.TDSY;
        else
            sylx = Sylx.FCSY;
        model.addAttribute("xzq",xzqbh);
        Page<SSjSwbd> sjSwbdPage = swdjtzService.findSyppxxMap(xzqbh,lx,request,swDjSyQuery,sylx);
        return sjSwbdPage;

    }

    @RequestMapping("wppJson")
    @ResponseBody
    public Page<SSjSwbd> getSwdjSyWpp(Model model,String xzqbh,String lxs,Pageable request,SwDjSyQuery swDjSyQuery,String sidx,String sord) {
        Sylx sylx=null;
        if(StringUtils.isBlank(lxs)|| Sylx.TDSY.toString().equals(lxs))  //默认是土地税源
            sylx=Sylx.TDSY;
        else
            sylx = Sylx.FCSY;
        model.addAttribute("xzq",xzqbh);
        Page<SSjSwbd> sjSwbdPage =swdjtzService.findWppSyMap(xzqbh,request,swDjSyQuery,sylx,sidx,sord);
        return sjSwbdPage;
    }

    @RequestMapping("yxfJson")
    @ResponseBody
    public Page<SSjSwbd> yxfJson(Model model,String lxs,Pageable pageable,SwDjSyQuery swDjSyQuery) {
        Sylx sylx=null;
        if(StringUtils.isBlank(lxs)|| Sylx.TDSY.toString().equals(lxs))  //默认是土地税源
            sylx=Sylx.TDSY;
        else
            sylx = Sylx.FCSY;
        Page<SSjSwbd> sjSwbdPage =swdjtzService.findYxfSyMap(pageable,swDjSyQuery,sylx);
        return sjSwbdPage;
    }


    @RequestMapping("exportExcelTz")
    public String exportExcelTz(String xzqbh,String lxs,SwDjSyQuery swDjSyQuery,String ids,HttpServletRequest request) throws Exception {
        try {
            //加载税源种类
            Sylx sylx=null;
            Map<String,Boolean> taxTypeConf = CommonUtil.getSyTypes();
            if(taxTypeConf.get(ObjectValueManager.LOAD_FCS)){
                lxs = Sylx.FCSY.toString();
            }else{
                lxs=Sylx.TDSY.toString();
            }
            HashMap param = new HashMap();
            param.put("xzqbh",xzqbh);
            param.put("sylx",lxs);

            //List<GtSwTzQuery> swdjTzList = swdjtzService.getSwdjTzList(param);
//            Sylx sylx=null;
//            if(StringUtils.isBlank(lxs)|| Sylx.TDSY.toString().equals(lxs))  //默认是土地税源
//                sylx=Sylx.TDSY;
//            else
//                sylx = Sylx.FCSY;
            List<GtSwTzQuery> swDjSyList=swdjtzService.findWppSyList(xzqbh, swDjSyQuery, lxs,ids);
            List<String[]> retList = new ArrayList<String[]>();

            if((StringUtils.isBlank(lxs)|| Sylx.TDSY.toString().equals(lxs))){
                for(int i=0;i<swDjSyList.size();i++){
                    String[] tempArr = new String[9];
                    for(int j=0;j<tempArr.length;j++){
                        tempArr[j] = "";
                    }
                    GtSwTzQuery swTzQuery=swDjSyList.get(i);
                    tempArr[0]=String.valueOf(i+1);
                    tempArr[1]=swTzQuery.getNsrsbh();
                    tempArr[2]=swTzQuery.getNsrmc();
                    tempArr[3]=swTzQuery.getZgkgMc();
                    tempArr[4]=swTzQuery.getSgyMc();
                    tempArr[5] = String.valueOf(swTzQuery.getNynseTd());
                    retList.add(tempArr);
                }

                HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
                ExcelBean eb = new ExcelBean();
                map.put("group1", retList);// 把retList放入group1中
                eb.setGroupMap(map);
                eb.setExcelTemplate("swdjtz.xls"); //
                eb.setExcelXml("swdjtz.xml"); // 上述两步骤是把xml文件和xls文件有机组合
                eb.printExcel(request);
            }else{
                for(int i=0;i<swDjSyList.size();i++){
                    String[] tempArr = new String[9];
                    for(int j=0;j<tempArr.length;j++){
                        tempArr[j] = "";
                    }
                    GtSwTzQuery swTzQuery=swDjSyList.get(i);
                    tempArr[0]=String.valueOf(i+1);
                    tempArr[1]=swTzQuery.getNsrsbh();
                    tempArr[2]=swTzQuery.getNsrmc();
                    tempArr[3]=swTzQuery.getZgkgMc();
                    tempArr[4]=swTzQuery.getSgyMc();
                    tempArr[5] = String.valueOf(swTzQuery.getNynseTd());
                    tempArr[6] = String.valueOf(swTzQuery.getNynseFc());
                    retList.add(tempArr);
                }

                HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
                ExcelBean eb = new ExcelBean();
                map.put("group1", retList);// 把retList放入group1中
                eb.setGroupMap(map);
                eb.setExcelTemplate("swdjtzContainFc.xls"); //
                eb.setExcelXml("swdjtzContainFc.xml"); // 上述两步骤是把xml文件和xls文件有机组合
                eb.printExcel(request);
            }


        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    @RequestMapping("save")
    @ResponseBody
    public String getSwdjSave(Model model,String json) {

        String mess = swdjtzService.saveListJson(json);
        return mess ;
    }



    @RequestMapping("saveDjh")
    @ResponseBody
    public Object saveDjh(Model model,String djh,String tdId,String fcId,String dbh,String tdzh,String bz) {

        ResponseMessage responseMessage = new ResponseMessage();
        responseMessage.setMsg("保存成功");
        try{
            //判断djh是否存在
            Zd zd = zdService.findZdByDjh(djh);
            if(zd==null){
                responseMessage.setMsg("您输入的地籍号不存在，请核查!");
            }else{
                swdjtzService.saveDjh(djh,tdId,fcId,dbh,tdzh,bz);
            }
        }catch(Exception e){
            e.printStackTrace();
            responseMessage.setMsg("保存失败");
        }
        return responseMessage;

    }


    @RequestMapping("wppxxJsonProject")
    @ResponseBody
    public List<SSjSwbd>  wppxxJsonProject(Model model,Pageable pageable,String proid) {
        List<SSjSwbd> sjSwbdPage =swdjtzService.findWppxxJsonProject(pageable,proid);
        return sjSwbdPage;
    }

    /*
    @RequestMapping("wppProjectList")
    public String   wppProjectList(Model model,String xzq,String proid){
        System.out.println(proid);
        model.addAttribute("proid",proid);
        return "landtax/syhc/sypptz/swWppProjectList";
    }
    */

    @RequestMapping("wppProject")
    public String   wppProject(Model model,String xzq,String proid){
        String userId = SessionUtil.getCurrentUserId();
        String remark=sysUserService.getUserVo(userId).getRemark();
        String canXg="";
        if(StringUtils.isNotBlank(remark)&&remark.indexOf("swy")>=0){
            canXg="1";
        }
        model.addAttribute("canXg",canXg);
        SwHcXmRwRel swHcXmRwRel = hcxmService.getSwHcXmRwRelByWiid(proid);
        String bdId = swHcXmRwRel.getBdId();

        SwDjTdWbd swDjTdWbd = baseRepository.get(SwDjTdWbd.class, bdId);
        model.addAttribute("swDjTdWbd",swDjTdWbd);

//        SwDjFcWbd swDjFcWbd = baseRepository.get(SwDjFcWbd.class, bdId);
//        model.addAttribute("swDjFcWbd", swDjFcWbd);

        String djh = "";
        if(swDjTdWbd!=null){
            Zd zd = swDjTdWbd.getZd();
            model.addAttribute("zd",zd);
        }
//        else if(swDjFcWbd!=null){
//            djh = swDjFcWbd.getDjh();
//        }
       /* if(StringUtils.isNotBlank(djh)){
            Zd zd = zdService.findZdByDjh(djh);
            model.addAttribute("zd",zd);
        }*/

        model.addAttribute("proid",proid);
        return "landtax/syhc/sypptz/swWppProject";
    }
    @RequestMapping("printSwdj")
    @ResponseBody
    public void exportSwdj(Model model,HttpServletResponse response,String tdId,String fcId,String djh,String dbh,String proid) throws  Exception{
        XMLBuildHelper xmlBuildHelper = new XMLBuildHelper();
        StringBuilder xml = new StringBuilder();
        //根据proid来获取swDjTdWbd的相关数据
        SwHcXmRwRel swHcXmRwRel = hcxmService.getSwHcXmRwRelByWiid(proid);
        String bdId = swHcXmRwRel.getBdId();
        SwDjTdWbd swDjTdWbd = baseRepository.get(SwDjTdWbd.class, bdId);
        Zd zd=new Zd();
        if(swDjTdWbd!=null){
             zd = swDjTdWbd.getZd();
        }
       // 根据税管状态代码来获取名称
        String sgztDm=swDjTdWbd.getSgztDm();
        String sgztMc=Sgzt.getMcByDm(sgztDm);
        swDjTdWbd.setSgztMc(sgztMc);
        //土地使用用途代码
//        String tdsyytDm = swDjTdWbd.getTdsyztDm();
//        String tdsyytMc = Tdyt.getMcByDm(tdsyytDm);
//        swDjTdWbd.setTdsyztMc(tdsyytMc);
        if(zd!=null){
            String tdytMc=zd.getTdytmc();
            swDjTdWbd.setTdsyztMc(tdytMc);
        }
        //根据土地使用权类型获取土地使用权类型名称
//        String tdsyqlx = swDjTdWbd.getTdsyqlx();
//        String tdsyqlxMc = Tdsyqlx.getMcByDm(tdsyqlx);
//        swDjTdWbd.setTdsyqlxMc(tdsyqlxMc);
        //根据主管控管代码获取主管空管名称
        String zgkgDm = swDjTdWbd.getSwDjJbbWbd().getZgkgDm();
        String sql = "select mc from dm_swbm where swbmbm="+zgkgDm;
        String zgkgMc = String.valueOf(baseRepository.getEntityManager().createNativeQuery(sql).getSingleResult());
        //根据登记注册类型代码获取登记注册类型名称
        String zclxDm = swDjTdWbd.getSwDjJbbWbd().getZclxDm();
        String zclxMc = Zclx.getMcByDm(zclxDm);

        //根据行业代码获取行业名称
        String hyDm = swDjTdWbd.getSwDjJbbWbd().getHyDm();
        String hyMc="";
        if(StringUtils.isNotEmpty(hyDm)){
            if(hyDm.length()==1){
                hyMc = Hylx.getMcByDm(hyDm);
                if(hyDm.length()>1){
                    String sql11 = "select MC from DM_HYDM  where DM='"+hyDm+"'";
                    hyMc = String.valueOf(baseRepository.getEntityManager().createNativeQuery(sql11).getSingleResult());
                }
            }
        }
        //根据土地使用状态代码获取土地使用状态名称
        String tdsyztDm = swDjTdWbd.getTdsyztDm();
        String tdsyztMc = Tdsyzt.getMcByDm(tdsyztDm);
        swDjTdWbd.setTdsyztMc(tdsyztMc);

        //根据土地登记代码获取土地登记名称
        String tddj = swDjTdWbd.getTddj();
        //根据tddj获取名称
        HashMap tddjMap = (HashMap) taxService.getTddjByDm(tddj);
        if(tddjMap != null){
            swDjTdWbd.setTddj(String.valueOf(tddjMap.get("MC")));
        }
        xml.append(xmlBuildHelper.voToXml(swDjTdWbd));
        //税管状态
        xml.append("<data name=\"sgztMc\" type=\"String\">");
        xml.append((sgztMc==null?"":sgztMc));
        xml.append("</data>");
        //djh
        if(zd!=null){
           djh=zd.getDjh();
        }
        xml.append("<data name=\"djh\" type=\"String\">");
        xml.append((djh==null?"":djh));
        xml.append("</data>");
        //dbh
        dbh=swDjTdWbd.getDbh();
        xml.append("<data name=\"dbh\" type=\"String\">");
        xml.append((dbh==null?"":dbh));
        xml.append("</data>");
        //nsrsbh
        String nsrsbh=swDjTdWbd.getNsrsbh();
        xml.append("<data name=\"nsrsbh\" type=\"String\">");
        xml.append((nsrsbh==null?"":nsrsbh));
        xml.append("</data>");
        //nsrmc
        String nsrmc=swDjTdWbd.getNsrmc();
        xml.append("<data name=\"nsrmc\" type=\"String\">");
        xml.append((nsrmc==null?"":nsrmc));
        xml.append("</data>");
        //tdsyztMc
        xml.append("<data name=\"tdsyztMc\" type=\"String\">");
        xml.append((tdsyztMc==null?"":tdsyztMc));
        xml.append("</data>");
        //czrmc
        String czrmc=swDjTdWbd.getCzrmc();
        xml.append("<data name=\"czrmc\" type=\"String\">");
        xml.append((czrmc==null?"":czrmc));
        xml.append("</data>");
        //czrzjhm
        String czrzjhm=swDjTdWbd.getCzrzjhm();
        xml.append("<data name=\"czrzjhm\" type=\"String\">");
        xml.append((czrzjhm==null?"":czrzjhm));
        xml.append("</data>");
        //fczl
        String fczl="";
        xml.append("<data name=\"fczl\" type=\"String\">");
        xml.append((fczl==null?"":fczl));
        xml.append("</data>");
        //tdzl
        String tdzl=swDjTdWbd.getTdzl();
        xml.append("<data name=\"tdzl\" type=\"String\">");
        xml.append((tdzl==null?"":tdzl));
        xml.append("</data>");
        //ishc@@@@@@@@@@@这边要改
        String ishc="";
        xml.append("<data name=\"ishc\" type=\"String\">");
        xml.append((ishc==null?"":ishc));
        xml.append("</data>");
        //tdsyzh
        String tdsyzh=swDjTdWbd.getTdsyzh();
        xml.append("<data name=\"tdsyzh\" type=\"String\">");
        xml.append((tdsyzh==null?"":tdsyzh));
        xml.append("</data>");
        //tdsyqlx
        String tdsyqlx=swDjTdWbd.getTdsyqlx();
        xml.append("<data name=\"tdsyqlx\" type=\"String\">");
        xml.append((tdsyqlx==null?"":tdsyqlx));
        xml.append("</data>");

        //**基本表的信息 zgkgMc
        xml.append("<data name=\"zgkgMc\" type=\"String\">");
        xml.append((zgkgMc==null?"":zgkgMc));
        xml.append("</data>");
        //zclxMc
        xml.append("<data name=\"zclxMc\" type=\"String\">");
        xml.append((zclxMc==null?"":zclxMc));
        xml.append("</data>");
        //hyMc
        xml.append("<data name=\"hyMc\" type=\"String\">");
        xml.append((hyMc==null?"":hyMc));
        xml.append("</data>");
        //sgyMc
        xml.append("<data name=\"sgyMc\" type=\"String\">");
        xml.append((swDjTdWbd.getSwDjJbbWbd().getSgyMc()==null?"":swDjTdWbd.getSwDjJbbWbd().getSgyMc()));
        xml.append("</data>");
        //fddbr
        xml.append("<data name=\"fddbr\" type=\"String\">");
        xml.append((swDjTdWbd.getSwDjJbbWbd().getFddbr()==null?"":swDjTdWbd.getSwDjJbbWbd().getFddbr()));
        xml.append("</data>");
        //lxdh
        xml.append("<data name=\"lxdh\" type=\"String\">");
        xml.append((swDjTdWbd.getSwDjJbbWbd().getLxdh()==null?"":swDjTdWbd.getSwDjJbbWbd().getLxdh()));
        xml.append("</data>");
        //zcdz
        xml.append("<data name=\"zcdz\" type=\"String\">");
        xml.append((swDjTdWbd.getSwDjJbbWbd().getZcdz()==null?"":swDjTdWbd.getSwDjJbbWbd().getZcdz()));
        xml.append("</data>");
        //土地数据 fzmj
        BigDecimal fzmj=swDjTdWbd.getFzmj();
        xml.append("<data name=\"fzmj\" type=\"BigDecimal\">");
        xml.append((fzmj==null?"":fzmj));
        xml.append("</data>");
        //scmj
        BigDecimal scmj=swDjTdWbd.getScmj();
        xml.append("<data name=\"scmj\" type=\"BigDecimal\">");
        xml.append((scmj==null?"":scmj));
        xml.append("</data>");
        //swDjTdWbd.getTddj();
        xml.append("<data name=\"tddj\" type=\"String\">");
        xml.append((swDjTdWbd.getTddj()==null?"":swDjTdWbd.getTddj()));
        xml.append("</data>");
        //msmj
        xml.append("<data name=\"msmj\" type=\"BigDecimal\">");
        xml.append((swDjTdWbd.getMsmj()==null?"":swDjTdWbd.getMsmj()));
        xml.append("</data>");
        //ynmj
        xml.append("<data name=\"ynmj\" type=\"BigDecimal\">");
        xml.append((swDjTdWbd.getYnmj()==null?"":swDjTdWbd.getYnmj()));
        xml.append("</data>");
        //dwse
        xml.append("<data name=\"dwse\" type=\"BigDecimal\">");
        xml.append((swDjTdWbd.getDwse()==null?"":swDjTdWbd.getDwse()));
        xml.append("</data>");
        //nynseTd
        xml.append("<data name=\"nynseTd\" type=\"BigDecimal\">");
        xml.append((swDjTdWbd.getNynseTd()==null?"":swDjTdWbd.getNynseTd()));
        xml.append("</data>");
        //tdMssjBegin
        String tdMssjBegin="";
        xml.append("<data name=\"tdMssjBegin\" type=\"String\">");
        xml.append((tdMssjBegin==null?"":tdMssjBegin));
        xml.append("</data>");
        //tdMssjEnd
        String tdMssjEnd="永久为空";
        xml.append("<data name=\"tdMssjEnd\" type=\"String\">");
        xml.append((tdMssjEnd==null?"":tdMssjEnd));
        xml.append("</data>");
//        String tdjmxzdm =swDjTdWbd;
//        String tdjmxzMc = Jmxztd.getMcByDm(tdjmxzdm);
//        syxx.setTdjmxzMc(tdjmxzMc);
        //TdjmxzMc
        String TdjmxzMc="";
        xml.append("<data name=\"TdjmxzMc\" type=\"String\">");
        xml.append((TdjmxzMc==null?"":TdjmxzMc));
        xml.append("</data>");
        //bz
        xml.append("<data name=\"bz\" type=\"String\">");
        xml.append((swDjTdWbd.getBz()==null?"":swDjTdWbd.getBz()));
        xml.append("</data>");

        //权利人名称
        String qlrmc="";
        if(zd!=null){
            qlrmc =zd.getQlrmc();
        }
        xml.append("<data name=\"qlrmc\" type=\"String\">");
        xml.append((qlrmc==null?"":qlrmc));
        xml.append("</data>");
        //国土宗地面积
        BigDecimal scmjZd= null;
        if(zd !=null){
            scmjZd=zd.getScmjZd();
        }
        xml.append("<data name=\"scmjZd\" type=\"BigDecimal\">");
        xml.append((scmjZd==null?"":scmjZd));
        xml.append("</data>");
        String res=xmlBuildHelper.getPrintXml(xml.toString());
        response.setContentType("text/xml; charset=GBK");
        PrintWriter out = response.getWriter();
        out.write(res);
        out.flush();
        out.close();
    }

    @RequestMapping("getprojectInform")
    @ResponseBody
    public Object getProjectInform(){
        Project project = swdjtzService.getProjectInform();
        return project;
    }


    @RequestMapping("newproject")
    @ResponseBody
    public String newProject(Model model,String nsrsbh,Project newProject,String sylx,String hcxmMc,String tdIds,String fcIds,SwDjSyQuery swDjSyQuery){
        if(StringUtils.isBlank(tdIds)){

        }
        String mess = swdjtzService.getCreateNewProject(nsrsbh,newProject,sylx,hcxmMc,tdIds,fcIds,swDjSyQuery);
        return mess;
    }

    @RequestMapping("uploadToData")
    @ResponseBody
    public String uploadToData(Model model,String proid) throws  Exception{
        swdjtzService.uploadToData(proid);
        return "";
    }

    @RequestMapping("delproject")
    @ResponseBody
    public Object delProject(Model model,String proid){
        if(StringUtils.isNotBlank(proid))
            swdjtzService.delSwbdProject(proid);
        return null;
    }


    @RequestMapping("findZdqueryByDjh")
    @ResponseBody
    public Object findZdqueryByDjh(Model model,String djh) throws Exception{
        if(StringUtils.isNotBlank(djh)){
            ZdQuery zdQuery = zdService.findZdqueryByDjh(djh);

            //根据地籍号创建地编号
            SwDjSyQuery swDjSyQuery = new SwDjSyQuery();
            if(zdQuery!=null){
                String dbh = taxService.createDbhByDjh(djh);
                BeanUtils.copyProperties(swDjSyQuery,zdQuery);
                swDjSyQuery.setDbh(dbh);
                String tdyt = swDjSyQuery.getTdyt();
                if(StringUtils.isNotBlank(tdyt)){
                    String tdytMc = Dldm.getMcByDm(tdyt);
                    swDjSyQuery.setTdytMc(tdytMc);
                }
            }
            return swDjSyQuery;
        }
        return null;
    }



}